/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XFSMTransition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public enum XCoverageUtils {
    INSTANCE;

    protected static VlogBitVector ONE;

    static {
        ONE = VlogBitVector.BIT_ONE;
    }

    public List<DVTNumber> iterateRange(DVTNumber start, DVTNumber end) {
        LinkedList<DVTNumber> numbers = new LinkedList<DVTNumber>();
        DVTNumber counter = start.copy();
        do {
            numbers.add(counter);
        } while (!(counter = DVTNumber.plus(counter, ONE)).equals(end));
        if (!DVTNumber.eq(end, start)) {
            numbers.add(counter);
        }
        return numbers;
    }

    private Deque<IHidObject> getTransitions(IHidOperator expression) {
        IHidObject lhValue;
        LinkedList<IHidObject> transitions = new LinkedList<IHidObject>();
        if (IHidOperatorConstants.OperatorType.TRANS_REPETITION.id == expression.getOperatorType()) {
            transitions.addFirst(expression);
            return transitions;
        }
        do {
            lhValue = expression.getLHValue();
            transitions.addFirst(expression.getFirstRHValue());
            if (!(lhValue instanceof IHidOperator)) {
                transitions.addFirst(lhValue);
                return transitions;
            }
            expression = (IHidOperator)lhValue;
        } while (((IHidOperator)lhValue).isImply());
        transitions.addFirst(lhValue);
        return transitions;
    }

    private Set<DVTNumber> getValuesFromEnumeration(IHidOperator expression, XValueHolder enclosing, IHidEvaluationGuardian guardian) {
        HashSet<DVTNumber> values = new HashSet<DVTNumber>();
        ListContainer<IHidObject> rhHids = expression.getRHValues();
        for (IHidObject hid : rhHids) {
            ELParamValueScope hidValue = ELUtils.evaluate(hid, enclosing, null, guardian);
            if (ELUtils.isUnsuccessfulEval(hidValue)) continue;
            values.add(XUtils.getValue(hidValue).getDVTNumber());
        }
        return values;
    }

    private Map.Entry<IELParamValue, IELParamValue> getValuesFromRange(IHidOperator expression, XValueHolder enclosing, IHidEvaluationGuardian guardian) {
        ELParamValueScope startValueScope = ELUtils.evaluate(expression.getLHValue(), enclosing, null, guardian);
        ELParamValueScope endValueScope = ELUtils.evaluate(expression.getFirstRHValue(), enclosing, null, guardian);
        if (ELUtils.isUnsuccessfulEval(startValueScope) || ELUtils.isUnsuccessfulEval(endValueScope)) {
            return null;
        }
        return Map.entry(XUtils.getValue(startValueScope), XUtils.getValue(endValueScope));
    }

    public void addTransitionItem(XFSMTransition fsmTransition, IHidObject hidObject, XValueHolder enclosing, IHidEvaluationGuardian guardian) {
        if (!(hidObject instanceof IHidOperator var5_6)) {
            ELParamValueScope hidValue = ELUtils.evaluate(hidObject, enclosing, null, guardian);
            if (ELUtils.isUnsuccessfulEval(hidValue)) {
                return;
            }
            fsmTransition.addTransitionSingleElement(XUtils.getValue(hidValue));
            return;
        }
        if (operator.isComma()) {
            fsmTransition.addTransitionArray(this.getValuesFromEnumeration((IHidOperator)operator, enclosing, guardian));
            return;
        }
        if (operator.isColon()) {
            Map.Entry<IELParamValue, IELParamValue> range = this.getValuesFromRange((IHidOperator)operator, enclosing, guardian);
            if (range == null) {
                return;
            }
            fsmTransition.addTransitionRange(range.getKey(), range.getValue());
            return;
        }
        if (IHidOperatorConstants.OperatorType.TRANS_REPETITION.id != operator.getOperatorType()) {
            return;
        }
        this.addTransrepetitionOperator(fsmTransition, (IHidOperator)operator, enclosing, guardian);
    }

    private void addTransrepetitionOperator(XFSMTransition fsmTransition, IHidOperator operator, XValueHolder enclosing, IHidEvaluationGuardian guardian) {
        IHidObject lhValue = operator.getLHValue();
        ELParamValueScope repeatedValueScope = ELUtils.evaluate(lhValue, enclosing, null, guardian);
        if (ELUtils.isUnsuccessfulEval(repeatedValueScope)) {
            return;
        }
        IELParamValue repeatedValue = XUtils.getValue(repeatedValueScope);
        IHidObject rhValue = operator.getFirstRHValue();
        if (!(rhValue instanceof IHidOperator var9_10)) {
            return;
        }
        IHidObject rangeHid = rhOperator.getLHValue();
        if (rangeHid instanceof IHidOperator var14_13) {
            Map.Entry<IELParamValue, IELParamValue> valuesFromRange = this.getValuesFromRange((IHidOperator)rangeOperator, enclosing, guardian);
            if (valuesFromRange == null) {
                return;
            }
            startValue = valuesFromRange.getKey();
            endValue = valuesFromRange.getValue();
        } else {
            ELParamValueScope valueScope = ELUtils.evaluate(rangeHid, enclosing, null, guardian);
            if (ELUtils.isUnsuccessfulEval(valueScope)) {
                return;
            }
            endValue = startValue = XUtils.getValue(valueScope);
        }
        if ("[*".equals(rhOperator.getOperatorText())) {
            fsmTransition.addTransitionRangeRepetition(repeatedValue, startValue, endValue);
            return;
        }
        if ("[->".equals(rhOperator.getOperatorText())) {
            fsmTransition.addTransitionGoToRepetition(repeatedValue, startValue, endValue);
            return;
        }
        if ("[=".equals(rhOperator.getOperatorText())) {
            fsmTransition.addTransitionNonConsecutiveRepetition(repeatedValue, startValue, endValue);
        }
    }

    private XFSMTransition extractTransition(IHidOperator expression, XValueHolder enclosing, IHidEvaluationGuardian guardian) {
        Deque<IHidObject> transitions = this.getTransitions(expression);
        XFSMTransition currentTransition = new XFSMTransition();
        for (IHidObject transition : transitions) {
            this.addTransitionItem(currentTransition, transition, enclosing, guardian);
        }
        return currentTransition;
    }

    public List<XFSMTransition> extractTransitions(List<IHidObject> binExpressions, XValueHolder enclosing, IHidEvaluationGuardian guardian) {
        LinkedList<XFSMTransition> fsmTransitions = new LinkedList<XFSMTransition>();
        for (IHidObject hidObject : binExpressions) {
            if (!(hidObject instanceof IHidOperator var7_7)) continue;
            fsmTransitions.add(this.extractTransition((IHidOperator)expression, enclosing, guardian));
        }
        return fsmTransitions;
    }
}

