/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XConditionalEvalScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.MaxLoopCountEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VlogBitVector;

public class XDoWhileEvalScope
extends XConditionalEvalScope {
    private IHidObject statement;
    private int loopCounter;
    private BitVectorContext noContext;

    public XDoWhileEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject statement, IHidObject condition) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian, condition);
        this.statement = statement;
        this.noContext = BitVectorContext.of(bvContext != null ? bvContext.getOrigin() : null, false);
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        if (this.loopCounter++ >= this.maxLoopCount) {
            String message = "Do-while loop counter > " + this.maxLoopCount;
            if (this.isRuntimeElabMode(this.guardian)) {
                this.guardian.logWarning(message);
                this.setDisabled();
            } else {
                this.guardian.logError(message);
                throw new MaxLoopCountEvaluationException((IHidObject)this.parentOperator, this.maxLoopCount);
            }
        }
        return super.executeStatement(nextStatement);
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            VlogBitVector result = this.loopCounter == 0 ? VlogBitVector.BIT_ONE : ELUtils.evaluateCondition(this.condition, this.evaluator, this.noContext, this.guardian.copy()).getDVTNumber();
            return this.guardian.guardControlFlowConditionTested(this.namedElement, this.condition, this.evaluator, result, this.loopCounter) ? this.statement : null;
        }
        return this.loopCounter == 0 || HidEvalCenter.testCondition(this.condition, this.evaluator, this.noContext, this.guardian.copy()) ? this.statement : null;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return true;
    }

    public void hotSwap(IHidObject statement, IHidObject condition) {
        this.statement = statement;
        this.condition = condition;
    }
}

