/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.Map;
import org.eclipse.debug.core.model.IStackFrame;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XAlwaysBlockEvalScope;
import ro.amiq.dvt.interpreter.XConcurrentAssertBlockEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XSeqBlockEvalScope;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalJumpStatementException;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;

public abstract class XEvalScope {
    protected IRfNamedElement namedElement;
    protected IHidOperator parentOperator;
    protected IHidEvaluator evaluator;
    protected IHidEvaluationGuardian guardian;
    protected BitVectorContext bvContext;
    private IStackFrame stackFrame;
    private IHidObject reExecuteStatement;
    private boolean needsHotSwap;
    protected boolean isDisabled;
    protected int lineNumber;
    protected int maxLoopCount;

    protected XEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian) {
        this.namedElement = namedElement;
        this.parentOperator = parentOperator;
        this.evaluator = evaluator;
        this.guardian = guardian;
        this.bvContext = bvContext;
        this.lineNumber = XUtils.getLine(parentOperator);
        if (guardian != null) {
            guardian.setLineNumber(this.lineNumber);
        }
        this.maxLoopCount = guardian != null && !guardian.isInterpreter() ? (evaluator.getManager() != null ? evaluator.getManager().getLoopStatementCutoff() : Integer.MAX_VALUE) : (guardian != null && this.isRuntimeElabMode(guardian) ? (guardian.getFactory() != null ? guardian.getFactory().xSim.getMaxLoopIterations() : Integer.MAX_VALUE) : Integer.MAX_VALUE);
        this.stackFrame = null;
        this.reExecuteStatement = null;
        this.isDisabled = false;
        this.needsHotSwap = false;
    }

    protected boolean isRuntimeElabMode(IHidEvaluationGuardian guardian) {
        return guardian != null && guardian.simulatorMode() == IXSim.XSimMode.UVM_RUNTIME_ELAB;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public IRfNamedElement getNamedElement() {
        return this.namedElement;
    }

    /*
     * Unable to fully structure code
     */
    public ELParamValueScope execute(XThread xThread) {
        nextStatement = null;
        while (true) {
            if (xThread != null && (xThread.isTerminated() || xThread.isMonitorCanceled())) {
                throw new XStopThreadException();
            }
            try {
                if (!this.isDisabled) {
                    if (xThread != null && xThread.isHotSwap()) {
                        if (!this.needsHotSwap()) {
                            this.guardian.endEvalScope(this);
                            return ELParamValueScope.IMPLICIT_RESULT;
                        }
                        xThread.setIsHotSwap(false);
                        this.setNeedsHotSwap(false);
                        enclosingEvalScope = xThread.getEnclosingEvalScope();
                        if (enclosingEvalScope != null) {
                            throw new HidEvalJumpStatementException.HidEvalHotSwapRerunException();
                        }
                    }
                    if (this.reExecuteStatement == null) {
                        try {
                            nextStatement = this.getNextStatement();
                        }
                        catch (Exception e) {
                            if (!(this instanceof XConcurrentAssertBlockEvalScope)) {
                                this.guardian.endEvalScope(this);
                            }
                            throw e;
                        }
                    } else {
                        nextStatement = this.reExecuteStatement;
                        this.reExecuteStatement = null;
                    }
                    if (nextStatement == null) {
                        this.guardian.endEvalScope(this);
                        return ELParamValueScope.IMPLICIT_RESULT;
                    }
                    result = this.executeStatement(nextStatement);
                    if (xThread != null && this instanceof XAlwaysBlockEvalScope) {
                        this.guardian.callbackYieldWaitThread();
                    }
                    if (this.guardian.isLinterStaticAnalysisMode() && ELUtils.isUnsuccessfulEval(result)) {
                        this.guardian.report(new UnknownHidObjectEvaluationException(nextStatement));
                    }
                    if (this.evaluator.isInterpreter()) continue;
                    if (result == null) {
                        return result;
                    }
                    if (!ELUtils.isUnsuccessfulEval(XUtils.getValue(result))) continue;
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
            }
            catch (HidEvalJumpStatementException.HidEvalContinueException e) {
                if (this.isLoopEvalScope()) continue;
                this.guardian.endEvalScope(this);
                throw e;
            }
            catch (HidEvalJumpStatementException.HidEvalBreakException e) {
                if (this.isLoopEvalScope()) break;
                this.guardian.endEvalScope(this);
                throw e;
            }
            catch (HidEvalJumpStatementException.HidEvalNextException e) {
                if (!this.isLoopEvalScope() || (loopLabelJump = e.getLoopLabelJump()) != null && this.namedElement != null && loopLabelJump != this.namedElement) ** break;
                continue;
                this.guardian.endEvalScope(this);
                throw e;
            }
            catch (HidEvalJumpStatementException.HidEvalExitException e) {
                if (this.isLoopEvalScope() && ((loopLabelJump = e.getLoopLabelJump()) == null || this.namedElement == null || loopLabelJump == this.namedElement)) break;
                this.guardian.endEvalScope(this);
                throw e;
            }
            catch (HidEvalJumpStatementException.HidEvalReturnException | HidEvalJumpStatementException.HidEvalReturnResultException e) {
                this.guardian.endEvalScope(this);
                throw e;
            }
            catch (XThread.XReSuspendThreadException v0) {
                this.reExecuteStatement = nextStatement;
                throw new XThread.XSuspendThreadException();
            }
            break;
        }
        this.guardian.endEvalScope(this);
        return ELParamValueScope.IMPLICIT_RESULT;
    }

    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        XThread xThread = this.guardian.getActiveThread();
        try {
            IHidObject nextStatementCandidate;
            this.guardian.checkBuildCanceled();
            this.guardian.callbackStartStatement(xThread, nextStatement);
            if (this instanceof XSeqBlockEvalScope && !(this instanceof XConcurrentAssertBlockEvalScope) && (nextStatementCandidate = ((XSeqBlockEvalScope)this).getNextStatementNoIncrement()) != null && nextStatement != nextStatementCandidate) {
                this.guardian.setLineNumber(XUtils.getLine(nextStatement));
                nextStatement = nextStatementCandidate;
            }
            this.lineNumber = this.guardian.getLineNumber();
            if (this.guardian.isHotSwapPending()) {
                ELParamValueScope eLParamValueScope = ELParamValueScope.IMPLICIT_RESULT;
                return eLParamValueScope;
            }
            if (this.guardian.isLinterStaticAnalysisMode() || !(nextStatement instanceof HidEvalCenter.ForeachLoopStatement) && !(nextStatement instanceof HidEvalCenter.ForeverLoopStatement)) {
                ELParamValueScope eLParamValueScope = ELUtils.evaluate(nextStatement, this.evaluator, this.bvContext, this.guardian.copy());
                return eLParamValueScope;
            }
        }
        finally {
            this.guardian.callbackEndStatement(xThread, nextStatement);
        }
        return ELUtils.evaluate(nextStatement, this.evaluator, this.bvContext, this.guardian.copy());
    }

    public IHidEvaluator getEvaluator() {
        return this.evaluator;
    }

    protected abstract IHidObject getNextStatement();

    protected abstract boolean isLoopEvalScope();

    protected boolean isForkEvalScope() {
        return false;
    }

    public void setStackFrame(IStackFrame stackFrame) {
        this.stackFrame = stackFrame;
    }

    public IStackFrame getStackFrame() {
        return this.stackFrame;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public String getLabel() {
        if (this.parentOperator == null) {
            return null;
        }
        return this.parentOperator.getLabel();
    }

    public void setDisabled() {
        this.isDisabled = true;
    }

    public IHidOperator getParentOperator() {
        return this.parentOperator;
    }

    protected void recomputeHotSwappedUnmodifiedStatements(Map<IRfNamedElement, Boolean> allChangedScopes) {
        if (allChangedScopes == null || !allChangedScopes.containsValue(true)) {
            return;
        }
        IHidOperator operator = this.parentOperator;
        if (!(operator instanceof HidEvalCenter.IHotSwapElement)) {
            if (this instanceof XFrameBlockEvalScope && ((XFrameBlockEvalScope)this).getStatements() instanceof HidEvalCenter.SeqBlockStatement) {
                ((HidEvalCenter.IHotSwapElement)((Object)((XFrameBlockEvalScope)this).getStatements())).hotSwap(this.guardian, this.evaluator, this, this.bvContext);
            }
            return;
        }
        ParserPath parentPath = ((HidEvalCenter.IHotSwapElement)((Object)operator)).getParserPath();
        if (parentPath == null) {
            return;
        }
        boolean isDirty = false;
        for (Map.Entry<IRfNamedElement, Boolean> changedScopeEntry : allChangedScopes.entrySet()) {
            ParserPath changedScopePath;
            IRfNamedElement changedScope;
            IRfDefElement changedScopeDeclaration;
            if (!changedScopeEntry.getValue().booleanValue() || (changedScopeDeclaration = (changedScope = changedScopeEntry.getKey()).getDeclaration()) == null || !parentPath.equals(changedScopePath = changedScopeDeclaration.getParserPath())) continue;
            isDirty = true;
            break;
        }
        if (!isDirty) {
            return;
        }
        ((HidEvalCenter.IHotSwapElement)((Object)operator)).hotSwap(this.guardian, this.evaluator, this, this.bvContext);
    }

    public boolean needsHotSwap() {
        return this.needsHotSwap;
    }

    public void setNeedsHotSwap(boolean needsHotSwap) {
        this.needsHotSwap = needsHotSwap;
    }

    protected void setStatements(ListContainer<IHidObject> statements) {
    }

    public ListContainer<IHidObject> getStatements() {
        return null;
    }

    public String getStackFrameInfo(int lineNumberOverride, ParserPath parserPathOverride) {
        return null;
    }

    public IHidEvaluationGuardian getGuardian() {
        return this.guardian;
    }

    public BitVectorContext getBvContext() {
        return this.bvContext;
    }

    public String getAdditionalInfo() {
        return null;
    }
}

