/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.List;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.BitVectorContext;

public class XEventControlEvalScope
extends XEvalScope {
    private boolean isDone = false;
    private List<IHidOperator.XEventControl> eventControls;
    private List<IHidOperator.XEventControlValue> prevValues;

    public XEventControlEvalScope(HidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian) {
        super(null, parentOperator, evaluator, bvContext, guardian);
        this.eventControls = parentOperator.xEventControls(guardian);
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        XThread activeThread = this.guardian.getActiveThread();
        if (this.evaluateNoThreadSwitch(activeThread)) {
            return ELParamValueScope.IMPLICIT_RESULT;
        }
        activeThread.doYield(true);
        return ELParamValueScope.IMPLICIT_RESULT;
    }

    public final boolean evaluateNoThreadSwitch(XThread activeThread) {
        if (this.isDisabled) {
            return true;
        }
        if (this.eventControls == null) {
            return false;
        }
        List<IHidOperator.XEventControlValue> currValues = this.parentOperator.xEventControlValues(this.eventControls, this.evaluator, this.bvContext, this.guardian.copy());
        if (this.prevValues == null) {
            this.isDone = false;
        } else {
            this.isDone = this.parentOperator.xEventTriggered(this.prevValues, currValues, this.guardian.copy());
            if (this.isDone) {
                return true;
            }
        }
        this.prevValues = currValues;
        XValueHolderFactory factory = this.guardian.getFactory();
        XValueHolderFactory.WaitingThread waitingThread = new XValueHolderFactory.WaitingThread(activeThread, false);
        int i = 0;
        while (i < this.eventControls.size()) {
            IHidOperator.XEventControl eventControl = this.eventControls.get(i);
            for (IHid hid : eventControl.hids) {
                ELParamValueScope hidValue;
                if (hid == Hid.EVALUATE_SKIP_HID) continue;
                if (HidUtils.isHidAccessArgs(eventControl.hidObject)) {
                    if (((Hid)hid).getParentAccess() == null) {
                        hidValue = ELUtils.evaluate(hid, this.evaluator, this.bvContext, this.guardian.copy());
                        factory.addWaitingThread((IELParamValue)hidValue.scope, waitingThread);
                        continue;
                    }
                    hidValue = ELUtils.evaluate(((Hid)hid).getParentAccess(), this.evaluator, this.bvContext, this.guardian.copy());
                    factory.addWaitingThread(hidValue.value, waitingThread);
                    continue;
                }
                if (hid == eventControl.hidObject) {
                    IHidOperator.XEventControlValue value = this.prevValues.get(i);
                    factory.addWaitingThread(value.original, waitingThread);
                    continue;
                }
                hidValue = ELUtils.evaluate(hid, this.evaluator, this.bvContext, this.guardian.copy());
                IELParamValue original = XUtils.getOriginal(hidValue.value, true);
                factory.addWaitingThread(original, waitingThread);
            }
            ++i;
        }
        return false;
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.isDone) {
            return null;
        }
        return this.parentOperator;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return false;
    }
}

