/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCoverageUtils;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XFSMTransition {
    private List<IXTransition> transitionElements = new ArrayList<IXTransition>();
    private int transitionsSize;
    private int currentTransitionIndex;

    public XFSMTransition() {
    }

    public XFSMTransition(XFSMTransition fsmTransition) {
        this.transitionElements = new ArrayList<IXTransition>(fsmTransition.transitionElements);
        this.transitionsSize = fsmTransition.transitionsSize;
    }

    public void addTransitionSingleElement(IELParamValue value) {
        this.transitionElements.add(new XTransitionElement(value));
        ++this.transitionsSize;
    }

    public void addTransitionArray(Set<DVTNumber> values) {
        this.transitionElements.add(new XTransitionArray(values));
        ++this.transitionsSize;
    }

    public void addTransitionRange(IELParamValue startValue, IELParamValue endValue) {
        this.transitionElements.add(new XTransitionRange(startValue, endValue));
        ++this.transitionsSize;
    }

    public void addTransitionRangeRepetition(IELParamValue value, IELParamValue startValue, IELParamValue endValue) {
        this.transitionElements.add(new XTransitionRangeRepetition(value, startValue.intValue(), endValue.intValue()));
        ++this.transitionsSize;
    }

    public void addTransitionGoToRepetition(IELParamValue value, IELParamValue startValue, IELParamValue endValue) {
        this.transitionElements.add(new XTransitionGoToRepetition(value, startValue.intValue(), endValue.intValue()));
        ++this.transitionsSize;
    }

    public void addTransitionNonConsecutiveRepetition(IELParamValue value, IELParamValue startValue, IELParamValue endValue) {
        this.transitionElements.add(new XTransitionNonConsecutiveRepetition(value, startValue.intValue(), endValue.intValue()));
        ++this.transitionsSize;
    }

    public void resetTransitions() {
        this.currentTransitionIndex = 0;
        for (IXTransition transition : this.transitionElements) {
            transition.resetTransition();
        }
    }

    public boolean addSampledValue(IELParamValue value) {
        IXTransition currentTransition = this.transitionElements.get(this.currentTransitionIndex);
        if (!currentTransition.isValueInElement(value)) {
            currentTransition.resetTransition();
            if (this.currentTransitionIndex == 0) {
                this.resetTransitions();
                return false;
            }
            --this.currentTransitionIndex;
            currentTransition = this.transitionElements.get(this.currentTransitionIndex);
            if (!currentTransition.acceptAlternative(value)) {
                this.resetTransitions();
                return false;
            }
        }
        if (currentTransition.completed()) {
            ++this.currentTransitionIndex;
            if (this.currentTransitionIndex != this.transitionsSize) {
                return false;
            }
            if (currentTransition.canContinue()) {
                --this.currentTransitionIndex;
            } else {
                this.resetTransitions();
            }
            return true;
        }
        return false;
    }

    private void addStatesToTransitions(List<XFSMTransition> fsmTransitions, IXTransition transition) {
        if (fsmTransitions.isEmpty()) {
            XFSMTransition fsmTransition = new XFSMTransition();
            fsmTransition.transitionElements.add(transition);
            ++fsmTransition.transitionsSize;
            fsmTransitions.add(fsmTransition);
            return;
        }
        for (XFSMTransition fsmTransition : fsmTransitions) {
            fsmTransition.transitionElements.add(transition);
            ++fsmTransition.transitionsSize;
        }
    }

    public List<XFSMTransition> splitTransition() {
        LinkedList<XFSMTransition> uniqueTransitions = new LinkedList<XFSMTransition>();
        for (IXTransition transition : this.transitionElements) {
            LinkedList<XFSMTransition> tempTransitions = new LinkedList<XFSMTransition>();
            for (IXTransition individualState : transition.split()) {
                List<XFSMTransition> newTransitions = uniqueTransitions.stream().map(obj -> new XFSMTransition((XFSMTransition)obj)).collect(Collectors.toList());
                this.addStatesToTransitions(newTransitions, individualState);
                tempTransitions.addAll(newTransitions);
            }
            uniqueTransitions = tempTransitions;
        }
        return uniqueTransitions;
    }

    public String toString() {
        return DVTStringUtil.join(this.transitionElements, "=>");
    }

    static interface IXTransition {
        public boolean isValueInElement(IELParamValue var1);

        default public boolean acceptAlternative(IELParamValue value) {
            return false;
        }

        default public boolean completed() {
            return true;
        }

        default public boolean canContinue() {
            return false;
        }

        default public List<IXTransition> split() {
            return List.of(this);
        }

        default public void resetTransition() {
        }
    }

    static class XTransitionArray
    implements IXTransition {
        private Set<DVTNumber> values;

        public XTransitionArray(Set<DVTNumber> values) {
            this.values = values;
        }

        @Override
        public boolean isValueInElement(IELParamValue value) {
            for (DVTNumber number : this.values) {
                if (!DVTNumber.eq(number, value.getDVTNumber())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return DVTStringUtil.join(this.values.stream().map(number -> number.bigIntegerValue().longValue()).collect(Collectors.toList()), ",");
        }

        @Override
        public List<IXTransition> split() {
            LinkedList<IXTransition> states = new LinkedList<IXTransition>();
            for (DVTNumber value : this.values) {
                states.add(new XTransitionArray(Set.of(value)));
            }
            return states;
        }
    }

    static class XTransitionElement
    implements IXTransition {
        protected IELParamValue value;

        public XTransitionElement(IELParamValue value) {
            this.value = value;
        }

        @Override
        public boolean isValueInElement(IELParamValue value) {
            return this.value.equals(value);
        }

        public String toString() {
            return Long.toString(this.value.bigIntegerValue().longValue());
        }
    }

    static class XTransitionGoToRepetition
    extends XTransitionRangeRepetition {
        private IELParamValue lastValue;

        public XTransitionGoToRepetition(IELParamValue value, int startNumber, int endNumber) {
            super(value, startNumber, endNumber);
        }

        @Override
        public boolean isValueInElement(IELParamValue value) {
            this.lastValue = value;
            if (this.value.equals(value)) {
                ++this.counter;
            }
            return true;
        }

        @Override
        public boolean acceptAlternative(IELParamValue value) {
            this.lastValue = value;
            if (this.startNumber == this.endNumber) {
                return false;
            }
            if (this.value.equals(value)) {
                ++this.counter;
            }
            return this.counter <= this.endNumber;
        }

        @Override
        public boolean completed() {
            return super.completed() && this.lastValue.equals(this.value);
        }

        @Override
        public String toString() {
            return String.valueOf(this.value.toString()) + " [-> " + this.startNumber + " : " + this.endNumber + "]";
        }
    }

    static class XTransitionNonConsecutiveRepetition
    extends XTransitionGoToRepetition {
        public XTransitionNonConsecutiveRepetition(IELParamValue value, int startNumber, int endNumber) {
            super(value, startNumber, endNumber);
        }

        @Override
        public boolean acceptAlternative(IELParamValue value) {
            return true;
        }

        @Override
        public boolean completed() {
            return this.counter >= this.startNumber && this.counter <= this.endNumber;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value.toString()) + " [= " + this.startNumber + " : " + this.endNumber + "]";
        }
    }

    static class XTransitionRange
    implements IXTransition {
        private DVTNumber startNumber;
        private DVTNumber endNumber;

        public XTransitionRange(IELParamValue startValue, IELParamValue endValue) {
            this.startNumber = startValue.getDVTNumber();
            this.endNumber = endValue.getDVTNumber();
        }

        @Override
        public boolean isValueInElement(IELParamValue value) {
            DVTNumber valueNumber = value.getDVTNumber();
            return DVTNumber.gte(valueNumber, this.startNumber) && DVTNumber.gte(this.endNumber, valueNumber);
        }

        public String toString() {
            return "[" + this.startNumber + " : " + this.endNumber + "]";
        }

        @Override
        public List<IXTransition> split() {
            LinkedList<IXTransition> states = new LinkedList<IXTransition>();
            for (DVTNumber number : XCoverageUtils.INSTANCE.iterateRange(this.startNumber, this.endNumber)) {
                states.add(new XTransitionArray(Set.of(number)));
            }
            return states;
        }
    }

    static class XTransitionRangeRepetition
    extends XTransitionElement {
        protected int startNumber;
        protected int endNumber;
        protected int counter;

        public XTransitionRangeRepetition(IELParamValue value, int startNumber, int endNumber) {
            super(value);
            this.startNumber = startNumber;
            this.endNumber = endNumber;
        }

        @Override
        public boolean isValueInElement(IELParamValue value) {
            if (!this.value.equals(value)) {
                return false;
            }
            ++this.counter;
            return true;
        }

        @Override
        public boolean acceptAlternative(IELParamValue value) {
            if (!this.value.equals(value)) {
                return false;
            }
            if (this.counter >= this.endNumber) {
                return false;
            }
            ++this.counter;
            return true;
        }

        @Override
        public boolean completed() {
            return this.counter >= this.startNumber && this.counter <= this.endNumber;
        }

        @Override
        public boolean canContinue() {
            return this.completed();
        }

        @Override
        public void resetTransition() {
            this.counter = 0;
        }

        @Override
        public String toString() {
            return String.valueOf(this.value.toString()) + " [* " + this.startNumber + " : " + this.endNumber + "]";
        }
    }
}

