/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XConditionalEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.MaxLoopCountEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XForEvalScope
extends XConditionalEvalScope {
    private IHidObject statement;
    private int loopCounter;
    private IHidObject stepHidObject;
    private IHidObject initHidObject;
    private boolean isIncrementStep;
    private DVTNumber incrementIntValue;

    public XForEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject statement, IHidObject initHidObject, IHidObject stepHidObject, IHidObject condition) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian, condition);
        this.statement = statement;
        this.initHidObject = initHidObject;
        this.stepHidObject = stepHidObject;
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        if (this.loopCounter++ >= this.maxLoopCount) {
            String message = "For loop counter > " + this.maxLoopCount;
            if (this.isRuntimeElabMode(this.guardian)) {
                this.guardian.logWarning(message);
                this.setDisabled();
            } else {
                this.guardian.logError(message);
                throw new MaxLoopCountEvaluationException((IHidObject)this.parentOperator, this.maxLoopCount);
            }
        }
        return super.executeStatement(nextStatement);
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.loopCounter == 0) {
            XThread currentThread = this.guardian.getActiveThread();
            this.guardian.callbackStartStatement(currentThread, XUtils.toOperator(this.condition));
            this.initLoop(this.guardian.copy());
        } else {
            this.nextStep(this.guardian.copy());
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            DVTNumber result = ELUtils.evaluateCondition(this.condition, this.evaluator, this.bvContext, this.guardian.copy()).getDVTNumber();
            return this.guardian.guardControlFlowConditionTested(this.namedElement, this.condition, this.evaluator, result, this.loopCounter) ? this.statement : null;
        }
        return this.condition == null || HidEvalCenter.testCondition(this.condition, this.evaluator, this.bvContext, this.guardian.copy(), this.loopCounter != 0) ? this.statement : null;
    }

    protected void initLoop(IHidEvaluationGuardian guardian) {
        if (this.initHidObject == null) {
            return;
        }
        ELParamValueScope genvarValueRaw = ELUtils.evaluate(this.initHidObject, this.evaluator, this.bvContext, guardian);
        if (ELUtils.isUnsuccessfulEval(genvarValueRaw)) {
            throw new UnknownHidObjectEvaluationException(this.initHidObject);
        }
    }

    protected void nextStep(IHidEvaluationGuardian guardian) {
        if (this.stepHidObject == null) {
            return;
        }
        this.cacheIncrementValue();
        if (!DVTNumber.isUndefined(this.incrementIntValue)) {
            DVTNumber resultNumber;
            IHidObject leftOp = ((HidOperator)this.stepHidObject).getLHValue();
            ELParamValueScope leftValueScope = ELUtils.evaluate(leftOp, this.evaluator, this.bvContext, guardian);
            if (ELUtils.isUnsuccessfulEval(leftValueScope)) {
                throw new UnknownHidObjectEvaluationException(this.stepHidObject);
            }
            if (!ELUtils.isParamValueNumber(XUtils.getValue(leftValueScope))) {
                throw new UnknownHidObjectEvaluationException(this.stepHidObject);
            }
            DVTNumber leftNumber = leftValueScope.getDVTNumber();
            DVTNumber dVTNumber = resultNumber = this.isIncrementStep ? DVTNumber.plus(leftNumber, leftNumber.from(this.incrementIntValue, false)) : DVTNumber.minus(leftNumber, leftNumber.from(this.incrementIntValue, false));
            if (DVTNumber.isUndefined(resultNumber)) {
                throw new UnknownHidObjectEvaluationException(this.stepHidObject);
            }
            leftValueScope.doUpdate((IHidOperator)this.stepHidObject, ELParamValues.ParamValueNumber.of(resultNumber), 1, this.evaluator, HidUtils.isHid(leftOp) ? (Hid)leftOp : null, guardian);
        } else {
            IELParamValue stepValue = XUtils.getValue(ELUtils.evaluate(this.stepHidObject, this.evaluator, this.bvContext, guardian));
            if (ELUtils.isUnsuccessfulEval(stepValue)) {
                throw new UnknownHidObjectEvaluationException(this.stepHidObject);
            }
        }
    }

    private void cacheIncrementValue() {
        if (this.incrementIntValue == null && HidUtils.isOperator(this.stepHidObject)) {
            IHidOperator operator = (IHidOperator)this.stepHidObject;
            IHidObject rhSide = operator.getFirstRHValue();
            if (((IHidOperator)this.stepHidObject).isAssignment()) {
                if (HidUtils.isOperator(rhSide) && (((IHidOperator)rhSide).isPlus() || ((IHidOperator)rhSide).isMinus())) {
                    IELParamValue step;
                    IHidObject stepValue = ((IHidOperator)rhSide).getFirstRHValue();
                    if (HidUtils.isHidImplicit(stepValue) && (step = XUtils.getValue(ELUtils.evaluate(stepValue, this.evaluator, this.bvContext, this.guardian))) != null && step.getDVTNumber() instanceof VlogBitVector) {
                        this.incrementIntValue = step.getDVTNumber();
                        this.isIncrementStep = ((IHidOperator)rhSide).isPlus();
                    }
                } else {
                    this.incrementIntValue = DVTNumber.UNDEFINED;
                }
            } else if (HidUtils.isHidImplicit(rhSide) && (operator.isPlusEqual() || operator.isMinusEqual())) {
                IELParamValue step = XUtils.getValue(ELUtils.evaluate(rhSide, this.evaluator, this.bvContext, this.guardian));
                if (step != null && step.getDVTNumber() instanceof VlogBitVector) {
                    this.incrementIntValue = step.getDVTNumber();
                    this.isIncrementStep = operator.isPlusEqual();
                }
            } else if (operator.isIncrement()) {
                this.incrementIntValue = VlogBitVector.ONE;
                this.isIncrementStep = true;
            } else if (operator.isDecrement()) {
                this.incrementIntValue = VlogBitVector.ONE;
                this.isIncrementStep = false;
            } else {
                this.incrementIntValue = DVTNumber.UNDEFINED;
            }
        }
    }

    @Override
    protected boolean isLoopEvalScope() {
        return true;
    }

    public void hotSwap(IHidObject statement, IHidObject initHidObject, IHidObject stepHidObject, IHidObject condition) {
        this.statement = statement;
        this.initHidObject = initHidObject;
        this.stepHidObject = stepHidObject;
        this.condition = condition;
    }
}

