/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.List;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXIterator;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XUnknownSizeIterator;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.MaxLoopCountEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VlogBitVector;

public class XForeachEvalScope
extends XEvalScope {
    private IHidObject statement;
    private IXIterator iterator;
    private int loopCounter;

    public XForeachEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject statement, IELParamValue valueToIterate, List<IHidObject> selects) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian);
        this.statement = statement;
        this.iterator = valueToIterate.iterator(selects, evaluator, guardian);
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        if (this.loopCounter++ >= this.maxLoopCount) {
            String message = "Foreach loop counter > " + this.maxLoopCount;
            if (this.isRuntimeElabMode(this.guardian)) {
                this.guardian.logWarning(message);
                this.setDisabled();
            } else {
                this.guardian.logError(message);
                throw new MaxLoopCountEvaluationException((IHidObject)this.parentOperator, this.maxLoopCount);
            }
        }
        return super.executeStatement(nextStatement);
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            VlogBitVector result = !this.iterator.next() ? VlogBitVector.BIT_ZERO : (this.iterator instanceof XUnknownSizeIterator ? VlogBitVector.BIT_UNKNOWN : VlogBitVector.BIT_ONE);
            return this.guardian.guardControlFlowConditionTested(this.namedElement, this.parentOperator.getLHValue(), this.evaluator, result, this.loopCounter) ? this.statement : null;
        }
        return this.iterator.next() ? this.statement : null;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return true;
    }

    public void hotSwap(IHidObject statement) {
        this.statement = statement;
    }
}

