/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.MaxLoopCountEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.VlogBitVector;

public class XForeverEvalScope
extends XEvalScope {
    private IHidObject statement;
    private int loopCounter;

    public XForeverEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject statement) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian);
        this.statement = statement;
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            return this.guardian.guardControlFlowConditionTested(null, null, this.evaluator, VlogBitVector.BIT_ONE, this.loopCounter) ? this.statement : null;
        }
        return this.statement;
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        if (this.loopCounter++ >= this.maxLoopCount) {
            String message = "Forever loop counter > " + this.maxLoopCount;
            if (this.isRuntimeElabMode(this.guardian)) {
                this.guardian.logWarning(message);
                this.setDisabled();
            } else {
                this.guardian.logError(message);
                throw new MaxLoopCountEvaluationException((IHidObject)this.parentOperator, this.maxLoopCount);
            }
        }
        return super.executeStatement(nextStatement);
    }

    @Override
    protected boolean isLoopEvalScope() {
        return true;
    }

    public void hotSwap(IHidObject statement) {
        this.statement = statement;
    }
}

