/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.interpreter.XConditionalEvalScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XIfElseEvalScope
extends XConditionalEvalScope {
    private IHidObject falseCondStatement;
    private IHidObject trueCondStatement;
    private boolean forceSelectFalseCondStatement;
    private boolean hasSelectedCondStatement;

    public XIfElseEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject condition, IHidObject trueCondStatement, IHidObject falseCondStatement) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian, condition);
        this.falseCondStatement = falseCondStatement;
        this.trueCondStatement = trueCondStatement;
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.hasSelectedCondStatement) {
            return null;
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            if (this.forceSelectFalseCondStatement) {
                this.hasSelectedCondStatement = true;
                return this.falseCondStatement;
            }
            DVTNumber result = ELUtils.evaluateCondition(this.condition, this.evaluator, this.bvContext, this.guardian.copy()).getDVTNumber();
            this.forceSelectFalseCondStatement = this.guardian.guardControlFlowConditionTested(this.namedElement, this.condition, this.evaluator, result, -1);
            this.hasSelectedCondStatement = !this.forceSelectFalseCondStatement;
            return this.forceSelectFalseCondStatement || result == VlogBitVector.BIT_ONE ? this.trueCondStatement : this.falseCondStatement;
        }
        this.hasSelectedCondStatement = true;
        return HidEvalCenter.testCondition(this.condition, this.evaluator, this.bvContext, this.guardian.copy()) ? this.trueCondStatement : this.falseCondStatement;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return false;
    }

    public void hotSwap(IHidObject condition, IHidObject trueCondStatement, IHidObject falseCondStatement) {
        this.condition = condition;
        this.trueCondStatement = trueCondStatement;
        this.falseCondStatement = falseCondStatement;
    }
}

