/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.SkippedHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogBitVector;

public class XInstValueHolder
extends XValueHolder {
    protected ElementPath path;
    protected ELInstance instance;
    private Map<String, XValueHolder> subInstances;
    private Map<String, List<XUtils.NameScope>> cbOutputPorts;

    public XInstValueHolder(XValueHolderFactory factory, IELParamValue enclosing, ELInstance instance) {
        super(factory, XNamedElement.create(instance), enclosing, null, true, false);
        this.instance = instance;
        this.path = instance.getHierarchyPath();
        IRfNamedElement namedElement = this.getNamedElement();
        ELParamValues paramValues = instance.getParamValues();
        if (paramValues == null) {
            return;
        }
        Iterator<? extends Map.Entry<String, IELParamValue>> it = paramValues.getEntriesIterator();
        while (it.hasNext()) {
            Map.Entry<String, IELParamValue> parameterEntry = it.next();
            String parameterName = parameterEntry.getKey();
            IELParamValue parameterValue = parameterEntry.getValue();
            DVTNumber parameterNumber = parameterValue.getDVTNumber();
            if (!(parameterValue instanceof ELParamValues.ParamValueType) && (parameterNumber instanceof DVTUnpackedArray || parameterNumber instanceof DVTUnpackedStruct)) {
                IRfNamedElement parameter = namedElement.xGetLocalParameter(parameterName);
                parameterValue = this.translateUnpackedValue(parameterEntry.getValue(), parameter, this);
            }
            this.putValueDirectly(parameterName, parameterValue);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private IELParamValue translateUnpackedValue(IELParamValue parameterValue, IRfNamedElement namedElement, XValueHolder enclosing) {
        if (namedElement == null) {
            return parameterValue;
        }
        int lineNumber = namedElement.getLine();
        this.factory.getEvaluationGuardian(false).setLineNumber(lineNumber);
        try {
            DVTNumber parameterNumber = parameterValue.getDVTNumber();
            if (parameterNumber instanceof DVTUnpackedArray) {
                IELParamValue arrayValue = enclosing instanceof XArrayValueHolder ? ((XArrayValueHolder)enclosing).createElementValueHolder() : enclosing.createValue(namedElement);
                DVTNumber[] arrayItemValues = ((DVTUnpackedArray)parameterNumber).getValues();
                ((XArrayValueHolder)arrayValue).clear();
                int i = 0;
                while (i < arrayItemValues.length) {
                    IRfFieldElement itemElementField = ((XArrayValueHolder)arrayValue).getItemElementField();
                    IELParamValue arrayItemValue = this.translateUnpackedValue(ELParamValues.ParamValueNumber.of(arrayItemValues[i]), itemElementField, (XArrayValueHolder)arrayValue);
                    ((XArrayValueHolder)arrayValue).push_back(arrayItemValue);
                    ++i;
                }
                return arrayValue;
            }
            if (parameterNumber instanceof DVTUnpackedStruct) {
                Map<String, DVTNumber> membersByName = ((DVTUnpackedStruct)parameterNumber).getMembersByName();
                IELParamValue structValue = enclosing.createValue(namedElement);
                Map<String, StructMemberContextInfo> membersInfoByName = ((DVTUnpackedStruct)parameterNumber).getMembersInfoByName();
                if (membersInfoByName == null) {
                    this.factory.logError("Fail to get the unpacked struct parameter item values");
                    return null;
                }
                for (Map.Entry<String, StructMemberContextInfo> structEntry : membersInfoByName.entrySet()) {
                    String structItemName = structEntry.getKey();
                    IRfNamedElement structType = structValue.getNamedElement();
                    IRfNamedElement structItemNamedElement = structType.getLocalMember(null, structItemName, null);
                    if (structItemNamedElement == null) {
                        this.factory.logError("Fail to get the unpacked struct item value '" + structItemName + "'");
                        return null;
                    }
                    IELParamValue structItemValue = this.translateUnpackedValue(ELParamValues.ParamValueNumber.of(membersByName.get(structItemName)), structItemNamedElement, (XValueHolder)structValue);
                    structValue.putValueDirectly(structItemName, structItemValue);
                }
                return structValue;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return parameterValue;
    }

    @Override
    protected XInstValueHolder internalGetInstanceScope() {
        return this;
    }

    public void initAssignOperators() {
        if (this.isInterface()) {
            this.putValueDirectly("self", this);
        }
    }

    protected void setParentInstanceScope(XInstValueHolder instanceValueHolder) {
        this.instanceScope = instanceValueHolder;
        if (instanceValueHolder != null) {
            instanceValueHolder.getSubInstances().put(this.path.lastSegment(), this);
        }
    }

    public XInstValueHolder getParentInstance() {
        return this.instanceScope;
    }

    @Override
    public XInstValueHolder getInstanceScope() {
        return this;
    }

    @Override
    public ELInstance getElInstance() {
        return this.instance;
    }

    public Map<String, XValueHolder> getSubInstances() {
        if (this.subInstances == null) {
            this.subInstances = new LinkedHashMap<String, XValueHolder>();
        }
        return this.subInstances;
    }

    @Override
    public IELParamValue getInstanceValue(String name) {
        IELParamValue subInstance = this.getValueDirectly(name);
        if (subInstance != null) {
            return subInstance;
        }
        if (this.instanceScope != null) {
            return this.instanceScope.getInstanceValue(name);
        }
        return null;
    }

    @Override
    public IELParamValue getValueDirectly(String name) {
        XValueHolder instValueHolder;
        IELParamValue value = super.getValueDirectly(name);
        if (value != null) {
            return value;
        }
        if (this.subInstances != null && (instValueHolder = this.subInstances.get(name)) != null) {
            return instValueHolder;
        }
        return null;
    }

    @Override
    public ELParamValueScope getValue(IHid hid, IHidEvaluator hidInitialScope, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
        String name = XUtils.getName(hid);
        IRfNamedElement element = hid.getElement();
        IELParamValue valueDirectly = super.getValueDirectly(name);
        if (valueDirectly != null && element instanceof IRfFieldElement) {
            ELParamValueScope valueScope = ELParamValueScope.of(valueDirectly, this);
            if (guardian != null && guardian.isEvalAssert()) {
                return this.factory.getPreponedValue(valueScope);
            }
            return valueScope;
        }
        if (hid.getParentHid() == null && element instanceof IRfDesignElement) {
            XInstValueHolder scope = this;
            do {
                IRfNamedElement namedElement;
                if ((namedElement = scope.getNamedElement()) != element) continue;
                return ELParamValueScope.of(scope);
            } while ((scope = scope.instanceScope) != null);
        }
        return super.getValue(hid, hidInitialScope, context, isMethod, guardian);
    }

    @Override
    public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
        XValueHolder instValueHolder;
        IELParamValue valueDirectly = super.getValueDirectly(name);
        if (valueDirectly != null && element instanceof IRfFieldElement) {
            return ELParamValueScope.of(valueDirectly, this);
        }
        if (this.subInstances != null && (instValueHolder = this.subInstances.get(name)) != null) {
            return ELParamValueScope.of(instValueHolder, this);
        }
        if (this.instanceScope != null && element != null && element.getEnclosingScope() == this.instanceScope.getNamedElement()) {
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        if (this.instanceScope != null && element == this.instanceScope.getNamedElement()) {
            return ELParamValueScope.of(this.instanceScope, this);
        }
        if (this.isGenerateBlockInstance(this.instanceScope) && element instanceof IRfFieldElement && ((IRfFieldElement)element).isGenvar()) {
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        if (this.isGenerateBlockInstance(this.instanceScope) && element instanceof IRfFieldElement && ((IRfFieldElement)element).isAnyParameter()) {
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        if (this.instanceScope != null && element instanceof IRfInstanceElement && !this.factory.hasMember(this.getNamedElement(), name)) {
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        if (this.instanceScope != null && element instanceof IRfDesignElement && !this.factory.hasMember(this.getNamedElement(), name)) {
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        if (this.instanceScope != null && this.isGenerateBlockInstance(this) && !this.factory.hasMember(this.getNamedElement(), name)) {
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        return super.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
    }

    protected ELParamValueScope getSubInstance(String name) {
        if (this.subInstances == null) {
            return null;
        }
        XValueHolder instValueHolder = this.subInstances.get(name);
        if (instValueHolder != null) {
            return ELParamValueScope.of(instValueHolder, this);
        }
        return null;
    }

    private boolean isGenerateBlockInstance(XInstValueHolder instanceHolder) {
        return instanceHolder != null && instanceHolder.instance != null && instanceHolder.instance.isBlock();
    }

    @Override
    public ElementPath getInstancePath() {
        return this.path;
    }

    @Override
    public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
        Map<DVTXVariableInfo, IELParamValue> variables = super.debuggerGetVariables(isFirstStackFrame, isBreakOnFirst);
        int instCount = 0;
        if (this.instanceScope != null) {
            variables.put(new DVTXVariableInfo(XUtils.prefix(this.instanceScope.path.lastSegment(), instCount++), DVTXVariableType.PARENT), this.instanceScope);
            if (isBreakOnFirst) {
                return variables;
            }
        }
        if (this.subInstances != null && !this.subInstances.isEmpty()) {
            for (Map.Entry<String, XValueHolder> subInstanceEntry : this.subInstances.entrySet()) {
                variables.put(new DVTXVariableInfo(XUtils.prefix(subInstanceEntry.getKey(), instCount++), DVTXVariableType.NO_TYPE), subInstanceEntry.getValue());
                if (!isBreakOnFirst) continue;
                return variables;
            }
        }
        return variables;
    }

    @Override
    public boolean debuggerHasVariables(boolean isFirstStackFrame) {
        return super.debuggerHasVariables(isFirstStackFrame) || this.subInstances != null && !this.subInstances.isEmpty();
    }

    public void declareLocalVariables() {
        IRfNamedElement module = this.getNamedElement();
        Collection<? extends IRfNamedElement> members = module instanceof IRfPredefinedGate ? DesignUtils.getDummyPorts(this.instance.getDescription()) : module.xGetLocalMembers();
        if (members == null || members.isEmpty()) {
            return;
        }
        for (IRfNamedElement iRfNamedElement : members) {
            if (iRfNamedElement instanceof IRfInstanceElement || iRfNamedElement instanceof IRfFieldElement && ((IRfFieldElement)iRfNamedElement).isTypeParameter() || iRfNamedElement instanceof IRfFieldElement && ((IRfFieldElement)iRfNamedElement).isParameter() || !(iRfNamedElement instanceof IRfFieldElement) || this.getValueDirectly(iRfNamedElement.getName()) != null) continue;
            XUtils.setPathAndLine(this.factory.xSim, iRfNamedElement);
            IELParamValue memberValue = XUtils.getValue(this.createMemberValue(iRfNamedElement));
            if (!(memberValue instanceof XValueHolder) || !XUtils.isStructOrUnion(memberValue.getNamedElement())) continue;
            ((XValueHolder)memberValue).initLocalVariables(false);
        }
    }

    public void collectInterfacePortConnections() {
        this.collectPortConnections(new ArrayList<Runnable>(), true);
    }

    public void collectPortConnections(List<Runnable> constantAssigns) {
        this.collectPortConnections(constantAssigns, false);
    }

    public void computePortCoercion() {
        IRfNamedElement namedElement = this.getNamedElement();
        IRfInstanceElement instanceElement = this.instance.getDescription();
        List<IHidOperator> operators = instanceElement.xGetPortConnections((IRfDesignElement)namedElement);
        if (this.isInterface()) {
            ((IRfInterface)namedElement).xComputeCoerceInout();
        }
        for (IHidOperator operator : operators) {
            boolean isPortCoerced;
            IHid portHid;
            IHidObject signalOperator = operator.getFirstRHValue();
            if (XUtils.isUnconnected(signalOperator) || XUtils.isInterfacePort(portHid = (IHid)operator.getLHValue())) continue;
            IRfNamedElement hidElement = portHid.getElement();
            boolean bl = isPortCoerced = hidElement instanceof IRfPortElement && ((IRfPortElement)hidElement).isCoerceInout() && XUtils.isAllowPortCoerce(signalOperator);
            if (!isPortCoerced) continue;
            Set<IHid> flattened = HidUtils.flattenToHids(signalOperator, HidFlatteningOption.IMPLICITS_EXCLUDED);
            for (IHid hid : flattened) {
                if (!(hid.getElement() instanceof IRfPortElement) || !((IRfPortElement)hid.getElement()).isInput() && !((IRfPortElement)hid.getElement()).isOutput()) continue;
                ((IRfPortElement)hid.getElement()).setCoerceInout();
            }
        }
    }

    private void collectPortConnections(List<Runnable> constantAssigns, boolean isInterfacePortEnable) {
        IRfNamedElement namedElement = this.getNamedElement();
        IRfInstanceElement instanceElement = this.instance.getDescription();
        List<IHidOperator> operators = instanceElement.xGetPortConnections((IRfDesignElement)namedElement);
        ParserPath parserPath = XUtils.getParserPath(instanceElement, new ParserPath("@" + this.path.toString()));
        boolean isArrayOfInstances = instanceElement.isArray();
        int arrayItemIndex = -1;
        int arraySize = -1;
        if (isArrayOfInstances) {
            String lastSegment = this.path.lastSegment();
            String index = lastSegment.substring(instanceElement.getName().length() + 1, lastSegment.length() - 1);
            arrayItemIndex = Integer.parseInt(index);
            arraySize = instanceElement.xGetUnpackedSize(this, this.factory.getEvaluationGuardian(true));
        }
        for (IHidOperator operator : operators) {
            List<IHidObject> hidObjects;
            XEvalOverrideHidOperator outputOverrideOperator;
            XEvalOverrideHidOperator inputOverrideOperator;
            IHidEvaluationGuardian guardian;
            HidOperator operatorCopy2;
            HidOperator operatorCopy1;
            boolean isInoutPort;
            boolean isOutputPort;
            boolean isInputPort;
            boolean isInterfacePort;
            String portName;
            IHid portHid;
            IHidObject signalOperator;
            block26: {
                signalOperator = operator.getFirstRHValue();
                if (XUtils.isUnconnected(signalOperator)) continue;
                portHid = (IHid)operator.getLHValue();
                portName = XUtils.getName(portHid);
                isInterfacePort = XUtils.isInterfacePort(portHid);
                if (isInterfacePortEnable && !isInterfacePort || !isInterfacePortEnable && isInterfacePort) continue;
                IRfNamedElement hidElement = portHid.getElement();
                boolean isPortCoerced = hidElement instanceof IRfPortElement && ((IRfPortElement)hidElement).isCoerceInout() && XUtils.isAllowPortCoerce(signalOperator);
                isInputPort = !isPortCoerced && XUtils.isInputPort(portHid, signalOperator);
                isOutputPort = !isPortCoerced && XUtils.isOutputPort(portHid, signalOperator);
                boolean bl = isInoutPort = isPortCoerced || XUtils.isInoutPort(portHid, signalOperator);
                if (isPortCoerced) {
                    this.factory.logWarning("Coerced port '" + hidElement.getNameAndEnclosing() + "' to inout when resolving instance '" + this.instance.getHierarchyPath() + "'", instanceElement.getDeclaration(), operator.getLine());
                }
                operatorCopy1 = operator.shallowCopy();
                operatorCopy2 = operator.shallowCopy();
                XEvalOverrideHid overridePortHid = new XEvalOverrideHid(this, (Hid)portHid);
                operatorCopy1.setLHValue(overridePortHid);
                operatorCopy2.setLHValue(overridePortHid);
                this.factory.setCurrentParserPath(parserPath);
                this.factory.setCurrentLineNumber(operator.getLine());
                guardian = this.factory.getEvaluationGuardian(false);
                if (isArrayOfInstances && signalOperator != null) {
                    try {
                        IELParamValue signalSize = XUtils.getValue(ELUtils.evaluateForSize(signalOperator, this.instanceScope, null, guardian.copy()));
                        if (ELUtils.isUnsuccessfulEval(signalSize)) {
                            guardian.logError("Fail to evaluate signal '" + signalOperator + "' size in port connection!");
                            continue;
                        }
                        IELParamValue portSize = XUtils.getValue(ELUtils.evaluateForSize(portHid, this, null, guardian.copy()));
                        if (ELUtils.isUnsuccessfulEval(portSize)) {
                            guardian.logError("Fail to evaluate port '" + portHid + "' size in port connection!");
                            continue;
                        }
                        DVTNumber portValueSize = portSize.getDVTNumber();
                        DVTNumber signalValueSize = signalSize.getDVTNumber();
                        if (signalValueSize.getSize() == portValueSize.getSize() || signalValueSize.getSize() != arraySize * portValueSize.getSize()) break block26;
                        int selectLeft = arrayItemIndex * portValueSize.getSize() + ((VlogBitVector)portValueSize).getLeft();
                        int selectRight = arrayItemIndex * portValueSize.getSize() + ((VlogBitVector)portValueSize).getRight();
                        if ((isOutputPort || isInoutPort) && signalOperator instanceof IHidOperator && ((IHidOperator)signalOperator).isVLOGConcatenation(true)) {
                            guardian.logError("Array of instances output ports connected to a concatenation is unsupported");
                        }
                        XSelectOperator selectOperator = new XSelectOperator(signalOperator, selectLeft, selectRight);
                        operatorCopy1.setRHValues(selectOperator);
                        operatorCopy2.setRHValues(selectOperator);
                    }
                    catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {
                        continue;
                    }
                }
            }
            signalOperator = operatorCopy1.getFirstRHValue();
            if (isInoutPort) {
                inputOverrideOperator = new XEvalOverrideHidOperator(this.instanceScope, operatorCopy1, parserPath);
                operatorCopy2.addQualifier(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER);
                outputOverrideOperator = new XEvalOverrideHidOperator(this.instanceScope, operatorCopy2, parserPath);
            } else {
                outputOverrideOperator = inputOverrideOperator = new XEvalOverrideHidOperator(this.instanceScope, operatorCopy1, parserPath);
            }
            IELParamValue portValue = XUtils.getValue(ELUtils.evaluate(portHid, this, null, guardian.copy()));
            if (ELUtils.isUnsuccessfulEval(portValue)) {
                guardian.logError("Port connection LHS (" + portName + ") evaluation fail!");
                continue;
            }
            if (isInterfacePort) {
                try {
                    IELParamValue signalValue = XUtils.getValue(ELUtils.evaluate(signalOperator, this.instanceScope, null, guardian.copy()));
                    if (ELUtils.isUnsuccessfulEval(signalValue)) {
                        guardian.logError("Interface port connection RHS (" + signalOperator + ") evaluation fail");
                        continue;
                    }
                    this.connectInterfacePort(portValue, signalValue);
                }
                catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {}
                continue;
            }
            IELParamValue portOriginal = XUtils.getOriginal(portValue, true);
            if (isOutputPort || isInoutPort) {
                int portUniqueId = this.factory.getUniqueId(portOriginal, true);
                XUtils.addToSetInMap(portUniqueId, outputOverrideOperator, this.factory.getAssignOperatorsMap());
            }
            boolean isConstantInit = true;
            Set<IHid> rhHids = XUtils.getDrivers(operatorCopy1, XUtils.ASSIGN_HID_FLATTENING, this, guardian);
            for (IHid hid : rhHids) {
                try {
                    boolean isSignalHid;
                    if (!HidUtils.isHid(hid)) continue;
                    isConstantInit = false;
                    if (!isInputPort && !isInoutPort) continue;
                    IELParamValue value = XUtils.getValue(ELUtils.evaluate(hid, this.instanceScope, null, guardian.copy()));
                    if (ELUtils.isUnsuccessfulEval(value)) {
                        guardian.logError("Port connection RHS (" + XUtils.getName(hid) + ") evaluation fail");
                        continue;
                    }
                    if (value instanceof XInstValueHolder) continue;
                    IELParamValue original = XUtils.getOriginal(value, true);
                    int inputUniqueId = this.factory.getUniqueId(original, true);
                    boolean bl = isSignalHid = hid == signalOperator;
                    if (!this.factory.disablePortSharing() && isInputPort && isSignalHid && portOriginal instanceof ELParamValues.ParamValueNumber && original instanceof ELParamValues.ParamValueNumber && !original.isStruct(true)) {
                        ELParamValues.ParamValueNumber sharedPortValue = this.factory.getSharedPortValue(inputUniqueId);
                        if (sharedPortValue != null) {
                            int portUniqueId = this.factory.getUniqueId(portOriginal, false);
                            if (portUniqueId < 0 && XUtils.isSameType((ELParamValues.ParamValueNumber)portOriginal, sharedPortValue)) {
                                this.putValueDirectly(portName, sharedPortValue);
                                XUtils.increment("port shared");
                                this.factory.setSharedPortReference(portName, sharedPortValue, this);
                                continue;
                            }
                            XUtils.addToSetInMap(inputUniqueId, inputOverrideOperator, this.factory.getAssignOperatorsMap());
                            continue;
                        }
                        this.factory.setSharedPortValue(inputUniqueId, (ELParamValues.ParamValueNumber)portOriginal);
                        XUtils.addToSetInMap(inputUniqueId, inputOverrideOperator, this.factory.getAssignOperatorsMap());
                        this.factory.setSharedPortReference(portName, (ELParamValues.ParamValueNumber)portOriginal, this);
                        continue;
                    }
                    XUtils.addToSetInMap(inputUniqueId, inputOverrideOperator, this.factory.getAssignOperatorsMap());
                }
                catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {}
            }
            if (isConstantInit && (isInputPort || isInoutPort)) {
                inputOverrideOperator.operator.addQualifier(HidOperatorQualifier.IS_DRIVEN_BY_CONSTANT.value());
                int portUniqueId = this.factory.getUniqueId(portOriginal, true);
                this.factory.addInitAssignOperator(portUniqueId, inputOverrideOperator);
                constantAssigns.add(() -> XUtils.addToSetInMap(portUniqueId, inputOverrideOperator, this.factory.getAssignOperatorsMap()));
            }
            if (isOutputPort || isInoutPort) {
                hidObjects = XUtils.getLHObjects(signalOperator);
                this.factory.setDrivers(this.instanceScope, hidObjects, outputOverrideOperator);
                this.setReleaseOperators(guardian, outputOverrideOperator, hidObjects);
            }
            if (!isInputPort && !isInoutPort) continue;
            hidObjects = Collections.singletonList(new XEvalOverrideHid(this, (Hid)portHid));
            this.factory.setDrivers(this, hidObjects, inputOverrideOperator);
            this.setReleaseOperators(guardian, inputOverrideOperator, hidObjects);
        }
    }

    private void connectInterfacePort(IELParamValue portValue, IELParamValue signalValue) {
        try {
            if (portValue instanceof XArrayValueHolder) {
                int size = ((XArrayValueHolder)portValue).size();
                int i = 0;
                while (i < size) {
                    int portOffset = ((XArrayValueHolder)portValue).getIndexOffset();
                    int signalOffset = ((XArrayValueHolder)signalValue).getIndexOffset();
                    this.connectInterfacePort(((XArrayValueHolder)portValue).getZValue(i + portOffset), ((XArrayValueHolder)signalValue).getZValue(i + signalOffset));
                    ++i;
                }
            } else {
                ((XValueHolder)portValue).updateValue(signalValue, true);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void collectAssignOperators(List<Runnable> constantAssigns, boolean isRuntimeElabOptimizedMode) {
        ParserPath parserPath;
        ArrayList<IHidOperator> portExpressionOperators;
        List<IHidOperator> operators;
        IRfNamedElement design = this.getNamedElement();
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        if (design.isPredefined()) {
            if (isRuntimeElabOptimizedMode) {
                operators = Collections.emptyList();
            } else {
                IRfInstanceElement instanceElement = this.instance.getDescription();
                IRfInstanceElement description = this.instance.getDescription();
                HidOperator driveStrength = XUtils.getInstanceDriveStrength(description);
                HidOperator delayControl = XUtils.getInstanceDelayControl(description);
                List<IHidOperator> portConnections = instanceElement.xGetPortConnections((IRfDesignElement)design);
                operators = design.xGetPredefGateAssignOperators(driveStrength, delayControl, portConnections, HidOperatorOccurrence.DUMMY_OCCURRENCE, guardian);
            }
            portExpressionOperators = null;
            parserPath = new ParserPath("<predefined gate>");
        } else {
            operators = new ArrayList();
            portExpressionOperators = new ArrayList<IHidOperator>();
            XLocalAssignsVisitor visitor = new XLocalAssignsVisitor(operators, portExpressionOperators, design, isRuntimeElabOptimizedMode, guardian);
            IHidHolder hidHolder = design.getHidHolder();
            if (hidHolder != null) {
                hidHolder.visitHidObject(null, visitor);
            }
            if (design instanceof IRfDesignElement) {
                ((IRfDesignElement)design).xCollectClockingEqAssigns(operators, this);
            }
            parserPath = XUtils.getParserPath(design, new ParserPath("@" + this.path.toString()));
        }
        for (IHidOperator operator : operators) {
            this.factory.setCurrentParserPath(parserPath);
            this.factory.setCurrentLineNumber(operator.getLine());
            this.collectAssignOperator(operator, constantAssigns, parserPath);
        }
        if (portExpressionOperators != null) {
            for (IHidOperator operator : portExpressionOperators) {
                this.factory.setCurrentLineNumber(operator.getLine());
                this.collectPortExpressionOperator(operator, isRuntimeElabOptimizedMode, parserPath);
            }
        }
    }

    private void collectAssignOperator(IHidOperator operator, List<Runnable> constantAssigns, ParserPath parserPath) {
        boolean isUnknownValueInit;
        Object value;
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(true);
        XEvalOverrideHidOperator overrideOperator = new XEvalOverrideHidOperator(this, (HidOperator)operator, parserPath);
        boolean isDeclarationAssign = operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) || operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_EXPRESSION);
        IHidObject leftOperand = operator.xGetAssignmentLHS();
        List<IHidObject> hidObjects = XUtils.getLHObjects(leftOperand);
        this.factory.setDrivers(this, hidObjects, overrideOperator);
        this.setReleaseOperators(guardian, overrideOperator, hidObjects);
        boolean isConstantInit = true;
        Set<IHid> rhHids = XUtils.getDrivers(operator, XUtils.ASSIGN_HID_FLATTENING, this, guardian);
        for (IHid hid : rhHids) {
            try {
                if (!HidUtils.isHid(hid)) continue;
                value = XUtils.getValue(ELUtils.evaluate(hid, this, null, guardian.copy()));
                if (ELUtils.isUnsuccessfulEval((IELParamValue)value)) {
                    guardian.logError("Fail to evaluate '" + hid + "' in scope of '" + this + "' (id:0004)");
                    continue;
                }
                if (value instanceof XInstValueHolder) continue;
                isConstantInit = false;
                IELParamValue original = XUtils.getOriginal((IELParamValue)value, true);
                int uniqueId = this.factory.getUniqueId(original, true);
                XUtils.addToSetInMap(uniqueId, overrideOperator, this.factory.getAssignOperatorsMap());
            }
            catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {}
        }
        List<IHidObject> lhHidObjects = XUtils.getLHObjects(leftOperand);
        if (isConstantInit) {
            ((HidOperator)operator).addQualifier(HidOperatorQualifier.IS_DRIVEN_BY_CONSTANT.value());
            for (IHidObject hidObject : lhHidObjects) {
                Hid hid = XUtils.getParentHid(hidObject);
                IELParamValue value2 = XUtils.getValue(ELUtils.evaluate(hid, this, null, guardian.copy()));
                if (ELUtils.isUnsuccessfulEval(value2)) {
                    guardian.logError("Fail to evaluate '" + hid + "' in scope of '" + this + "' (id:0005)");
                    continue;
                }
                IELParamValue original = XUtils.getOriginal(value2, true);
                int uniqueId = this.factory.getUniqueId(original, true);
                this.factory.addInitAssignOperator(uniqueId, overrideOperator);
                if (isDeclarationAssign && XUtils.netType(hid) == IRfNamedElement.NetType.NONE) continue;
                constantAssigns.add(() -> XUtils.addToSetInMap(uniqueId, overrideOperator, this.factory.getAssignOperatorsMap()));
            }
        }
        boolean bl = isUnknownValueInit = !isConstantInit || operator instanceof HidEvalCenter.DelayedContinuousAssign;
        if (!isDeclarationAssign && isUnknownValueInit) {
            value = XUtils.getValue(ELUtils.evaluate(leftOperand, this, null, guardian.copy()));
            if (ELUtils.isUnsuccessfulEval((IELParamValue)value) || value instanceof XArrayValueHolder) {
                return;
            }
            for (IHidObject hidObject : lhHidObjects) {
                DVTNumber number;
                Hid hid = XUtils.getParentHid(hidObject);
                if (XUtils.isInoutPort(hid, null) || XUtils.isInputPort(hid, null) || !(value instanceof ELParamValues.ParamValueNumber) || DVTNumber.isUndefined(number = value.getDVTNumber()) || !number.is4State() || !(number instanceof VlogBitVector)) continue;
                VlogBitVector newValue = VlogBitVector.copy((VlogBitVector)number, VlogBitVector.createMaskOfType(MaskType.X, number.getSize()));
                value.updateValue(ELParamValues.ParamValueNumber.of(newValue, value.getElement(), value.getEnumTypeWrapper()), guardian);
            }
        }
    }

    private void setReleaseOperators(IHidEvaluationGuardian guardian, XEvalOverrideHidOperator overrideOperator, List<IHidObject> hidObjects) {
        XValueHolder evaluator = overrideOperator.getOverrideEvaluator();
        for (IHidObject hidObject : hidObjects) {
            boolean isDeclarationAssign;
            Hid hid = XUtils.getParentHid(hidObject);
            if (hid == null || (isDeclarationAssign = overrideOperator.isDeclarationAssign()) && XUtils.netType(hid) == IRfNamedElement.NetType.NONE) continue;
            IELParamValue value = XUtils.getValue(ELUtils.evaluate(hid, evaluator, null, guardian.copy()));
            if (ELUtils.isUnsuccessfulEval(value)) {
                guardian.logError("Fail to evaluate '" + hid + "' in scope of '" + evaluator + "' (id:0006)");
                continue;
            }
            IELParamValue original = XUtils.getOriginal(value, true);
            XUtils.addToListInMap(this.factory.getUniqueId(original, true), overrideOperator, this.factory.getReleaseOperatorsMap());
        }
    }

    private void collectPortExpressionOperator(IHidOperator operator, boolean isRuntimeElabOptimizedMode, ParserPath parserPath) {
        List<IHidObject> hidObjects;
        XEvalOverrideHidOperator outputOverrideOperator;
        IHidObject signalOperator = operator.getFirstRHValue();
        if (signalOperator != null && HidUtils.isHidImplicit(signalOperator) && ((IHidImplicit)signalOperator).isUnconnectedAssociation()) {
            return;
        }
        IHid portHid = (IHid)operator.getLHValue();
        String portName = XUtils.getName(portHid);
        if (portHid instanceof IHidImplicit) {
            portHid = ((IHidImplicit)portHid).xToHid(this.getNamedElement(), operator.getOccurrence());
        }
        boolean isInterfacePort = XUtils.isInterfacePort(portHid);
        if (isRuntimeElabOptimizedMode && !isInterfacePort) {
            return;
        }
        HidOperator operatorCopy1 = operator.shallowCopy();
        HidOperator operatorCopy2 = operator.shallowCopy();
        XEvalOverrideHid overridePortHid = new XEvalOverrideHid(this, (Hid)portHid);
        operatorCopy1.setLHValue(overridePortHid);
        operatorCopy2.setLHValue(operatorCopy1.getLHValue());
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(true);
        boolean isInputPort = XUtils.isOutputPort(portHid, signalOperator);
        boolean isInoutPort = XUtils.isInoutPort(portHid, signalOperator);
        boolean isOutputPort = XUtils.isInputPort(portHid, signalOperator);
        XEvalOverrideHidOperator inputOverrideOperator = new XEvalOverrideHidOperator(this, operatorCopy1, parserPath);
        if (isInoutPort) {
            operatorCopy2.addQualifier(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER);
            outputOverrideOperator = new XEvalOverrideHidOperator(this, operatorCopy2, parserPath);
        } else {
            outputOverrideOperator = inputOverrideOperator;
        }
        if (isOutputPort || isInoutPort) {
            hidObjects = XUtils.getLHObjects(signalOperator);
            this.factory.setDrivers(this, hidObjects, outputOverrideOperator);
            this.setReleaseOperators(guardian, outputOverrideOperator, hidObjects);
        }
        if (isInputPort || isInoutPort) {
            hidObjects = Collections.singletonList(new XEvalOverrideHid(this, (Hid)portHid));
            this.factory.setDrivers(this, hidObjects, inputOverrideOperator);
            this.setReleaseOperators(guardian, inputOverrideOperator, hidObjects);
        }
        if (isOutputPort || isInoutPort) {
            IELParamValue value = XUtils.getValue(ELUtils.evaluate(portHid, this, null, guardian.copy()));
            if (ELUtils.isUnsuccessfulEval(value)) {
                guardian.logError("Port connection LHS (" + portName + ") evaluation fail!");
                return;
            }
            IELParamValue original = XUtils.getOriginal(value, true);
            XUtils.addToSetInMap(this.factory.getUniqueId(original, true), outputOverrideOperator, this.factory.getAssignOperatorsMap());
        }
        if (isInterfacePort) {
            try {
                IELParamValue portValue = XUtils.getValue(ELUtils.evaluate(portHid, this, null, guardian.copy()));
                if (ELUtils.isUnsuccessfulEval(portValue)) {
                    guardian.logError("Interface port connection LHS (" + portName + ") evaluation fail!");
                    return;
                }
                IELParamValue signalValue = XUtils.getValue(ELUtils.evaluate(signalOperator, this.instanceScope, null, guardian.copy()));
                if (ELUtils.isUnsuccessfulEval(signalValue)) {
                    guardian.logError("Interface port connection RHS (" + signalOperator + ") evaluation fail!");
                    return;
                }
                this.connectInterfacePort(portValue, signalValue);
            }
            catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {}
            return;
        }
        Set<IHid> rhHids = XUtils.getDrivers(operatorCopy1, XUtils.ASSIGN_HID_FLATTENING, this, guardian);
        for (IHid hid : rhHids) {
            try {
                if (!HidUtils.isHid(hid) || !isInputPort && !isInoutPort) continue;
                IELParamValue value = XUtils.getValue(ELUtils.evaluate(hid, this, null, guardian.copy()));
                if (ELUtils.isUnsuccessfulEval(value)) {
                    guardian.logError("Port connection RHS (" + hid + ") evaluation fail!");
                    continue;
                }
                if (value instanceof XInstValueHolder) continue;
                IELParamValue original = XUtils.getOriginal(value, true);
                XUtils.addToSetInMap(this.factory.getUniqueId(original, true), inputOverrideOperator, this.factory.getAssignOperatorsMap());
            }
            catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {}
        }
    }

    public void addCbOutputPort(String intfSignalName, XUtils.NameScope cbOutputPort) {
        List<XUtils.NameScope> cbOutputs;
        if (this.cbOutputPorts == null) {
            this.cbOutputPorts = new HashMap<String, List<XUtils.NameScope>>();
        }
        if ((cbOutputs = this.cbOutputPorts.get(intfSignalName)) == null) {
            cbOutputs = new ArrayList<XUtils.NameScope>();
            this.cbOutputPorts.put(intfSignalName, cbOutputs);
        }
        cbOutputs.add(cbOutputPort);
    }

    @Override
    public List<XEvalOverrideHid> getCbOutputPorts(String intfSignalName, int offset, int line) {
        if (this.cbOutputPorts == null) {
            return Collections.emptyList();
        }
        List<XUtils.NameScope> cbOutputs = this.cbOutputPorts.get(intfSignalName);
        if (cbOutputs == null) {
            return Collections.emptyList();
        }
        return cbOutputs.stream().map(out -> out.toHid(offset, line)).collect(Collectors.toList());
    }

    public boolean isInterface() {
        IRfNamedElement namedElement = this.getNamedElement();
        return namedElement instanceof IRfInterface;
    }

    @Override
    public String toStringConfigDB() {
        return this.path.toString();
    }

    public static class XBBoxValueHolder
    extends XInstValueHolder {
        public XBBoxValueHolder(XValueHolderFactory factory, IELParamValue enclosing, ELInstance instance) {
            super(factory, enclosing, instance);
        }

        @Override
        public ELParamValueScope getValue(IHid hid, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return ELParamValueScope.of(IELParamValue.BLACK_BOX_VALUE);
        }

        @Override
        public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
            return ELParamValueScope.of(IELParamValue.BLACK_BOX_VALUE);
        }

        @Override
        public IELParamValue getValueDirectly(String name) {
            return IELParamValue.BLACK_BOX_VALUE;
        }

        @Override
        public IELParamValue getInstanceValue(String name) {
            return IELParamValue.BLACK_BOX_VALUE;
        }

        @Override
        public void initLocalVariables(boolean onlyStaticMembers) {
        }

        @Override
        public void declareLocalVariables() {
        }

        @Override
        public void collectAssignOperators(List<Runnable> constantAssigns, boolean isRuntimeElabOptimizedMode) {
        }

        @Override
        public void collectPortConnections(List<Runnable> constantAssigns) {
        }

        @Override
        public void collectInterfacePortConnections() {
        }
    }

    public static final class XClockingValueHolder
    extends XInstValueHolder {
        private Map<String, IHidObject> portOperators;
        private Set<String> drivenCbPorts = new HashSet<String>();
        private boolean isResetAllowed;

        public static XClockingValueHolder create(XValueHolderFactory factory, IELParamValue enclosing, ELInstance instance) {
            XClockingValueHolder clockingBlock = new XClockingValueHolder(factory, enclosing, instance);
            factory.addClockingBlock(clockingBlock);
            return clockingBlock;
        }

        private XClockingValueHolder(XValueHolderFactory factory, IELParamValue enclosing, ELInstance instance) {
            super(factory, enclosing, instance);
        }

        @Override
        protected void setParentInstanceScope(XInstValueHolder instanceValueHolder) {
            super.setParentInstanceScope(instanceValueHolder);
            IRfNamedElement namedElement = this.instance.getBinding(false);
            this.declarePorts(namedElement);
            this.setPortOperators(namedElement);
        }

        private void setPortOperators(IRfNamedElement namedElement) {
            List<IHidOperator> operators = namedElement.getHidOperators(ELConstants.PORT_EXPRESSIONS_QUALIFIERS_ARRAY, true);
            if (operators == null || operators.isEmpty()) {
                return;
            }
            this.portOperators = new HashMap<String, IHidObject>();
            for (IHidOperator operator : operators) {
                String portName = XUtils.getName((IHid)operator.getLHValue());
                this.portOperators.put(portName, operator.getFirstRHValue());
            }
        }

        private void declarePorts(IRfNamedElement namedElement) {
            Collection<? extends IRfNamedElement> ports = namedElement.xGetLocalMembers();
            if (ports == null || ports.isEmpty()) {
                return;
            }
            for (IRfNamedElement iRfNamedElement : ports) {
                String cbOutputEqPortName;
                String cbInputEqPortName;
                if (!(iRfNamedElement instanceof IRfFieldElement)) continue;
                IELParamValue value = this.createValue(iRfNamedElement);
                String portName = iRfNamedElement.getName();
                if (((IRfFieldElement)iRfNamedElement).isInput()) {
                    this.putValueDirectly(portName, value);
                    continue;
                }
                if (((IRfFieldElement)iRfNamedElement).isOutput()) {
                    cbInputEqPortName = XUtils.inputEqPortName(portName);
                    this.putValueDirectly(cbInputEqPortName, value);
                    cbOutputEqPortName = XUtils.outputEqPortName(portName);
                    this.putValueDirectly(cbOutputEqPortName, value.copy());
                    this.instanceScope.addCbOutputPort(portName, XUtils.NameScope.create(this, iRfNamedElement, cbOutputEqPortName));
                    continue;
                }
                if (!((IRfFieldElement)iRfNamedElement).isInout()) continue;
                cbInputEqPortName = XUtils.inputEqPortName(portName);
                this.putValueDirectly(cbInputEqPortName, value);
                cbOutputEqPortName = XUtils.outputEqPortName(portName);
                this.putValueDirectly(cbOutputEqPortName, value.copy());
                this.instanceScope.addCbOutputPort(portName, XUtils.NameScope.create(this, iRfNamedElement, cbOutputEqPortName));
            }
        }

        @Override
        public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
            IHidObject hidObject;
            IRfNamedElement namedElement = this.getNamedElement();
            if (element instanceof IRfPortElement && element.getEnclosingScope() instanceof IRfClockingBlockElement) {
                if (((IRfPortElement)element).isInput()) {
                    return ELParamValueScope.of(this.getValueDirectly(name), this);
                }
                if (((IRfPortElement)element).isOutput()) {
                    String eqPortName = name;
                    if (name.charAt(0) == '<') {
                        eqPortName = name;
                    } else if (guardian.isLHS()) {
                        eqPortName = XUtils.outputEqPortName(name);
                    } else {
                        if (!guardian.isAssignment()) {
                            return ELParamValueScope.of(this.instanceScope.getValueDirectly(XUtils.getCbPortName(false, namedElement, name)), this.instanceScope);
                        }
                        eqPortName = XUtils.inputEqPortName(name);
                    }
                    return ELParamValueScope.of(this.getValueDirectly(eqPortName), this);
                }
                if (((IRfPortElement)element).isInout()) {
                    String eqPortName = name.charAt(0) == '<' ? name : (guardian.isLHS() ? XUtils.outputEqPortName(name) : XUtils.inputEqPortName(name));
                    return ELParamValueScope.of(this.getValueDirectly(eqPortName), this);
                }
            }
            IHidObject iHidObject = hidObject = this.portOperators == null ? null : this.portOperators.get(name);
            if (hidObject != null) {
                return ELUtils.evaluate(hidObject, this, null, this.factory.getEvaluationGuardian(true));
            }
            return this.instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }

        @Override
        public ELParamValueScope getValue(IHid hid, IHidEvaluator hidInitialScope, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
            IHidObject hidObject;
            IRfNamedElement namedElement = this.getNamedElement();
            String name = XUtils.getName(hid);
            IRfNamedElement element = hid.getElement();
            if (element instanceof IRfPortElement && element.getEnclosingScope() instanceof IRfClockingBlockElement) {
                if (((IRfPortElement)element).isInput()) {
                    return ELParamValueScope.of(this.getValueDirectly(name), this);
                }
                if (((IRfPortElement)element).isOutput()) {
                    String eqPortName = name;
                    if (name.charAt(0) == '<') {
                        eqPortName = name;
                    } else if (guardian.isLHS()) {
                        eqPortName = XUtils.outputEqPortName(name);
                    } else {
                        if (!guardian.isAssignment()) {
                            return ELParamValueScope.of(this.instanceScope.getValueDirectly(XUtils.getCbPortName(false, namedElement, name)), this.instanceScope);
                        }
                        eqPortName = XUtils.inputEqPortName(name);
                    }
                    return ELParamValueScope.of(this.getValueDirectly(eqPortName), this);
                }
                if (((IRfPortElement)element).isInout()) {
                    String eqPortName = name.charAt(0) == '<' ? name : (guardian.isLHS() ? XUtils.outputEqPortName(name) : XUtils.inputEqPortName(name));
                    return ELParamValueScope.of(this.getValueDirectly(eqPortName), this);
                }
            }
            IHidObject iHidObject = hidObject = this.portOperators == null ? null : this.portOperators.get(name);
            if (hidObject != null) {
                return ELUtils.evaluate(hidObject, this, null, guardian.copy());
            }
            return this.instanceScope.getValue(hid, hidInitialScope, context, isMethod, guardian);
        }

        public void setDriven(String name) {
            String eqPortName = name.charAt(0) == '<' ? name : XUtils.outputEqPortName(name);
            this.drivenCbPorts.add(eqPortName);
        }

        public boolean isDriven(String name) {
            this.isResetAllowed = true;
            String eqPortName = name.charAt(0) == '<' ? name : XUtils.outputEqPortName(name);
            boolean result = this.drivenCbPorts.contains(eqPortName);
            return result;
        }

        public void resetDriven() {
            if (!this.isResetAllowed) {
                return;
            }
            this.isResetAllowed = false;
            this.drivenCbPorts.clear();
        }
    }

    public static class XEvalOverrideHid
    extends Hid {
        private static final long serialVersionUID = 1L;
        private XValueHolder overrideEvaluator;
        private Hid hid;

        public XEvalOverrideHid(XValueHolder evaluator, Hid hid) {
            super(XUtils.getName(hid), hid.getSecondaryScope(), hid.getOffset(), hid.getLine(), hid.getQualifiers());
            this.overrideEvaluator = evaluator;
            this.hid = hid;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return ELUtils.evaluate(this.hid, this.overrideEvaluator, context, guardian);
        }

        @Override
        public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
            return ELUtils.evaluateForSize(this.hid, this.overrideEvaluator, origin, guardian);
        }

        public XValueHolder getOverrideEvaluator() {
            return this.overrideEvaluator;
        }

        public IHid getOverrideHid() {
            return this.hid;
        }

        @Override
        public IRfNamedElement getElement() {
            return this.hid.getElement();
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.hid == null ? 0 : this.hid.hashCode());
            result = 31 * result + (this.overrideEvaluator == null ? 0 : System.identityHashCode(this.overrideEvaluator));
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof XEvalOverrideHid)) {
                return false;
            }
            XEvalOverrideHid other = (XEvalOverrideHid)obj;
            if (this.overrideEvaluator != other.overrideEvaluator) {
                return false;
            }
            return this.hid == other.hid;
        }
    }

    public static class XEvalOverrideHidOperator
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        protected XValueHolder overrideEvaluator;
        protected HidOperator operator;
        private ParserPath parserPath;

        public static XEvalOverrideHidOperator create(XValueHolder evaluator, HidOperator operator, ParserPath parserPath) {
            if (operator instanceof XEvalOverrideHidOperator) {
                return (XEvalOverrideHidOperator)operator;
            }
            return new XEvalOverrideHidOperator(evaluator, operator, parserPath);
        }

        public XEvalOverrideHidOperator(XValueHolder evaluator, HidOperator operator, ParserPath parserPath) {
            super(operator.getOperatorType(), operator.getOperatorKind(), operator.getOperatorText(), operator.getOffset(), operator.getLine(), operator.getOpenBoundary(), operator.getCloseBoundary(), operator.getQualifiers());
            this.lhValue = operator.getLHValue();
            this.rhValues = operator.getRHValues();
            this.overrideEvaluator = evaluator;
            this.operator = operator;
            this.parserPath = parserPath == null ? evaluator.getParserPath() : parserPath;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            guardian.setParserPath(this.parserPath);
            guardian.setLineNumber(this.operator.getLine());
            return ELUtils.evaluate(this.operator, this.overrideEvaluator, context, guardian.copy());
        }

        @Override
        public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
            guardian.setParserPath(this.parserPath);
            guardian.setLineNumber(this.operator.getLine());
            return ELUtils.evaluateForSize(this.operator, this.overrideEvaluator, origin, guardian.copy());
        }

        @Override
        public List<IHidOperator.XEventControlValue> xEventControlValues(List<IHidOperator.XEventControl> eventControls, IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return this.operator.xEventControlValues(eventControls, evaluator, context, guardian);
        }

        @Override
        public boolean xEventTriggered(List<IHidOperator.XEventControlValue> prevValues, List<IHidOperator.XEventControlValue> currValues, IHidEvaluationGuardian guardian) {
            return this.operator.xEventTriggered(prevValues, currValues, guardian);
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.operator.getLanguageKind();
        }

        public XValueHolder getOverrideEvaluator() {
            return this.overrideEvaluator;
        }

        @Override
        public List<IHidOperator.XEventControl> xEventControls(IHidEvaluationGuardian guardian) {
            return this.operator.xEventControls(guardian);
        }

        public IHidOperator getOverrideOperator() {
            return this.operator;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        @Override
        public boolean hasQualifier(long qualifier) {
            return this.operator.hasQualifier(qualifier);
        }

        @Override
        public boolean hasOccurrence(long qualifiers) {
            return this.operator.hasOccurrence(qualifiers);
        }

        @Override
        public boolean hasOccurrence(HidOperatorQualifier qualifier) {
            return this.operator.hasOccurrence(qualifier);
        }

        @Override
        public int getVirtualOffset() {
            return this.operator.getVirtualOffset();
        }

        @Override
        public int getUsageIndex() {
            return this.operator.getUsageIndex();
        }

        @Override
        public String toString() {
            return this.operator.toString();
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            boolean isIndexedOp = this.operator instanceof XIndexedCopyConcatOperator;
            result = 31 * result + (this.operator == null ? 0 : (isIndexedOp ? this.operator.hashCode() : System.identityHashCode(this.operator)));
            result = 31 * result + (this.overrideEvaluator == null ? 0 : System.identityHashCode(this.overrideEvaluator));
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XEvalOverrideHidOperator other = (XEvalOverrideHidOperator)obj;
            if (this.overrideEvaluator != other.overrideEvaluator) {
                return false;
            }
            if (this.operator instanceof XIndexedCopyConcatOperator && other.operator instanceof XIndexedCopyConcatOperator) {
                return this.operator.equals(other.operator);
            }
            return this.operator == other.operator;
        }

        public boolean isDeclarationAssign() {
            return this.operator.hasQualifier(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER) || this.operator.hasQualifier(HidQualifierCache.IS_DECLARATION_EXPRESSION_QUALIFIER);
        }
    }

    public static class XEvalReleaseOverrideHidOperator
    extends XEvalOverrideHidOperator {
        private static final long serialVersionUID = 1L;

        public XEvalReleaseOverrideHidOperator(XValueHolder evaluator, HidOperator operator, ParserPath parserPath) {
            super(evaluator, operator, parserPath);
            this.lhValue = operator.getLHValue();
            this.rhValues = operator.getRHValues();
            this.overrideEvaluator = evaluator;
            this.operator = operator;
        }
    }

    public static class XIndexedCopyConcatOperator
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        protected HidOperator operator;
        protected int index;

        public XIndexedCopyConcatOperator(HidOperator operator, int index) {
            super(operator.getOperatorType(), operator.getOperatorKind(), operator.getOperatorText(), operator.getOffset(), operator.getLine(), operator.getOpenBoundary(), operator.getCloseBoundary(), operator.getQualifiers());
            this.lhValue = operator.getLHValue();
            this.rhValues = operator.getRHValues();
            this.operator = operator;
            this.index = index;
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            return ELUtils.evaluate(this.operator, evaluator, context, guardian);
        }

        @Override
        public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
            return ELUtils.evaluateForSize(this.operator, evaluator, origin, guardian);
        }

        @Override
        public LanguageKind getLanguageKind() {
            return this.operator.getLanguageKind();
        }

        public IHidOperator getOverrideOperator() {
            return this.operator;
        }

        @Override
        public boolean hasQualifier(long qualifier) {
            return this.operator.hasQualifier(qualifier);
        }

        @Override
        public boolean hasOccurrence(long qualifiers) {
            return this.operator.hasOccurrence(qualifiers);
        }

        @Override
        public boolean hasOccurrence(HidOperatorQualifier qualifier) {
            return this.operator.hasOccurrence(qualifier);
        }

        @Override
        public int getVirtualOffset() {
            return this.operator.getVirtualOffset();
        }

        @Override
        public int getUsageIndex() {
            return this.operator.getUsageIndex();
        }

        @Override
        public String toString() {
            return this.operator.toString();
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.index;
            result = 31 * result + super.hashCode();
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof XIndexedCopyConcatOperator)) {
                return false;
            }
            XIndexedCopyConcatOperator other = (XIndexedCopyConcatOperator)obj;
            if (this.index != other.index) {
                return false;
            }
            return super.equals(obj);
        }
    }

    private static class XLocalAssignsVisitor
    implements IHidVisitor<HidOperator> {
        private List<IHidOperator> operators;
        private List<IHidOperator> portExpressionOperators;
        private IRfNamedElement currentScope;
        private IHidEvaluationGuardian guardian;
        private HidOperator currentDelayControl;
        private HidOperator currentDriveStrength;
        private boolean isRuntimeElabOptimizedMode;

        public XLocalAssignsVisitor(List<IHidOperator> operators, List<IHidOperator> portExpressionOperators, IRfNamedElement currentScope, boolean isRuntimeElabOptimizedMode, IHidEvaluationGuardian guardian) {
            this.operators = operators;
            this.portExpressionOperators = portExpressionOperators;
            this.currentScope = currentScope;
            this.isRuntimeElabOptimizedMode = isRuntimeElabOptimizedMode;
            this.guardian = guardian;
        }

        @Override
        public boolean visit(HidOperator operator) {
            boolean isPortExpression;
            boolean isDeclarationAssign;
            boolean isComplete = operator.isComplete();
            if (!isComplete) {
                return true;
            }
            if (operator.isDriveStrength()) {
                this.currentDriveStrength = operator;
                return true;
            }
            if (operator.isVlogDelayControlStatement()) {
                this.currentDelayControl = operator;
                return true;
            }
            boolean bl = isDeclarationAssign = operator.hasQualifier(HidQualifierCache.IS_DECLARATION_ASSIGN_QUALIFIER) || operator.hasQualifier(HidQualifierCache.IS_DECLARATION_EXPRESSION_QUALIFIER);
            if (isDeclarationAssign) {
                IRfNamedElement element;
                if (HidUtils.isHidImplicit(operator.getLHValue())) {
                    operator = operator.shallowCopy();
                    IHid hid = ((HidImplicit)operator.getLHValue()).xToHid(this.currentScope, operator.getOccurrence());
                    operator.setLHValue(hid);
                }
                if (!HidUtils.isHid(operator.getLHValue())) {
                    this.guardian.logError("Fail to evaluate declaration assign (id: 0002)");
                }
                if ((element = ((Hid)operator.getLHValue()).getElement()) == null) {
                    this.guardian.logError("Fail to evaluate declaration assign (id: 0003)");
                }
                if (element instanceof IRfFieldElement && (((IRfFieldElement)element).isAnyParameter() || ((IRfFieldElement)element).isGenvar() || ELUtils.isVHDLConstantVariable(element))) {
                    return true;
                }
                if (operator.hasQualifier(HidQualifierCache.IS_WITH_CONTROL_QUALIFIER) && this.currentDelayControl != null) {
                    operator = HidEvalCenter.INSTANCE.createDelayedContinuousAssign(this.currentDelayControl, operator, operator.getOccurrence());
                } else {
                    this.currentDelayControl = null;
                }
                if (operator.hasQualifier(HidQualifierCache.IS_WITH_DRIVE_STRENGTH_QUALIFIER) && this.currentDriveStrength != null) {
                    operator = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(this.currentDriveStrength, operator, operator.getOccurrence());
                } else {
                    this.currentDriveStrength = null;
                }
                this.operators.add(operator);
                return true;
            }
            if (this.isRuntimeElabOptimizedMode) {
                return true;
            }
            boolean isContinuousAssign = operator.hasQualifier(HidQualifierCache.IS_CONTINUOUS_ASSIGN_QUALIFIER);
            if (isContinuousAssign) {
                if (operator.hasQualifier(HidQualifierCache.IS_WITH_CONTROL_QUALIFIER) && this.currentDelayControl != null) {
                    operator = HidEvalCenter.INSTANCE.createDelayedContinuousAssign(this.currentDelayControl, operator, operator.getOccurrence());
                } else {
                    this.currentDelayControl = null;
                }
                if (operator.hasQualifier(HidQualifierCache.IS_WITH_DRIVE_STRENGTH_QUALIFIER) && this.currentDriveStrength != null) {
                    operator = HidEvalCenter.INSTANCE.createDriveStrengthContinuousAssign(this.currentDriveStrength, operator, operator.getOccurrence());
                } else {
                    this.currentDriveStrength = null;
                }
                this.operators.add(operator);
            }
            boolean bl2 = isPortExpression = operator.hasQualifier(HidQualifierCache.IS_PORT_EXPRESSION_QUALIFIER) && !operator.hasQualifier(HidQualifierCache.IS_HIDDEN_QUALIFIER);
            if (isPortExpression) {
                this.portExpressionOperators.add(operator);
            }
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.currentDelayControl = null;
            this.currentDriveStrength = null;
        }

        @Override
        public Class<HidOperator> getType() {
            return HidOperator.class;
        }
    }

    public static class XModportValueHolder
    extends XValueHolder {
        private Map<String, IHidObject> portOperators;

        public XModportValueHolder(XValueHolderFactory factory, XNamedElement element, IELParamValue enclosing) {
            super(factory, element, enclosing, null, true, false);
            IRfNamedElement namedElement = element.getNamedElement();
            List<IHidOperator> operators = namedElement.getHidOperators(ELConstants.PORT_EXPRESSIONS_QUALIFIERS_ARRAY, true);
            if (operators == null || operators.isEmpty()) {
                return;
            }
            this.portOperators = new HashMap<String, IHidObject>();
            for (IHidOperator operator : operators) {
                String portName = XUtils.getName((IHid)operator.getLHValue());
                this.portOperators.put(portName, operator.getFirstRHValue());
            }
        }

        @Override
        public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
            IHidObject hidObject;
            IHidObject iHidObject = hidObject = this.portOperators == null ? null : this.portOperators.get(name);
            if (hidObject != null) {
                return ELUtils.evaluate(hidObject, this, null, this.factory.getEvaluationGuardian(true));
            }
            return ((XValueHolder)this.enclosing).getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }

        @Override
        public ELParamValueScope getValue(IHid hid, IHidEvaluator hidInitialScope, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
            IHidObject hidObject;
            String name = XUtils.getName(hid);
            IHidObject iHidObject = hidObject = this.portOperators == null ? null : this.portOperators.get(name);
            if (hidObject != null) {
                return ELUtils.evaluate(hidObject, this, null, guardian.copy());
            }
            return ((XValueHolder)this.enclosing).getValue(hid, hidInitialScope, context, isMethod, guardian);
        }
    }

    public static class XSelectOperator
    extends HidOperator {
        private static final long serialVersionUID = 1L;
        private int left;
        private int right;

        public XSelectOperator(IHidObject hidObject, int left, int right) {
            super(IHidOperatorConstants.OperatorType.ARRAY_OF_INSTANCES_PORT_CONNECTION_SELECT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "", -1, -1, -1, -1, 0L);
            this.setLHValue(hidObject);
            this.left = left;
            this.right = right;
        }

        @Override
        public String toString() {
            return DVTStringUtil.appendString(this.getLHValue().toString(), "[", this.left, ":", this.right, "]");
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        @Override
        public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
            if (guardian.shouldSkip(this)) {
                throw new SkippedHidObjectEvaluationException(this);
            }
            ELParamValueScope valueToSelectRawScope = ELUtils.evaluateForSize(this.getLHValue(), evaluator, origin, guardian.copy());
            IELParamValue valueToSelectRaw = XUtils.getValue(valueToSelectRawScope);
            IELParamValue valueToSelectScope = (IELParamValue)XUtils.getScope(valueToSelectRawScope);
            if (ELUtils.isUnsuccessfulEval(valueToSelectRaw)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            return ELParamValueScope.of(XValueHolderFactory.createSelectProxyValue(this.left, this.right, valueToSelectRaw, BitVectorContext.of(origin, false), true, false, guardian, LanguageKind.VLOG), valueToSelectScope);
        }

        @Override
        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            if (guardian.shouldSkip(this)) {
                throw new SkippedHidObjectEvaluationException(this);
            }
            IHidObject lhValue = this.getLHValue();
            BitVectorContext noContext = BitVectorContext.of(context == null ? null : context.getOrigin(), false);
            ELParamValueScope valueToSelectRawScope = ELUtils.evaluate(lhValue, evaluator, noContext, guardian.copy());
            IELParamValue valueToSelectRaw = XUtils.getValue(valueToSelectRawScope);
            IHidEvaluator valueToSelectScope = XUtils.getScope(valueToSelectRawScope);
            if (valueToSelectRaw == null) {
                throw new UnknownHidObjectEvaluationException(this);
            }
            if (ELUtils.isUnsuccessfulEval(valueToSelectRaw)) {
                return ELParamValueScope.UNDEFINED_VALUE;
            }
            IELParamValue value = XValueHolderFactory.createSelectProxyValue(this.left, this.right, valueToSelectRaw, context, false, false, guardian, LanguageKind.VLOG);
            return ELParamValueScope.of(value, valueToSelectScope);
        }

        @Override
        public int getVirtualOffset() {
            return -1;
        }

        @Override
        public int getUsageIndex() {
            return -1;
        }

        @Override
        public LanguageKind getLanguageKind() {
            return null;
        }

        public ListContainer<XComputedSelect> getComputedSelects() {
            IELParamValue[] computedValues = new IELParamValue[]{ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(this.left))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(this.right)))};
            XComputedSelect computedSelects = new XComputedSelect(HidUtils.makeStandInImplicit(Integer.toString(this.left), 0), computedValues);
            return computedSelects;
        }
    }
}

