/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.IXArrayValues;
import ro.amiq.dvt.interpreter.IXInternalForeachLoopAction;
import ro.amiq.dvt.interpreter.IXIterator;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XQueueValues;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XMapValues
implements IXArrayValues {
    protected Map<IELParamValue, IELParamValue> zValues = new TreeMap<IELParamValue, IELParamValue>(XArrayValueHolder.COMPARATOR);
    private IELParamValue defaultValue;
    private boolean isReversed;
    protected boolean isAssociative;
    private XArrayValueHolder xArrayValueHolder;
    private boolean debuggerIsMapEntry;

    public XMapValues(boolean isAssociative, XArrayValueHolder xArrayValueHolder) {
        this.isAssociative = isAssociative;
        this.xArrayValueHolder = xArrayValueHolder;
    }

    public XMapValues(XMapValues map) {
        this.isAssociative = map.isAssociative;
        this.isReversed = map.isReversed;
        this.defaultValue = map.defaultValue;
        this.xArrayValueHolder = map.xArrayValueHolder;
        this.debuggerIsMapEntry = map.debuggerIsMapEntry;
    }

    @Override
    public void setReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public void clear() {
        this.zValues.clear();
    }

    @Override
    public boolean copyByValue(IXArrayValues from, boolean clearBeforeCopy) {
        boolean isModified;
        block7: {
            boolean isReversed;
            int leftBound;
            int rightBound;
            block6: {
                boolean bl = isModified = from.size() > this.size() || clearBeforeCopy && from.size() < this.size() || this.partialEquals(this, from);
                if (clearBeforeCopy) {
                    this.zValues.clear();
                }
                rightBound = Math.max(0, this.xArrayValueHolder.getRightBound());
                leftBound = Math.max(0, this.xArrayValueHolder.getLeftBound());
                isReversed = from.isReversed() ^ this.isReversed();
                this.setDefaultValue(from.getDefaultValue());
                if (!(from instanceof XMapValues)) break block6;
                if (this.isAssociative) {
                    for (Map.Entry<IELParamValue, IELParamValue> entry : ((XMapValues)from).zValues.entrySet()) {
                        IELParamValue key = entry.getKey();
                        IELParamValue value = entry.getValue();
                        this.copyByValueItem(key, value);
                    }
                } else {
                    int index = isReversed ? Math.max(leftBound, rightBound) : Math.min(leftBound, rightBound);
                    for (Map.Entry<IELParamValue, IELParamValue> entry : ((XMapValues)from).zValues.entrySet()) {
                        IELParamValue key = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(index));
                        IELParamValue value = entry.getValue();
                        this.copyByValueItem(key, value);
                        int n = index = isReversed ? index - 1 : index + 1;
                    }
                }
                break block7;
            }
            if (!(from instanceof XQueueValues)) break block7;
            int size = ((XQueueValues)from).zValues.size();
            int i = isReversed ? size - 1 : 0;
            while (i >= 0 && i < size) {
                int index = leftBound > rightBound ? leftBound - i : (rightBound > leftBound ? leftBound + i : i);
                IELParamValue key = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(index));
                IELParamValue value = ((XQueueValues)from).zValues.get(i);
                this.copyByValueItem(key, value);
                int n = i = isReversed ? i - 1 : i + 1;
            }
        }
        return isModified;
    }

    private boolean partialEquals(IXArrayValues to, IXArrayValues from) {
        if (to.size() < from.size()) {
            return this.partialEquals(from, to);
        }
        boolean[] isModified = new boolean[1];
        from.foreach((key, value) -> {
            IELParamValue toValue = to.get(key, null);
            if (!value.equals(toValue)) {
                blArray[0] = true;
                return false;
            }
            return true;
        });
        return isModified[0];
    }

    private void copyByValueItem(IELParamValue key, IELParamValue value) {
        IELParamValue valueCopy = null;
        valueCopy = value instanceof XArrayValueHolder ? ((XArrayValueHolder)value).copyByValue() : this.xArrayValueHolder.createElementValueHolder(value);
        this.zValues.put(key, valueCopy);
    }

    @Override
    public boolean containsKey(IELParamValue key) {
        return this.zValues.containsKey(key);
    }

    @Override
    public boolean containsValue(IELParamValue value) {
        if (ELUtils.isUnsuccessfulEval(value)) {
            return false;
        }
        if (value instanceof XValueHolder) {
            return this.zValues.containsValue(value);
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return false;
        }
        return this.zValues.containsValue(value);
    }

    @Override
    public IELParamValue first() {
        if (this.zValues.isEmpty()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return (IELParamValue)((TreeMap)this.zValues).firstKey();
    }

    @Override
    public IELParamValue get(IELParamValue key, IHidEvaluationGuardian guardian) {
        IELParamValue value = this.zValues.get(key);
        if (value == null && this.defaultValue != null) {
            return this.defaultValue.shallowCopy();
        }
        if (value == null) {
            return null;
        }
        if (value instanceof XValueHolder) {
            return value;
        }
        IELParamValue scalarCopy = value.shallowCopy();
        scalarCopy.setOriginal(value);
        return scalarCopy;
    }

    @Override
    public void setDefaultValue(IELParamValue defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public IELParamValue getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void insert(IELParamValue index, IELParamValue value, IHidEvaluationGuardian guardian) {
        if (index instanceof ELParamValues.ParamValueNumber) {
            index = ELParamValues.ParamValueNumber.of(index);
        } else if (index instanceof XValueHolder) {
            index = ((XValueHolder)index).createKeyCopy();
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        this.zValues.put(index, value);
    }

    @Override
    public IELParamValue last() {
        if (this.zValues.isEmpty()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return (IELParamValue)((TreeMap)this.zValues).lastKey();
    }

    @Override
    public IELParamValue max() {
        DVTNumber maxNumber = null;
        for (Map.Entry<IELParamValue, IELParamValue> entry : this.zValues.entrySet()) {
            maxNumber = this.computeMinMax(maxNumber, entry.getValue(), false);
        }
        if (maxNumber != null) {
            return ELParamValues.ParamValueNumber.of(maxNumber);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue min() {
        DVTNumber minNumber = null;
        for (Map.Entry<IELParamValue, IELParamValue> entry : this.zValues.entrySet()) {
            minNumber = this.computeMinMax(minNumber, entry.getValue(), true);
        }
        if (minNumber != null) {
            return ELParamValues.ParamValueNumber.of(minNumber);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue next(IELParamValue index) {
        if (this.zValues.isEmpty() || index == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IELParamValue entry = ((TreeMap)this.zValues).higherKey(index);
        if (entry != null) {
            return entry;
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue pop_back() {
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue pop_front() {
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue prev(IELParamValue index) {
        if (this.zValues.isEmpty() || index == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IELParamValue entry = ((TreeMap)this.zValues).lowerKey(index);
        if (entry != null) {
            return entry;
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public void push_back(IELParamValue value) {
    }

    @Override
    public void push_front(IELParamValue value) {
    }

    @Override
    public void put(int intKey, IELParamValue value, IHidEvaluationGuardian guardian) {
        IELParamValue key = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(intKey));
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        this.zValues.put(key, value);
    }

    @Override
    public boolean put(IELParamValue key, IELParamValue value, IHidEvaluationGuardian guardian) {
        IELParamValue existingValue;
        if (key instanceof ELParamValues.ParamValueNumber) {
            key = ELParamValues.ParamValueNumber.of(key);
        } else if (key instanceof XValueHolder) {
            key = ((XValueHolder)key).createKeyCopy();
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        boolean isModified = !value.equals(existingValue = this.zValues.get(key));
        this.zValues.put(key, value);
        return isModified;
    }

    @Override
    public void remove(IELParamValue key, IHidEvaluationGuardian guardian) {
        this.zValues.remove(key);
    }

    @Override
    public int size() {
        return this.zValues.size();
    }

    @Override
    public IXIterator iterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        return new XIterator(selects, evaluator, guardian);
    }

    @Override
    public void foreach(IXInternalForeachLoopAction action) {
        ArrayList<Map.Entry<IELParamValue, IELParamValue>> entrySet = new ArrayList<Map.Entry<IELParamValue, IELParamValue>>(this.zValues.entrySet());
        if (this.isReversed) {
            Collections.reverse((List)entrySet);
        }
        for (Map.Entry entry : entrySet) {
            IELParamValue value;
            IELParamValue key = (IELParamValue)entry.getKey();
            if (!action.execute(key, value = (IELParamValue)entry.getValue())) break;
        }
    }

    @Override
    public void shuffle(Random random) {
    }

    @Override
    public boolean debuggerHasVariables() {
        return !this.zValues.isEmpty();
    }

    @Override
    public Map<DVTXVariableInfo, IELParamValue> debuggerGetSliceVariables(int lowerBound, int upperBound) {
        LinkedHashMap<DVTXVariableInfo, IELParamValue> result = new LinkedHashMap<DVTXVariableInfo, IELParamValue>();
        int index = -1;
        if (this.debuggerIsMapEntry) {
            for (Map.Entry<IELParamValue, IELParamValue> entry : this.zValues.entrySet()) {
                result.put(new DVTXVariableInfo("key", DVTXVariableType.NO_TYPE), entry.getKey());
                result.put(new DVTXVariableInfo("value", DVTXVariableType.NO_TYPE), entry.getValue());
            }
            return result;
        }
        for (Map.Entry<IELParamValue, IELParamValue> entry : this.zValues.entrySet()) {
            if (++index < lowerBound) continue;
            if (index > upperBound) break;
            this.debuggerIsMapEntry = true;
            XArrayValueHolder mapEntryArrayValueHolder = new XArrayValueHolder(this.xArrayValueHolder);
            this.debuggerIsMapEntry = false;
            mapEntryArrayValueHolder.clear();
            mapEntryArrayValueHolder.put(entry.getKey(), entry.getValue());
            result.put(new DVTXVariableInfo("[" + index + "]", DVTXVariableType.NO_TYPE), mapEntryArrayValueHolder);
        }
        return result;
    }

    @Override
    public List<IELParamValue> getZValues() {
        if (this.zValues == null || this.zValues.isEmpty()) {
            return null;
        }
        return new XArrayValueHolder.LazyInitArrayList(this.xArrayValueHolder, this.zValues.values());
    }

    @Override
    public IELParamValue getZValue(int index) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.zValues == null ? 0 : this.zValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMapValues other = (XMapValues)obj;
        return !(this.zValues == null ? other.zValues != null : !this.zValues.equals(other.zValues));
    }

    @Override
    public IELParamValue vlogEq(IXArrayValues arrayValues, BitVectorContext context) {
        if (arrayValues == null) {
            return IELParamValue.getFalseInContext(context);
        }
        if (this.size() != arrayValues.size()) {
            return IELParamValue.getFalseInContext(context);
        }
        if (this.getClass() != arrayValues.getClass()) {
            return IELParamValue.getFalseInContext(context);
        }
        XMapValues other = (XMapValues)arrayValues;
        for (Map.Entry<IELParamValue, IELParamValue> keyValueEntry : this.zValues.entrySet()) {
            IELParamValue vlogEq;
            IELParamValue value1 = keyValueEntry.getValue();
            IELParamValue value2 = other.zValues.get(keyValueEntry.getKey());
            if (value1 == null && value2 == null) continue;
            if (value1 == null || value2 == null) {
                return IELParamValue.getFalseInContext(context);
            }
            if (!(value1 instanceof ELParamValues.ParamValueNumber && value2 instanceof ELParamValues.ParamValueNumber ? !value1.getDVTNumber().equals(value2.getDVTNumber()) : ELUtils.isFalse(vlogEq = value1.vlogEq(value2, context)))) continue;
            return IELParamValue.getFalseInContext(context);
        }
        return IELParamValue.getTrueInContext(context);
    }

    public boolean getDebuggerIsMapEntry() {
        return this.debuggerIsMapEntry;
    }

    class XIterator
    implements IXIterator {
        private List<IHidObject> selects;
        private IHidEvaluator evaluator;
        private IHidEvaluationGuardian guardian;
        private IXIterator valueIterator;
        private Iterator<Map.Entry<IELParamValue, IELParamValue>> myIterator;

        public XIterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            this.selects = selects;
            this.evaluator = evaluator;
            this.guardian = guardian;
            ArrayList<Map.Entry<IELParamValue, IELParamValue>> entrySet = new ArrayList<Map.Entry<IELParamValue, IELParamValue>>(XMapValues.this.zValues.entrySet());
            if (XMapValues.this.isReversed) {
                Collections.reverse(entrySet);
            }
            this.myIterator = entrySet.iterator();
        }

        @Override
        public boolean next() {
            if (this.selects == null || this.selects.isEmpty()) {
                return false;
            }
            if (this.valueIterator != null && this.valueIterator.next()) {
                return true;
            }
            if (this.myIterator == null) {
                return false;
            }
            this.valueIterator = null;
            IHidObject indexHidObject = this.selects.get(0);
            boolean hasNext = this.myIterator.hasNext();
            boolean isSkipFirstIndex = HidUtils.isHidImplicit(indexHidObject) && ((HidImplicit)indexHidObject).getType() == IHidImplicitConstants.ImplicitType.EMPTY.id;
            IELParamValue value = null;
            if (isSkipFirstIndex) {
                this.myIterator = null;
                this.guardian.logWarning("Create default value for non existing entry in associative array");
                value = XMapValues.this.xArrayValueHolder.createElementValueHolder();
                if (ELUtils.isUnsuccessfulEval(value)) {
                    this.guardian.logError("Fail to evaluate default array item");
                    return false;
                }
            } else {
                if (!hasNext) {
                    return false;
                }
                Map.Entry<IELParamValue, IELParamValue> entry = this.myIterator.next();
                IELParamValue indexValue = entry.getKey();
                value = entry.getValue();
                if (this.guardian.isLinterStaticAnalysisMode()) {
                    BitVectorContext defaultContext = BitVectorContext.of(null, false);
                    IELParamValue newIndexValue = XUtils.getValue(ELUtils.evaluate(indexHidObject, this.evaluator, defaultContext, this.guardian));
                    this.guardian.guardValueUpdate(newIndexValue.getElement(), null, newIndexValue, indexValue);
                } else {
                    this.evaluator.putValueDirectly(XUtils.getName((IHid)indexHidObject), indexValue);
                }
            }
            if (this.selects.size() > 1) {
                if (value == null) {
                    return false;
                }
                this.valueIterator = value.iterator(this.selects.subList(1, this.selects.size()), this.evaluator, this.guardian);
                return this.valueIterator.next();
            }
            return true;
        }
    }
}

