/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.IXArrayValues;
import ro.amiq.dvt.interpreter.IXInternalForeachLoopAction;
import ro.amiq.dvt.interpreter.IXIterator;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XMapValues;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XQueueValues
implements IXArrayValues {
    protected List<IELParamValue> zValues;
    private int maxSize;
    private int offset;
    private boolean isReversed;
    private boolean isQueue;
    private XArrayValueHolder xArrayValueHolder;

    public XQueueValues(boolean isQueue, XArrayValueHolder xArrayValueHolder) {
        this.zValues = new XArrayValueHolder.LazyInitArrayList(xArrayValueHolder);
        this.maxSize = -1;
        this.offset = 0;
        this.isQueue = isQueue;
        this.xArrayValueHolder = xArrayValueHolder;
    }

    public XQueueValues(XQueueValues queue) {
        this.zValues = new XArrayValueHolder.LazyInitArrayList(queue.xArrayValueHolder);
        this.maxSize = queue.maxSize;
        this.offset = queue.offset;
        this.isReversed = queue.isReversed;
        this.isQueue = queue.isQueue;
        this.xArrayValueHolder = queue.xArrayValueHolder;
    }

    @Override
    public void setReversed(boolean isReversed) {
        this.isReversed = isReversed;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public void clear() {
        this.zValues.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean copyByValue(IXArrayValues from, boolean clearBeforeCopy) {
        boolean isModified;
        block7: {
            void var7_14;
            boolean isReversed;
            block6: {
                boolean bl = isModified = from.size() > this.size() || clearBeforeCopy && from.size() < this.size() || this.partialEquals(this, from);
                if (clearBeforeCopy) {
                    this.zValues.clear();
                }
                isReversed = from.isReversed() ^ this.isReversed();
                this.setDefaultValue(from.getDefaultValue());
                if (!(from instanceof XMapValues)) break block6;
                Collection<Map.Entry<IELParamValue, IELParamValue>> entrySet = ((XMapValues)from).zValues.entrySet();
                if (isReversed) {
                    entrySet = new ArrayList<Map.Entry<IELParamValue, IELParamValue>>(entrySet);
                    Collections.reverse((List)entrySet);
                }
                int index = 0;
                for (Map.Entry entry : entrySet) {
                    IELParamValue value = (IELParamValue)entry.getValue();
                    this.copyByValueItem(index, value);
                    ++index;
                }
                break block7;
            }
            if (!(from instanceof XQueueValues)) break block7;
            int size = ((XQueueValues)from).zValues.size();
            int index = 0;
            int n = isReversed ? size - 1 : 0;
            while (var7_14 >= 0 && var7_14 < size) {
                try {
                    IELParamValue value = ((XQueueValues)from).zValues.get((int)var7_14);
                    this.copyByValueItem(index, value);
                    ++index;
                }
                catch (ExceedMaxSize e) {
                    this.xArrayValueHolder.getFactory().getEvaluationGuardian(false).logWarning(e.getMessage());
                }
                void v1 = var7_14 = isReversed ? var7_14 - true : var7_14 + true;
            }
        }
        return isModified;
    }

    private boolean partialEquals(IXArrayValues to, IXArrayValues from) {
        if (to.size() < from.size()) {
            return this.partialEquals(from, to);
        }
        boolean[] isModified = new boolean[1];
        from.foreach((key, value) -> {
            IELParamValue toValue = to.get(key, null);
            if (XUtils.isModified(toValue, value)) {
                blArray[0] = true;
                return false;
            }
            return true;
        });
        return isModified[0];
    }

    private void copyByValueItem(int index, IELParamValue value) {
        if (this.maxSize > 0 && this.zValues.size() >= this.maxSize) {
            throw new ExceedMaxSize(this.maxSize, this.isQueue);
        }
        IELParamValue valueCopy = value == null ? null : (value instanceof XArrayValueHolder ? ((XArrayValueHolder)value).copyByValue() : this.xArrayValueHolder.createElementValueHolder(value));
        if (index == this.zValues.size()) {
            this.zValues.add(valueCopy);
        } else {
            this.zValues.set(index, valueCopy);
        }
    }

    @Override
    public boolean containsKey(IELParamValue key) {
        if (ELUtils.isUnsuccessfulEval(key)) {
            return false;
        }
        DVTNumber dvtNumber = key.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return false;
        }
        int index = dvtNumber.intValue() - this.offset;
        return index >= 0 && index < this.zValues.size();
    }

    @Override
    public boolean containsValue(IELParamValue value) {
        if (ELUtils.isUnsuccessfulEval(value)) {
            return false;
        }
        if (value instanceof XValueHolder) {
            return this.zValues.contains(value);
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return false;
        }
        return this.zValues.contains(value);
    }

    @Override
    public IELParamValue first() {
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue get(IELParamValue key, IHidEvaluationGuardian guardian) {
        int index;
        if (ELUtils.isUnsuccessfulEval(key)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        DVTNumber dvtNumber = key.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (guardian != null && dvtNumber.isAmbiguous()) {
            guardian.logWarning("Ignored x/z bits in invalid index " + dvtNumber.intValue() + ".");
        }
        if ((index = dvtNumber.intValue() - this.offset) < 0 || index >= this.zValues.size()) {
            return null;
        }
        IELParamValue value = this.zValues.get(index);
        if (value == null) {
            return null;
        }
        if (value instanceof XValueHolder) {
            return value;
        }
        IELParamValue scalarCopy = value.shallowCopy();
        scalarCopy.setOriginal(value);
        return scalarCopy;
    }

    @Override
    public void insert(IELParamValue key, IELParamValue value, IHidEvaluationGuardian guardian) {
        if (ELUtils.isUnsuccessfulEval(key)) {
            return;
        }
        DVTNumber dvtNumber = key.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return;
        }
        int index = dvtNumber.intValue() - this.offset;
        if (this.maxSize > 0 && index >= this.maxSize) {
            throw new ExceedMaxSize(this.maxSize, this.isQueue);
        }
        if (index < 0 || index > this.zValues.size()) {
            this.printOutOfBoundsWarning(guardian, index);
            return;
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        this.zValues.add(index, value);
        if (this.maxSize > 0 && this.zValues.size() > this.maxSize) {
            this.zValues.remove(this.zValues.size() - 1);
        }
    }

    @Override
    public IELParamValue last() {
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue max() {
        DVTNumber maxNumber = null;
        int i = 0;
        while (i < this.zValues.size()) {
            maxNumber = this.computeMinMax(maxNumber, this.zValues.get(i), false);
            ++i;
        }
        if (maxNumber != null) {
            return ELParamValues.ParamValueNumber.of(maxNumber);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue min() {
        DVTNumber minNumber = null;
        int i = 0;
        while (i < this.zValues.size()) {
            minNumber = this.computeMinMax(minNumber, this.zValues.get(i), true);
            ++i;
        }
        if (minNumber != null) {
            return ELParamValues.ParamValueNumber.of(minNumber);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue next(IELParamValue index) {
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue pop_back() {
        if (this.zValues.isEmpty()) {
            return null;
        }
        return this.zValues.remove(this.zValues.size() - 1);
    }

    @Override
    public IELParamValue pop_front() {
        if (this.zValues.isEmpty()) {
            return null;
        }
        return this.zValues.remove(0);
    }

    @Override
    public IELParamValue prev(IELParamValue index) {
        return IELParamValue.UNDEFINED_VALUE;
    }

    @Override
    public void push_back(IELParamValue value) {
        if (this.maxSize > 0 && this.zValues.size() >= this.maxSize) {
            throw new ExceedMaxSize(this.maxSize, this.isQueue);
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        this.zValues.add(value);
    }

    @Override
    public void push_front(IELParamValue value) {
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        this.zValues.add(0, value);
        if (this.maxSize > 0 && this.zValues.size() > this.maxSize) {
            this.zValues.remove(this.zValues.size() - 1);
        }
    }

    @Override
    public void put(int origIndex, IELParamValue value, IHidEvaluationGuardian guardian) {
        int index = origIndex - this.offset;
        if (index < 0 || index > this.zValues.size() || this.maxSize > 0 && index >= this.maxSize) {
            throw new ExceedMaxSize(this.maxSize, this.isQueue);
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        if (index == this.zValues.size()) {
            this.zValues.add(value);
        } else {
            this.zValues.set(index, value);
        }
    }

    private void printOutOfBoundsWarning(IHidEvaluationGuardian guardian, int index) {
        if (guardian == null) {
            return;
        }
        if (this.zValues.isEmpty()) {
            guardian.logWarning("Ignored out of bounds index " + (index + this.offset) + " (array/queue is empty).");
        } else {
            guardian.logWarning("Ignored out of bounds index " + (index + this.offset) + " (valid index in range [" + this.offset + ": " + (this.zValues.size() + this.offset - 1) + "]).");
        }
    }

    @Override
    public boolean put(IELParamValue key, IELParamValue value, IHidEvaluationGuardian guardian) {
        int index;
        if (ELUtils.isUnsuccessfulEval(key)) {
            return false;
        }
        DVTNumber dvtNumber = key.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return false;
        }
        if (guardian != null && dvtNumber.isAmbiguous()) {
            guardian.logWarning("Ignored x/z bits in invalid index " + dvtNumber.intValue() + ".");
        }
        if ((index = dvtNumber.intValue() - this.offset) < 0 || index > this.zValues.size()) {
            this.printOutOfBoundsWarning(guardian, index);
            return false;
        }
        if (this.maxSize > 0 && index == this.maxSize && this.zValues.size() >= this.maxSize) {
            throw new ExceedMaxSize(this.maxSize, this.isQueue);
        }
        if (value instanceof ELParamValues.ParamValueNumber) {
            value = ELParamValues.ParamValueNumber.of(value);
        }
        if (index == this.zValues.size()) {
            this.zValues.add(value);
            return true;
        }
        IELParamValue existingValue = this.zValues.get(index);
        boolean isModified = XUtils.isModified(existingValue, value);
        this.zValues.set(index, value);
        return isModified;
    }

    @Override
    public void remove(IELParamValue key, IHidEvaluationGuardian guardian) {
        int index;
        if (ELUtils.isUnsuccessfulEval(key)) {
            return;
        }
        DVTNumber dvtNumber = key.getDVTNumber();
        if (DVTNumber.isUndefined(dvtNumber)) {
            return;
        }
        if (guardian != null && dvtNumber.isAmbiguous()) {
            guardian.logWarning("Ignored x/z bits in invalid index " + dvtNumber.intValue() + ".");
        }
        if ((index = dvtNumber.intValue() - this.offset) < 0 || index >= this.zValues.size()) {
            this.printOutOfBoundsWarning(guardian, index);
            return;
        }
        this.zValues.remove(index);
    }

    @Override
    public int size() {
        return this.zValues.size();
    }

    @Override
    public IXIterator iterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        return new XIterator(selects, evaluator, guardian);
    }

    @Override
    public void foreach(IXInternalForeachLoopAction action) {
        int size = this.zValues.size();
        int i = this.isReversed ? size - 1 : 0;
        while (i >= 0 && i < size) {
            IELParamValue key = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(i));
            IELParamValue value = this.zValues.get(i);
            if (value == null) {
                value = this.xArrayValueHolder.createElementValueHolder();
            }
            if (!action.execute(key, value)) break;
            int n = i = this.isReversed ? i - 1 : i + 1;
        }
    }

    @Override
    public void shuffle(Random random) {
        Collections.shuffle(this.zValues, random);
    }

    @Override
    public boolean debuggerHasVariables() {
        return !this.zValues.isEmpty();
    }

    @Override
    public Map<DVTXVariableInfo, IELParamValue> debuggerGetSliceVariables(int lowerBound, int upperBound) {
        TreeMap<DVTXVariableInfo, IELParamValue> result = new TreeMap<DVTXVariableInfo, IELParamValue>((o1, o2) -> {
            String varName1 = o1.getVariableName();
            String varName2 = o2.getVariableName();
            return Integer.parseInt(varName1.substring(1, varName1.length() - 1)) - Integer.parseInt(varName2.substring(1, varName2.length() - 1));
        });
        int i = lowerBound;
        while (i < upperBound + 1) {
            result.put(new DVTXVariableInfo("[" + Integer.toString(i + this.offset) + "]", DVTXVariableType.NO_TYPE), this.zValues.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public String mUvmStringQueueJoin() {
        StringBuilder result = new StringBuilder();
        for (IELParamValue value : this.zValues) {
            DVTNumber number;
            if (value == null || (number = value.getDVTNumber()) == null) continue;
            result.append(number.xGetRawString());
        }
        return result.toString();
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    public void setIndexOffset(int offset) {
        this.offset = offset;
    }

    public int getIndexOffset() {
        return this.offset;
    }

    @Override
    public List<IELParamValue> getZValues() {
        return this.zValues;
    }

    @Override
    public IELParamValue getZValue(int index) {
        if (this.zValues == null || this.zValues.isEmpty()) {
            return null;
        }
        return this.zValues.get(index -= this.offset);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.zValues == null ? 0 : this.zValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XQueueValues other = (XQueueValues)obj;
        return !(this.zValues == null ? other.zValues != null : !this.zValues.equals(other.zValues));
    }

    @Override
    public IELParamValue vlogEq(IXArrayValues arrayValues, BitVectorContext context) {
        if (arrayValues == null) {
            return IELParamValue.getFalseInContext(context);
        }
        if (this.size() != arrayValues.size()) {
            return IELParamValue.getFalseInContext(context);
        }
        if (this.getClass() != arrayValues.getClass()) {
            return IELParamValue.getFalseInContext(context);
        }
        XQueueValues other = (XQueueValues)arrayValues;
        int i = 0;
        while (i < this.zValues.size()) {
            IELParamValue value1 = this.zValues.get(i);
            IELParamValue value2 = other.zValues.get(i);
            if (value1 != null || value2 != null) {
                IELParamValue vlogEq;
                if (value1 == null || value2 == null) {
                    return IELParamValue.getFalseInContext(context);
                }
                if (value1 instanceof ELParamValues.ParamValueNumber && value2 instanceof ELParamValues.ParamValueNumber ? !value1.getDVTNumber().equals(value2.getDVTNumber()) : ELUtils.isFalse(vlogEq = value1.vlogEq(value2, context))) {
                    return IELParamValue.getFalseInContext(context);
                }
            }
            ++i;
        }
        return IELParamValue.getTrueInContext(context);
    }

    public static class ExceedMaxSize
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ExceedMaxSize(int maxSize, boolean isQueue) {
            super("Operation exeeds max " + (isQueue ? "queue" : "array") + " size " + maxSize + " (operation ignored)");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    class XIterator
    implements IXIterator {
        private List<IHidObject> selects;
        private IHidEvaluator evaluator;
        private IHidEvaluationGuardian guardian;
        private int index;
        private IXIterator valueIterator;

        public XIterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
            this.selects = selects;
            this.evaluator = evaluator;
            this.guardian = guardian;
            this.index = XQueueValues.this.isReversed ? XQueueValues.this.offset + XQueueValues.this.zValues.size() - 1 : XQueueValues.this.offset;
        }

        @Override
        public boolean next() {
            if (this.selects == null || this.selects.isEmpty()) {
                return false;
            }
            if (this.valueIterator != null && this.valueIterator.next()) {
                return true;
            }
            this.valueIterator = null;
            IHidObject indexHidObject = this.selects.get(0);
            if (this.index >= XQueueValues.this.offset + XQueueValues.this.zValues.size() || this.index < XQueueValues.this.offset) {
                return false;
            }
            IELParamValue indexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(this.index));
            IELParamValue value = XQueueValues.this.get(indexValue, this.guardian);
            int n = this.index = XQueueValues.this.isReversed ? this.index - 1 : this.index + 1;
            if (this.guardian.isLinterStaticAnalysisMode()) {
                BitVectorContext defaultContext = BitVectorContext.of(null, false);
                IELParamValue newIndexValue = XUtils.getValue(ELUtils.evaluate(indexHidObject, this.evaluator, defaultContext, this.guardian));
                this.guardian.guardValueUpdate(newIndexValue.getElement(), null, newIndexValue, indexValue);
            } else if (HidUtils.isHidImplicit(indexHidObject) && ((HidImplicit)indexHidObject).getType() == IHidImplicitConstants.ImplicitType.EMPTY.id) {
                this.index = -1;
            } else {
                this.evaluator.putValueDirectly(XUtils.getName((IHid)indexHidObject), indexValue);
            }
            if (this.selects.size() > 1) {
                if (value == null) {
                    return false;
                }
                this.valueIterator = value.iterator(this.selects.subList(1, this.selects.size()), this.evaluator, this.guardian);
                return this.valueIterator.next();
            }
            return true;
        }
    }
}

