/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.MaxLoopCountEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;

public class XRepeatEvalScope
extends XEvalScope {
    private IHidObject statement;
    private int loopCounter;
    private int nofRepeats;
    private String indexName;

    public XRepeatEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject statement, int nofRepeats, int repeatLine) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian);
        this.statement = statement;
        this.nofRepeats = nofRepeats;
        this.indexName = DVTStringUtil.appendString("[repeat index @", repeatLine, "]");
    }

    @Override
    protected final ELParamValueScope executeStatement(IHidObject nextStatement) {
        if (this.loopCounter++ >= this.maxLoopCount) {
            String message = "Repeat loop counter > " + this.maxLoopCount;
            if (this.isRuntimeElabMode(this.guardian)) {
                this.guardian.logWarning(message);
                this.setDisabled();
            } else {
                this.guardian.logError(message);
                throw new MaxLoopCountEvaluationException((IHidObject)this.parentOperator, this.maxLoopCount);
            }
        }
        if (!this.guardian.isRunMode()) {
            IELParamValue indexValue = this.evaluator.getValueDirectly(this.indexName);
            if (indexValue == null) {
                indexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(this.loopCounter)));
                this.evaluator.putValueDirectly(this.indexName, indexValue);
            } else {
                indexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.copy((VlogBitVector)indexValue.getDVTNumber(), BigInteger.valueOf(this.loopCounter)));
                this.evaluator.putValueDirectly(this.indexName, indexValue);
            }
        }
        return super.executeStatement(nextStatement);
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            return this.guardian.guardControlFlowConditionTested(null, this.parentOperator.getLHValue(), this.evaluator, this.loopCounter < this.nofRepeats ? VlogBitVector.BIT_ONE : VlogBitVector.BIT_ZERO, this.loopCounter) ? this.statement : null;
        }
        return this.loopCounter < this.nofRepeats ? this.statement : null;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return true;
    }

    public void hotSwap(IHidObject statement) {
        this.statement = statement;
    }
}

