/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.OptimizedUtils;

public class XSelectProxy {
    private IELParamValue valueBeforeSelect;
    public ListContainer<XComputedSelect> computedSelects;
    public BitVectorContext context;
    public IHidEvaluationGuardian guardian;

    public XSelectProxy(IELParamValue valueBeforeSelect, ListContainer<XComputedSelect> computedSelects, BitVectorContext context, IHidEvaluationGuardian guardian) {
        this.valueBeforeSelect = valueBeforeSelect;
        this.computedSelects = computedSelects;
        this.context = context;
        this.guardian = guardian;
    }

    public XSelectProxy getFirstSelectProxy() {
        int size = this.computedSelects.size();
        if (size < 2) {
            return this;
        }
        return new XSelectProxy(this.valueBeforeSelect, this.computedSelects.get(0), this.context, this.guardian);
    }

    public XSelectProxy getDecreasedSelectProxy(IELParamValue value) {
        int size = this.computedSelects.size();
        if (size <= 1) {
            return null;
        }
        if (size == 2) {
            return new XSelectProxy(value, this.computedSelects.get(1), this.context, this.guardian);
        }
        ArrayListContainer<XComputedSelect> subComputedSelects = new ArrayListContainer<XComputedSelect>(size - 1);
        int i = 1;
        while (i < size) {
            subComputedSelects.add(this.computedSelects.get(i));
            ++i;
        }
        return new XSelectProxy(value, subComputedSelects, this.context, this.guardian);
    }

    public XSelectProxy getParentSelectProxy(IELParamValue value) {
        int size = this.computedSelects.size();
        if (size <= 1) {
            return null;
        }
        if (size == 2) {
            return new XSelectProxy(value, this.computedSelects.get(0), null, this.guardian);
        }
        ArrayListContainer<XComputedSelect> subComputedSelects = new ArrayListContainer<XComputedSelect>(size - 1);
        int i = 0;
        while (i < size - 1) {
            subComputedSelects.add(this.computedSelects.get(i));
            ++i;
        }
        return new XSelectProxy(value, subComputedSelects, null, this.guardian);
    }

    public XSelectProxy appendSelectProxy(XSelectProxy select) {
        ArrayListContainer<XComputedSelect> newComputedSelects = new ArrayListContainer<XComputedSelect>(this.computedSelects.size() + select.computedSelects.size());
        int i = 0;
        while (i < this.computedSelects.size()) {
            newComputedSelects.add(this.computedSelects.get(i));
            ++i;
        }
        i = 0;
        while (i < select.computedSelects.size()) {
            newComputedSelects.add(select.computedSelects.get(i));
            ++i;
        }
        return new XSelectProxy(this.valueBeforeSelect, newComputedSelects, null, this.guardian);
    }

    public IELParamValue getValueBeforeSelectRaw() {
        return this.valueBeforeSelect;
    }

    public IELParamValue getValueBeforeSelect() {
        IELParamValue original = this.valueBeforeSelect.getOriginal();
        if (original == null) {
            return this.valueBeforeSelect;
        }
        return original;
    }

    public XSelectProxy getSelectProxy() {
        XSelectProxy selectProxy = this.valueBeforeSelect.getSelectProxy();
        if (selectProxy != null) {
            return selectProxy;
        }
        IELParamValue original = this.valueBeforeSelect.getOriginal();
        if (original != null) {
            return original.getSelectProxy();
        }
        return null;
    }

    public void addComputedSelect(XComputedSelect select) {
        if (this.computedSelects == null || this.computedSelects.isEmpty()) {
            this.computedSelects = select;
        }
        this.computedSelects = OptimizedUtils.listContainerAdd(this.computedSelects, select);
    }
}

