/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XSemaphoreValueHolder
extends XValueHolder {
    private int[] nofAvailableKeys = new int[1];
    private List<SemaphoreRequest> putListeners = new ArrayList<SemaphoreRequest>();

    public XSemaphoreValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder, boolean isNull) {
        super(factory, xAssociatedType, enclosing, instanceScope, isStaticHolder, isNull);
    }

    @Override
    protected boolean updateValue(IELParamValue newResult, boolean keepRef) {
        boolean isModified = false;
        if (newResult instanceof XSemaphoreValueHolder) {
            XSemaphoreValueHolder xNewResult = (XSemaphoreValueHolder)newResult;
            if (IELParamValue.NULL_VALUE == xNewResult) {
                isModified = this.nofAvailableKeys[0] != 0 || !this.putListeners.isEmpty();
                this.nofAvailableKeys = new int[1];
                this.putListeners.clear();
            } else {
                isModified = this.nofAvailableKeys[0] != xNewResult.nofAvailableKeys[0] || !Objects.equals(this.putListeners, xNewResult.putListeners);
                this.nofAvailableKeys = xNewResult.nofAvailableKeys;
                this.putListeners = xNewResult.putListeners;
            }
        }
        return isModified |= super.updateValue(newResult, keepRef);
    }

    public IELParamValue executePredefinedMethod(IHidOperator hidObject, IHidEvaluator methodValueHolder, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        String methodName = methodValueHolder.getNamedElement().getName();
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        boolean isNullSemaphore = this.isNull();
        if (isNullSemaphore) {
            guardian.logWarning("Try to evaluate method '" + methodName + "' on a null semaphore");
            return IELParamValue.UNDEFINED_VALUE;
        }
        if ("new".equals(methodName)) {
            this.nofAvailableKeys[0] = 0;
            IELParamValue keyCountValue = methodValueHolder.getValueDirectly("keyCount");
            if (ELUtils.isUnsuccessfulEval(keyCountValue)) {
                return this;
            }
            DVTNumber keyCountNumber = keyCountValue.getDVTNumber();
            if (DVTNumber.isUndefined(keyCountNumber)) {
                return this;
            }
            this.nofAvailableKeys[0] = keyCountNumber.intValue();
            return this;
        }
        if ("try_get".equals(methodName)) {
            DVTNumber keyCountNumber;
            int keyCount = 1;
            IELParamValue keyCountValue = methodValueHolder.getValueDirectly("keyCount");
            if (!ELUtils.isUnsuccessfulEval(keyCountValue) && !DVTNumber.isUndefined(keyCountNumber = keyCountValue.getDVTNumber())) {
                keyCount = keyCountNumber.intValue();
            }
            if (this.nofAvailableKeys[0] < keyCount) {
                return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
            }
            this.nofAvailableKeys[0] = this.nofAvailableKeys[0] - keyCount;
            return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
        }
        if ("get".equals(methodName)) {
            DVTNumber keyCountNumber;
            int keyCount = 1;
            IELParamValue keyCountValue = methodValueHolder.getValueDirectly("keyCount");
            if (!ELUtils.isUnsuccessfulEval(keyCountValue) && !DVTNumber.isUndefined(keyCountNumber = keyCountValue.getDVTNumber())) {
                keyCount = keyCountNumber.intValue();
            }
            if (this.nofAvailableKeys[0] < keyCount) {
                XThread activeThread = guardian.getActiveThread();
                this.putListeners.add(new SemaphoreRequest(activeThread, keyCount));
                guardian.callbackYieldThread(true);
            }
            this.nofAvailableKeys[0] = this.nofAvailableKeys[0] - keyCount;
            return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
        }
        if ("put".equals(methodName)) {
            DVTNumber keyCountNumber;
            int keyCount = 1;
            IELParamValue keyCountValue = methodValueHolder.getValueDirectly("keyCount");
            if (!ELUtils.isUnsuccessfulEval(keyCountValue) && !DVTNumber.isUndefined(keyCountNumber = keyCountValue.getDVTNumber())) {
                keyCount = keyCountNumber.intValue();
            }
            this.nofAvailableKeys[0] = this.nofAvailableKeys[0] + keyCount;
            int tempNofAvailableKeys = this.nofAvailableKeys[0];
            while (!this.putListeners.isEmpty()) {
                SemaphoreRequest listener = this.putListeners.get(0);
                if (listener.xThread.getState() != XThread.XThreadState.YIELDING) {
                    this.putListeners.remove(0);
                    continue;
                }
                if (tempNofAvailableKeys < listener.nofRequestedKeys) break;
                tempNofAvailableKeys -= listener.nofRequestedKeys;
                guardian.callbackResumeThread(listener.xThread);
                this.putListeners.remove(0);
            }
            return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
        }
        return null;
    }

    @Override
    public boolean debuggerHasVariables(boolean isFirstStackFrame) {
        return true;
    }

    public TreeMap<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
        TreeMap<DVTXVariableInfo, IELParamValue> result = new TreeMap<DVTXVariableInfo, IELParamValue>();
        result.put(new DVTXVariableInfo("size", DVTXVariableType.NO_TYPE), ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(this.nofAvailableKeys[0])));
        return result;
    }

    static class SemaphoreRequest {
        private int nofRequestedKeys;
        private XThread xThread;

        private SemaphoreRequest(XThread xThread, int nofRequestedKeys) {
            this.xThread = xThread;
            this.nofRequestedKeys = nofRequestedKeys;
        }
    }
}

