/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;

public class XSeqBlockEvalScope
extends XEvalScope {
    private ListContainer<IHidObject> statements;
    protected int pc;
    protected IHidObject nextStatement;
    private boolean isForkEvalScope;

    public XSeqBlockEvalScope(IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, ListContainer<IHidObject> statements) {
        super(null, parentOperator, evaluator, bvContext, guardian);
        this.statements = statements;
        this.pc = -1;
        this.nextStatement = null;
        this.isForkEvalScope = false;
    }

    public void setForkEvalScope(boolean isForkEvalScope) {
        this.isForkEvalScope = isForkEvalScope;
    }

    @Override
    public void setDisabled() {
        super.setDisabled();
        this.pc = Integer.MAX_VALUE;
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        this.nextStatement = this.getNextStatementInternal();
        return this.nextStatement;
    }

    private IHidObject getNextStatementInternal() {
        if (this.statements == null) {
            return null;
        }
        if (this.pc == Integer.MAX_VALUE) {
            return null;
        }
        ++this.pc;
        if (this.pc < this.statements.size()) {
            return this.statements.get(this.pc);
        }
        return null;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return false;
    }

    @Override
    public void setStatements(ListContainer<IHidObject> statements) {
        this.statements = statements;
    }

    @Override
    public ListContainer<IHidObject> getStatements() {
        return this.statements;
    }

    public IHidObject getLastStatement() {
        int size = this.statements.size();
        if (size > 0) {
            return this.statements.get(size - 1);
        }
        return null;
    }

    public void hotSwap(ListContainer<IHidObject> statements) {
        this.statements = statements;
        if (this.pc >= 0 && this.pc < statements.size()) {
            this.nextStatement = statements.get(this.pc);
        }
    }

    public IHidObject getNextStatementNoIncrement() {
        return this.nextStatement;
    }

    public void setParentOperator(IHidOperator parentOperator) {
        this.parentOperator = parentOperator;
    }

    public void resetStatementNum() {
        this.pc = -1;
        this.nextStatement = null;
    }

    @Override
    protected boolean isForkEvalScope() {
        return this.isForkEvalScope;
    }
}

