/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.DuplicateFormatFlagsException;
import java.util.EnumMap;
import java.util.FormatFlagsConversionMismatchException;
import java.util.HashSet;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogAbstractRealNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.XGlobalCache;

public class XStringFormatter {
    private StringBuilder a = new StringBuilder();
    private IOException lastException;
    public int lastArgumentReferenced;
    private IHidEvaluator evaluator;
    private boolean useLowerCaseMaskType;
    public static final String UNKNOWN_NA_NA_STRING = "NA.NA";
    private static final String formatSpecifier = "%(\\*)?(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([a-zA-Z%])";
    private static final Pattern fsPattern = Pattern.compile("%(\\*)?(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([a-zA-Z%])");
    private static final String octaValue = "[0-7]";
    private static final Pattern octaPattern = Pattern.compile("[0-7]");
    private static final String hexValue = "[0-9a-fA-F]";
    private static final Pattern hexPattern = Pattern.compile("[0-9a-fA-F]");
    private static final String binaryValue = "[01]";
    private static final Pattern binaryPattern = Pattern.compile("[01]");
    private static final String xValue = "[xX]";
    private static final Pattern xPattern = Pattern.compile("[xX]");
    private static final String zValue = "[zZ]";
    private static final Pattern zPattern = Pattern.compile("[zZ]");
    private static Set<Character> DECIMAL_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('_')));
    private static Set<Character> FLOAT_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.'), Character.valueOf('_'), Character.valueOf('?'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('e'), Character.valueOf('E')));
    public static final Set<Character> BINARY_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('x'), Character.valueOf('X'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('_'), Character.valueOf('?')));
    public static final Set<Character> HEXADECIMAL_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('x'), Character.valueOf('X'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('_'), Character.valueOf('?')));
    private static Set<Character> OCTAL_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('x'), Character.valueOf('X'), Character.valueOf('z'), Character.valueOf('Z'), Character.valueOf('_'), Character.valueOf('?')));
    private static Set<Character> UNFORMATED_TWO_VALUES = new HashSet<Character>(Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('_'), Character.valueOf('?')));

    public XStringFormatter() {
    }

    public XStringFormatter(IHidEvaluator evaluator, boolean useLowerCaseMaskType) {
        this.evaluator = evaluator;
        this.useLowerCaseMaskType = useLowerCaseMaskType;
    }

    public String toString() {
        return this.a.toString();
    }

    public IOException ioException() {
        return this.lastException;
    }

    public XStringFormatter format(String format, Object ... args) {
        int last = -1;
        int lasto = -1;
        FormatString[] fsa = this.parse(format);
        int i = 0;
        while (i < fsa.length) {
            FormatString fs = fsa[i];
            int index = fs.index();
            try {
                switch (index) {
                    case -2: {
                        fs.print(null);
                        break;
                    }
                    case -1: {
                        if (last < 0 || args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last]);
                        break;
                    }
                    case 0: {
                        last = ++lasto;
                        if (args != null && lasto > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[lasto]);
                        break;
                    }
                    default: {
                        last = index - 1;
                        if (args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last]);
                        break;
                    }
                }
            }
            catch (IOException x) {
                this.lastException = x;
            }
            ++i;
        }
        this.lastArgumentReferenced = last;
        return this;
    }

    public FormatString[] parse(String s) {
        ArrayList<FormatString> al = new ArrayList<FormatString>();
        Matcher m = fsPattern.matcher(s);
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (m.find(i)) {
                if (m.start() != i) {
                    XStringFormatter.checkText(s, i, m.start());
                    al.add(new FixedString(s.substring(i, m.start())));
                }
                al.add(new FormatSpecifier(m));
                i = m.end();
                continue;
            }
            XStringFormatter.checkText(s, i, len);
            al.add(new FixedString(s.substring(i)));
            break;
        }
        return al.toArray(new FormatString[al.size()]);
    }

    public boolean hasNoValidSpecifiers(String s) {
        Matcher m = fsPattern.matcher(s);
        if (m.find(0)) {
            if (m.start() != 0) {
                XStringFormatter.checkText(s, 0, m.start());
            }
            return false;
        }
        return true;
    }

    private static void checkText(String s, int start, int end) {
        int i = start;
        while (i < end) {
            if (s.charAt(i) == '%') {
                char c = i == end - 1 ? (char)'%' : (char)s.charAt(i + 1);
                throw new UnknownFormatConversionException(String.valueOf(c));
            }
            ++i;
        }
    }

    public void formatInput(String input, RandomAccessFile inputStreamReader, String format, List<Integer> sizes, String currentHierarchicalPath, List<Object> result) throws IOException {
        int sizeIndex = 0;
        int size = sizes.get(sizeIndex);
        FormatString[] formatter = this.parse(format);
        int[] index = new int[1];
        FormatString[] formatStringArray = formatter;
        int n = formatter.length;
        int n2 = 0;
        while (n2 < n) {
            FormatString formatString = formatStringArray[n2];
            String string = formatString.toString().trim();
            if (!(string.isEmpty() || string.contains("\\n") || string.contains("\\t"))) {
                Object word = this.readFromInput(formatString.getType(), formatString.getWidth(), size, input, index, inputStreamReader, currentHierarchicalPath);
                if (!formatString.supress()) {
                    if (formatString.index() == -2) {
                        if (word instanceof String && !word.equals(string)) {
                            return;
                        }
                    } else {
                        if (word == null || word instanceof String && ((String)word).isEmpty()) {
                            return;
                        }
                        Object newValue = word;
                        result.add(newValue);
                        if (++sizeIndex < sizes.size()) {
                            size = sizes.get(sizeIndex);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readFromInput(char type, int width, int size, String input, int[] index, RandomAccessFile inputStreamReader, String currentHierarchicalPath) throws IOException {
        byteOutputStream = new ByteArrayOutputStream();
        input = DVTStringUtil.unquote(input);
        restorePointer = inputStreamReader != null ? inputStreamReader.getFilePointer() : 0L;
        try {
            switch (type) {
                case '%': 
                case 'C': 
                case 'c': {
                    if (inputStreamReader != null) {
                        byteOutputStream.write(inputStreamReader.readByte());
                        return byteOutputStream.toString();
                    }
                    if (index[0] >= input.length()) return byteOutputStream.toString();
                    byteOutputStream.write(input.charAt(index[0]));
                    index[0] = index[0] + 1;
                    return byteOutputStream.toString();
                }
                case 'S': 
                case 's': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    if (inputStreamReader != null) {
                        while (crtChar > 0) {
                            if (crtChar == 32) return byteOutputStream.toString();
                            if (crtChar == 10) return byteOutputStream.toString();
                            if (crtChar == 9) {
                                return byteOutputStream.toString();
                            }
                            byteOutputStream.write(crtChar);
                            if (byteOutputStream.size() == width) {
                                return byteOutputStream.toString();
                            }
                            crtChar = inputStreamReader.readByte();
                        }
                        return byteOutputStream.toString();
                    }
                    ** GOTO lbl114
                }
                case 'D': 
                case 'd': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    if ((char)crtChar == '_') {
                        return null;
                    }
                    if (crtChar == 122) return VlogBitVector.BIT_Z;
                    if (crtChar == 90) {
                        return VlogBitVector.BIT_Z;
                    }
                    if (crtChar == 120) return VlogBitVector.BIT_X;
                    if (crtChar == 88) return VlogBitVector.BIT_X;
                    if (crtChar == 63) {
                        return VlogBitVector.BIT_X;
                    }
                    signed = crtChar == 45;
                    this.readFormattedInput(width, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.DECIMAL_VALUES);
                    if (byteOutputStream.size() != 0) return VlogBitVector.create(signed, 31, 0, null, false, false, BigInteger.valueOf(Integer.valueOf(byteOutputStream.toString()).intValue()));
                    this.rewindInputStream(inputStreamReader, restorePointer);
                    return null;
                }
                case 'E': 
                case 'F': 
                case 'G': 
                case 'T': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 't': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    this.readFormattedInput(width, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.FLOAT_VALUES);
                    if (byteOutputStream.size() == 0) {
                        this.rewindInputStream(inputStreamReader, restorePointer);
                        return null;
                    }
                    floatValue = Double.valueOf(byteOutputStream.toString());
                    if (floatValue == Infinity) {
                        return VlogRealNumber.INFINITY;
                    }
                    if (floatValue != -Infinity) return VlogRealNumber.create(floatValue);
                    return VlogRealNumber.NEGATIVE_INFINITY;
                }
                case 'B': 
                case 'b': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    if ((char)crtChar == '_') {
                        return null;
                    }
                    this.readFormattedInput(width, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.BINARY_VALUES);
                    if (byteOutputStream.size() == 0) {
                        this.rewindInputStream(inputStreamReader, restorePointer);
                        return null;
                    }
                    result = this.stringToVlogBitVector(byteOutputStream.toString(), size, 2);
                    return this.addMasksToResultBitVector(size, byteOutputStream.toString(), result, XStringFormatter.binaryPattern, 2);
                }
                case 'O': 
                case 'o': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    if ((char)crtChar == '_') {
                        return null;
                    }
                    this.readFormattedInput(width, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.OCTAL_VALUES);
                    if (byteOutputStream.size() == 0) {
                        this.rewindInputStream(inputStreamReader, restorePointer);
                        return null;
                    }
                    result = this.stringToVlogBitVector(byteOutputStream.toString(), size, 8);
                    return this.addMasksToResultBitVector(size, byteOutputStream.toString(), result, XStringFormatter.octaPattern, 8);
                }
                case 'H': 
                case 'X': 
                case 'h': 
                case 'x': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    if ((char)crtChar == '_') {
                        return null;
                    }
                    this.readFormattedInput(width, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.HEXADECIMAL_VALUES);
                    if (byteOutputStream.size() == 0) {
                        this.rewindInputStream(inputStreamReader, restorePointer);
                        return null;
                    }
                    result = this.stringToVlogBitVector(byteOutputStream.toString(), size, 16);
                    return this.addMasksToResultBitVector(size, byteOutputStream.toString(), result, XStringFormatter.hexPattern, 16);
                }
                case 'U': 
                case 'u': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    this.readFormattedInput(width > 0 ? width : size, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.UNFORMATED_TWO_VALUES);
                    if (inputStreamReader != null) {
                        if (width < 0) {
                            if (byteOutputStream.size() < size) throw new EOFException();
                        }
                        if (width > 0 && byteOutputStream.size() < width) {
                            throw new EOFException();
                        }
                    }
                    if (byteOutputStream.size() != 0) return this.stringToVlogBitVector(byteOutputStream.toString(), size, 2);
                    this.rewindInputStream(inputStreamReader, restorePointer);
                    return null;
                }
                case 'Z': 
                case 'z': {
                    crtChar = this.readFirstCharacter(input, index, inputStreamReader);
                    this.readFormattedInput(width > 0 ? width : size, input, index, inputStreamReader, byteOutputStream, crtChar, XStringFormatter.BINARY_VALUES);
                    if (inputStreamReader != null) {
                        if (width < 0) {
                            if (byteOutputStream.size() < size) throw new EOFException();
                        }
                        if (width > 0 && byteOutputStream.size() < width) {
                            throw new EOFException();
                        }
                    }
                    if (byteOutputStream.size() == 0) {
                        this.rewindInputStream(inputStreamReader, restorePointer);
                        return null;
                    }
                    result = this.stringToVlogBitVector(byteOutputStream.toString(), size, 2);
                    return this.addMasksToResultBitVector(size, byteOutputStream.toString(), result, XStringFormatter.binaryPattern, 2);
                }
                case 'M': 
                case 'm': {
                    return currentHierarchicalPath;
                }
                default: {
                    return byteOutputStream.toString();
lbl114:
                    // 1 sources

                    if (true) ** GOTO lbl125
                }
            }
        }
        catch (Exception e) {
            if (inputStreamReader != null && e instanceof EOFException) {
                throw e;
            }
            this.rewindInputStream(inputStreamReader, restorePointer);
            return null;
        }
        do {
            byteOutputStream.write(crtChar);
            if (byteOutputStream.size() == width) break;
            crtChar = input.charAt(index[0]);
            index[0] = index[0] + 1;
lbl125:
            // 2 sources

        } while (crtChar > 0 && crtChar != 32 && crtChar != 10 && crtChar != 9 && index[0] < input.length());
        isFullFormatWidth = width > 0 && byteOutputStream.size() >= width;
        if (crtChar <= 0) return byteOutputStream.toString();
        if (crtChar == 32) return byteOutputStream.toString();
        if (isFullFormatWidth != false) return byteOutputStream.toString();
        byteOutputStream.write(crtChar);
        return byteOutputStream.toString();
    }

    private void rewindInputStream(RandomAccessFile inputStreamReader, long restorePointer) throws IOException {
        if (inputStreamReader == null) {
            return;
        }
        long currentPointer = inputStreamReader.getFilePointer();
        inputStreamReader.seek(restorePointer + 1L == currentPointer ? restorePointer : restorePointer + 1L);
    }

    private VlogBitVector stringToVlogBitVector(String binaryNumber, int size, int radix) {
        String baseNumber = DVTStringUtil.replaceAll(xPattern, binaryNumber, "0");
        baseNumber = DVTStringUtil.replaceAll(zPattern, baseNumber, "0");
        return VlogBitVector.create(false, size, 0, new BigInteger(baseNumber, radix));
    }

    private VlogBitVector addMasksToResultBitVector(int size, String binaryNumber, VlogBitVector result, Pattern pattern, int radix) {
        EnumMap<MaskType, BitSet> newMasks = new EnumMap<MaskType, BitSet>(MaskType.class);
        String xMaskPattern = DVTStringUtil.replaceAll(pattern, binaryNumber, "0");
        xMaskPattern = DVTStringUtil.replaceAll(zPattern, xMaskPattern, "0");
        if ((xMaskPattern = DVTStringUtil.replaceAll(xPattern, xMaskPattern, "1")).contains("1")) {
            newMasks.put(MaskType.X, VlogBitVector.createMask(size, BitSetUtils.toBitSet(new BigInteger(xMaskPattern, radix))));
        }
        String zMaskPattern = DVTStringUtil.replaceAll(pattern, binaryNumber, "0");
        zMaskPattern = DVTStringUtil.replaceAll(xPattern, zMaskPattern, "0");
        if ((zMaskPattern = DVTStringUtil.replaceAll(zPattern, zMaskPattern, "1")).contains("1")) {
            newMasks.put(MaskType.Z, VlogBitVector.createMask(size, BitSetUtils.toBitSet(new BigInteger(zMaskPattern, radix))));
        }
        if (newMasks.isEmpty()) {
            return result;
        }
        return VlogBitVector.copy(result, newMasks);
    }

    private void readFormattedInput(int width, String input, int[] index, RandomAccessFile inputStreamReader, ByteArrayOutputStream byteOutputStream, int len, Set<Character> allowedCharacters) throws IOException {
        if (inputStreamReader != null) {
            this.readWordFromInputStream(inputStreamReader, width, byteOutputStream, len, allowedCharacters);
        } else {
            this.readWordFromInputString(input, index, width, byteOutputStream, len, allowedCharacters);
        }
    }

    private int readFirstCharacter(String input, int[] index, RandomAccessFile inputStreamReader) throws IOException {
        int crtChar = inputStreamReader != null ? this.readCharFromInputStream(inputStreamReader, true) : this.readCharFromInputString(input, index);
        if (crtChar < 0) {
            throw new EOFException();
        }
        return crtChar;
    }

    private void readWordFromInputStream(RandomAccessFile inputStreamReader, int width, ByteArrayOutputStream byteOutputStream, int crtChar, Set<Character> inclusionSet) throws IOException {
        crtChar = this.skipWhitespaces(inputStreamReader, crtChar);
        while (crtChar > 0 && inclusionSet.contains(Character.valueOf((char)crtChar))) {
            byteOutputStream.write(crtChar);
            if (byteOutputStream.size() == width) break;
            crtChar = inputStreamReader.read();
        }
    }

    public int readCharFromInputStream(RandomAccessFile inputStreamReader, boolean skipWhitespaces) throws IOException {
        int crtChar = inputStreamReader.readByte();
        if (skipWhitespaces) {
            crtChar = this.skipWhitespaces(inputStreamReader, crtChar);
        }
        return crtChar;
    }

    private int skipWhitespaces(RandomAccessFile inputStreamReader, int crtChar) throws IOException {
        while (crtChar == 32 || crtChar == 10 || crtChar == 9) {
            crtChar = inputStreamReader.readByte();
        }
        return crtChar;
    }

    private void readWordFromInputString(String input, int[] index, int width, ByteArrayOutputStream byteOutputStream, int crtChar, Set<Character> inclusionSet) {
        while (crtChar > 0 && inclusionSet.contains(Character.valueOf((char)crtChar)) && index[0] < input.length()) {
            if ((char)crtChar == '?') {
                crtChar = 120;
            }
            if ((char)crtChar != '_') {
                byteOutputStream.write(crtChar);
            }
            if (byteOutputStream.size() == width) break;
            crtChar = input.charAt(index[0]);
            index[0] = index[0] + 1;
        }
        if (crtChar > 0 && inclusionSet.contains(Character.valueOf((char)crtChar))) {
            if ((char)crtChar == '?') {
                crtChar = 120;
            }
            if ((char)crtChar != '_' && (width < 0 || byteOutputStream.size() < width)) {
                byteOutputStream.write(crtChar);
            }
        }
    }

    private int readCharFromInputString(String input, int[] index) {
        if (index[0] >= input.length()) {
            return -1;
        }
        char crtChar = input.charAt(index[0]);
        index[0] = index[0] + 1;
        while ((crtChar == ' ' || crtChar == '\n' || crtChar == '\t') && index[0] < input.length()) {
            crtChar = input.charAt(index[0]);
            index[0] = index[0] + 1;
        }
        return crtChar;
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }

    public static class Conversion {
        public static final char MISSING_DEFAULT = 'y';
        public static final char DECIMAL_INTEGER = 'd';
        static final char DECIMAL_INTEGER_UPPER = 'D';
        public static final char BINARY_INTEGER = 'b';
        static final char BINARY_INTEGER_UPPER = 'B';
        public static final char OCTAL_INTEGER = 'o';
        static final char OCTAL_INTEGER_UPPER = 'O';
        public static final char HEXADECIMAL_INTEGER_X = 'x';
        static final char HEXADECIMAL_INTEGER_X_UPPER = 'X';
        public static final char HEXADECIMAL_INTEGER_H = 'h';
        static final char HEXADECIMAL_INTEGER_H_UPPER = 'H';
        static final char REAL_IN_EXPO = 'e';
        static final char REAL_IN_EXPO_UPPER = 'E';
        static final char REAL_IN_DECIMAL = 'f';
        static final char REAL_IN_DECIMAL_UPPER = 'F';
        static final char REAL_IN_EXPO_OR_DECIMAL = 'g';
        static final char REAL_IN_EXPO_OR_DECIMAL_UPPER = 'G';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';
        static final char LIBRARY_BINDING = 'l';
        static final char LIBRARY_BINDING_UPPER = 'L';
        static final char HIERARCHICAL_NAME = 'm';
        static final char HIERARCHICAL_NAME_UPPER = 'M';
        static final char SIGNAL_STRENGTH = 'v';
        static final char SIGNAL_STRENGTH_UPPER = 'V';
        static final char POINTER = 'p';
        static final char POINTER_UPPER = 'P';
        static final char UNFORMATTED_TWO_VALUE = 'u';
        static final char UNFORMATTED_TWO_VALUE_UPPER = 'U';
        static final char UNFORMATTED_FOUR_VALUE = 'z';
        static final char UNFORMATTED_FOUR_VALUE_UPPER = 'Z';
        static final char TIME = 't';
        static final char TIME_UPPER = 'T';

        static boolean isValid(char c) {
            return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
        }

        static boolean isGeneral(char c) {
            switch (c) {
                case 'S': 
                case 's': 
                case 'y': {
                    return true;
                }
                case 'P': 
                case 'U': 
                case 'V': 
                case 'Z': 
                case 'p': 
                case 'u': 
                case 'v': 
                case 'z': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c) {
            switch (c) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c) {
            switch (c) {
                case 'B': 
                case 'D': 
                case 'H': 
                case 'O': 
                case 'T': 
                case 'X': 
                case 'b': 
                case 'd': 
                case 'h': 
                case 'o': 
                case 't': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c) {
            switch (c) {
                case 'E': 
                case 'F': 
                case 'G': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c) {
            switch (c) {
                case '%': 
                case 'L': 
                case 'M': 
                case 'l': 
                case 'm': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    private class FixedString
    implements FormatString {
        private String s;

        FixedString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return -2;
        }

        @Override
        public void print(Object arg) throws IOException {
            XStringFormatter.this.a.append(this.s);
        }

        @Override
        public String toString() {
            return this.s;
        }

        @Override
        public char getType() {
            return 's';
        }

        @Override
        public int getWidth() {
            return -1;
        }

        @Override
        public boolean supress() {
            return false;
        }
    }

    private static class Flags {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags GROUP = new Flags(64);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int f2) {
            this.flags = f2;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags f2) {
            return (this.flags & f2.valueOf()) == f2.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags f2) {
            this.flags |= f2.valueOf();
            return this;
        }

        public Flags remove(Flags f2) {
            this.flags &= ~f2.valueOf();
            return this;
        }

        public static Flags parse(String s) {
            char[] ca = s.toCharArray();
            Flags f2 = new Flags(0);
            int i = 0;
            while (i < ca.length) {
                Flags v = Flags.parse(ca[i]);
                if (f2.contains(v)) {
                    throw new DuplicateFormatFlagsException(v.toString());
                }
                f2.add(v);
                ++i;
            }
            return f2;
        }

        private static Flags parse(char c) {
            switch (c) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case ',': {
                    return GROUP;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw new UnknownFormatFlagsException(String.valueOf(c));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                sb.append('-');
            }
            if (this.contains(UPPERCASE)) {
                sb.append('^');
            }
            if (this.contains(ALTERNATE)) {
                sb.append('#');
            }
            if (this.contains(PLUS)) {
                sb.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                sb.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                sb.append('0');
            }
            if (this.contains(GROUP)) {
                sb.append(',');
            }
            if (this.contains(PARENTHESES)) {
                sb.append('(');
            }
            if (this.contains(PREVIOUS)) {
                sb.append('<');
            }
            return sb.toString();
        }
    }

    private class FormatSpecifier
    implements FormatString {
        private int index = -1;
        private Flags f = Flags.NONE;
        private int width;
        private int precision;
        private char c;
        private boolean supress;

        private int index(String s) {
            if (s != null) {
                try {
                    this.index = Integer.parseInt(s.substring(0, s.length() - 1));
                }
                catch (NumberFormatException numberFormatException) {
                    assert (false);
                }
            } else {
                this.index = 0;
            }
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        private Flags flags(String s) {
            this.f = Flags.parse(s);
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            return this.f;
        }

        private int width(String s) {
            block4: {
                this.width = -1;
                if (s != null) {
                    try {
                        this.width = Integer.parseInt(s);
                        if (this.width < 0) {
                            throw new IllegalFormatWidthException(this.width);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.width;
        }

        private int precision(String s) {
            block4: {
                this.precision = -1;
                if (s != null) {
                    try {
                        this.precision = Integer.parseInt(s.substring(1));
                        if (this.precision < 0) {
                            throw new IllegalFormatPrecisionException(this.precision);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.precision;
        }

        private char conversion(String s) {
            this.c = s.charAt(0);
            if (!Conversion.isValid(this.c)) {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
            if (Character.isUpperCase(this.c)) {
                this.f.add(Flags.UPPERCASE);
            }
            this.c = Character.toLowerCase(this.c);
            if (Conversion.isText(this.c)) {
                this.index = -2;
            }
            return this.c;
        }

        FormatSpecifier(Matcher m) {
            int idx = 1;
            this.supress(m.group(idx++));
            this.index(m.group(idx++));
            this.flags(m.group(idx++));
            this.width(m.group(idx++));
            this.precision(m.group(idx++));
            this.conversion(m.group(idx));
            if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (Conversion.isCharacter(this.c)) {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
        }

        private boolean supress(String s) {
            if (s != null) {
                this.supress = s.equals("*");
            }
            return this.supress;
        }

        @Override
        public void print(Object arg) throws IOException {
            switch (this.c) {
                case 'y': {
                    this.printDefault(arg);
                    break;
                }
                case 'b': 
                case 'd': 
                case 'h': 
                case 'o': 
                case 'x': {
                    this.printInteger(arg);
                    break;
                }
                case 't': {
                    this.printTime(arg);
                    break;
                }
                case 'e': 
                case 'f': 
                case 'g': {
                    this.printFloat(arg);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.printCharacter(arg);
                    break;
                }
                case 'P': 
                case 'p': 
                case 's': {
                    this.printString(arg);
                    break;
                }
                case 'n': {
                    XStringFormatter.this.a.append(System.getProperty("line.separator"));
                    break;
                }
                case '%': {
                    XStringFormatter.this.a.append('%');
                    break;
                }
                case 'L': 
                case 'l': {
                    XStringFormatter.this.a.append(XUtils.getLibraryBinding(XStringFormatter.this.evaluator));
                    break;
                }
                case 'M': 
                case 'm': {
                    XStringFormatter.this.a.append(XUtils.getInstancePath(XStringFormatter.this.evaluator));
                    break;
                }
                case 'U': 
                case 'Z': 
                case 'u': 
                case 'z': {
                    this.printInteger(arg);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void printDefault(Object arg) throws IOException {
            if (arg == null) {
                this.print("");
            } else if (arg instanceof Byte || arg instanceof Short || arg instanceof Integer || arg instanceof BigInteger || arg instanceof Long) {
                this.print(arg);
            } else if (arg instanceof IELParamValue) {
                DVTNumber dvtNumber = ((IELParamValue)arg).getDVTNumber();
                if (dvtNumber instanceof VlogBitVector) {
                    if (DVTNumber.isString(dvtNumber)) {
                        this.printString(arg);
                    } else {
                        this.print(dvtNumber.print(10, false, -1, XStringFormatter.this.useLowerCaseMaskType, false));
                    }
                } else if (dvtNumber instanceof VlogAbstractRealNumber) {
                    this.print(dvtNumber.toString());
                } else {
                    this.print(dvtNumber.toString(10, false, XStringFormatter.this.useLowerCaseMaskType));
                }
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printTime(Object arg) throws IOException {
            if (arg instanceof IELParamValue && XStringFormatter.this.evaluator instanceof XValueHolder) {
                XGlobalCache.TimeScale timescale = XUtils.getTimeScale((XValueHolder)XStringFormatter.this.evaluator);
                XGlobalCache.TimeScale timeFormat = ((XValueHolder)XStringFormatter.this.evaluator).factory.getTimeFormat();
                DVTNumber dvtNumber = ((IELParamValue)arg).getDVTNumber();
                BigDecimal time = BigDecimal.valueOf(dvtNumber.doubleValue()).multiply(timescale.unit).divide(timeFormat.precision).setScale(0, RoundingMode.HALF_UP);
                this.print(VlogBitVector.create(false, 63, 0, time.toBigInteger()));
            } else {
                this.printInteger(arg);
            }
        }

        private void printInteger(Object arg) throws IOException {
            if (arg == null) {
                this.print("");
            } else if (arg instanceof Byte) {
                this.print(arg);
            } else if (arg instanceof Short) {
                this.print(arg);
            } else if (arg instanceof Integer) {
                this.print(arg);
            } else if (arg instanceof BigInteger) {
                this.print(arg);
            } else if (arg instanceof Long) {
                this.print(arg);
            } else if (arg instanceof IELParamValue) {
                DVTNumber dvtNumber = ((IELParamValue)arg).getDVTNumber();
                if (dvtNumber instanceof VlogBitVector) {
                    this.print((VlogBitVector)dvtNumber);
                } else if (dvtNumber instanceof VlogAbstractRealNumber) {
                    this.print(dvtNumber.toBitVector());
                } else {
                    this.print(dvtNumber.toString(10, false, XStringFormatter.this.useLowerCaseMaskType));
                }
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printFloat(Object arg) throws IOException {
            if (arg == null) {
                this.print("");
            } else if (arg instanceof Float) {
                this.print(arg);
            } else if (arg instanceof Double) {
                this.print(arg);
            } else if (arg instanceof BigDecimal) {
                this.print((BigDecimal)arg);
            } else if (arg instanceof IELParamValue) {
                DVTNumber dvtNumber = ((IELParamValue)arg).getDVTNumber();
                this.print(dvtNumber.doubleValue());
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void print(double value) {
            XStringFormatter.this.a.append(this.justify(this.formatFloat(value, this.c)));
        }

        private String formatFloat(double value, char conversion) throws IllegalFormatException {
            if (Double.isInfinite(value) || Double.isNaN(value)) {
                return Double.toString(value);
            }
            String floatFormat = this.precision >= 0 ? "%." + this.precision : "%";
            if (this.f.contains(Flags.UPPERCASE) && conversion != 'f') {
                conversion = (char)(conversion - 32);
            }
            String prefix = Double.compare(value, -0.0) == 0 ? "-" : "";
            String result = String.valueOf(prefix) + String.format(String.valueOf(floatFormat) + conversion, new BigDecimal(value));
            if (conversion == 'g' && !this.f.contains(Flags.ALTERNATE)) {
                return this.trimZerosFromFloat(result);
            }
            return result;
        }

        private String trimZerosFromFloat(String numberStr) {
            String expNotation;
            int decimalPointIndex = numberStr.indexOf(46);
            if (decimalPointIndex < 1) {
                return numberStr;
            }
            int expNotationIndex = -1;
            int i = numberStr.length() - 1;
            while (i > decimalPointIndex) {
                char ch = numberStr.charAt(i);
                if (ch == 'e' || ch == 'E') {
                    expNotationIndex = i;
                    break;
                }
                --i;
            }
            int lastDecimalIndex = expNotationIndex == -1 ? numberStr.length() : expNotationIndex;
            int firstZeroIndex = -1;
            int i2 = decimalPointIndex + 1;
            while (i2 < lastDecimalIndex) {
                if (numberStr.charAt(i2) == '0') {
                    if (firstZeroIndex == -1) {
                        firstZeroIndex = i2;
                    }
                } else {
                    firstZeroIndex = -1;
                }
                ++i2;
            }
            if (firstZeroIndex == -1) {
                return numberStr;
            }
            String string = expNotation = expNotationIndex == -1 ? "" : numberStr.substring(lastDecimalIndex, numberStr.length());
            if (firstZeroIndex == decimalPointIndex + 1) {
                return String.valueOf(numberStr.substring(0, decimalPointIndex)) + expNotation;
            }
            return String.valueOf(numberStr.substring(0, firstZeroIndex)) + expNotation;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void printCharacter(Object arg) {
            if (arg == null) {
                this.print("");
                return;
            }
            String s = null;
            if (arg instanceof Character) {
                s = ((Character)arg).toString();
            } else if (arg instanceof Byte) {
                byte i = (Byte)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof Short) {
                short i = (Short)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof Integer) {
                int i = (Integer)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof ELParamValues.ParamValueNumber) {
                DVTNumber number = ((ELParamValues.ParamValueNumber)arg).getDVTNumber();
                if (number instanceof VlogBitVector) {
                    if (DVTNumber.isString(number)) {
                        String stringValue = ((VlogBitVector)number).stringValue(true);
                        if (stringValue != null && !stringValue.isEmpty()) {
                            s = Character.valueOf(stringValue.charAt(stringValue.length() - 1)).toString();
                        } else {
                            this.failConversion(this.c, arg);
                        }
                    } else {
                        s = new String(Character.toChars(number.bigIntegerValue().intValue() & Short.MAX_VALUE));
                    }
                } else {
                    this.failConversion(this.c, arg);
                }
            } else {
                this.failConversion(this.c, arg);
            }
            this.print(s);
        }

        private void printString(Object arg) {
            if (this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, 's');
            }
            if (arg == null) {
                this.print("");
            } else if (arg instanceof Boolean) {
                this.print(arg.toString().toUpperCase());
            } else if (arg instanceof IELParamValue) {
                if (arg instanceof ELParamValues.ParamValueNumber) {
                    if (((ELParamValues.ParamValueNumber)arg).isStruct(true)) {
                        this.printString(((ELParamValues.ParamValueNumber)arg).getDVTNumber().print(16, true, -1, XStringFormatter.this.useLowerCaseMaskType, true));
                        return;
                    }
                    IELParamValue original = ((ELParamValues.ParamValueNumber)arg).getOriginal();
                    ELEnumTypeWrapper enumType = ((ELParamValues.ParamValueNumber)arg).getEnumTypeWrapper();
                    if (enumType != null) {
                        IELParamValue nameValue = enumType.name((ELParamValues.ParamValueNumber)arg);
                        this.printString(nameValue);
                        return;
                    }
                    if (DVTNumber.isString(((ELParamValues.ParamValueNumber)arg).getDVTNumber()) && original != null && !DVTNumber.isString(original.getDVTNumber())) {
                        this.print(original.toStringRadix(10));
                        return;
                    }
                } else if (arg instanceof IELParamValue.UndefinedXValue) {
                    this.print("");
                    return;
                }
                BitVectorContext stringContext = BitVectorContext.of(VlogBitVector.create(false, 0, 0, null, false, true), null);
                boolean isString = arg instanceof ELParamValues.ParamValueNumber && ((ELParamValues.ParamValueNumber)arg).getDVTNumber().isString();
                this.print(ELUtils.valueToString(isString ? (IELParamValue)arg : stringContext.transform((IELParamValue)arg)));
            } else {
                this.print(arg.toString());
            }
        }

        private void print(String s) {
            if (this.precision != -1 && this.precision < s.length()) {
                s = s.substring(0, this.precision);
            }
            XStringFormatter.this.a.append(this.justify(s));
        }

        private String justify(String s) {
            int i;
            if (this.width == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            boolean pad = this.f.contains(Flags.LEFT_JUSTIFY);
            int sp = this.width - s.length();
            if (!pad) {
                i = 0;
                while (i < sp) {
                    sb.append(' ');
                    ++i;
                }
            }
            sb.append(s);
            if (pad) {
                i = 0;
                while (i < sp) {
                    sb.append(' ');
                    ++i;
                }
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Flags dupf = this.f.dup().remove(Flags.UPPERCASE);
            sb.append(dupf.toString());
            if (this.index > 0) {
                sb.append(this.index).append('$');
            }
            if (this.width != -1) {
                sb.append(this.width);
            }
            if (this.precision != -1) {
                sb.append('.').append(this.precision);
            }
            sb.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return sb.toString();
        }

        private void checkGeneral() {
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
            this.checkBadFlags(Flags.PLUS, Flags.LEADING_SPACE, Flags.GROUP, Flags.PARENTHESES);
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.c == 'd' || this.c == 't') {
                this.checkBadFlags(Flags.ALTERNATE);
            } else if (this.c == 'o') {
                this.checkBadFlags(Flags.GROUP);
            } else {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkBadFlags(Flags ... badFlags) {
            int i = 0;
            while (i < badFlags.length) {
                if (this.f.contains(badFlags[i])) {
                    this.failMismatch(badFlags[i], this.c);
                }
                ++i;
            }
        }

        private void checkFloat() {
            this.checkNumeric();
            if (this.c == 'e') {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.precision != -1 && this.precision < 0) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw new IllegalFormatFlagsException(this.f.toString());
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw new MissingFormatWidthException(this.toString());
                }
                case 'n': {
                    if (this.width != -1) {
                        throw new IllegalFormatWidthException(this.width);
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw new IllegalFormatFlagsException(this.f.toString());
                }
                case 'L': 
                case 'M': 
                case 'l': 
                case 'm': {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void print(VlogBitVector value) {
            boolean stripLeadingZeroes = this.f.contains(Flags.ZERO_PAD);
            if (this.c == 'd' || this.c == 't') {
                this.print(value.print(10, stripLeadingZeroes, this.width, XStringFormatter.this.useLowerCaseMaskType, false));
            } else if (this.c == 'o') {
                this.print(value.print(8, this.width <= 0 && stripLeadingZeroes, this.width, XStringFormatter.this.useLowerCaseMaskType, false));
            } else if (this.c == 'x' || this.c == 'h') {
                this.print(value.print(16, this.width <= 0 && stripLeadingZeroes, this.width, XStringFormatter.this.useLowerCaseMaskType, false));
            } else if (this.c == 'b' || this.c == 'z') {
                this.print(value.print(2, this.width <= 0 && stripLeadingZeroes, this.width, XStringFormatter.this.useLowerCaseMaskType, false));
            } else if (this.c == 'u') {
                this.print(value.printBinaryNoMasks(2, this.width <= 0 && stripLeadingZeroes, this.width, XStringFormatter.this.useLowerCaseMaskType));
            }
        }

        private void print(BigDecimal value) {
            int convertedPrecision = value.precision() - value.scale() + 6;
            if (this.precision >= 0) {
                convertedPrecision = value.precision() - value.scale() + this.precision;
            }
            MathContext mc = new MathContext(Math.abs(convertedPrecision));
            BigDecimal v = new BigDecimal(value.unscaledValue(), value.scale(), mc);
            XStringFormatter.this.a.append(this.justify(v.toString()));
        }

        private void failMismatch(Flags f2, char c) {
            String fs = f2.toString();
            throw new FormatFlagsConversionMismatchException(fs, c);
        }

        private void failConversion(char c, Object arg) {
            throw new IllegalFormatConversionException(c, arg.getClass());
        }

        @Override
        public char getType() {
            return this.c;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public boolean supress() {
            return this.supress;
        }
    }

    public static interface FormatString {
        public int index();

        public void print(Object var1) throws IOException;

        public String toString();

        public char getType();

        public int getWidth();

        public boolean supress();
    }
}

