/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.model.IStackFrame;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XAlwaysBlockEvalScope;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XEvalScopeWithParserPath;
import ro.amiq.dvt.interpreter.XEventControlEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodBlockEvalScope;
import ro.amiq.dvt.interpreter.XSeqBlockEvalScope;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XWaitControlEvalScope;
import ro.amiq.dvt.interpreter.sim.XSimEventScheduler;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalJumpStatementException;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.optimized.collections.Stack;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XThread {
    public static final String GLOBAL_INIT_SCOPE_NAME = "[global init]";
    private int id;
    private int spawnedById;
    private int nonTerminatedAncestorId;
    private XThreadDefinition xThreadDefinition;
    private IXThreadScheduler xThreadScheduler;
    protected XThreadState state;
    private LinkedList<XThread> spawnedThreads;
    protected Stack<XEvalScope> xEvalScopesStack;
    private Set<String> spawnedByLabels;
    private XInstValueHolder instanceScope;
    private boolean isHotSwap;
    private ParserPath parserPath;
    private IntrpDebugThread debugThread;
    private Runnable endOfScopeRunnable;
    private int endOfScopeStackSize;
    private List<DeferredAssert> deferredAssertQueue;

    public XThread(XThreadDefinition xThreadDefinition, int id, int spawnedById, Set<String> spawnedByLabels, IXThreadScheduler xThreadScheduler, XInstValueHolder instanceScope) {
        this.xThreadDefinition = xThreadDefinition;
        this.id = id;
        this.spawnedById = spawnedById;
        this.spawnedByLabels = spawnedByLabels;
        this.nonTerminatedAncestorId = spawnedById;
        this.xThreadScheduler = xThreadScheduler;
        this.state = XThreadState.NEW;
        this.xEvalScopesStack = new Stack();
        this.instanceScope = instanceScope;
        xThreadDefinition.init(instanceScope);
    }

    public void setDebugThread(IntrpDebugThread debugThread) {
        this.debugThread = debugThread;
    }

    public boolean isAlwaysBlock() {
        return this.xThreadDefinition.isAlwaysBlock();
    }

    public boolean isInitialBlock() {
        return this.xThreadDefinition.isInitialBlock();
    }

    public boolean isFinalBlock() {
        return this.xThreadDefinition.isFinalBlock();
    }

    public void addSpawnedThread(XThread spawnedThread) {
        if (this.spawnedThreads == null) {
            this.spawnedThreads = new LinkedList();
        }
        this.spawnedThreads.add(spawnedThread);
    }

    public int getNonTerminatedAncestorId() {
        return this.nonTerminatedAncestorId;
    }

    public void setNonTerminatedAncestorId(int nonTerminatedAncestorId) {
        if (nonTerminatedAncestorId < 0) {
            return;
        }
        this.nonTerminatedAncestorId = nonTerminatedAncestorId;
    }

    public IXThreadScheduler getXThreadScheduler() {
        return this.xThreadScheduler;
    }

    public XThreadDefinition getXThreadDefinition() {
        return this.xThreadDefinition;
    }

    public IHidEvaluationGuardian getHidEvaluationGuardian() {
        return this.xThreadDefinition.getHidEvaluationGuardian();
    }

    public IXThreadImpl getXThreadImpl() {
        return this.xThreadDefinition.getXThreadImpl();
    }

    public int getId() {
        return this.id;
    }

    public int getSpawnedById() {
        return this.spawnedById;
    }

    public void doYield(boolean reExecuteStatement) {
        if (this.xThreadScheduler.isTerminated() || this.isTerminated()) {
            throw new XStopThreadException();
        }
        this.state = XThreadState.YIELDING;
        if (reExecuteStatement) {
            throw new XReSuspendThreadException();
        }
        throw new XSuspendThreadException();
    }

    public void setEndOfScopeRunnable(Runnable runnable) {
        this.endOfScopeRunnable = runnable;
        this.endOfScopeStackSize = this.xEvalScopesStack.size();
    }

    public void resetEndOfScopeRunnable() {
        this.endOfScopeRunnable = null;
        this.endOfScopeStackSize = 0;
    }

    public void run() {
        while (!this.xEvalScopesStack.isEmpty() && !this.isTerminated()) {
            try {
                this.state = XThreadState.RUNNING;
                XEvalScope xEvalScope = this.xEvalScopesStack.peek();
                xEvalScope = this.suspendThreadLookahead(xEvalScope);
                if (xEvalScope == null) {
                    this.state = XThreadState.YIELDING;
                    break;
                }
                this.executeScope(xEvalScope);
            }
            catch (XSuspendThreadException xSuspendThreadException) {
                break;
            }
            catch (XStopThreadException xStopThreadException) {
                this.localTerminate(false);
            }
            catch (BuildCancelException e) {
                this.localTerminate(false);
                throw e;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.handleInternalException();
                this.localTerminate(false);
            }
        }
        if (this.xEvalScopesStack.isEmpty()) {
            this.localTerminate(false);
        }
    }

    private XEvalScope suspendThreadLookahead(XEvalScope xEvalScope) {
        if (xEvalScope.isDisabled()) {
            return xEvalScope;
        }
        if (xEvalScope instanceof XAlwaysBlockEvalScope) {
            HidEvalCenter.SeqBlockStatement blockStatement;
            IHidObject eventCtrlStatement;
            IHidObject nextStatement = xEvalScope.getNextStatement();
            if (nextStatement instanceof HidEvalCenter.SeqBlockStatement && (eventCtrlStatement = (blockStatement = (HidEvalCenter.SeqBlockStatement)nextStatement).getFirstRHValue()) instanceof HidOperator && ((HidOperator)eventCtrlStatement).isVlogEventControl()) {
                boolean hasLocalMembers = blockStatement.hasLocalMembers();
                ListContainer<IHidObject> rhValues = ((HidOperator)nextStatement).getRHValues();
                ArrayListContainer<IHidObject> statements = new ArrayListContainer<IHidObject>(rhValues == null ? 0 : rhValues.size());
                blockStatement.unfoldStatements(xEvalScope.evaluator, statements);
                IRfNamedElement blockNamedElement = blockStatement.getNamedElement();
                IHidEvaluator currentEvaluator = xEvalScope.evaluator;
                if (currentEvaluator.isInterpreter() && hasLocalMembers) {
                    currentEvaluator = currentEvaluator.createEnclosedValueHolder(blockNamedElement);
                }
                BitVectorContext bvContext = BitVectorContext.of(blockStatement.getNamedElement(), false);
                xEvalScope = new XSeqBlockEvalScope(blockStatement, currentEvaluator, bvContext, xEvalScope.guardian, statements);
                this.pushEvalScope(xEvalScope);
                eventCtrlStatement = xEvalScope.getNextStatement();
                xEvalScope = new XEventControlEvalScope((HidOperator)eventCtrlStatement, xEvalScope.evaluator, null, xEvalScope.guardian);
                this.pushEvalScope(xEvalScope);
                ((XEventControlEvalScope)xEvalScope).evaluateNoThreadSwitch(this);
                return null;
            }
        } else {
            if (xEvalScope instanceof XEventControlEvalScope) {
                boolean eventControlDone = ((XEventControlEvalScope)xEvalScope).evaluateNoThreadSwitch(this);
                if (eventControlDone) {
                    this.notifyEventControlDone();
                    this.popEvalScope();
                    return this.xEvalScopesStack.peek();
                }
                return null;
            }
            if (xEvalScope instanceof XWaitControlEvalScope) {
                boolean waitDone = ((XWaitControlEvalScope)xEvalScope).evaluateNoThreadSwitch(this);
                if (waitDone) {
                    this.popEvalScope();
                    return this.xEvalScopesStack.peek();
                }
                return null;
            }
        }
        return xEvalScope;
    }

    protected void notifyEventControlDone() {
    }

    protected void handleInternalException() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushEvalScope(XEvalScope xEvalScope) {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        this.parserPath = null;
        if (activeThreadImpl == null) {
            this.xEvalScopesStack.push(xEvalScope);
            return;
        }
        Stack<XEvalScope> stack = this.xEvalScopesStack;
        synchronized (stack) {
            this.xEvalScopesStack.push(xEvalScope);
        }
        if (xEvalScope instanceof XMethodBlockEvalScope) {
            activeThreadImpl.startMethod(xEvalScope);
        } else if (xEvalScope instanceof XFrameBlockEvalScope) {
            activeThreadImpl.startFrame(xEvalScope);
        } else if (xEvalScope instanceof XSeqBlockEvalScope) {
            activeThreadImpl.startBlock(xEvalScope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XEvalScope popEvalScope() {
        XEvalScope xEvalScope;
        if (this.xEvalScopesStack.isEmpty()) {
            return null;
        }
        IXThreadImpl activeThreadImpl = this.getXThreadDefinition().getXThreadImpl();
        this.parserPath = null;
        if (activeThreadImpl == null) {
            return this.xEvalScopesStack.pop();
        }
        Stack<XEvalScope> stack = this.xEvalScopesStack;
        synchronized (stack) {
            xEvalScope = this.xEvalScopesStack.peek();
        }
        if (xEvalScope instanceof XMethodBlockEvalScope) {
            activeThreadImpl.preEndMethod(xEvalScope);
        } else if (xEvalScope instanceof XFrameBlockEvalScope) {
            activeThreadImpl.preEndFrame(xEvalScope);
        }
        stack = this.xEvalScopesStack;
        synchronized (stack) {
            this.xEvalScopesStack.pop();
        }
        if (xEvalScope instanceof XMethodBlockEvalScope) {
            activeThreadImpl.endMethod(xEvalScope);
        } else if (xEvalScope instanceof XFrameBlockEvalScope) {
            activeThreadImpl.endFrame(xEvalScope);
        } else if (xEvalScope instanceof XSeqBlockEvalScope) {
            activeThreadImpl.endBlock(xEvalScope);
        }
        if (this.endOfScopeRunnable != null && this.endOfScopeStackSize > this.xEvalScopesStack.size()) {
            try {
                this.endOfScopeRunnable.run();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            this.resetEndOfScopeRunnable();
        }
        return xEvalScope;
    }

    public XInstValueHolder getInstanceScope() {
        return this.instanceScope;
    }

    public void setInstanceScope(XInstValueHolder instanceScope) {
        this.instanceScope = instanceScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XEvalScope getParentScope(boolean ignoreFirst) {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (!(xEvalScope instanceof XMethodBlockEvalScope) && !(xEvalScope instanceof XFrameBlockEvalScope)) continue;
                if (ignoreFirst) {
                    ignoreFirst = false;
                    continue;
                }
                return xEvalScope;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XEvalScope getParentScopeExcludingFrameBlock() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            XEvalScope lastEvalScope = null;
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (xEvalScope instanceof XMethodBlockEvalScope) {
                    return xEvalScope;
                }
                if (xEvalScope instanceof XFrameBlockEvalScope) {
                    return lastEvalScope;
                }
                lastEvalScope = xEvalScope;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSeqBlockEvalScope getEnclosingSeqEvalScope() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (!(xEvalScope instanceof XSeqBlockEvalScope)) continue;
                return (XSeqBlockEvalScope)xEvalScope;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XEvalScope getFirstEvalScope() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            return this.xEvalScopesStack.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XEvalScope getEnclosingScope(boolean ignoreFirst) {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (ignoreFirst) {
                    ignoreFirst = false;
                    continue;
                }
                return xEvalScope;
            }
        }
        return null;
    }

    private void executeScope(XEvalScope xEvalScope) {
        try {
            xEvalScope.execute(this);
        }
        catch (HidEvalJumpStatementException.HidEvalContinueException hidEvalContinueException) {
            xEvalScope = this.gotoEnclosingLoopScope(xEvalScope);
            this.pushEvalScope(xEvalScope);
        }
        catch (HidEvalJumpStatementException.HidEvalBreakException hidEvalBreakException) {
            xEvalScope = this.gotoEnclosingLoopScope(xEvalScope);
        }
        catch (HidEvalJumpStatementException.HidEvalNextException e) {
            xEvalScope = this.gotoEnclosingLoopScope(xEvalScope, e.getLoopLabelJump());
            this.pushEvalScope(xEvalScope);
        }
        catch (HidEvalJumpStatementException.HidEvalExitException e) {
            xEvalScope = this.gotoEnclosingLoopScope(xEvalScope, e.getLoopLabelJump());
        }
        catch (HidEvalJumpStatementException.HidEvalReturnException | HidEvalJumpStatementException.HidEvalReturnResultException hidEvalJumpStatementException) {
            this.exitEnclosingMethodScope();
        }
        catch (HidEvalJumpStatementException.HidEvalHotSwapRerunException hidEvalHotSwapRerunException) {
            IXThreadImpl xThreadImpl;
            this.popEvalScope();
            if (xEvalScope.getParentOperator() instanceof HidEvalCenter.IHotSwapElement) {
                ((HidEvalCenter.IHotSwapElement)((Object)xEvalScope.getParentOperator())).hotSwap(xEvalScope.guardian, xEvalScope.evaluator, xEvalScope, xEvalScope.bvContext);
                if (xEvalScope instanceof XSeqBlockEvalScope) {
                    ((XSeqBlockEvalScope)xEvalScope).resetStatementNum();
                    IHidObject eventCtrlStatement = xEvalScope.getNextStatement();
                    if (!(eventCtrlStatement instanceof HidOperator) || !((HidOperator)eventCtrlStatement).isVlogEventControl()) {
                        ((XSeqBlockEvalScope)xEvalScope).resetStatementNum();
                    }
                }
            }
            if ((xThreadImpl = this.getXThreadImpl()) instanceof IntrpDebugThread) {
                ((IntrpDebugThread)xThreadImpl).callbackStartHotSwap();
            }
            this.pushEvalScope(xEvalScope);
        }
    }

    protected XEvalScope gotoEnclosingLoopScope(XEvalScope xEvalScope) {
        while (!xEvalScope.isLoopEvalScope() && !this.xEvalScopesStack.isEmpty()) {
            xEvalScope = this.popEvalScope();
        }
        return xEvalScope;
    }

    protected XEvalScope gotoEnclosingLoopScope(XEvalScope xEvalScope, IRfNamedElement loopLabel) {
        while (!this.xEvalScopesStack.isEmpty() && (!xEvalScope.isLoopEvalScope() || loopLabel != null && xEvalScope.getNamedElement() != null && xEvalScope.getNamedElement() != loopLabel)) {
            xEvalScope = this.popEvalScope();
        }
        return xEvalScope;
    }

    private void exitEnclosingMethodScope() {
        while (!this.xEvalScopesStack.isEmpty()) {
            XEvalScope xEvalScope = this.popEvalScope();
            if (!(xEvalScope instanceof XMethodBlockEvalScope)) continue;
            return;
        }
    }

    public boolean isTerminated() {
        return this.state == XThreadState.TERMINATED || this.state == XThreadState.KILLED || this.xThreadScheduler.isMonitorCanceled();
    }

    public void localTerminate(boolean isKilled) {
        XThread spawnedByThread;
        if (this.state == XThreadState.TERMINATED || this.state == XThreadState.KILLED) {
            return;
        }
        if (this.spawnedThreads != null && !this.spawnedThreads.isEmpty()) {
            for (XThread spawnedThread : this.spawnedThreads) {
                spawnedThread.setNonTerminatedAncestorId(this.nonTerminatedAncestorId);
            }
            this.spawnedThreads.clear();
        }
        if ((spawnedByThread = this.xThreadScheduler.getThread(this.spawnedById)) != null) {
            spawnedByThread.spawnedThreads.remove(this);
        }
        this.state = isKilled ? XThreadState.KILLED : XThreadState.TERMINATED;
        this.xThreadScheduler.resumeAwaitingThreads(this.id);
        this.spawnedThreads = null;
        this.spawnedByLabels = null;
        this.xThreadScheduler.removeTerminated(this);
    }

    public boolean isYielding() {
        return this.state == XThreadState.YIELDING;
    }

    public boolean isNew() {
        return this.state == XThreadState.NEW;
    }

    public boolean isRunning() {
        return this.state == XThreadState.RUNNING;
    }

    public XThreadState getState() {
        return this.state;
    }

    public void startEvalScope(XEvalScope xEvalScope) {
        this.pushEvalScope(xEvalScope);
    }

    public void endEvalScope(XEvalScope xEvalScope) {
        this.popEvalScope();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasStackFrames() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            XEvalScope xEvalScope;
            Iterator<XEvalScope> iterator = this.xEvalScopesStack.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                xEvalScope = iterator.next();
                if (!(xEvalScope instanceof XMethodBlockEvalScope)) continue;
                return true;
            } while (!(xEvalScope instanceof XFrameBlockEvalScope));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGlobalInit() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            block8: {
                IntrpStackFrame stackFrame;
                block7: {
                    block6: {
                        if (!this.xEvalScopesStack.isEmpty()) break block6;
                        return false;
                    }
                    stackFrame = (IntrpStackFrame)this.xEvalScopesStack.getLast().getStackFrame();
                    if (stackFrame != null) break block7;
                    return false;
                }
                if (!GLOBAL_INIT_SCOPE_NAME.equals(stackFrame.getName())) break block8;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame[] getStackFrames() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        ArrayList<IStackFrame> stackFrames = new ArrayList<IStackFrame>();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (xEvalScope instanceof XMethodBlockEvalScope) {
                    stackFrames.add(xEvalScope.getStackFrame());
                }
                if (!(xEvalScope instanceof XFrameBlockEvalScope)) continue;
                stackFrames.add(xEvalScope.getStackFrame());
            }
        }
        return stackFrames.toArray(new IStackFrame[stackFrames.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStackFrame getTopStackFrame() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (xEvalScope instanceof XMethodBlockEvalScope) {
                    return xEvalScope.getStackFrame();
                }
                if (!(xEvalScope instanceof XFrameBlockEvalScope)) continue;
                return xEvalScope.getStackFrame();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMethodBlockEvalScope getTopStackMethodBlockEvalScope() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            XEvalScope xEvalScope;
            Iterator<XEvalScope> iterator = this.xEvalScopesStack.iterator();
            do {
                if (!iterator.hasNext()) {
                    return null;
                }
                xEvalScope = iterator.next();
                if (!(xEvalScope instanceof XMethodBlockEvalScope)) continue;
                return (XMethodBlockEvalScope)xEvalScope;
            } while (!(xEvalScope instanceof XFrameBlockEvalScope));
            return null;
        }
    }

    public void resumeThread() {
        if (this.deferredAssertQueue != null && this.isYielding()) {
            this.deferredAssertQueue.clear();
        }
        this.xThreadScheduler.resumeThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabled(String label) {
        if (label == null) {
            return;
        }
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            boolean breakOnNextIfNotAlways = false;
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (breakOnNextIfNotAlways && !(xEvalScope instanceof XAlwaysBlockEvalScope)) break;
                xEvalScope.setDisabled();
                if (!label.equals(xEvalScope.getLabel())) continue;
                breakOnNextIfNotAlways = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAncestorLabels(Set<String> labels) {
        XThread ancestorThread;
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                String label = xEvalScope.getLabel();
                if (label == null) continue;
                labels.add(label);
            }
        }
        if (this.spawnedByLabels != null) {
            labels.addAll(this.spawnedByLabels);
        }
        if ((ancestorThread = this.xThreadScheduler.getThread(this.spawnedById)) == null) {
            return;
        }
        if (ancestorThread.spawnedByLabels != null) {
            labels.addAll(ancestorThread.spawnedByLabels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAncestorLabel(String disableLabel) {
        if (this.spawnedByLabels != null && this.spawnedByLabels.contains(disableLabel)) {
            return true;
        }
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            XEvalScope xEvalScope;
            String label;
            Iterator<XEvalScope> iterator = this.xEvalScopesStack.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!disableLabel.equals(label = (xEvalScope = iterator.next()).getLabel()) || xEvalScope.isForkEvalScope());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasLabel(String disableLabel) {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            XEvalScope xEvalScope;
            String label;
            Iterator<XEvalScope> iterator = this.xEvalScopesStack.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!disableLabel.equals(label = (xEvalScope = iterator.next()).getLabel()));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStackTraceString() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            StringBuilder result = new StringBuilder();
            if (!this.xEvalScopesStack.isEmpty()) {
                Stack<XEvalScope> xEvalScopesStackCopy = new Stack<XEvalScope>(this.xEvalScopesStack);
                boolean isStackTraceEmpty = true;
                int currLineNumber = -1;
                int size = xEvalScopesStackCopy.size();
                int i = 0;
                for (XEvalScope xEvalScope : xEvalScopesStackCopy) {
                    ++i;
                    int scopeLineNumber = xEvalScope.getLineNumber();
                    if (xEvalScope instanceof XEvalScopeWithParserPath) {
                        if (currLineNumber == -1 && scopeLineNumber == -1) continue;
                        isStackTraceEmpty = false;
                        result.append("    ").append(xEvalScope.getStackFrameInfo(currLineNumber == -1 && scopeLineNumber != -1 ? scopeLineNumber : currLineNumber, null));
                        if (i < size) {
                            result.append("\n");
                        }
                        currLineNumber = -1;
                        continue;
                    }
                    if (currLineNumber != -1) continue;
                    currLineNumber = scopeLineNumber;
                }
                if (!isStackTraceEmpty) {
                    return result.toString();
                }
            }
            int lineNumberOverride = this.xThreadScheduler.getCurrentLineNumber();
            ParserPath parserPathOverride = this.xThreadScheduler.getCurrentParserPath();
            String path = parserPathOverride == null ? XSimEventScheduler.INIT_PARSER_PATH.toString() : parserPathOverride.toString();
            return DVTStringUtil.appendString("    ", GLOBAL_INIT_SCOPE_NAME, " at line ", lineNumberOverride > -1 ? lineNumberOverride : 0, " in ", path);
        }
    }

    public ParserPath getParserPath() {
        if (this.parserPath == null) {
            this.parserPath = this.internalGetParserPath();
        }
        return this.parserPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParserPath internalGetParserPath() {
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope xEvalScope : this.xEvalScopesStack) {
                if (!(xEvalScope instanceof XEvalScopeWithParserPath)) continue;
                return ((XEvalScopeWithParserPath)xEvalScope).getParserPath();
            }
        }
        return XSimEventScheduler.INIT_PARSER_PATH;
    }

    public XEvalScope getEnclosingEvalScope() {
        if (this.xEvalScopesStack.size() > 1) {
            return this.xEvalScopesStack.get(1);
        }
        return null;
    }

    private XEvalScope getHotSwapCommonScope(Stack<XEvalScope> xEvalScopesStackCopy, Map<IRfNamedElement, Boolean> allChangedScopes) {
        HashSet<IRfNamedElement> stackSet = new HashSet<IRfNamedElement>();
        HashMap<IRfNamedElement, XEvalScope> namedElementToEvalScope = new HashMap<IRfNamedElement, XEvalScope>();
        HashMap<IRfNamedElement, Integer> namedElementOrder = new HashMap<IRfNamedElement, Integer>();
        int index = 0;
        for (XEvalScope scope : xEvalScopesStackCopy) {
            IHidOperator parentOperator = scope.getParentOperator();
            if (!(parentOperator instanceof HidEvalCenter.IHotSwapElement)) continue;
            if (parentOperator instanceof HidEvalCenter.ForkJoinStatement && !this.debugThread.isSuspended()) {
                return null;
            }
            IRfNamedElement stackElement = ((HidEvalCenter.IHotSwapElement)((Object)parentOperator)).getNamedElement();
            if (stackElement instanceof IRfActionBlockElement && ((IRfActionBlockElement)stackElement).isForEach()) {
                return null;
            }
            if (stackSet.contains(stackElement)) continue;
            stackSet.add(stackElement);
            namedElementToEvalScope.put(stackElement, scope);
            namedElementOrder.put(stackElement, index);
            ++index;
        }
        XEvalScope enclosingScope = null;
        int enclosingScopePriority = -1;
        for (IRfNamedElement changedNamedElement : allChangedScopes.keySet()) {
            while (changedNamedElement != null && !stackSet.contains(changedNamedElement)) {
                changedNamedElement = (IRfNamedElement)changedNamedElement.getEnclosingScope();
            }
            if (changedNamedElement == null || (Integer)namedElementOrder.get(changedNamedElement) <= enclosingScopePriority) continue;
            enclosingScope = (XEvalScope)namedElementToEvalScope.get(changedNamedElement);
            enclosingScopePriority = (Integer)namedElementOrder.get(changedNamedElement);
        }
        return !(enclosingScope instanceof XFrameBlockEvalScope) ? enclosingScope : null;
    }

    public void dropToFrame(IntrpStackFrame stackFrame) {
        XEvalScope xEvalScope = stackFrame.getXEvalScope();
        if (xEvalScope instanceof XFrameBlockEvalScope) {
            xEvalScope = this.getChildXSeqBlockEvalScope(xEvalScope);
        }
        if (xEvalScope == null) {
            return;
        }
        this.setHotSwapFlags(xEvalScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XSeqBlockEvalScope getChildXSeqBlockEvalScope(XEvalScope xEvalScope) {
        XSeqBlockEvalScope seqBlockEvalScope = null;
        IXThreadImpl activeThreadImpl = this.xThreadDefinition.getXThreadImpl();
        Stack<XEvalScope> stack = activeThreadImpl == null ? new Stack<XEvalScope>() : this.xEvalScopesStack;
        synchronized (stack) {
            for (XEvalScope scope : this.xEvalScopesStack) {
                if (scope == xEvalScope) {
                    return seqBlockEvalScope;
                }
                if (!(scope instanceof XSeqBlockEvalScope)) continue;
                seqBlockEvalScope = (XSeqBlockEvalScope)scope;
            }
        }
        return null;
    }

    public void computeHotSwapElement(Map<IRfNamedElement, Boolean> allChangedScopes, Collection<ParserPath> changedFiles) {
        if (this.debugThread == null) {
            return;
        }
        Stack<XEvalScope> xEvalScopesStackCopy = new Stack<XEvalScope>(this.xEvalScopesStack);
        XEvalScope encompassingScope = null;
        encompassingScope = this.getHotSwapCommonScope(xEvalScopesStackCopy, allChangedScopes);
        if (encompassingScope == null && this.debugThread.isSuspended()) {
            ParserPath parserPath = this.getParserPath();
            if (changedFiles.stream().anyMatch(e -> e.equals(parserPath))) {
                encompassingScope = this.getParentScopeExcludingFrameBlock();
            }
        }
        this.setHotSwapFlags(encompassingScope);
        int i = 0;
        while (i < xEvalScopesStackCopy.size()) {
            XEvalScope xEvalScope = xEvalScopesStackCopy.get(i);
            if (i <= 0 || !xEvalScope.needsHotSwap()) {
                xEvalScope.recomputeHotSwappedUnmodifiedStatements(allChangedScopes);
            }
            ++i;
        }
    }

    private void setHotSwapFlags(XEvalScope xEvalScope) {
        if (xEvalScope == null) {
            return;
        }
        xEvalScope.setNeedsHotSwap(true);
        this.setIsHotSwap(true);
        if (this.spawnedThreads == null) {
            return;
        }
        ArrayList<XThread> spawnedThreadsCopy = new ArrayList<XThread>(this.spawnedThreads);
        for (XThread spawnedThread : spawnedThreadsCopy) {
            spawnedThread.setIsHotSwap(true);
        }
    }

    boolean isSameFile(IRfNamedElement e1, IRfNamedElement e2) {
        if (e1 == null) {
            return false;
        }
        if (e2 == null) {
            return false;
        }
        IRfDefElement declaration = e1.getDeclaration();
        if (declaration == null) {
            return false;
        }
        IRfDefElement declaration2 = e2.getDeclaration();
        if (declaration2 == null) {
            return false;
        }
        return declaration.getParserPath().equals(declaration2.getParserPath());
    }

    public void setIsHotSwap(boolean isHotSwap) {
        this.isHotSwap = isHotSwap;
    }

    public boolean isHotSwap() {
        return this.isHotSwap;
    }

    public XEvalScopeWithParserPath getFirstBlockEvalScopeWithParserPathFromStack() {
        if (this.xEvalScopesStack == null || this.xEvalScopesStack.isEmpty()) {
            return null;
        }
        Iterator<XEvalScope> it = this.xEvalScopesStack.iterator();
        if (!it.hasNext()) {
            return null;
        }
        it.next();
        while (it.hasNext()) {
            XEvalScope xEvalScope = it.next();
            if (!(xEvalScope instanceof XEvalScopeWithParserPath)) continue;
            return (XEvalScopeWithParserPath)xEvalScope;
        }
        return null;
    }

    public XEvalScopeWithParserPath getNextEvalScopeWithParserPathFromStackAfter(XEvalScopeWithParserPath xEvalScopeWithPath) {
        if (this.xEvalScopesStack == null || this.xEvalScopesStack.isEmpty()) {
            return null;
        }
        Iterator<XEvalScope> it = this.xEvalScopesStack.iterator();
        if (!it.hasNext()) {
            return null;
        }
        it.next();
        boolean foundRef = false;
        while (it.hasNext()) {
            XEvalScope xEvalScope = it.next();
            if (foundRef && xEvalScope instanceof XEvalScopeWithParserPath) {
                return (XEvalScopeWithParserPath)xEvalScope;
            }
            if (xEvalScope != xEvalScopeWithPath) continue;
            foundRef = true;
        }
        return null;
    }

    public boolean isMonitorCanceled() {
        return this.xThreadScheduler.isMonitorCanceled();
    }

    public void setActiveThread() {
        this.xThreadScheduler.setActiveThread(this);
    }

    public void addDeferredAssertMessage(IRfAssertExpectElement.AssertKind deferredAssertKind, Runnable reportRunnable) {
        if (this.deferredAssertQueue == null) {
            this.deferredAssertQueue = new ArrayList<DeferredAssert>();
        }
        this.deferredAssertQueue.add(new DeferredAssert(deferredAssertKind, reportRunnable));
    }

    public void getReportDeferredAssert(IRfAssertExpectElement.AssertKind assertKind) {
        if (this.deferredAssertQueue == null) {
            return;
        }
        for (DeferredAssert deferredAssert : this.deferredAssertQueue) {
            if (deferredAssert.assertKind != assertKind) continue;
            deferredAssert.reportRunnable.run();
        }
    }

    private static class DeferredAssert {
        private IRfAssertExpectElement.AssertKind assertKind;
        private Runnable reportRunnable;

        private DeferredAssert(IRfAssertExpectElement.AssertKind assertKind, Runnable reportRunnable) {
            this.assertKind = assertKind;
            this.reportRunnable = reportRunnable;
        }
    }

    public static class XReSuspendThreadException
    extends XSuspendThreadException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static class XSuspendThreadException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }

    public static enum XThreadState {
        NEW,
        RUNNING,
        YIELDING,
        TERMINATED,
        KILLED;

    }
}

