/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.Objects;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XThreadDefinition {
    private IXThreadImpl xThreadImpl;
    private IHidEvaluationGuardian hidEvaluationGuardian;
    private IHidEvaluator hidEvaluator;
    private IHidObject firstStatement;
    private ParserPath firstStatementParserPath;
    private IHidObject firstStatementOnMainThread;
    private String additionalInfo;
    private XValueHolderFactory factory;
    private IRfNamedElement enclosingScope;
    private MethodCall methodCall;
    private IHidObject hidObject;
    private IRfNamedElement viaActionBlock;
    private ThreadKind threadKind;

    public XThreadDefinition(IXThreadImpl xThreadImpl, IHidEvaluationGuardian hidEvaluationGuardian, IHidEvaluator hidEvaluator, IHidObject firstStatement, ParserPath firstStatementParserPath, String additionalInfo, ThreadKind threadKind) {
        this.xThreadImpl = xThreadImpl;
        this.hidEvaluationGuardian = hidEvaluationGuardian;
        this.firstStatementParserPath = firstStatementParserPath;
        this.additionalInfo = additionalInfo;
        this.threadKind = threadKind;
        this.firstStatement = firstStatement;
        this.hidEvaluator = hidEvaluator;
    }

    public XThreadDefinition(IXThreadImpl xThreadImpl, XValueHolderFactory factory, IHidEvaluationGuardian hidEvaluationGuardian, IRfNamedElement enclosingScope, MethodCall methodCall, IHidObject hidObject, ParserPath parserPath, String additionalInfo, ThreadKind threadKind) {
        this.xThreadImpl = xThreadImpl;
        this.hidEvaluationGuardian = hidEvaluationGuardian;
        this.firstStatementParserPath = parserPath;
        this.additionalInfo = additionalInfo;
        this.threadKind = threadKind;
        this.factory = factory;
        this.enclosingScope = enclosingScope;
        this.methodCall = methodCall;
        this.hidObject = hidObject;
    }

    public XThreadDefinition(IXThreadImpl xThreadImpl, XValueHolderFactory factory, IHidEvaluationGuardian hidEvaluationGuardian, IRfNamedElement enclosingScope, IRfNamedElement viaActionBlock, ParserPath parserPath, String additionalInfo, ThreadKind threadKind) {
        this.xThreadImpl = xThreadImpl;
        this.hidEvaluationGuardian = hidEvaluationGuardian;
        this.firstStatementParserPath = parserPath;
        this.additionalInfo = additionalInfo;
        this.threadKind = threadKind;
        this.factory = factory;
        this.enclosingScope = enclosingScope;
        this.viaActionBlock = viaActionBlock;
    }

    public void init(XInstValueHolder instanceScope) {
        if (this.viaActionBlock != null) {
            IELParamValue enclosingValue = this.factory.createValueHolder(this.enclosingScope, null, null);
            IHidOperator hidOperator = HidEvalConverter.INSTANCE.convertElement(this.viaActionBlock, this.hidEvaluationGuardian, enclosingValue);
            this.hidEvaluator = enclosingValue;
            this.firstStatementOnMainThread = this.firstStatement = hidOperator;
        } else if (this.firstStatement == null && this.factory != null && this.enclosingScope != null) {
            XValueHolder enclosingValue = (XValueHolder)this.factory.createValueHolder(this.enclosingScope, null, null);
            enclosingValue.setIsNull(false);
            this.initLocalVariables(enclosingValue, instanceScope);
            this.hidEvaluator = enclosingValue;
            this.firstStatementOnMainThread = this.firstStatement = HidEvalCenter.INSTANCE.createMethodCall(this.methodCall, this.hidObject, enclosingValue, false);
        }
    }

    private void initLocalVariables(XValueHolder enclosingValue, XInstValueHolder instanceScope) {
        IELParamValue superValue = XUtils.getValue(enclosingValue.getSuper(instanceScope));
        if (superValue instanceof XValueHolder) {
            this.initLocalVariables((XValueHolder)superValue, instanceScope);
        }
        enclosingValue.initLocalVariables(false);
    }

    public IHidEvaluator getHidEvaluator() {
        return this.hidEvaluator;
    }

    public IHidEvaluationGuardian getHidEvaluationGuardian() {
        return this.hidEvaluationGuardian;
    }

    public IHidObject getFirstStatement() {
        return this.firstStatement;
    }

    public String getName() {
        if (this.methodCall != null) {
            return this.methodCall.toString();
        }
        if (this.firstStatement instanceof HidOperator) {
            return DVTStringUtil.appendString(this.additionalInfo, " ", ((HidOperator)this.firstStatement).getLine(), "@", Path.fromOSString((String)this.firstStatementParserPath.path).lastSegment());
        }
        return DVTStringUtil.appendString(this.additionalInfo, " @", Path.fromOSString((String)this.firstStatementParserPath.path).lastSegment());
    }

    public ParserPath getFirstStatementParserPath() {
        return this.firstStatementParserPath;
    }

    public boolean isFirstStatementOnMainThread(IHidObject statement) {
        return statement == this.firstStatementOnMainThread;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public IXThreadImpl getXThreadImpl() {
        return this.xThreadImpl;
    }

    public void setXThread(XThread xThread, boolean isStepInto) {
        if (this.xThreadImpl == null) {
            return;
        }
        this.xThreadImpl.setXThread(xThread, isStepInto);
    }

    public void preStartEval() {
        if (this.xThreadImpl == null) {
            return;
        }
        this.xThreadImpl.preStartEval();
    }

    public void localTerminate() {
        if (this.xThreadImpl == null) {
            return;
        }
        this.xThreadImpl.localTerminate();
    }

    public int hashCode() {
        return Objects.hash(this.firstStatement, this.firstStatementParserPath, this.hidEvaluator);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XThreadDefinition other = (XThreadDefinition)obj;
        return Objects.equals(this.firstStatement, other.firstStatement) && Objects.equals(this.firstStatementParserPath, other.firstStatementParserPath) && Objects.equals(this.hidEvaluator, other.hidEvaluator);
    }

    public ThreadKind getThreadKind() {
        return this.threadKind;
    }

    public boolean isAlwaysBlock() {
        return ThreadKind.isAlwaysBlock(this.threadKind);
    }

    public boolean isInitialBlock() {
        return ThreadKind.isInitialBlock(this.threadKind);
    }

    public boolean isFinalBlock() {
        return ThreadKind.isFinalBlock(this.threadKind);
    }

    public static enum ThreadKind {
        GLOBAL_INIT,
        FINAL,
        INITIAL,
        PROCESS,
        ALWAYS,
        ALWAYS_COMB,
        FORKED,
        NBA,
        NONE,
        ASSERTION,
        PREPONED;


        static boolean isAlwaysBlock(ThreadKind threadKind) {
            return threadKind == ALWAYS || threadKind == ALWAYS_COMB || threadKind == PROCESS;
        }

        static boolean isInitialBlock(ThreadKind threadKind) {
            return threadKind == INITIAL;
        }

        static boolean isFinalBlock(ThreadKind threadKind) {
            return threadKind == FINAL;
        }
    }
}

