/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;

public class XUVMElaborationSetup {
    private String testName;
    private final List<String> customArgs = new LinkedList<String>();
    private HistoryItem historyItem;
    public final List<IXContributor> xContributors = new ArrayList<IXContributor>();
    protected IProject project;
    private String projectName;
    private boolean isDebugMode;
    private boolean isLoadSerializedTestMode;
    private String chdFileName;
    private boolean shouldSaveModel;
    private boolean shouldStopAfterUVMElaboration;
    private String verbosity;
    private String seed;
    private boolean useBuiltinDPIC;
    private String addArguments;

    public void addXContributor(IXContributor xContributor) {
        this.xContributors.add(xContributor);
    }

    public String getTestName() {
        return this.testName;
    }

    public List<String> getCustomArgs() {
        return this.customArgs;
    }

    public HistoryItem getHistoryItem() {
        return this.historyItem;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public XUVMElaborationSetup withDebugModeOn(boolean isDebugMode) {
        this.isDebugMode = isDebugMode;
        return this;
    }

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public XUVMElaborationSetup withTestName(String testName) {
        this.testName = testName;
        return this;
    }

    public XUVMElaborationSetup withCustomArgs(List<String> customArgs) {
        this.customArgs.addAll(customArgs);
        return this;
    }

    public XUVMElaborationSetup withVHViewContributor() {
        this.xContributors.add(XViewsUtils.getXVHContributor());
        return this;
    }

    public XUVMElaborationSetup withRegistersViewContributor() {
        this.xContributors.add(XViewsUtils.getXRegistersViewContributor());
        return this;
    }

    public XUVMElaborationSetup withProject(IProject project) {
        this.project = project;
        return this;
    }

    public XUVMElaborationSetup withProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    public XUVMElaborationSetup withHistoryItem(HistoryItem historyItem) {
        this.historyItem = historyItem;
        return this;
    }

    public XUVMElaborationSetup withFactoryOverridesViewContributor() {
        this.xContributors.add(XViewsUtils.getXFactoryOverridesViewContributor());
        return this;
    }

    public XUVMElaborationSetup withSaveModel(boolean saveModel) {
        this.shouldSaveModel = saveModel;
        return this;
    }

    public XUVMElaborationSetup withStopAfterElaboration(boolean stopAfterUVMElaboration) {
        this.shouldStopAfterUVMElaboration = stopAfterUVMElaboration;
        return this;
    }

    public XUVMElaborationSetup withConfigDBViewContributor() {
        this.xContributors.add(XViewsUtils.getXConfigDBViewContributor());
        return this;
    }

    public XUVMElaborationSetup withLoadSerializedTestMode(boolean isLoadSerializedTestMode) {
        this.isLoadSerializedTestMode = isLoadSerializedTestMode;
        return this;
    }

    public boolean isLoadSerializedTestMode() {
        return this.isLoadSerializedTestMode;
    }

    public XUVMElaborationSetup withCHDFileName(String chdFileName) {
        this.chdFileName = chdFileName;
        return this;
    }

    public String getChdFileName() {
        return this.chdFileName;
    }

    public boolean shouldSaveModel() {
        return this.shouldSaveModel;
    }

    public boolean shouldStopAfterUVMElaboration() {
        return this.shouldStopAfterUVMElaboration;
    }

    public XUVMElaborationSetup withVerbosity(String verbosity) {
        this.verbosity = verbosity;
        return this;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public XUVMElaborationSetup withSeed(String seed) {
        this.seed = seed;
        return this;
    }

    public String getSeed() {
        return this.seed;
    }

    public XUVMElaborationSetup withUseBUiltinDPIC(boolean useBuiltinDPIC) {
        this.useBuiltinDPIC = useBuiltinDPIC;
        return this;
    }

    public boolean isUseBuiltinDPIC() {
        return this.useBuiltinDPIC;
    }

    public XUVMElaborationSetup withAdditionalArgs(String addArguments) {
        this.addArguments = addArguments;
        return this;
    }

    public String getAddArguments() {
        return this.addArguments;
    }
}

