/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.debug.core.model.IStackFrame;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.MinTypMax;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugThread;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.debug.core.model.breakpoints.LastExecutedStatementInfo;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XSeqBlockEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfPredefinedGate;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidAccessArgs;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.AssociationUtils;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.test.TestHelperCommon;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.XGlobalCache;

public class XUtils {
    public static final boolean DVT_ENABLE_SV_INTERP_DEBUG = Boolean.parseBoolean(System.getenv("DVT_ENABLE_SV_INTERP_DEBUG"));
    public static final boolean DVT_ENABLE_SV_INTERP_DEBUG_EXTRA = Boolean.parseBoolean(System.getenv("DVT_ENABLE_SV_INTERP_DEBUG_EXTRA"));
    public static final String ITERATION_COUNT = "[repeat index @";
    private static final String RUN_TEST_METHOD_CALL = "run_test()";
    public static final boolean DVT_DEBUG_MODE = "true".equals(System.getenv("DVT_DEBUG_MODE"));
    public static final BigDecimal MINUS_ONE_DECIMAL = BigDecimal.valueOf(-1L);
    public static final Set<HidFlatteningOption> EVENT_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IFF_EXPRESSION, HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    public static final Set<HidFlatteningOption> ASSIGN_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_CONSTANTS));
    public static final Set<HidFlatteningOption> LHS_HID_FLATTENING = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_CONSTANTS, HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS));
    public static final boolean enableCbInputDelayed = true;
    public static final boolean enableCbOutputDelayed = true;
    public static final boolean enableCbInoutDelayed = true;
    private static final Map<String, Integer> statisticCounters = new HashMap<String, Integer>();
    private static final Map<String, Long> statisticTimeCounters = new HashMap<String, Long>();
    private static final Map<String, Long> statisticStartTimeMap = new HashMap<String, Long>();
    private static final Map<String, Integer> inlineStatisticCounters = new LinkedHashMap<String, Integer>();
    private static int nofInstancesTotal;
    private static int nofInstancesUsed;
    public static boolean verbosityChanged;

    public static void startSimulation() {
        statisticCounters.clear();
        statisticTimeCounters.clear();
        statisticStartTimeMap.clear();
        nofInstancesTotal = 0;
        nofInstancesUsed = 0;
        inlineStatisticCounters.put("unsuccessful inline singleton method (null test)", 0);
        inlineStatisticCounters.put("unsuccessful inline singleton method (non-null test)", 0);
        inlineStatisticCounters.put("inline single return statement method", 0);
        inlineStatisticCounters.put("inline single return statement method recursive", 0);
        inlineStatisticCounters.put("inline singleton method (null test)", 0);
        inlineStatisticCounters.put("inline singleton method (non-null test)", 0);
        inlineStatisticCounters.put("inline if-then-else method", 0);
        inlineStatisticCounters.put("changed ternary operator to imply operator", 0);
    }

    public static void endSimulation() {
        XUtils.printStatistic(TestHelperCommon.out);
        statisticCounters.clear();
        statisticTimeCounters.clear();
        statisticStartTimeMap.clear();
        inlineStatisticCounters.clear();
    }

    public static String getName(IHid hid) {
        String name = hid.getName();
        IRfNamedElement element = hid.getElement();
        if (element == null) {
            return hid.getLanguageKind() == LanguageKind.VHDL ? name.toLowerCase() : name;
        }
        if (AssociationUtils.isConnectedType(hid)) {
            name = element.getName();
        }
        return element.getLanguageKind() == LanguageKind.VHDL ? name.toLowerCase() : name;
    }

    public static String getName(IRfNamedElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IRfCompositeTypeElement) {
            return ((IRfCompositeTypeElement)element).getAliasName();
        }
        String name = element.getName();
        if (element.getLanguageKind() == LanguageKind.VHDL) {
            return name.toLowerCase();
        }
        return name;
    }

    public static BitSet getMaskXZ(IELParamValue value, boolean isChangeDetection) {
        if (value instanceof XArrayValueHolder) {
            return BitSetUtils.valueOf(0);
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (!(dvtNumber instanceof VlogBitVector)) {
            return BitSetUtils.valueOf(0);
        }
        VlogBitVector number = (VlogBitVector)dvtNumber;
        if (!number.is4State()) {
            return BitSetUtils.valueOf(0);
        }
        BitSet result = number.getMask(MaskType.X);
        int size = dvtNumber.getSize();
        if (result == null) {
            result = number.getMask(MaskType.Z);
            if (result == null) {
                return BitSetUtils.valueOf(0);
            }
            if (isChangeDetection) {
                return BitSetUtils.shiftLeft(result, size);
            }
            return (BitSet)result.clone();
        }
        result = (BitSet)result.clone();
        BitSet resultZ = number.getMask(MaskType.Z);
        if (resultZ == null) {
            return result;
        }
        if (isChangeDetection) {
            result.or(BitSetUtils.shiftLeft(resultZ, size));
        } else {
            result.or(resultZ);
        }
        return result;
    }

    public static boolean isSensitiveAll(IHidObject hidObject) {
        ListContainer<IHidObject> hidObjects;
        if (HidUtils.isHidImplicit(hidObject) && ((HidImplicit)hidObject).isSensitivityListAll()) {
            return true;
        }
        return HidUtils.isOperator(hidObject) && (hidObjects = ((IHidOperator)hidObject).getRHValues()) != null && hidObjects.size() == 1 && XUtils.isSensitiveAll(hidObjects.get(0));
    }

    public static boolean isSensitiveAllEdgeControl(IHidObject hidObject) {
        if (!HidUtils.isOperator(hidObject) || !((HidOperator)hidObject).hasQualifier(HidQualifierCache.IS_EVENT_CONTROL_QUALIFIER)) {
            return false;
        }
        return XUtils.isSensitiveAll(((HidOperator)hidObject).getLHValue());
    }

    public static String removePrefix(String variableName) {
        int i = 0;
        while (i < variableName.length()) {
            char ch = variableName.charAt(i);
            if (!Character.isDigit(ch)) {
                if (ch == '#') {
                    return variableName.substring(i + 1);
                }
                return variableName;
            }
            ++i;
        }
        return variableName;
    }

    public static String prefix(String variableName, int index) {
        return Integer.toString(index) + "#" + variableName;
    }

    public static <K, V> void addToListInMap(K key, V value, Map<K, List<V>> map) {
        List<V> values = map.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    public static <K, V> void addToSetInMap(K key, V value, Map<K, Set<V>> map) {
        Set<V> values = map.get(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            map.put(key, values);
        }
        values.add(value);
    }

    public static boolean isInoutPort(IHid portHid, IHidObject signalHidObject) {
        String associatedTypeName;
        IRfScopeElement enclosingScope;
        if (!HidUtils.isHid(portHid)) {
            return false;
        }
        IRfNamedElement element = portHid.getElement();
        if (element instanceof IRfFieldElement && ((IRfFieldElement)element).isInout()) {
            return true;
        }
        if (element instanceof IRfPortElement && ((IRfPortElement)element).isCoerceInout() && XUtils.netType(element) != IRfNamedElement.NetType.NONE && XUtils.isAllowPortCoerce(signalHidObject)) {
            return true;
        }
        return element instanceof IRfPortElement && (enclosingScope = element.getEnclosingScope()) instanceof IRfInstanceElement && ("pullup".equals(associatedTypeName = ((IRfInstanceElement)enclosingScope).getAssociatedTypeName()) || "pulldown".equals(associatedTypeName));
    }

    public static boolean isInterfacePort(IHid hid) {
        if (!HidUtils.isHid(hid)) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        return element instanceof IRfPortElement && ((IRfPortElement)element).isInterfacePort();
    }

    public static boolean isRefPort(IHid hid) {
        if (!HidUtils.isHid(hid)) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        return element instanceof IRfFieldElement && ((IRfFieldElement)element).isRef();
    }

    public static boolean isInputPort(IHid portHid, IHidObject signalHidObject) {
        if (!HidUtils.isHid(portHid)) {
            return false;
        }
        IRfNamedElement element = portHid.getElement();
        if (element instanceof IRfFieldElement && ((IRfFieldElement)element).isInput()) {
            return !(element instanceof IRfPortElement) || !((IRfPortElement)element).isCoerceInout() || XUtils.netType(element) == IRfNamedElement.NetType.NONE || !XUtils.isAllowPortCoerce(signalHidObject);
        }
        return false;
    }

    public static boolean isOutputPort(IHid hid, IHidObject signalHidObject) {
        if (!HidUtils.isHid(hid)) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (element instanceof IRfFieldElement && ((IRfFieldElement)element).isOutput()) {
            String associatedTypeName;
            if (element instanceof IRfPortElement && ((IRfPortElement)element).isCoerceInout() && XUtils.netType(element) != IRfNamedElement.NetType.NONE && XUtils.isAllowPortCoerce(signalHidObject)) {
                return false;
            }
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            return !(element instanceof IRfPortElement) || !(enclosingScope instanceof IRfInstanceElement) || !"pullup".equals(associatedTypeName = ((IRfInstanceElement)enclosingScope).getAssociatedTypeName()) && !"pulldown".equals(associatedTypeName);
        }
        return false;
    }

    public static IHidEvaluator getEnclosingNamedScope(IHidEvaluator evaluator) {
        if (evaluator instanceof XValueHolder) {
            while (evaluator != null && evaluator.getNamedElement() instanceof IRfActionBlockElement) {
                evaluator = ((XValueHolder)evaluator).getEnclosingValue();
            }
        }
        return evaluator;
    }

    public static ELManager getNonElabManager(RfMixedLangProject project) {
        return ELManager.createNonElabManager(project);
    }

    public static IHidObject toOperator(IHidObject condition) {
        if (condition instanceof HidOperator) {
            return condition;
        }
        Hid parentHid = XUtils.getParentHid(condition);
        if (parentHid == null) {
            return condition;
        }
        HidOperatorOccurrence occurrence = new HidOperatorOccurrence(parentHid.getOffset(), parentHid.getVirtualOffset(), parentHid.getLine(), 0L, null);
        return HidUtils.makeStandInOperator(condition, Collections.emptyList(), IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "<condition wrapper>", occurrence, 0L);
    }

    public static Set<String> getAncestorLabels(String forkLabel, XThread xActiveThread) {
        if (forkLabel == null) {
            if (xActiveThread == null) {
                return null;
            }
            HashSet<String> labels = new HashSet<String>();
            xActiveThread.collectAncestorLabels(labels);
            return labels.isEmpty() ? null : labels;
        }
        if (xActiveThread == null) {
            return Collections.singleton(forkLabel);
        }
        HashSet<String> labels = new HashSet<String>();
        xActiveThread.collectAncestorLabels(labels);
        if (labels == null || labels.isEmpty()) {
            return Collections.singleton(forkLabel);
        }
        labels.add(forkLabel);
        return labels;
    }

    public static int getLine(IHidObject statement) {
        return statement != null ? statement.xGetLine() : -1;
    }

    public static Hid getParentHid(IHidObject object) {
        if (HidUtils.isHidAccess(object)) {
            return XUtils.getParentHid(((HidAccess)object).getParentHid());
        }
        if (HidUtils.isHid(object)) {
            return (Hid)object;
        }
        if (object instanceof XInstValueHolder.XSelectOperator) {
            return XUtils.getParentHid(((XInstValueHolder.XSelectOperator)object).getLHValue());
        }
        return null;
    }

    public static IRfNamedElement.NetType netType(IHid hid) {
        IRfNamedElement element = hid.getElement();
        return XUtils.netType(element);
    }

    public static IRfNamedElement.NetType netType(IRfNamedElement element) {
        if (!(element instanceof IRfAssociatedTypeElement)) {
            return IRfNamedElement.NetType.NONE;
        }
        return element.xGetNetType();
    }

    public static boolean isAlwaysComb(IRfActionBlockElement actionBlock) {
        return XUtils.isAlwaysBlock(actionBlock) && actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB);
    }

    public static boolean isAlwaysLatch(IRfActionBlockElement actionBlock) {
        return XUtils.isAlwaysBlock(actionBlock) && actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH);
    }

    public static boolean isAlwaysBlock(IRfActionBlockElement actionBlock) {
        return actionBlock != null && (actionBlock.isAlways() || actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.PROCESS));
    }

    public static boolean isInitialBlock(IRfActionBlockElement actionBlock) {
        return actionBlock != null && actionBlock.isInitial();
    }

    public static boolean isFinalBlock(IRfActionBlockElement actionBlock) {
        return actionBlock != null && actionBlock.isFinal();
    }

    public static boolean isConcurrentAssertion(IRfActionBlockElement actionBlock) {
        return actionBlock instanceof IRfAssertExpectElement && ((IRfAssertExpectElement)actionBlock).isConcurrentAssertionStatement();
    }

    public static Set<IHid> getDrivers(IHidObject operator, Set<HidFlatteningOption> options, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        IHidObject rhValue;
        if (operator instanceof HidOperator && (rhValue = ((HidOperator)operator).getFirstRHValue()) instanceof HidAccess && "new".equals(XUtils.getName(((HidAccess)rhValue).getParentHid()))) {
            return Collections.emptySet();
        }
        LinkedHashSet<IHid> driverHids = new LinkedHashSet<IHid>();
        HashSet<IHid> localVariables = new HashSet<IHid>();
        XUtils.collectDrivers(true, driverHids, driverHids, localVariables, operator, options, null, evaluator, guardian);
        driverHids.removeAll(localVariables);
        return driverHids;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean collectDrivers(boolean reportError, Set<IHid> driverHids, Set<IHid> selectHids, Set<IHid> localVariables, IHidObject operator, Set<HidFlatteningOption> options, IRfNamedElement scope, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (operator == null) {
            return false;
        }
        if (operator instanceof IHidImplicit) {
            return false;
        }
        if (operator instanceof IHidAccessArgs && ((HidAccess)operator).getLanguageKind() == LanguageKind.VLOG) {
            MethodCall methodCall = ((IHidAccessArgs)((Object)operator)).getMethodCall(guardian);
            if (methodCall != null && methodCall.method instanceof IRfMethodElement) {
                List<Object> methodBodyStatements;
                IHidOperator methodBody;
                Hid parentHid = ((HidAccess)operator).getParentHid();
                boolean useLocalValiable = XUtils.addHid(driverHids, driverHids, parentHid, localVariables, options, scope, evaluator, guardian);
                if (useLocalValiable) {
                    return true;
                }
                if (methodCall.argumentValuesMapRaw == null) return false;
                IRfMethodElement methodElement = (IRfMethodElement)methodCall.method;
                LinkedHashMap<String, IHidObject> specifiedArguments = new LinkedHashMap<String, IHidObject>();
                for (Map.Entry<IRfFieldElement, IHidObject> argValuePair : methodCall.argumentValuesMapRaw.entrySet()) {
                    IRfFieldElement formalArgument = argValuePair.getKey();
                    IHidObject argValueObject = argValuePair.getValue();
                    XUtils.collectDrivers(false, driverHids, driverHids, localVariables, argValueObject, options, scope, evaluator, guardian);
                    if (argValueObject == null && !XUtils.isSystemFunctionOrTask(methodElement)) continue;
                    String formalArgName = formalArgument.getName();
                    specifiedArguments.put(formalArgName, argValueObject);
                }
                ELManager manager = evaluator.getManager();
                IHidOperator iHidOperator = methodBody = manager != null ? manager.computeIfAbsentResolvedMethodBody(methodElement, guardian, evaluator) : null;
                List<Object> list = methodBody instanceof HidEvalCenter.SeqBlockStatement ? OptimizedUtils.asList(methodBody.getRHValues(), false) : (methodBodyStatements = methodBody != null ? Collections.singletonList(methodBody) : Collections.emptyList());
                if (methodBodyStatements == null) {
                    return false;
                }
                LinkedHashSet<IHid> localDeclaredVariables = new LinkedHashSet<IHid>();
                int i = 0;
                while (i < methodBodyStatements.size()) {
                    IHidObject statement = (IHidObject)methodBodyStatements.get(i);
                    if (statement != null) {
                        if (statement instanceof HidEvalCenter.DeclarationStatement) {
                            Hid lhValue = (Hid)((HidEvalCenter.DeclarationStatement)statement).getLHValue();
                            localDeclaredVariables.add(lhValue);
                        } else {
                            if (!(statement instanceof HidEvalCenter.IInitialValueDeclarationStatement)) return false;
                            HidEvalCenter.IInitialValueDeclarationStatement initStatement = (HidEvalCenter.IInitialValueDeclarationStatement)statement;
                            if (!specifiedArguments.containsKey(initStatement.getFieldName()) || !MethodCallUtils.isValidMethodArgument(initStatement.getField())) {
                                Hid lhValue = (Hid)initStatement.getLHValue();
                                localDeclaredVariables.add(lhValue);
                                ListContainer<IHidObject> rhValues = initStatement.getRHValues();
                                for (IHidObject rhValue : rhValues) {
                                    XUtils.collectDrivers(false, driverHids, driverHids, localDeclaredVariables, rhValue, options, scope, evaluator, guardian);
                                }
                            }
                        }
                    }
                    ++i;
                }
                return false;
            } else {
                if (!reportError) return false;
                guardian.logError(DVTStringUtil.appendString("Fail to evaluate '", XUtils.getName(((HidAccess)operator).getParentHid()), "' in scope of '", evaluator, "' (id:0007)"));
            }
            return false;
        }
        if (operator instanceof HidEvalCenter.DelayedContinuousAssign) {
            return XUtils.collectDrivers(false, driverHids, driverHids, localVariables, ((HidEvalCenter.DelayedContinuousAssign)operator).getAssignOperator(), options, scope, evaluator, guardian);
        }
        if (operator instanceof IHidOperator) {
            boolean isPortConnection = ((IHidOperator)operator).hasOccurrence(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER);
            boolean isPortExpression = ((IHidOperator)operator).hasOccurrence(HidQualifierCache.IS_PORT_EXPRESSION_QUALIFIER);
            boolean isAssignment = ((IHidOperator)operator).isAssignment();
            if (isAssignment || isPortConnection || isPortExpression) {
                IHidObject lhValue = ((IHidOperator)operator).getLHValue();
                boolean isDeclarationAssign = ((IHidOperator)operator).hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN);
                boolean isContinuousAssign = ((IHidOperator)operator).hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN);
                if (isContinuousAssign && scope instanceof IRfActionBlockElement && HidUtils.isHid(lhValue) && ((IRfActionBlockElement)scope).isForOrForeach() && ((IHid)lhValue).hasOccurrence(HidQualifierCache.LOOP_INDEX_VAR_QUALIFIER)) {
                    localVariables.add((IHid)lhValue);
                    return true;
                }
                if (isDeclarationAssign && scope instanceof IRfActionBlockElement && HidUtils.isHidImplicit(lhValue)) {
                    IHid hid = ((IHidImplicit)lhValue).xToHid(scope, HidOccurrence.DUMMY_OCCURRENCE);
                    localVariables.add(hid);
                    if (hid.getElement() != null && hid.getElement().xIsStaticMember()) {
                        return true;
                    }
                } else if (isDeclarationAssign && scope instanceof IRfActionBlockElement && HidUtils.isHid(lhValue)) {
                    localVariables.add((IHid)lhValue);
                }
                XUtils.collectDrivers(true, new HashSet<IHid>(), driverHids, localVariables, lhValue, options, scope, evaluator, guardian);
                ListContainer<IHidObject> rhValues = ((IHidOperator)operator).getRHValues();
                for (IHidObject rhValue : rhValues) {
                    XUtils.collectDrivers(true, driverHids, driverHids, localVariables, rhValue, options, scope, evaluator, guardian);
                }
                return false;
            }
        }
        if (operator instanceof IHid) {
            return XUtils.addHid(driverHids, selectHids, (Hid)operator, localVariables, options, scope, evaluator, guardian);
        }
        if (operator instanceof HidAccess) {
            Hid parentHid = ((HidAccess)operator).getParentHid();
            boolean useLocalValiable = XUtils.addHid(driverHids, selectHids, parentHid, localVariables, options, scope, evaluator, guardian);
            List<IHidObject> selects = ((HidAccess)operator).getSelects();
            if (selects == null || selects.isEmpty()) return useLocalValiable;
            for (IHidObject select : selects) {
                useLocalValiable |= XUtils.collectDrivers(false, selectHids, selectHids, localVariables, select, options, scope, evaluator, guardian);
            }
            return useLocalValiable;
        }
        if (!(operator instanceof IHidOperator)) return false;
        boolean useLocalValiable = XUtils.collectDrivers(false, driverHids, driverHids, localVariables, ((IHidOperator)operator).getLHValue(), options, scope, evaluator, guardian);
        ListContainer<IHidObject> rhValues = ((IHidOperator)operator).getRHValues();
        if (rhValues == null || rhValues.isEmpty()) return useLocalValiable;
        for (IHidObject rhValue : rhValues) {
            if (((IHidOperator)operator).isAssignmentPattern() && HidUtils.isOperator(rhValue) && ((IHidOperator)rhValue).getOperatorType() == IHidOperatorConstants.OperatorType.ASSOCIATION.id) {
                rhValue = ((IHidOperator)rhValue).getFirstRHValue();
            }
            useLocalValiable |= XUtils.collectDrivers(false, driverHids, driverHids, localVariables, rhValue, options, scope, evaluator, guardian);
        }
        return useLocalValiable;
    }

    private static boolean addHid(Set<IHid> driverHids, Set<IHid> selectHids, Hid hid, Set<IHid> localValiables, Set<HidFlatteningOption> options, IRfNamedElement scope, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        IRfNamedElement namedElement;
        if (localValiables.contains(hid)) {
            return true;
        }
        HidAccess parentAccess = hid.getParentAccess();
        if (parentAccess != null) {
            boolean useLocalValiable = XUtils.addHid(driverHids, selectHids, parentAccess.getParentHid(), localValiables, options, scope, evaluator, guardian);
            List<IHidObject> selects = parentAccess.getSelects();
            if (selects != null && !selects.isEmpty()) {
                for (IHidObject select : selects) {
                    useLocalValiable |= XUtils.collectDrivers(false, selectHids, selectHids, localValiables, select, options, scope, evaluator, guardian);
                }
            }
            if (useLocalValiable) {
                return true;
            }
        }
        if ((namedElement = hid.getElement()) instanceof IRfFieldElement && ((IRfFieldElement)namedElement).isGenvar()) {
            return false;
        }
        if (namedElement instanceof IRfFieldElement && ((IRfFieldElement)namedElement).isConst()) {
            return false;
        }
        if (namedElement instanceof IRfFieldElement && ((IRfFieldElement)namedElement).isEnumElement()) {
            return false;
        }
        if (namedElement instanceof IRfMethodElement && hid.hasAccesses()) {
            return false;
        }
        driverHids.add(hid);
        return false;
    }

    public static boolean isSystemFunctionOrTask(IRfMethodElement methodElement) {
        if (methodElement == null) {
            return false;
        }
        if (!methodElement.isPredefined()) {
            return false;
        }
        String methodName = methodElement.getName();
        return !methodName.isEmpty() && methodName.charAt(0) == '$';
    }

    public static String getInstancePath(IHidEvaluator evaluator) {
        if (evaluator == null) {
            return "NA.NA";
        }
        if (!(evaluator instanceof XValueHolder)) {
            return "NA.NA";
        }
        ElementPath instancePath = ((XValueHolder)evaluator).getInstancePath();
        if (instancePath == null) {
            return "NA.NA";
        }
        return instancePath.toString();
    }

    public static boolean isDesignMemberElement(Hid hid) {
        if (hid == null) {
            return false;
        }
        IRfNamedElement element = hid.getElement();
        if (element == null) {
            return XUtils.isDesignMemberElement(hid.getParentHid());
        }
        return XUtils.isDesignMemberElement(element);
    }

    public static boolean isDesignMemberElement(IRfNamedElement element) {
        IRfScopeElement enclosingScope = element.getEnclosingScope();
        if (enclosingScope instanceof IRfActionBlockElement) {
            return false;
        }
        if (enclosingScope instanceof IRfLibraryElement) {
            return true;
        }
        if (enclosingScope instanceof IRfPackageElement) {
            return true;
        }
        if (enclosingScope instanceof IRfInstanceElement) {
            return true;
        }
        if (enclosingScope instanceof IRfBlockElement) {
            return true;
        }
        if (enclosingScope instanceof IRfDesignElement) {
            return true;
        }
        if (enclosingScope instanceof IRfModportElement) {
            return true;
        }
        if (enclosingScope instanceof IRfClockingBlockElement) {
            return true;
        }
        if (enclosingScope instanceof IRfMethodElement && ((IRfMethodElement)enclosingScope).isTask()) {
            return true;
        }
        return enclosingScope instanceof IRfCompositeTypeElement && (((IRfCompositeTypeElement)enclosingScope).isStruct() || ((IRfCompositeTypeElement)enclosingScope).isUnion());
    }

    public static BigDecimal getDelay(double delay, XValueHolder evaluator) {
        if (delay == 0.0) {
            return BigDecimal.ZERO;
        }
        XGlobalCache.TimeScale timeScale = XUtils.getTimeScale(evaluator);
        BigDecimal convertedDelay = BigDecimal.valueOf(delay).multiply(timeScale.scale).setScale(0, RoundingMode.HALF_UP);
        convertedDelay = convertedDelay.multiply(timeScale.unit).divide(timeScale.scale);
        return convertedDelay;
    }

    public static XGlobalCache.TimeScale getTimeScale(XValueHolder evaluator) {
        IRfNamedElement module = evaluator.getNamedElement();
        if (module == null || module.getLanguageKind() == LanguageKind.VHDL) {
            return XGlobalCache.TimeScale.DEFAULT_TIME_SCALE;
        }
        return XUtils.getTimescaleFromElement(module);
    }

    public static XGlobalCache.TimeScale getTimescaleFromElement(IRfNamedElement designElement) {
        XGlobalCache.TimeScale timeScale = XGlobalCache.INSTANCE.getTimeScale(designElement);
        if (timeScale != null) {
            return timeScale;
        }
        HidImplicit[] timescale = designElement.getEffectiveTimescale();
        if (timescale == null) {
            return XGlobalCache.TimeScale.DEFAULT_TIME_SCALE;
        }
        int unitValue = timescale[0].evaluateTimescale();
        int precisionValue = timescale[1].evaluateTimescale();
        return XGlobalCache.INSTANCE.putTimeScale(designElement, unitValue, unitValue - precisionValue);
    }

    public static IELParamValue getOriginal(IELParamValue value, boolean inSelect) {
        XValueHolder refValueHolder;
        IELParamValue original = value.getOriginal();
        if (original instanceof ELParamValues.ParamValueNumber.PackedStructMember) {
            return XUtils.getOriginal(original, inSelect);
        }
        XSelectProxy selectProxy = value.getSelectProxy();
        if (inSelect && selectProxy != null) {
            IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelectRaw();
            return XUtils.getOriginal(valueBeforeSelect, inSelect);
        }
        if (value instanceof XValueHolder && (refValueHolder = ((XValueHolder)value).getRefValueHolder()) != null) {
            return XUtils.getOriginal(refValueHolder, inSelect);
        }
        if (original != null) {
            return XUtils.getOriginal(original, inSelect);
        }
        return value;
    }

    public static IELParamValue refValueUpdate(IELParamValue value) {
        DVTNumber dvtNumber;
        if (value == null) {
            return null;
        }
        IELParamValue original = value.getOriginal();
        if (original == null) {
            return value;
        }
        IELParamValue refValue = XUtils.refValueUpdate(original);
        if (refValue == value) {
            return value;
        }
        if (value instanceof XValueHolder) {
            return value;
        }
        DVTNumber refNumber = refValue.getDVTNumber();
        if (!refNumber.equals(dvtNumber = value.getDVTNumber())) {
            IELParamValue newValue = BitVectorContext.of(dvtNumber, null).transform(refValue);
            value.updateValue(newValue, null);
            return newValue;
        }
        return value;
    }

    public static IELParamValue getRefValue(IELParamValue value) {
        XValueHolder refValueHolder;
        if (value instanceof XValueHolder && (refValueHolder = ((XValueHolder)value).getRefValueHolder()) != null) {
            return XUtils.getRefValue(refValueHolder);
        }
        return value;
    }

    public static IHidEvaluator getEnclosingEvaluator(IHidEvaluator evaluator, Set<Class<? extends IRfNamedElement>> scopes) {
        IELParamValue enclosing;
        if (!(evaluator instanceof XValueHolder)) {
            return null;
        }
        XValueHolder scopeEvaluator = (XValueHolder)evaluator;
        do {
            IRfNamedElement scope;
            if ((scope = scopeEvaluator.getNamedElement()) instanceof IRfClassElement && scopes.contains(((IRfClassElement)scope).getGenericClass().getClass())) {
                return scopeEvaluator;
            }
            if (scope instanceof IRfSpecializedTypeElement && scopes.contains(((IRfSpecializedTypeElement)scope).getGenericElement().getClass())) {
                return scopeEvaluator;
            }
            if (scopes.contains(scope.getClass())) {
                return scopeEvaluator;
            }
            enclosing = scopeEvaluator.getEnclosingValue();
            if (enclosing instanceof XValueHolder) continue;
            return null;
        } while ((scopeEvaluator = (XValueHolder)enclosing) != null);
        return null;
    }

    public static BigInteger lcm(BigInteger a, BigInteger b) {
        BigInteger mul = a.multiply(b);
        BigInteger gcd = a.gcd(b);
        BigInteger lcm = mul.divide(gcd);
        return lcm;
    }

    public static String pad(String text, int size) {
        if (text.length() > size) {
            return text;
        }
        StringBuilder sb = new StringBuilder(text);
        int i = text.length();
        while (i < size) {
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static List<IHidObject> getLHObjects(IHidObject operator) {
        ArrayList<IHidObject> result = new ArrayList<IHidObject>();
        XUtils.getLHObjects(result, operator);
        return result;
    }

    private static void getLHObjects(List<IHidObject> result, IHidObject operator) {
        if (HidUtils.isHidImplicit(operator)) {
            return;
        }
        if (operator instanceof HidEvalCenter.DelayedContinuousAssign) {
            XUtils.getLHObjects(result, ((HidEvalCenter.DelayedContinuousAssign)operator).getAssignOperator());
            return;
        }
        boolean isAssignmentPattern = operator instanceof HidOperator && ((HidOperator)operator).isAssignmentPattern();
        Predicate<IHidObject> predicate = hidObject -> {
            if (isAssignmentPattern && HidUtils.isOperator(hidObject) && ((HidOperator)hidObject).isAssociation()) {
                XUtils.getLHObjects(result, ((HidOperator)hidObject).getFirstRHValue());
                return false;
            }
            if (HidUtils.isHid(hidObject) || HidUtils.isHidAccess(hidObject) || hidObject instanceof XInstValueHolder.XSelectOperator) {
                result.add((IHidObject)hidObject);
                return false;
            }
            return true;
        };
        HidUtils.flattenToObjects(predicate, operator, LHS_HID_FLATTENING);
    }

    public static IELParamValue getValue(ELParamValueScope valueScope) {
        return valueScope == null ? null : valueScope.value;
    }

    public static IHidEvaluator getScope(ELParamValueScope valueScope) {
        return valueScope == null ? null : valueScope.scope;
    }

    public static IRfNamedElement getElement(ELParamValueScope valueScope) {
        return valueScope == null ? null : XUtils.getElement(valueScope.value);
    }

    public static IRfNamedElement getElement(IELParamValue value) {
        return value == null ? null : value.getElement();
    }

    public static String getElementName(ELParamValueScope valueScope) {
        return valueScope == null ? null : valueScope.getElementName();
    }

    public static IHidObject getHidObject(ELParamValueScope valueScope) {
        return valueScope == null ? null : valueScope.getHidObject();
    }

    public static boolean isUnconnected(IHidObject signalOperator) {
        if (signalOperator == null) {
            return true;
        }
        if (HidUtils.isHidImplicit(signalOperator) && ((IHidImplicit)signalOperator).isUnconnectedAssociation()) {
            return true;
        }
        return HidUtils.isHidImplicit(signalOperator) && "open".equalsIgnoreCase(((HidImplicit)signalOperator).getName());
    }

    public static boolean isEventControl(IHidObject hidObject) {
        if (!(hidObject instanceof HidOperator)) {
            return false;
        }
        return ((HidOperator)hidObject).isVlogEventControl() || ((HidOperator)hidObject).isVhdlEventControl();
    }

    public static boolean isClockResetEventControl(IHidObject hidObject, IHidEvaluationGuardian guardian) {
        if (!XUtils.isEventControl(hidObject)) {
            return false;
        }
        List<IHidOperator.XEventControl> eventControls = ((HidOperator)hidObject).xEventControls(guardian);
        if (eventControls == null || eventControls.isEmpty()) {
            return false;
        }
        for (IHidOperator.XEventControl eventControl : eventControls) {
            if (eventControl.eventKind == IHidOperator.XEventControlKind.POSEDGE || eventControl.eventKind == IHidOperator.XEventControlKind.NEGEDGE) continue;
            return false;
        }
        return true;
    }

    public static boolean hasDelayBlockingStatement(ListContainer<IHidObject> statements) {
        if (statements == null || statements.isEmpty()) {
            return false;
        }
        for (IHidObject statement : statements) {
            if (statement instanceof HidOperator && ((HidOperator)statement).hasOccurrence(HidOperatorQualifier.IS_ALWAYS_SENSITIVITY_LIST) || statement instanceof HidOperator && ((HidOperator)statement).isNBAssignment()) continue;
            if (statement instanceof HidEvalCenter.ForkJoinStatement) {
                return true;
            }
            if (statement instanceof HidEvalCenter.EventControlledAssignment) {
                return true;
            }
            if (statement instanceof HidEvalCenter.EventControlledTriggerEvent) {
                return true;
            }
            if (statement instanceof HidEvalCenter.DelayedTriggerEvent) {
                return true;
            }
            if (statement instanceof HidOperator && ((HidOperator)statement).hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) {
                return true;
            }
            if (statement instanceof HidOperator && ((HidOperator)statement).hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL)) {
                return true;
            }
            if (statement instanceof HidEvalCenter.ConcurrentAssertStatement) {
                return true;
            }
            if (statement instanceof HidEvalCenter.BlockStatement var3_3) {
                if (blockStatement instanceof HidEvalCenter.ForLoopStatement var5_5) {
                    IHidObject condition = forLoopStatement.getCondition();
                    if (condition != null && XUtils.hasDelayBlockingStatement(condition)) {
                        return true;
                    }
                    IHidObject step = forLoopStatement.getStep();
                    if (step != null && XUtils.hasDelayBlockingStatement(step)) {
                        return true;
                    }
                }
                if (XUtils.hasDelayBlockingStatement(blockStatement.getRHValues())) {
                    return true;
                }
            }
            if (!XUtils.hasTaskOrFunctionCalls(statement)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasTaskOrFunctionCalls(IHidObject object) {
        void var2_1;
        HidEvalCenter.ForLoopStatement forLoopStatement;
        if (object instanceof IHidAccessArgs) {
            return true;
        }
        if (object instanceof HidEvalCenter.MethodCallPlaceholder) {
            return true;
        }
        IHidObject iHidObject = object;
        if (iHidObject instanceof HidEvalCenter.ForLoopStatement && (forLoopStatement = (HidEvalCenter.ForLoopStatement)iHidObject) == (HidEvalCenter.ForLoopStatement)var2_1) {
            void statement;
            IHidObject condition = statement.getCondition();
            if (condition != null && XUtils.hasTaskOrFunctionCalls(condition)) {
                return true;
            }
            IHidObject step = statement.getStep();
            if (step != null && XUtils.hasTaskOrFunctionCalls(step)) {
                return true;
            }
        }
        if (object instanceof HidOperator) {
            if (XUtils.hasTaskOrFunctionCalls(((HidOperator)object).getLHValue())) {
                return true;
            }
            if (((HidOperator)object).hasRHValues()) {
                for (IHidObject hidObject : ((HidOperator)object).getRHValues()) {
                    if (!XUtils.hasTaskOrFunctionCalls(hidObject)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void start(IRfNamedElement methodElement) {
        if (!DVT_DEBUG_MODE) {
            return;
        }
        if (methodElement instanceof IRfMethodElement && ((IRfMethodElement)methodElement).isTask()) {
            return;
        }
        String counterName = methodElement.getName();
        IRfScopeElement enclosingScope = methodElement.getEnclosingScope();
        if (enclosingScope != null) {
            counterName = DVTStringUtil.appendString(enclosingScope.getName(), ".", counterName);
        }
        statisticStartTimeMap.put(counterName, System.nanoTime());
    }

    public static void end(boolean statisticOn, IRfNamedElement methodElement) {
        if (!DVT_DEBUG_MODE) {
            return;
        }
        if (!statisticOn) {
            return;
        }
        if (methodElement instanceof IRfMethodElement && ((IRfMethodElement)methodElement).isTask()) {
            return;
        }
        String counterName = methodElement.getName();
        IRfScopeElement enclosingScope = methodElement.getEnclosingScope();
        if (enclosingScope != null) {
            counterName = DVTStringUtil.appendString(enclosingScope.getName(), ".", counterName);
        }
        XUtils.increment(statisticCounters, counterName, 0);
        Long startTime = statisticStartTimeMap.get(counterName);
        if (startTime == null) {
            return;
        }
        long time = System.nanoTime() - startTime;
        Long spentTime = statisticTimeCounters.get(counterName);
        if (spentTime == null) {
            statisticTimeCounters.put(counterName, time);
        } else {
            statisticTimeCounters.put(counterName, spentTime + time);
        }
    }

    public static void increment(String counterName) {
        if (!DVT_DEBUG_MODE) {
            return;
        }
        XUtils.increment(statisticCounters, counterName, 0);
    }

    public static void printDebug(String message) {
        if (!DVT_DEBUG_MODE) {
            return;
        }
        TestHelperCommon.out.println(message);
    }

    public static void inlineIncrement(String counterName) {
        if (!DVT_DEBUG_MODE) {
            return;
        }
        XUtils.increment(inlineStatisticCounters, counterName, 0);
    }

    private static void increment(Map<String, Integer> countersMap, String counterName, int index) {
        Integer count;
        if (index != 0) {
            counterName = DVTStringUtil.appendString(counterName, "_", index);
        }
        if ((count = countersMap.get(counterName)) == null) {
            countersMap.put(counterName, 1);
            return;
        }
        if (count == Integer.MAX_VALUE) {
            XUtils.increment(countersMap, counterName, index + 1);
            return;
        }
        countersMap.put(counterName, count + 1);
    }

    public static void printStatistic(PrintStream out) {
        if (!DVT_DEBUG_MODE) {
            return;
        }
        if (!statisticCounters.isEmpty()) {
            boolean bl;
            boolean bl2 = false;
            for (Map.Entry<String, Integer> statisticCounter : statisticCounters.entrySet()) {
                if (statisticTimeCounters.containsKey(statisticCounter.getKey())) continue;
                if (!bl) {
                    out.println("-----------------------------------------------------------");
                    bl = true;
                }
                out.println(String.valueOf((String)statisticCounter.getKey()) + " = " + statisticCounter.getValue());
            }
            if (bl) {
                out.println("-----------------------------------------------------------");
            }
        }
        if (!inlineStatisticCounters.isEmpty()) {
            out.println("|-------------------------------------------------------------------|");
            out.println("|                         Inline Statistics                         |");
            out.println("|-------------------------------------------------------------------|");
            for (Map.Entry entry : inlineStatisticCounters.entrySet()) {
                out.println("| " + XUtils.padRight((String)entry.getKey(), 52) + " | " + XUtils.padLeft("" + entry.getValue(), 10) + " |");
            }
            out.println("|-------------------------------------------------------------------|");
        }
        if (!statisticTimeCounters.isEmpty()) {
            long time;
            Integer hits;
            ArrayList<Map.Entry<String, Long>> arrayList = new ArrayList<Map.Entry<String, Long>>(statisticTimeCounters.entrySet());
            arrayList.sort(Map.Entry.comparingByValue());
            Collections.reverse(arrayList);
            int maxNameLength = 3;
            int maxHitsLength = 3;
            int maxTimeLength = 3;
            int count = 0;
            for (Map.Entry entry : arrayList) {
                hits = statisticCounters.get(entry.getKey());
                time = (Long)entry.getValue() / 1000000L;
                if (time <= 500L || count == 30) break;
                ++count;
                maxNameLength = Math.max(maxNameLength, ((String)entry.getKey()).length());
                maxHitsLength = Math.max(maxHitsLength, ("" + hits).length());
                maxTimeLength = Math.max(maxTimeLength, ("" + time).length());
            }
            out.println();
            out.println("|" + XUtils.fill(maxNameLength + maxHitsLength + maxTimeLength + 14, '-') + "|");
            out.println("| " + XUtils.padRight("METHOD NAME", maxNameLength + 2) + "|" + XUtils.padLeft("HITS", maxHitsLength + 2) + " |" + XUtils.padLeft("TIME", maxTimeLength + 2) + "    |");
            out.println("|" + XUtils.fill(maxNameLength + maxHitsLength + maxTimeLength + 14, '-') + "|");
            count = 0;
            for (Map.Entry entry : arrayList) {
                hits = statisticCounters.get(entry.getKey());
                time = (Long)entry.getValue() / 1000000L;
                if (time <= 500L || count == 30) break;
                ++count;
                out.println("| " + XUtils.padRight((String)entry.getKey(), maxNameLength + 2) + "|" + XUtils.padLeft("" + hits, maxHitsLength + 2) + " |" + XUtils.padLeft("" + time, maxTimeLength + 2) + " ms |");
            }
            out.println("|" + XUtils.fill(maxNameLength + maxHitsLength + maxTimeLength + 14, '-') + "|");
        }
    }

    private static String fill(int length, char ch) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < length) {
            result.append(ch);
            ++i;
        }
        return result.toString();
    }

    private static String padLeft(String text, int length) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < length - text.length()) {
            result.append(" ");
            ++i;
        }
        result.append(text);
        return result.toString();
    }

    private static String padRight(String text, int length) {
        StringBuilder result = new StringBuilder();
        result.append(text);
        int i = 0;
        while (i < length - text.length()) {
            result.append(" ");
            ++i;
        }
        return result.toString();
    }

    public static boolean hasLocalMembers(IRfNamedElement blockNamedElement) {
        boolean hasLocalMembers = blockNamedElement.hasLocalMembers();
        if (!hasLocalMembers) {
            return false;
        }
        Collection<? extends IRfNamedElement> localMembers = blockNamedElement.xGetLocalMembers();
        for (IRfNamedElement iRfNamedElement : localMembers) {
            if (iRfNamedElement.isAnonymous()) continue;
            return true;
        }
        return false;
    }

    public static <K, V> Map.Entry<K, V> getFirstEntry(Map<K, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        return map.entrySet().iterator().next();
    }

    public static IHidObject getArgHidObject(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> argValues, String argName) {
        HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = argValues.get(argName);
        if (argumentInfo == null) {
            return null;
        }
        return argumentInfo.argHidObject;
    }

    public static IELParamValue getArgValue(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> argValues, String argName) {
        HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = argValues.get(argName);
        if (argumentInfo == null) {
            return null;
        }
        return XUtils.getValue(argumentInfo.argValueScope);
    }

    public static IELParamValue getMethodValue(IHid hid, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        ELParamValueScope methodValue = evaluator.getValue(hid, null, null, true, guardian.copy());
        if (ELUtils.isUnsuccessfulEval(methodValue)) {
            return null;
        }
        return XUtils.getValue(methodValue);
    }

    public static int getStatementIndex(ListContainer<IHidObject> statements, int nofStatements) {
        int size = statements.size();
        int i = 0;
        while (i < size) {
            IHidObject statement = statements.get(i);
            if (!(statement instanceof HidEvalCenter.DeclarationStatement)) {
                return size >= i + nofStatements ? i : -1;
            }
            ++i;
        }
        return -1;
    }

    public static void setPathAndLine(IXSim xSim, IRfNamedElement namedElement) {
        IRfDefElement declaration = namedElement.getDeclaration();
        ParserPath parserPath = declaration == null ? null : declaration.getParserPath();
        int startLineNumber = declaration == null ? -1 : declaration.getStartLine();
        xSim.setCurrentParserPath(parserPath);
        xSim.setCurrentLineNumber(startLineNumber);
    }

    public static boolean isSameType(ELParamValues.ParamValueNumber value1, ELParamValues.ParamValueNumber value2) {
        DVTNumber number1 = value1.getDVTNumber();
        DVTNumber number2 = value2.getDVTNumber();
        if (number1 == null || number2 == null) {
            return false;
        }
        if (number1.hasSign() != number2.hasSign()) {
            return false;
        }
        if (number1.getSize() != number2.getSize()) {
            return false;
        }
        if (number1.is4State() != number2.is4State()) {
            return false;
        }
        if (number1.isString() != number2.isString()) {
            return false;
        }
        if (number1.isStruct(false) != number2.isStruct(false)) {
            return false;
        }
        if (number1.isUnion() != number2.isUnion()) {
            return false;
        }
        return Arrays.equals(number1.getPacked(), number2.getPacked());
    }

    public static boolean isGenerateBlockInstance(IHidEvaluator evaluator) {
        return evaluator instanceof XInstValueHolder && evaluator.getNamedElement() instanceof IRfBlockElement;
    }

    public static void sortAssignments(List<? extends HidOperator> operatorsList) {
        if (operatorsList == null || operatorsList.isEmpty()) {
            return;
        }
        Collections.sort(operatorsList, new Comparator<HidOperator>(){

            @Override
            public int compare(HidOperator op1, HidOperator op2) {
                IHidObject rhs2;
                boolean isOutputPortConnection1 = this.isOutputPortConnection(op1);
                boolean isOutputPortConnection2 = this.isOutputPortConnection(op2);
                IHidObject lhs1 = isOutputPortConnection1 ? op1.getFirstRHValue() : op1.getLHValue();
                IHidObject rhs1 = isOutputPortConnection1 ? op1.getLHValue() : op1.getFirstRHValue();
                IHidObject lhs2 = isOutputPortConnection2 ? op2.getFirstRHValue() : op2.getLHValue();
                IHidObject iHidObject = rhs2 = isOutputPortConnection2 ? op2.getLHValue() : op2.getFirstRHValue();
                if (lhs1.equals(rhs2)) {
                    return -1;
                }
                if (lhs2.equals(rhs1)) {
                    return 1;
                }
                return 0;
            }

            private boolean isOutputPortConnection(HidOperator op) {
                boolean isPortConnection = op.hasQualifier(HidQualifierCache.IS_PORT_CONNECTION_QUALIFIER);
                boolean isPortExpression = op.hasQualifier(HidQualifierCache.IS_PORT_EXPRESSION_QUALIFIER);
                if (isPortConnection || isPortExpression) {
                    boolean isLHSInoutDriver = op.hasQualifier(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER);
                    IHid lhValue = (IHid)op.getLHValue();
                    IHidObject firstRHValue = op.getFirstRHValue();
                    return isPortConnection && XUtils.isOutputPort(lhValue, firstRHValue) || isPortExpression && XUtils.isInputPort(lhValue, firstRHValue) || isLHSInoutDriver && XUtils.isInoutPort(lhValue, firstRHValue);
                }
                return false;
            }
        });
    }

    public static boolean isBBox(IELParamValue value) {
        if (value == null) {
            return false;
        }
        return value.isBBox();
    }

    public static boolean isBBox(ELParamValueScope value) {
        if (value == null) {
            return false;
        }
        return XUtils.isBBox(value.value);
    }

    public static void incrementNofInstancesTotal() {
        ++nofInstancesTotal;
    }

    public static void incrementNofInstancesUsed() {
        ++nofInstancesUsed;
    }

    public static String getNofInstances() {
        return String.valueOf(Integer.toString(nofInstancesUsed)) + "/" + Integer.toString(nofInstancesTotal);
    }

    public static boolean isClassScope(IHidEvaluator scope) {
        if (scope == null) {
            return false;
        }
        if (scope instanceof XInstValueHolder) {
            return false;
        }
        if (scope instanceof XMethodValueHolder) {
            return false;
        }
        return XValueHolderFactory.xIsClass(scope.getNamedElement());
    }

    public static String dot(String message) {
        if (message.isEmpty()) {
            return "";
        }
        char ch = message.charAt(message.length() - 1);
        return ch == '.' || ch == '!' ? "" : ".";
    }

    public static boolean isInstanceRef(XValueHolder valueHolder) {
        if (valueHolder == null) {
            return false;
        }
        if (valueHolder instanceof XInstValueHolder) {
            return true;
        }
        IRfNamedElement namedElement = valueHolder.getNamedElement();
        return namedElement instanceof IRfModportElement || namedElement instanceof IRfClockingBlockElement;
    }

    public static LastExecutedStatementInfo computeLastExecutedStatementOnActiveThreadBeforeFail(IntrpDebugTarget debugTarget) {
        if (debugTarget == null) {
            return null;
        }
        IntrpDebugThread activeThread = debugTarget.getActiveThread();
        if (activeThread == null) {
            return null;
        }
        XThread xThread = activeThread.getXThread();
        if (xThread == null) {
            return null;
        }
        IStackFrame topStackFrame = xThread.getTopStackFrame();
        if (!(topStackFrame instanceof IntrpStackFrame)) {
            return null;
        }
        IntrpStackFrame intrpStackFrame = (IntrpStackFrame)topStackFrame;
        ParserPath parserPath = intrpStackFrame.getParserPath();
        String parserPathString = parserPath.toString();
        return new LastExecutedStatementInfo(parserPathString, String.valueOf(intrpStackFrame.currLine));
    }

    public static LastExecutedStatementInfo computeLastExecutedStatementNoActiveThreadBeforeFail(IntrpDebugTarget debugTarget) {
        List<XThread> threads = debugTarget.getThreadsDuringTerminate();
        for (XThread thread : threads) {
            XEvalScope firstEvalScope = thread.getFirstEvalScope();
            if (!(firstEvalScope instanceof XSeqBlockEvalScope)) continue;
            IHidOccurrenceHolder firstDelayControl = null;
            boolean foundRunTest = false;
            ListContainer<IHidObject> statements = ((XSeqBlockEvalScope)firstEvalScope).getStatements();
            if (statements == null || statements.isEmpty()) continue;
            for (IHidObject statement : statements) {
                IHidOperator iHidOperator;
                foundRunTest = XUtils.isRunTest(statement);
                if (foundRunTest) break;
                if (!(statement instanceof IHidOperator) || firstDelayControl != null || !(iHidOperator = (IHidOperator)statement).hasOccurrence(HidOperatorQualifier.IS_DELAY_CONTROL) && !iHidOperator.hasOccurrence(HidOperatorQualifier.IS_EVENT_CONTROL)) continue;
                firstDelayControl = iHidOperator;
            }
            if (!foundRunTest || firstDelayControl == null) continue;
            ParserPath parserPath = thread.getParserPath();
            int line = firstDelayControl.getLine();
            return new LastExecutedStatementInfo(parserPath.toString(), String.valueOf(line));
        }
        return null;
    }

    private static boolean isRunTest(IHidObject statement) {
        if (!(statement instanceof HidEvalCenter.MethodCallPlaceholder)) {
            return false;
        }
        HidEvalCenter.MethodCallPlaceholder methodCallPlaceholder = (HidEvalCenter.MethodCallPlaceholder)statement;
        IHidObject hidOrAccess = methodCallPlaceholder.getHidOrAccess();
        if (hidOrAccess == null) {
            return false;
        }
        String hidOrAccessString = HidUtils.toNiceString(hidOrAccess);
        return RUN_TEST_METHOD_CALL.equals(hidOrAccessString);
    }

    public static boolean isInoutOpositeDriver(IHidOperator operator1, IHidOperator operator2) {
        boolean qualifier2;
        boolean isInoutPortConnection;
        if (operator1 == null || operator2 == null) {
            return false;
        }
        boolean isPortConnection1 = XUtils.isPortConnection(operator1);
        boolean isPortConnection2 = XUtils.isPortConnection(operator2);
        if (!isPortConnection1 || !isPortConnection2) {
            return false;
        }
        boolean bl = isInoutPortConnection = HidUtils.isHid(operator1.getLHValue()) && XUtils.isInoutPort((IHid)operator1.getLHValue(), operator1.getFirstRHValue());
        if (!isInoutPortConnection) {
            return false;
        }
        boolean qualifier1 = operator1.hasOccurrence(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER);
        return qualifier1 ^ (qualifier2 = operator2.hasOccurrence(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER)) && operator1.getLHValue() == operator2.getLHValue() && operator1.getFirstRHValue() == operator2.getFirstRHValue();
    }

    public static ParserPath getParserPath(IRfNamedElement namedElement, ParserPath defaultParserPath) {
        ParserPath parserPath;
        if (namedElement == null) {
            return defaultParserPath;
        }
        if (namedElement.isPredefined()) {
            return defaultParserPath;
        }
        IRfDefElement declaration = namedElement.getDeclaration();
        ParserPath parserPath2 = parserPath = declaration == null ? defaultParserPath : declaration.getParserPath();
        if (parserPath != null) {
            return parserPath;
        }
        return defaultParserPath;
    }

    public static <T> T last(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> T last(ListContainer<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static <T> ListContainer<T> reverse(ListContainer<T> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayListContainer newList = new ArrayListContainer(list.size());
        newList.addAll((ArrayListContainer)list);
        Collections.reverse(newList);
        return newList;
    }

    public static IHidObject selectMinTypMax(IHidObject delayHidObject, MinTypMax minTypMax) {
        if (HidUtils.isOperator(delayHidObject) && ((HidOperator)delayHidObject).isMinTypMax()) {
            HidOperator delayOperator = (HidOperator)delayHidObject;
            return minTypMax == MinTypMax.MIN ? delayOperator.getLHValue() : (minTypMax == MinTypMax.TYP ? delayOperator.getRHValues().get(1) : delayOperator.getRHValues().get(0));
        }
        return delayHidObject;
    }

    public static TransitionKind getTransitionKind(IELParamValue rhValue) {
        BigInteger rhValueInt = rhValue.getDVTNumber().bigIntegerValue();
        if (!rhValueInt.testBit(0) && !rhValue.isAmbiguous()) {
            return TransitionKind.FALLING;
        }
        BitSet rhValueZ = rhValue.getDVTNumber().getMask(MaskType.Z);
        if (rhValueZ != null && rhValueZ.get(0)) {
            return TransitionKind.TURN_OFF;
        }
        BitSet rhValueX = rhValue.getDVTNumber().getMask(MaskType.X);
        if (rhValueX != null && rhValueX.get(0)) {
            return TransitionKind.MINIMUM;
        }
        return TransitionKind.RISING;
    }

    public static boolean isRisingFallingDelay(HidOperator delayOperator) {
        if (!delayOperator.hasQualifier(HidQualifierCache.IS_DELAY_CONTROL_QUALIFIER)) {
            return false;
        }
        IHidObject lhValue = delayOperator.getLHValue();
        if (!HidUtils.isOperator(lhValue)) {
            return false;
        }
        return ((HidOperator)lhValue).isComma();
    }

    public static boolean isIgnoreInitialBlock(IRfActionBlockElement initialActionBlock, IELMemory elMemory, ELInstance elInstance, TreeMap<ElementPath, String> runtimeElabPaths, List<ElementPath> bboxPaths) {
        IRfScopeElement enclosingModule = initialActionBlock.getEnclosingScope();
        AtomicBoolean result = new AtomicBoolean(true);
        InitialBlockVisitor functionCallsVisitor = new InitialBlockVisitor(result, enclosingModule, elMemory, elInstance, new LinkedHashSet<ElementPath>(), new HashSet<IHid>());
        initialActionBlock.visitHidObject(null, functionCallsVisitor);
        boolean isIgnore = result.get();
        if (isIgnore) {
            return true;
        }
        for (ElementPath elementPath : functionCallsVisitor.elementPaths) {
            XUtils.addRuntimeElabPath(runtimeElabPaths, elementPath, bboxPaths, "hierarchical_id");
        }
        return false;
    }

    public static void addRuntimeElabPath(TreeMap<ElementPath, String> runtimeElabPaths, ElementPath path, List<ElementPath> bboxPaths, String cause) {
        ElementPath parentPath = path;
        block0: while (parentPath != null && !parentPath.isEmpty() && !runtimeElabPaths.containsKey(parentPath)) {
            if (bboxPaths != null && !bboxPaths.isEmpty()) {
                for (ElementPath bboxPath : bboxPaths) {
                    if (!bboxPath.isPrefixOf(parentPath)) continue;
                    parentPath = parentPath.removeLastSegment();
                    continue block0;
                }
            }
            runtimeElabPaths.put(parentPath, cause);
            parentPath = parentPath.removeLastSegment();
        }
    }

    public static boolean isNullArgument(String argumentName, Map<IRfFieldElement, IHidObject> argumentValues) {
        for (Map.Entry<IRfFieldElement, IHidObject> argumentValueEntry : argumentValues.entrySet()) {
            IRfFieldElement argument = argumentValueEntry.getKey();
            if (!argumentName.equals(argument.getName())) continue;
            IHidObject hidObject = argumentValueEntry.getValue();
            return HidUtils.isHidImplicit(hidObject) && ((HidImplicit)hidObject).isLiteralNull();
        }
        return false;
    }

    public static void collectSensitivityAllDrivers(IHidObject hidObject, Set<IHid> forLoopVariables, Set<IHidObject> loads, Set<IHidObject> drivers) {
        if (hidObject instanceof HidEvalCenter.MethodCallPlaceholder) {
            hidObject = ((HidEvalCenter.MethodCallPlaceholder)hidObject).getHidOrAccess();
        }
        if (HidUtils.isOperator(hidObject) && ((HidOperator)hidObject).isComplete()) {
            IHidObject lhValue;
            HidOperator operator = (HidOperator)hidObject;
            if (operator.isWaitEventControl()) {
                return;
            }
            if (operator.isForInit() && HidUtils.isOperator(lhValue = operator.getLHValue())) {
                operator = (HidOperator)lhValue;
            }
            boolean isDeclarationAssign = operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN);
            boolean isBlockingAssign = operator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN);
            boolean isContinuousAssign = operator.hasOccurrence(HidOperatorQualifier.IS_CONTINUOUS_ASSIGN);
            boolean isNonblockingAssign = operator.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN);
            boolean isAlias = operator.hasOccurrence(HidOperatorQualifier.IS_ALIAS);
            boolean isForCondition = operator.isForCondition();
            boolean isForStep = operator.isForStep();
            IHidObject lhValue2 = operator.getLHValue();
            ListContainer<IHidObject> rhValues = operator.getRHValues();
            if (lhValue2 == null) {
                throw new UnsupportedOperationException();
            }
            if (isDeclarationAssign) {
                XUtils.addDrivers(drivers, rhValues);
            } else if (isBlockingAssign || isNonblockingAssign || isContinuousAssign || isAlias) {
                loads.add(lhValue2);
                XUtils.addDrivers(drivers, rhValues);
            } else if (isForCondition && lhValue2 instanceof HidOperator) {
                XUtils.addDrivers(drivers, ((HidOperator)lhValue2).getRHValues());
            } else if (isForStep && lhValue2 instanceof HidOperator) {
                forLoopVariables.addAll(((HidOperator)lhValue2).getLHHids(LHS_HID_FLATTENING));
                XUtils.addDrivers(drivers, ((HidOperator)lhValue2).getRHValues());
            } else {
                XUtils.addDrivers(drivers, lhValue2);
                XUtils.addDrivers(drivers, rhValues);
            }
        } else if (HidUtils.isHidAccess(hidObject) && ((HidAccess)hidObject).getParentHid().hasOccurrence(HidQualifier.HID_IS_STATEMENT)) {
            XUtils.addDrivers(drivers, hidObject);
        } else if (HidUtils.isHid(hidObject) && ((Hid)hidObject).hasOccurrence(HidQualifier.HID_IS_STATEMENT)) {
            XUtils.addDrivers(drivers, hidObject);
        }
    }

    public static void addDrivers(Set<IHidObject> drivers, ListContainer<IHidObject> hidObjects) {
        if (hidObjects == null) {
            return;
        }
        for (IHidObject hidObject : hidObjects) {
            if (HidUtils.isOperator(hidObject) && ((HidOperator)hidObject).isTickCast()) {
                hidObject = ((HidOperator)hidObject).getFirstRHValue();
            }
            if (hidObject == null || HidUtils.isHidImplicit(hidObject) || HidUtils.isHid(hidObject) && !XUtils.isSensitivityRelevant((Hid)hidObject)) continue;
            if (HidUtils.isHidAccess(hidObject) && !XUtils.isSensitivityRelevant(((HidAccess)hidObject).getParentHid())) {
                List<IHidObject> selects = ((HidAccess)hidObject).getSelects();
                if (selects == null || selects.isEmpty()) continue;
                for (IHidObject select : selects) {
                    XUtils.addDrivers(drivers, select);
                }
                continue;
            }
            if (HidUtils.isOperator(hidObject)) {
                XUtils.addDrivers(drivers, ((HidOperator)hidObject).getLHValue());
                ListContainer<IHidObject> rhValues = ((HidOperator)hidObject).getRHValues();
                if (rhValues == null || rhValues.isEmpty()) continue;
                for (IHidObject rhValue : rhValues) {
                    if (((IHidOperator)hidObject).isAssignmentPattern() && HidUtils.isOperator(rhValue) && ((IHidOperator)rhValue).getOperatorType() == IHidOperatorConstants.OperatorType.ASSOCIATION.id) {
                        rhValue = ((IHidOperator)rhValue).getFirstRHValue();
                    }
                    XUtils.addDrivers(drivers, rhValue);
                }
                continue;
            }
            drivers.add(hidObject);
        }
    }

    public static boolean isSensitivityRelevant(Hid hid) {
        IRfNamedElement namedElement = hid.getElement();
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof IRfFieldElement && ((IRfFieldElement)namedElement).isAnyParameter()) {
            return false;
        }
        if (namedElement instanceof IRfFieldElement && ((IRfFieldElement)namedElement).isConst()) {
            return false;
        }
        if (namedElement instanceof IRfFieldElement && ((IRfFieldElement)namedElement).isEnumElement()) {
            return false;
        }
        if (hid.getParentHid() == null && namedElement.getEnclosingScope() instanceof IRfMethodElement) {
            return false;
        }
        if (hid.getParentHid() == null && namedElement.getEnclosingScope() instanceof IRfActionBlockElement) {
            return false;
        }
        if (hid.getParentHid() != null) {
            return XUtils.isSensitivityRelevant(hid.getParentHid());
        }
        return true;
    }

    public static void filterNonField(Set<IHidObject> drivers) {
        IHidObject[] driversCopy = drivers.toArray(new IHidObject[drivers.size()]);
        drivers.clear();
        IHidObject[] iHidObjectArray = driversCopy;
        int n = driversCopy.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Hid hid;
                IHidObject hidObject;
                block7: {
                    block6: {
                        hidObject = iHidObjectArray[n2];
                        if (!HidUtils.isHid(hidObject)) break block6;
                        hid = (Hid)hidObject;
                        break block7;
                    }
                    if (!HidUtils.isHidAccess(hidObject)) break block8;
                    hid = ((HidAccess)hidObject).getParentHid();
                    List<IHidObject> selects = ((HidAccess)hidObject).getSelects();
                    if (selects == null || selects.isEmpty()) {
                        hidObject = hid;
                    }
                }
                if (hid.getElement() instanceof IRfFieldElement) {
                    drivers.add(hidObject);
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void collectSelects(Set<IHidObject> result, ListContainer<IHidObject> hidObjects) {
        if (hidObjects == null) {
            return;
        }
        for (IHidObject hidObject : hidObjects) {
            if (hidObject == null || HidUtils.isHidImplicit(hidObject)) continue;
            if (HidUtils.isOperator(hidObject)) {
                XUtils.collectSelects(result, ((HidOperator)hidObject).getLHValue());
                ListContainer<IHidObject> rhValues = ((HidOperator)hidObject).getRHValues();
                if (rhValues == null || rhValues.isEmpty()) continue;
                for (IHidObject iHidObject : rhValues) {
                    void var5_8;
                    if (((IHidOperator)hidObject).isAssignmentPattern() && HidUtils.isOperator(iHidObject) && ((IHidOperator)iHidObject).getOperatorType() == IHidOperatorConstants.OperatorType.ASSOCIATION.id) {
                        IHidObject iHidObject2 = ((IHidOperator)iHidObject).getFirstRHValue();
                    }
                    XUtils.collectSelects(result, (ListContainer<IHidObject>)var5_8);
                }
                continue;
            }
            if (HidUtils.isHidAccessArgs(hidObject)) {
                Hid hid;
                List<? extends IHidObject> argHidObjects = ((IHidAccessArgs)((Object)hidObject)).getArgumentValues();
                if (argHidObjects != null && !argHidObjects.isEmpty()) {
                    for (IHidObject iHidObject : argHidObjects) {
                        XUtils.collectSelects(result, iHidObject);
                    }
                }
                if ((hid = ((HidAccess)hidObject).getParentHid()) == null) continue;
                XUtils.collectSelects(result, hid.getParentAccess());
                continue;
            }
            if (HidUtils.isHidAccess(hidObject)) {
                Hid hid;
                ListContainer<IHidObject> selectsContainer = ((HidAccess)hidObject).getSelectsContainer();
                if (selectsContainer != null && !selectsContainer.isEmpty()) {
                    for (IHidObject iHidObject : selectsContainer) {
                        XUtils.addDrivers(result, iHidObject);
                    }
                }
                if ((hid = ((HidAccess)hidObject).getParentHid()) == null) continue;
                XUtils.collectSelects(result, hid.getParentAccess());
                continue;
            }
            if (!HidUtils.isHid(hidObject)) continue;
            XUtils.collectSelects(result, ((Hid)hidObject).getParentAccess());
        }
    }

    public static IELParamValue transform(BitVectorContext context, IELParamValue value) {
        if (context == null || context.getContextNumber() == null) {
            return value;
        }
        if (value instanceof XArrayValueHolder) {
            return value;
        }
        if (value instanceof XValueHolder && value.isStruct(true)) {
            return value;
        }
        boolean isSignedContext = context.getContextNumber().hasSign();
        if (isSignedContext) {
            return value;
        }
        DVTNumber dvtNumber = value.getDVTNumber();
        if (dvtNumber instanceof VlogBitVector && dvtNumber.hasSign()) {
            return ELParamValues.ParamValueNumber.of(((VlogBitVector)dvtNumber).signedToUnsigned());
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClockingInputPort(IHidObject rhValue) {
        void port;
        void var3_2;
        IRfPortElement iRfPortElement;
        if (!(rhValue instanceof Hid)) {
            return false;
        }
        IRfNamedElement element = ((Hid)rhValue).getElement();
        IRfNamedElement iRfNamedElement = element;
        if (iRfNamedElement instanceof IRfPortElement && (iRfPortElement = (IRfPortElement)iRfNamedElement) == (IRfPortElement)var3_2 && port.isInput()) {
            return element.getEnclosingScope() instanceof IRfClockingBlockElement;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClockingInoutPort(IHidObject rhValue) {
        void port;
        void var3_2;
        IRfPortElement iRfPortElement;
        if (!(rhValue instanceof Hid)) {
            return false;
        }
        IRfNamedElement element = ((Hid)rhValue).getElement();
        IRfNamedElement iRfNamedElement = element;
        if (iRfNamedElement instanceof IRfPortElement && (iRfPortElement = (IRfPortElement)iRfNamedElement) == (IRfPortElement)var3_2 && port.isInout()) {
            return element.getEnclosingScope() instanceof IRfClockingBlockElement;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isClockingOutputPort(IHidObject rhValue) {
        void port;
        void var3_2;
        IRfPortElement iRfPortElement;
        if (!(rhValue instanceof Hid)) {
            return false;
        }
        IRfNamedElement element = ((Hid)rhValue).getElement();
        IRfNamedElement iRfNamedElement = element;
        if (iRfNamedElement instanceof IRfPortElement && (iRfPortElement = (IRfPortElement)iRfNamedElement) == (IRfPortElement)var3_2 && port.isOutput()) {
            return element.getEnclosingScope() instanceof IRfClockingBlockElement;
        }
        return false;
    }

    public static boolean isFunctionEnclosing(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        IRfScopeElement enclosingScope = namedElement.getEnclosingScope();
        if (enclosingScope instanceof IRfMethodElement && !((IRfMethodElement)enclosingScope).isTask()) {
            return true;
        }
        if (enclosingScope instanceof IRfActionBlockElement) {
            return XUtils.isFunctionEnclosing((IRfNamedElement)enclosingScope);
        }
        return false;
    }

    public static Hid getForIndex(IHidObject hidObject) {
        if (!(hidObject instanceof HidOperator)) {
            return null;
        }
        HidOperator hidOperator = (HidOperator)hidObject;
        IHidObject lhValue = hidOperator.getLHValue();
        if (hidOperator.isIncrementOrDecrement() && lhValue instanceof Hid) {
            return (Hid)lhValue;
        }
        if (hidOperator.isAssignment() && lhValue instanceof Hid) {
            return (Hid)lhValue;
        }
        return null;
    }

    public static String inputEqPortName(String portName) {
        return DVTStringUtil.appendString("<in_", portName, ">");
    }

    public static String outputEqPortName(String portName) {
        return DVTStringUtil.appendString("<out_", portName, ">");
    }

    public static String getEvCtrlName(IRfNamedElement clockingBlock) {
        return DVTStringUtil.appendString("<cbEvCtrl@", clockingBlock.getName(), ">");
    }

    public static String getCbPortName(boolean inputNotOutput, IRfNamedElement clockingBlock, String portName) {
        return DVTStringUtil.appendString("<", inputNotOutput ? "in_" : "out_", portName, "@", clockingBlock.getName(), ">");
    }

    public static String getPrevVarName(IHidObject argHidObject) {
        return DVTStringUtil.appendString("<prev_", HidUtils.toNiceString(argHidObject), ">");
    }

    public static boolean isClockingOutputDriver(IRfNamedElement element) {
        return element != null && element.isPredefined() && element.getName().startsWith("<out_");
    }

    public static void stripLeadingZeroes(StringBuilder result, String numberText) {
        int length = numberText.length();
        if (length > 0 && numberText.charAt(0) != '0') {
            result.append(numberText);
            return;
        }
        boolean isLeading = true;
        int i = 0;
        while (i < length) {
            char charAt = numberText.charAt(i);
            if (charAt != '0' || !isLeading || i >= length - 1) {
                result.append(charAt);
                isLeading = false;
            }
            ++i;
        }
    }

    public static boolean isInternalSignal(String name) {
        return name.length() > 0 && name.charAt(0) == '<';
    }

    public static boolean isModified(IELParamValue prevValue, IELParamValue currValue) {
        if (currValue == null && prevValue != null) {
            return true;
        }
        if (currValue != null && prevValue == null) {
            return true;
        }
        return currValue != null && !currValue.equals(prevValue);
    }

    public static int timeUnitExponent(String numberName) {
        int exponentTime = 0;
        char ch = numberName.charAt(numberName.length() - 1);
        if (ch == 's' || ch == 'S') {
            exponentTime = 15;
            if (numberName.length() > 2) {
                ch = numberName.charAt(numberName.length() - 2);
                switch (ch) {
                    case 'F': 
                    case 'f': {
                        exponentTime = 0;
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        exponentTime = 3;
                        break;
                    }
                    case 'N': 
                    case 'n': {
                        exponentTime = 6;
                        break;
                    }
                    case 'U': 
                    case 'u': {
                        exponentTime = 9;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        exponentTime = 12;
                        break;
                    }
                }
            }
        }
        return exponentTime;
    }

    public static String reverseTimeUnitExponent(int exponentTime, boolean upperCase) {
        if (exponentTime < 0) {
            return "";
        }
        if (exponentTime < 3) {
            return upperCase ? "FS" : "fs";
        }
        if (exponentTime < 6) {
            return upperCase ? "PS" : "ps";
        }
        if (exponentTime < 9) {
            return upperCase ? "NS" : "ns";
        }
        if (exponentTime < 12) {
            return upperCase ? "US" : "us";
        }
        if (exponentTime < 15) {
            return upperCase ? "MS" : "ms";
        }
        return "";
    }

    public static IHid getFirstParentHid(IHid hid) {
        IHid parentHid = hid.getParentHid();
        if (parentHid != null) {
            return XUtils.getFirstParentHid(parentHid);
        }
        if (AssociationUtils.isConnectedType(hid)) {
            return null;
        }
        return hid;
    }

    public static boolean isStructOrUnion(IRfScopeElement element) {
        return (element = XValueHolderFactory.unwrapTypeAlias((IRfNamedElement)element)) instanceof IRfCompositeTypeElement && (((IRfCompositeTypeElement)element).isStruct() || ((IRfCompositeTypeElement)element).isUnion());
    }

    public static IHidObject getDriven(IHidOperator operator) {
        IHidObject firstRHValue = operator.getFirstRHValue();
        IHidObject lhValue = operator.getLHValue();
        boolean isLhsInoutDriver = operator.hasOccurrence(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER);
        if (isLhsInoutDriver) {
            return firstRHValue;
        }
        boolean isPortConnection = XUtils.isPortConnection(operator);
        if (isPortConnection && lhValue instanceof Hid && XUtils.isOutputPort((IHid)lhValue, firstRHValue)) {
            return firstRHValue;
        }
        return lhValue;
    }

    public static IHidObject getDriver(IHidOperator operator) {
        IHidObject firstRHValue = operator.getFirstRHValue();
        IHidObject lhValue = operator.getLHValue();
        boolean isLhsInoutDriver = operator.hasOccurrence(HidQualifierCache.IS_LHS_INOUT_DRIVER_QUALIFIER);
        if (isLhsInoutDriver) {
            return lhValue;
        }
        boolean isPortConnection = XUtils.isPortConnection(operator);
        if (isPortConnection && lhValue instanceof Hid && XUtils.isOutputPort((IHid)lhValue, firstRHValue)) {
            return lhValue;
        }
        return firstRHValue;
    }

    public static boolean isPortConnection(IHidOperator operator) {
        return operator.hasOccurrence(HidOperatorQualifier.IS_PORT_CONNECTION) || operator.hasOccurrence(HidOperatorQualifier.IS_PORT_EXPRESSION);
    }

    public static boolean equals(IHid hid1, IHid hid2) {
        if (hid1 instanceof XInstValueHolder.XEvalOverrideHid) {
            hid1 = ((XInstValueHolder.XEvalOverrideHid)hid1).getOverrideHid();
        }
        if (hid2 instanceof XInstValueHolder.XEvalOverrideHid) {
            hid2 = ((XInstValueHolder.XEvalOverrideHid)hid2).getOverrideHid();
        }
        return hid1.equals(hid2);
    }

    public static boolean isAllowPortCoerce(IHidObject signalHidObject) {
        if (signalHidObject == null) {
            return false;
        }
        if (HidUtils.isOperator(signalHidObject)) {
            if (HidUtils.isOperator(signalHidObject) && ((HidOperator)signalHidObject).isVLOGConcatenation(false)) {
                ListContainer<IHidObject> concatOperands = ((HidOperator)signalHidObject).getRHValues();
                for (IHidObject concatOperand : concatOperands) {
                    if (XUtils.isAllowPortCoerce(concatOperand)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (HidUtils.isHid(signalHidObject) && XUtils.netType((IHid)signalHidObject) == IRfNamedElement.NetType.NONE) {
            return false;
        }
        return !HidUtils.isHidAccess(signalHidObject) || XUtils.netType(((HidAccess)signalHidObject).getParentHid()) != IRfNamedElement.NetType.NONE;
    }

    public static ListContainer<XComputedSelect> selects(XSelectProxy selectProxy) {
        if (selectProxy == null) {
            return null;
        }
        XSelectProxy beforeSelectProxy = selectProxy.getSelectProxy();
        if (beforeSelectProxy == null) {
            return selectProxy.computedSelects;
        }
        ArrayListContainer<XComputedSelect> result = new ArrayListContainer<XComputedSelect>(10);
        XUtils.selects(selectProxy, result);
        return result;
    }

    private static void selects(XSelectProxy selectProxy, ArrayListContainer<XComputedSelect> result) {
        if (selectProxy == null) {
            return;
        }
        XUtils.selects(selectProxy.getSelectProxy(), result);
        ListContainer<XComputedSelect> selects = selectProxy.computedSelects;
        if (selects instanceof XComputedSelect) {
            result.add((XComputedSelect)selects);
        } else if (selects instanceof ArrayListContainer) {
            result.addAll((ArrayListContainer)selects);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void setVerbosityChanged(boolean value) {
        verbosityChanged = value;
    }

    public static boolean hasX(IELParamValue value) {
        DVTNumber dvtNumber = value.getDVTNumber();
        BitSet maskX = dvtNumber.getMask(MaskType.X);
        return maskX != null && !maskX.isEmpty();
    }

    public static boolean isMultipleDriver(IELParamValue value) {
        IELParamValue original = value.getOriginal();
        if (original instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Tristate) {
            return true;
        }
        if (original != null && original.getOriginal() instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Tristate) {
            return true;
        }
        if (value.getSelectProxy() != null) {
            IELParamValue rightValueBeforeSelect = value.getValueBeforeSelect();
            if (value != rightValueBeforeSelect) {
                return XUtils.isMultipleDriver(rightValueBeforeSelect);
            }
            return false;
        }
        return false;
    }

    public static boolean isDriveStrengthPassthrough(ELParamValueScope valueScope) {
        IHidEvaluator scope = XUtils.getScope(valueScope);
        if (scope == null) {
            return false;
        }
        IRfNamedElement namedElement = scope.getNamedElement();
        return namedElement instanceof IRfPredefinedGate;
    }

    public static boolean isDriveStrengthReduction(ELParamValueScope valueScope) {
        IHidEvaluator scope = XUtils.getScope(valueScope);
        if (scope == null) {
            return false;
        }
        IRfNamedElement namedElement = scope.getNamedElement();
        if (namedElement instanceof IRfPredefinedGate) {
            String name = namedElement.getName();
            return "tranif0".equals(name) || "tranif1".equals(name) || "tran".equals(name);
        }
        return false;
    }

    public static IHidOperator getOverrideOperator(IHidOperator operator) {
        if (operator instanceof XInstValueHolder.XEvalOverrideHidOperator) {
            return ((XInstValueHolder.XEvalOverrideHidOperator)operator).getOverrideOperator();
        }
        return operator;
    }

    public static String getLibraryBinding(IHidEvaluator evaluator) {
        if (evaluator == null) {
            return "";
        }
        IRfNamedElement namedElement = evaluator.getNamedElement();
        IRfLibraryElement library = namedElement.getEnclosingLibrary();
        return DVTStringUtil.appendString(XUtils.getName(library), ".", XUtils.getName(namedElement));
    }

    public static HidOperator getInstanceDelayControl(IRfInstanceElement description) {
        if (description == null) {
            return null;
        }
        IHidHolder hidHolder = description.getHidHolder();
        if (hidHolder == null) {
            return null;
        }
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(ELConstants.DELAY_CONTROL_QUALIFIERS_ARRAY);
        hidHolder.visitHidObject(null, hidOperatorVisitor);
        List<IHidOperator> results = hidOperatorVisitor.getObjects();
        return !results.isEmpty() ? (HidOperator)results.get(0) : null;
    }

    public static HidOperator getInstanceDriveStrength(IRfInstanceElement description) {
        if (description == null) {
            return null;
        }
        IHidHolder hidHolder = description.getHidHolder();
        if (hidHolder == null) {
            return null;
        }
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(IHidOperatorConstants.OperatorType.DRIVE_STRENGTH.id);
        hidHolder.visitHidObject(null, hidOperatorVisitor);
        List<IHidOperator> results = hidOperatorVisitor.getObjects();
        return !results.isEmpty() ? (HidOperator)results.get(0) : null;
    }

    public static final String readLineIncludingNewline(RandomAccessFile raf) throws IOException {
        StringBuilder input = new StringBuilder();
        int c = -1;
        boolean eol = false;
        while (!eol) {
            c = raf.read();
            switch (c) {
                case -1: {
                    eol = true;
                    break;
                }
                case 10: {
                    eol = true;
                    input.append((char)c);
                    break;
                }
                case 13: {
                    eol = true;
                    input.append((char)c);
                    long cur = raf.getFilePointer();
                    if (raf.read() != 10) {
                        raf.seek(cur);
                        break;
                    }
                    input.append((char)c);
                    break;
                }
                default: {
                    input.append((char)c);
                }
            }
        }
        if (c == -1 && input.length() == 0) {
            return null;
        }
        return input.toString();
    }

    public static BigInteger toBigInteger(BitSet bits) {
        byte[] little = bits.toByteArray();
        if (little.length == 0) {
            return BigInteger.ZERO;
        }
        int n = little.length;
        byte[] bigEndian = new byte[n];
        int i = 0;
        while (i < n) {
            bigEndian[i] = little[n - 1 - i];
            ++i;
        }
        return new BigInteger(1, bigEndian);
    }

    public static XInstValueHolder getInstanceScope(ELParamValueScope valueScope) {
        if (valueScope != null && valueScope.scope instanceof XInstValueHolder) {
            return (XInstValueHolder)valueScope.scope;
        }
        if (valueScope != null && valueScope.scope instanceof XValueHolder) {
            return ((XValueHolder)valueScope.scope).getInstanceScope();
        }
        return null;
    }

    static class InitialBlockVisitor
    implements IHidVisitor<IHid> {
        private AtomicBoolean isIgnoreInitialBlock;
        private IRfScopeElement enclosingModule;
        private IELMemory elMemory;
        private ELInstance elInstance;
        private Set<ElementPath> elementPaths;
        private Set<IHid> visitedMethods;

        private InitialBlockVisitor(AtomicBoolean isIgnoreInitialBlock, IRfScopeElement enclosingModule, IELMemory elMemory, ELInstance elInstance, Set<ElementPath> elementPaths, Set<IHid> visitedMethods) {
            this.isIgnoreInitialBlock = isIgnoreInitialBlock;
            this.enclosingModule = enclosingModule;
            this.elMemory = elMemory;
            this.elInstance = elInstance;
            this.elementPaths = elementPaths;
            this.visitedMethods = visitedMethods;
        }

        @Override
        public boolean visit(IHid hid) {
            if (hid == null) {
                return true;
            }
            IRfNamedElement element = hid.getElement();
            if (element == null) {
                return true;
            }
            boolean isMethod = element instanceof IRfMethodElement;
            if (isMethod) {
                if (this.visitedMethods.contains(hid)) {
                    return true;
                }
                this.visitedMethods.add(hid);
            }
            IHid parentHid = hid;
            do {
                ElementPath absolutePath;
                IRfNamedElement tempElement;
                if (!((tempElement = parentHid.getElement()) instanceof IRfInstanceElement)) continue;
                ElementPath hierarchicalPath = parentHid.getHierarchicalPath();
                if (this.collectInstancesFor(hierarchicalPath = ElementPath.join(hierarchicalPath, parentHid.getName()))) break;
                ElementPath parentPath = this.elInstance.getHierarchyPath();
                while (!this.collectInstancesFor(absolutePath = ElementPath.join(parentPath, hierarchicalPath)) && (parentPath = ElementPath.upperPathOf(parentPath)) != null && !parentPath.isEmpty()) {
                }
                break;
            } while ((parentHid = parentHid.getParentHid()) != null);
            if (!isMethod) {
                boolean hasVirtualDataType = element instanceof IRfAssociatedTypeElement && ((IRfAssociatedTypeElement)element).getDataType() != null && ((IRfAssociatedTypeElement)element).getDataType().isVirtualInterface();
                this.isIgnoreInitialBlock.set(this.isIgnoreInitialBlock.get() & !hasVirtualDataType);
                return true;
            }
            IRfScopeElement enclosingScope = element.getEnclosingScope();
            if (enclosingScope instanceof IRfClassElement || enclosingScope instanceof IRfPackageElement) {
                this.isIgnoreInitialBlock.set(false);
                return true;
            }
            InitialBlockVisitor functionCallsVisitor = new InitialBlockVisitor(this.isIgnoreInitialBlock, this.enclosingModule, this.elMemory, this.elInstance, this.elementPaths, this.visitedMethods);
            element.visitHidObject(null, functionCallsVisitor);
            return true;
        }

        private boolean collectInstancesFor(ElementPath absolutePath) {
            ELInstance instanceFor = this.elMemory.instanceFor(absolutePath);
            if (instanceFor != null) {
                this.elementPaths.add(absolutePath);
                return true;
            }
            String lastSegment = absolutePath.lastSegment();
            ElementPath low = ElementPath.join(ElementPath.upperPathOf(absolutePath), String.valueOf(lastSegment) + "[");
            ElementPath high = ElementPath.join(ElementPath.upperPathOf(absolutePath), String.valueOf(lastSegment) + "]");
            Map<ElementPath, ELInstance> subMemory = this.elMemory.subMap(low, true, high, true, false);
            boolean collected = false;
            for (Map.Entry<ElementPath, ELInstance> instanceEntry : subMemory.entrySet()) {
                if (instanceEntry.getKey().length() > absolutePath.length()) continue;
                this.elementPaths.add(instanceEntry.getKey());
                collected = true;
            }
            return collected;
        }

        @Override
        public Class<IHid> getType() {
            return IHid.class;
        }
    }

    public static class NameScope {
        private String name;
        private IRfNamedElement element;
        private XValueHolder scope;

        public NameScope(XValueHolder scope, IRfNamedElement element, String name) {
            this.scope = scope;
            this.element = element;
            this.name = name;
        }

        public static NameScope create(XValueHolder scope, IRfNamedElement element, String name) {
            return new NameScope(scope, element, name);
        }

        public IELParamValue getValueHolder() {
            return this.scope.getValueDirectly(this.name);
        }

        public XValueHolder getScope() {
            return this.scope;
        }

        public XInstValueHolder.XEvalOverrideHid toHid(int offset, int line) {
            return new XInstValueHolder.XEvalOverrideHid(this.scope, new Hid(this.name, null, offset, line, 0L){
                private static final long serialVersionUID = 1L;

                @Override
                public IRfNamedElement getElement() {
                    return element;
                }

                @Override
                public ELParamValueScope evaluateForSize(IHidEvaluator evaluator, IRfNamedElement origin, IHidEvaluationGuardian guardian) {
                    return ELParamValueScope.of(scope.getValueDirectly(this.name), scope);
                }

                @Override
                public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    return ELParamValueScope.of(scope.getValueDirectly(this.name), scope);
                }

                @Override
                public ELParamValueScope evaluateInterpreter(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                    return ELParamValueScope.of(scope.getValueDirectly(this.name), scope);
                }
            });
        }
    }

    public static enum PortDirection {
        NONE,
        INPUT,
        INOUT,
        OUTPUT;

    }

    public static enum TransitionKind {
        FALLING,
        RISING,
        TURN_OFF,
        MINIMUM,
        NONE;

    }
}

