/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.OperationCanceledException;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.DVTXVariableType;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXValueHolderFactoryContributor;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.dpi.IXSystemCFactory;
import ro.amiq.dvt.interpreter.dpi.types.IXDPICUtils;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfConstraintElement;
import ro.amiq.dvt.model.reflection.IRfCoverbin;
import ro.amiq.dvt.model.reflection.IRfCovergroup;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.IRfTypeElement;
import ro.amiq.dvt.model.reflection.IRfVhdlTypeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidObjectWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownMethodEvaluationException;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.DVTUnpackedStruct;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VhdlEnum;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogRealNumber;
import ro.amiq.dvt.utils.VlogShortrealNumber;

public class XValueHolder
implements IELParamValue {
    public static final String ROV = "__rov__";
    private static final Comparator<HidOperatorElementWrapper> INIT_ASSIGN_WRAPPER_COMPARATOR = (w1, w2) -> {
        boolean secondIsElabConstant;
        boolean firstIsElabConstant = w1.element instanceof IRfFieldElement && ((IRfFieldElement)w1.element).isElabConstant();
        boolean bl = secondIsElabConstant = w2.element instanceof IRfFieldElement && ((IRfFieldElement)w2.element).isElabConstant();
        if (firstIsElabConstant == secondIsElabConstant) {
            return HidOperator.OPERATOR_COMPARATOR.compare((HidOperator)w1.hidObject, (HidOperator)w2.hidObject);
        }
        return firstIsElabConstant ? -1 : 1;
    };
    protected final XValueHolderFactory factory;
    protected final XNamedElement xAssociatedType;
    protected IELParamValue enclosing;
    protected XValueHolder staticHolder;
    protected XInstValueHolder instanceScope;
    protected XValueHolder refValueHolder;
    protected ELParamValues values;
    private boolean isNull;
    private boolean isUnknown;
    private boolean isStatic;
    private boolean isConstraintModeOn;
    private IELParamValue original;
    private XSelectProxy selectProxy;
    protected IRfNamedElement element;
    protected int uniqueId;
    protected int uniqueValuesId;

    public XValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder, boolean isNull) {
        this(factory, xAssociatedType, enclosing, instanceScope, isStaticHolder, isNull, isStaticHolder && factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
    }

    public XValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder, boolean isNull, boolean isUnknown) {
        this.factory = factory;
        this.xAssociatedType = xAssociatedType;
        this.enclosing = enclosing;
        this.instanceScope = instanceScope;
        this.values = ELParamValues.create(XValueHolderFactory.isCaseSensitive(xAssociatedType));
        this.uniqueId = factory.getUniqueId();
        this.uniqueValuesId = factory.getUniqueId();
        IRfNamedElement namedElement = xAssociatedType.getNamedElement();
        if (factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode() && namedElement instanceof IRfSpecializedTypeElement) {
            namedElement = ((IRfSpecializedTypeElement)namedElement).getGenericElement();
            xAssociatedType = XNamedElement.create(namedElement, null);
        }
        boolean isNamedActionBlock = namedElement instanceof IRfActionBlockElement && !namedElement.isAnonymous();
        boolean isGenerateBlock = namedElement instanceof IRfBlockElement;
        boolean isMethod = namedElement instanceof IRfMethodElement;
        if (enclosing != null && (isNamedActionBlock || isGenerateBlock || isMethod)) {
            enclosing.putValueDirectly(XUtils.getName(namedElement), this);
        }
        this.isNull = isNull && !isUnknown;
        this.isUnknown = isUnknown;
        this.isStatic = isStaticHolder || namedElement instanceof IRfDesignElement || namedElement instanceof IRfModportElement;
        this.isConstraintModeOn = true;
        if (this.isStatic) {
            ELParamValues elabConstantValues;
            ELParamValues eLParamValues = elabConstantValues = namedElement instanceof IRfPackageElement || namedElement instanceof IRfLibraryElement ? null : xAssociatedType.getLocalElabConstantValues();
            if (elabConstantValues != null) {
                this.values.putAll(elabConstantValues);
            }
        } else if (!namedElement.xIsNonStaticValueHolder()) {
            this.staticHolder = factory.createStaticValueHolder(xAssociatedType);
        }
    }

    public XValueHolder getRefValueHolder() {
        return this.refValueHolder;
    }

    @Override
    public boolean isClass() {
        return this.getNamedElement() instanceof IRfClassElement;
    }

    public ELParamValues getValues() {
        return this.values;
    }

    public XValueHolderFactory getFactory() {
        return this.factory;
    }

    @Override
    public IHidEvaluationGuardian getCachedSimGuardian(boolean createCopy) {
        return this.factory.xSim.getEvaluationGuardian(createCopy);
    }

    @Override
    public IRfNamedElement getElement() {
        return this.element;
    }

    public void setElement(IRfNamedElement element) {
        this.element = element;
    }

    @Override
    public ELParamValues getLastValueContainer() {
        return this.values;
    }

    public boolean isStaticHolder() {
        return this.isStatic;
    }

    @Override
    public void setOriginal(IELParamValue original) {
        this.original = original;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.isStaticHolder() ? 1231 : 1237);
        result = 31 * result + (this.isNull ? 1231 : 1237);
        result = 31 * result + (this.values == null ? 0 : System.identityHashCode(this.values));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XValueHolder other = (XValueHolder)obj;
        if (this.values != other.values) {
            return false;
        }
        if (this.isNull != other.isNull) {
            return false;
        }
        if (this.isStaticHolder() != other.isStaticHolder()) {
            return false;
        }
        return this.getNamedElement() == other.getNamedElement();
    }

    @Override
    public XSelectProxy getSelectProxy() {
        return this.selectProxy;
    }

    @Override
    public void setSelectProxy(XSelectProxy selectProxy) {
        this.selectProxy = selectProxy;
    }

    @Override
    public void prepareHotSwap() {
        IELParamValue.super.prepareHotSwap();
        this.factory.prepareHotSwap();
    }

    public void setConstraintModeOn(boolean isConstraintModeOn) {
        this.isConstraintModeOn = isConstraintModeOn;
    }

    public boolean isConstraintModeOn() {
        return this.isConstraintModeOn;
    }

    @Override
    public ELParamValueScope getValue(IHid hid, BitVectorContext context, IHidEvaluationGuardian guardian) {
        return this.getValue(hid, this, context, false, guardian);
    }

    @Override
    public ELParamValueScope getValue(IHid hid, IHidEvaluator hidInitialScope, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
        String name = XUtils.getName(hid);
        if ("void".equals(name)) {
            return null;
        }
        IRfNamedElement element = hid.getElement();
        if (element instanceof IRfFieldElement && ((IRfFieldElement)element).isEnumElement()) {
            IRfNamedElement parentEnumType = ((IRfFieldElement)element).getParentEnumType();
            ELEnumTypeWrapper enumType = this.createEnumTypeWrapper(parentEnumType);
            if (enumType != null) {
                IELParamValue enumItemValue = enumType.getItemValue(element.getName());
                return ELParamValueScope.of(enumItemValue, this);
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        boolean isSuperAccess = false;
        if (HidUtils.isHid(hid)) {
            boolean isType;
            HidAccess firstAccess = ((Hid)hid).getFirstAccess();
            if (this.factory.isCoverage()) {
                isType = ((Hid)hid).hasQualifier(HidQualifierCache.TYPE_QUALIFIER) && element != null && (!(element instanceof IRfFieldElement) || ((IRfFieldElement)element).isTypeParameter()) && firstAccess != null && firstAccess.getFirstHid().hasQualifier(HidQualifierCache.IS_COVERAGE_OPTION_QUALIFIER);
            } else {
                boolean bl = isType = ((Hid)hid).hasQualifier(HidQualifierCache.TYPE_QUALIFIER) && element != null && (!(element instanceof IRfFieldElement) || ((IRfFieldElement)element).isTypeParameter());
            }
            if (firstAccess != null && firstAccess.getAccessKind() == 2) {
                XValueHolder enclosingClassValueHolder;
                IRfNamedElement associatedType = firstAccess.xRecomputeAssociatedType(hidInitialScope);
                if (associatedType == null) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                if (associatedType instanceof IRfClassElement && (enclosingClassValueHolder = this.getEnclosingClassValueHolder()) != null && enclosingClassValueHolder.getNamedElement().xCanCastTo(associatedType) && !firstAccess.getFirstHid().hasOccurrence(HidQualifierCache.TYPE_QUALIFIER)) {
                    IELParamValue resultHolder = this.factory.createValueHolder(associatedType, null, this.instanceScope);
                    ((XValueHolder)resultHolder).updateValue((IELParamValue)enclosingClassValueHolder, true);
                    return ELParamValueScope.of(resultHolder);
                }
                return ELParamValueScope.of(this.factory.createStaticValueHolder(XNamedElement.create(associatedType, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode())));
            }
            if (isType) {
                IRfNamedElement associatedType;
                IRfNamedElement iRfNamedElement = associatedType = firstAccess != null ? firstAccess.xRecomputeAssociatedType(hidInitialScope) : ((Hid)hid).xRecomputeElementType(hidInitialScope);
                if (associatedType == null) {
                    return ELParamValueScope.UNDEFINED_VALUE;
                }
                IRfScopeElement enclosingScope = associatedType.getEnclosingScope();
                if (!(associatedType.getLanguageKind() != LanguageKind.VLOG || associatedType instanceof IRfCovergroup && enclosingScope instanceof IRfClassElement || enclosingScope instanceof IRfFieldElement && ((IRfFieldElement)enclosingScope).isCoverpoint())) {
                    if (associatedType instanceof IRfClassElement) {
                        return ELParamValueScope.of(this.factory.createStaticValueHolder(XNamedElement.create(associatedType, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode())));
                    }
                    if (associatedType instanceof IRfTypeElement) {
                        BitVectorContext typeContext = ((IRfTypeElement)associatedType).getBitVectorContext(this, guardian, null);
                        return typeContext != null ? ELParamValueScope.of(ELParamValues.ParamValueType.of(typeContext.getContextType(), typeContext.getContextNumber())) : ELParamValueScope.UNDEFINED_VALUE;
                    }
                    return ELParamValueScope.of(this.factory.createStaticValueHolder(XNamedElement.create(associatedType, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode())));
                }
            }
            HidAccess parentAccess = ((Hid)hid).getParentAccess();
            isSuperAccess = XValueHolder.isSuperDotAccess(hid);
            if (parentAccess != null && parentAccess.getAccessKind() == 2) {
                isSuperAccess = !this.isStaticHolder();
            }
        }
        return this.getValueImpl(name, element, isSuperAccess, isMethod, true, guardian);
    }

    public static boolean isSuperDotAccess(IHidObject hid) {
        Hid parentHid;
        HidAccess parentAccess;
        return HidUtils.isHid(hid) && (parentAccess = ((Hid)hid).getParentAccess()) != null && parentAccess.getAccessKind() == 0 && (parentHid = parentAccess.getParentHid()) != null && "super".equals(XUtils.getName(parentHid));
    }

    public static boolean isEnum(IRfScopeElement element) {
        return (element = XValueHolderFactory.unwrapTypeAlias((IRfNamedElement)element)) instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)element).isEnum() || element instanceof IRfVhdlTypeElement && ((IRfVhdlTypeElement)element).isEnumType();
    }

    public boolean isUnpackedStructOrUnion() {
        IRfNamedElement element = this.xAssociatedType.getNamedElement();
        boolean structOrUnion = XValueHolder.isStructOrUnion(element);
        if (!structOrUnion) {
            return false;
        }
        return !((IRfCompositeTypeElement)element).isPacked();
    }

    public static boolean isStructOrUnion(IRfScopeElement element) {
        return (element = XValueHolderFactory.unwrapTypeAlias((IRfNamedElement)element)) instanceof IRfCompositeTypeElement && (((IRfCompositeTypeElement)element).isStruct() || ((IRfCompositeTypeElement)element).isUnion());
    }

    public IELParamValue getEnclosingValue() {
        return this.enclosing;
    }

    public IRfNamedElement getEnclosingClass() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (XValueHolderFactory.xIsClass(namedElement)) {
            return this.xAssociatedType.getNamedElement();
        }
        if (this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getEnclosingClass();
        }
        return null;
    }

    private XValueHolder getEnclosingClassValueHolder() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (XValueHolderFactory.xIsClass(namedElement)) {
            return this;
        }
        if (this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getEnclosingClassValueHolder();
        }
        return null;
    }

    @Override
    public boolean is4State() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isAmbiguous() {
        return false;
    }

    @Override
    public boolean isStruct(boolean isStructOrUnion) {
        boolean isUnion;
        IRfNamedElement namedElement = this.getNamedElement();
        boolean isStruct = namedElement instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)namedElement).isStruct();
        boolean bl = isUnion = namedElement instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)namedElement).isUnion();
        return isStruct || isStructOrUnion && isUnion;
    }

    @Override
    public boolean isUnion() {
        IRfNamedElement namedElement = this.getNamedElement();
        return namedElement instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)namedElement).isUnion();
    }

    public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
        ELParamValueScope valueScope = this.internalGetValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        if (guardian != null && guardian.isEvalAssert()) {
            return this.factory.getPreponedValue(valueScope);
        }
        return valueScope;
    }

    private ELParamValueScope internalGetValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
        IRfPackageElement vhdlPackage;
        ELParamValueScope memberValue;
        if (element instanceof IRfInstanceElement && !(this instanceof XInstValueHolder) && this.instanceScope != null && !ELUtils.isUnsuccessfulEval(memberValue = this.instanceScope.getSubInstance(name))) {
            return memberValue;
        }
        XInstValueHolder instanceScope = this.getInstanceScope();
        if ("new".equals(name)) {
            return this.getConstructor(isSuperAccess, instanceScope);
        }
        if (isMethod) {
            if (this.refValueHolder instanceof XInstValueHolder) {
                return this.refValueHolder.getMethod(name, element, isSuperAccess, (XInstValueHolder)this.refValueHolder);
            }
            return this.getMethod(name, element, isSuperAccess, instanceScope);
        }
        if ("this".equals(name)) {
            return this.getThis();
        }
        if ("super".equals(name)) {
            return this.getSuper(instanceScope);
        }
        if ("$root".equals(name)) {
            XInstValueHolder rootInstanceScope = instanceScope;
            while (rootInstanceScope != null && rootInstanceScope.instanceScope != null) {
                rootInstanceScope = rootInstanceScope.instanceScope;
            }
            return ELParamValueScope.of(rootInstanceScope);
        }
        if (XUtils.isInstanceRef(this.refValueHolder) && this.refValueHolder != this && !isMethod) {
            return this.refValueHolder.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }
        ELParamValueScope existingValue = this.getExistingValue(name, element);
        if (existingValue != null) {
            return existingValue;
        }
        IRfNamedElement elementAssocType = this.xAssociatedType.getNamedElement();
        IRfNamedElement member = null;
        if (this.isStatic) {
            XValueHolder parentValueHolder;
            ELParamValueScope memberValue2;
            XNamedElement parent;
            if (element instanceof IRfInstanceElement) {
                element = null;
            }
            if (elementAssocType instanceof IRfDesignElement && element instanceof DummyPort) {
                member = element;
            } else if (elementAssocType instanceof IRfLibraryElement || elementAssocType instanceof IRfPackageElement || elementAssocType instanceof IRfDesignElement) {
                member = this.getMemberSemantic(name, element, elementAssocType);
            } else {
                boolean isLocalMember = this.isLocalMember(element, elementAssocType);
                if (isLocalMember && this.factory.hasMember(elementAssocType, name)) {
                    member = elementAssocType.xGetMember(name);
                }
            }
            if (member == null && (parent = this.xGetParent()) != null && !ELUtils.isUnsuccessfulEval(memberValue2 = (parentValueHolder = this.factory.createStaticValueHolder(parent)).getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian))) {
                return memberValue2;
            }
        } else {
            if (this.refValueHolder instanceof XInstValueHolder && "interface".equals(elementAssocType.getName())) {
                IELParamValue value = this.refValueHolder.getValueDirectly(name);
                return ELParamValueScope.of(value, this.refValueHolder);
            }
            if (this.refValueHolder instanceof XInstValueHolder && elementAssocType instanceof IRfInterface) {
                IELParamValue value = this.refValueHolder.getValueDirectly(name);
                return ELParamValueScope.of(value, this.refValueHolder);
            }
            if (member == null && (elementAssocType instanceof IRfDesignElement || elementAssocType instanceof IRfActionBlockElement && elementAssocType.getEnclosingScope() instanceof IRfDesignElement) && (member = this.getMemberSemantic(name, element, elementAssocType)) != null && !(member.getEnclosingScope() instanceof IRfPackageElement)) {
                member = null;
            }
            if (member == null && this.factory.hasMember(elementAssocType, name)) {
                member = elementAssocType.xGetMember(name);
            }
        }
        if (member == null) {
            ELParamValueScope memberValue3;
            if (element instanceof IRfDesignElement && instanceScope != null && (memberValue3 = instanceScope.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian)) != null) {
                return memberValue3;
            }
            if (this.enclosing != null) {
                return ((XValueHolder)this.enclosing).getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        ELParamValueScope memberValue4 = null;
        IRfNamedElement memberEnclosingScope = (IRfNamedElement)member.getEnclosingScope();
        if (memberEnclosingScope instanceof IRfPackageElement && ((IRfPackageElement)memberEnclosingScope).isPackageBody() && (vhdlPackage = ((IRfPackageElement)memberEnclosingScope).getPackage()) != null) {
            memberEnclosingScope = vhdlPackage;
        }
        if (memberEnclosingScope instanceof IRfLibraryElement || memberEnclosingScope instanceof IRfPackageElement) {
            IELParamValue value;
            if ((member instanceof IRfDesignElement || member instanceof IRfInstanceElement) && this instanceof XInstValueHolder && name.equals(((XInstValueHolder)this).getInstancePath().getName())) {
                return ELParamValueScope.of(this);
            }
            ELManager manager = this.factory.getManager();
            ELParamValues elabValues = manager.getExternalConstants(memberEnclosingScope);
            if (elabValues != null && (value = elabValues.getValue(name)) != null && !(value.getDVTNumber() instanceof DVTUnpackedArray) && !(value.getDVTNumber() instanceof DVTUnpackedStruct)) {
                return ELParamValueScope.of(value, this);
            }
            if (memberEnclosingScope != elementAssocType) {
                if (memberEnclosingScope.getClass() == elementAssocType.getClass() && memberEnclosingScope.getName().equals(elementAssocType.getName())) {
                    return null;
                }
                XNamedElement simpleXNamedElement = XNamedElement.create(memberEnclosingScope, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
                XValueHolder enclosingScopeValueHolder = this.factory.createStaticValueHolder(simpleXNamedElement);
                if (enclosingScopeValueHolder == this) {
                    return null;
                }
                if (enclosingScopeValueHolder == null) {
                    return null;
                }
                return enclosingScopeValueHolder.getValueImpl(name, member, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
            }
        } else {
            if (this.staticHolder != null && member.xIsStaticMember()) {
                return this.staticHolder.getValueImpl(name, member, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
            }
            IELParamValue value = this.isStatic ? this.getValueDirectly(name) : null;
            memberValue4 = ELParamValueScope.of(value, this, name, null);
        }
        if (this.staticHolder != null && memberValue4 == null && member instanceof IRfInstanceElement && instanceScope != null) {
            memberValue4 = ELParamValueScope.of(instanceScope.getValueDirectly(name), this);
        }
        if (isDeclareMissingVariable && memberValue4 == null) {
            boolean isEvaluateForSize;
            boolean bl = isEvaluateForSize = guardian != null && guardian.isEvaluateForSize();
            if (!isEvaluateForSize && this.isStatic && !member.xIsStaticMember()) {
                this.factory.logError(DVTStringUtil.appendString("Fail to evaluate non-static member '", name, "' in static scope of '", this, "'"));
            } else if (!isEvaluateForSize && !this.isStatic && member.xIsStaticMember()) {
                this.factory.logError(DVTStringUtil.appendString("Fail to evaluate static member '", name, "' in non-static scope of '", this, "'"));
            }
            memberValue4 = this.getExistingValue(name, member);
            if (memberValue4 != null) {
                return memberValue4;
            }
            memberValue4 = this.createMemberValue(member);
        }
        return memberValue4;
    }

    private ELParamValueScope getExistingValue(String name, IRfNamedElement element) {
        IELParamValue value;
        boolean isStaticMemberCandidate;
        IELParamValue value2;
        boolean isNonStaticMemberCandidate;
        if (element == null && XUtils.isClassScope(this)) {
            return null;
        }
        if (!(element instanceof IRfFieldElement) || !XValueHolderFactory.xIsClass((IRfNamedElement)element.getEnclosingScope(), false)) {
            element = null;
        }
        boolean bl = isNonStaticMemberCandidate = element == null || !element.xIsStaticMember();
        if ((this.isStatic || isNonStaticMemberCandidate) && (value2 = this.values.getValue(name, element)) != null) {
            if (value2 instanceof XUninitValue) {
                ((XUninitValue)value2).evaluate();
                value2 = this.values.getValue(name, element);
            }
            return ELParamValueScope.of(value2, this);
        }
        boolean bl2 = isStaticMemberCandidate = element == null || element.xIsStaticMember();
        if (this.staticHolder != null && isStaticMemberCandidate && (value = this.staticHolder.values.getValue(name, element)) != null) {
            if (value instanceof XUninitValue) {
                ((XUninitValue)value).evaluate();
                value = this.values.getValue(name, element);
            }
            return ELParamValueScope.of(value, this.staticHolder);
        }
        return null;
    }

    private IRfNamedElement getMemberSemantic(String name, IRfNamedElement element, IRfNamedElement elementAssocType) {
        IRfPackageElement vhdlPackageBody;
        if (element != null) {
            return element;
        }
        element = elementAssocType.semanticGetMember(name, null, null, elementAssocType, elementAssocType, true, true, false);
        if (element != null) {
            return element;
        }
        if (element == null && elementAssocType instanceof IRfPackageElement && (vhdlPackageBody = ((IRfPackageElement)elementAssocType).getPackageBody()) != null && vhdlPackageBody == elementAssocType) {
            return vhdlPackageBody.semanticGetMember(name, null, null, elementAssocType, elementAssocType, true, true, false);
        }
        return element;
    }

    public XInstValueHolder getInstanceScope() {
        if (this.instanceScope != null) {
            return this.instanceScope;
        }
        this.instanceScope = this.internalGetInstanceScope();
        if (this.instanceScope != null) {
            return this.instanceScope;
        }
        this.instanceScope = this.factory.getTopInstanceValueHolder();
        return this.instanceScope;
    }

    protected XInstValueHolder internalGetInstanceScope() {
        if (this.instanceScope != null) {
            return this.instanceScope;
        }
        if (this.refValueHolder != null && this.getNamedElement() instanceof IRfDesignElement) {
            return this.refValueHolder.internalGetInstanceScope();
        }
        if (this.enclosing instanceof XValueHolder) {
            return ((XValueHolder)this.enclosing).internalGetInstanceScope();
        }
        return null;
    }

    private boolean isLocalMember(IRfNamedElement elementCandidate, IRfNamedElement containingMember) {
        if (elementCandidate == null) {
            return true;
        }
        IRfScopeElement enclosingScope = elementCandidate.getEnclosingScope();
        if (enclosingScope == null) {
            return true;
        }
        if (enclosingScope == containingMember) {
            return true;
        }
        return enclosingScope.getName().equals(containingMember.getName());
    }

    private boolean isInterfaceInstance(IRfNamedElement member) {
        IRfNamedElement associatedType = this.factory.xGetAssociatedType((IRfAssociatedTypeElement)member, this);
        if (associatedType == null) {
            return false;
        }
        if (associatedType instanceof IRfInterface) {
            return true;
        }
        if (associatedType instanceof IRfListType) {
            return this.isInterfaceInstance(associatedType);
        }
        return false;
    }

    public IELParamValue createValue(IRfNamedElement member) {
        boolean isLinterStaticAnalysisMode = this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode();
        XInstValueHolder instanceScope = this.getInstanceScope();
        IELParamValue memberValue = null;
        if (member instanceof IRfTypeElement && LanguageKind.VHDL == member.getLanguageKind()) {
            IRfNamedElement associatedType = this.factory.xGetAssociatedType((IRfAssociatedTypeElement)member, this);
            if (associatedType == null) {
                memberValue = this.factory.createValueHolder(XNamedElement.create(member, this, true, isLinterStaticAnalysisMode), (IELParamValue)this, instanceScope);
                if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                    ((XValueHolder)memberValue).setElement(member);
                }
            } else {
                BitVectorContext memberContext = ((IRfAssociatedTypeElement)member).getDataTypeBitVectorContext(this, true, null, this.getManager());
                if (memberContext == null) {
                    memberContext = this.getBitVectorContext(associatedType);
                }
                if ((memberValue = this.createNumericScalarMemberValue(member, memberContext, member instanceof IRfTypeAliasElement)) == null && !ELUtils.isUnsuccessfulEval(memberValue = this.factory.createValueHolder(XNamedElement.create(associatedType, null, true, isLinterStaticAnalysisMode), (IELParamValue)this, instanceScope))) {
                    ((XValueHolder)memberValue).setElement(member);
                }
            }
        } else if (member instanceof IRfCoverpoint || member instanceof IRfCoverbin) {
            memberValue = this.factory.createValueHolder(XNamedElement.create(member, this, true, isLinterStaticAnalysisMode), (IELParamValue)this, instanceScope);
        } else if (member instanceof IRfAssociatedTypeElement) {
            IRfNamedElement associatedType = this.factory.xGetAssociatedType((IRfAssociatedTypeElement)member, this);
            if (associatedType == null) {
                boolean isSystemFunctionOrTask;
                IRfScopeElement enclosingScope = member.getEnclosingScope();
                boolean bl = isSystemFunctionOrTask = enclosingScope instanceof IRfMethodElement && XUtils.isSystemFunctionOrTask((IRfMethodElement)enclosingScope);
                if (!isSystemFunctionOrTask) {
                    this.factory.logError("Unknown associated type of '" + member.getName() + "' in scope of '" + this.toUniqueString(true) + "'");
                }
                return IELParamValue.UNDEFINED_VALUE;
            }
            boolean isInstanceElement = member instanceof IRfInstanceElement;
            if (isInstanceElement && isLinterStaticAnalysisMode) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if ((isInstanceElement || member instanceof IRfDesignElement) && !this.factory.isInstanceAllowed && !this.isInterfaceInstance(member)) {
                if (this.factory.getEvaluationGuardian(false).simulatorMode() == IXSim.XSimMode.SIMULATOR) {
                    String typeName = XNamedElement.create(member, this, true, isLinterStaticAnalysisMode).getQualifiedName(true);
                    String typeKind = member instanceof IRfInstanceElement ? "instance" : "design";
                    String errorMessage = DVTStringUtil.appendString("Internal error evaluating ", typeKind, " '", member.getName(), "' of type '", typeName, "' (see error log for thrown exceptions)");
                    this.factory.logError(errorMessage);
                    DVTLogger.INSTANCE.logError((Throwable)new Exception(errorMessage));
                }
                return IELParamValue.BLACK_BOX_VALUE;
            }
            if (isInstanceElement && associatedType instanceof IRfListType) {
                memberValue = new XArrayValueHolder(this.factory, XNamedElement.create(associatedType, null, true, isLinterStaticAnalysisMode), this, instanceScope, member.getName());
                ((XArrayValueHolder)memberValue).setElement(member);
            } else if (associatedType.isPredefined() && "chandle".equals(associatedType.getName())) {
                memberValue = this.factory.createValueHolder(XNamedElement.create(associatedType, null, true, isLinterStaticAnalysisMode), null, instanceScope);
                if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                    ((XValueHolder)memberValue).setElement(member);
                }
            } else if (this.factory.getEvaluationGuardian(true).isLinterStaticAnalysisMode() && associatedType instanceof IRfFieldElement && ((IRfFieldElement)associatedType).isTypeParameter()) {
                memberValue = this.createNumericScalarMemberValue(member, this.getBitVectorContext(associatedType), false);
            } else if (!XValueHolderFactory.xIsClass(associatedType, true)) {
                BitVectorContext memberContext = null;
                if (member instanceof IRfListType && member instanceof IRfAssociatedTypeElement || member.getLanguageKind() == LanguageKind.VHDL) {
                    memberContext = ((IRfAssociatedTypeElement)member).getDataTypeBitVectorContext(this, true, null, this.getManager());
                } else if (member.getLanguageKind() == LanguageKind.VLOG) {
                    memberContext = ((IRfAssociatedTypeElement)member).xGetDefaultDataTypeBitVectorContext();
                }
                if (memberContext == null) {
                    memberContext = this.getBitVectorContext(associatedType);
                }
                memberValue = this.createNumericScalarMemberValue(member, memberContext, member instanceof IRfTypeAliasElement);
            }
            if (memberValue == null) {
                XValueHolder enclosing = associatedType instanceof IRfListType || associatedType instanceof IRfCovergroup || associatedType instanceof IRfCompositeTypeElement && (((IRfCompositeTypeElement)associatedType).isStruct() || ((IRfCompositeTypeElement)associatedType).isUnion()) ? this : null;
                memberValue = member.getLanguageKind() == LanguageKind.VHDL ? this.factory.createValueHolder(XNamedElement.create(associatedType, null, ((IRfAssociatedTypeElement)member).xGetVHDLElementConstraints(), true, isLinterStaticAnalysisMode), (IELParamValue)enclosing, instanceScope) : this.factory.createValueHolder(XNamedElement.create(associatedType, null, true, isLinterStaticAnalysisMode), (IELParamValue)enclosing, instanceScope);
                if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                    ((XValueHolder)memberValue).setElement(member);
                }
            }
        } else if (member instanceof IRfConstraintElement) {
            memberValue = this.factory.createValueHolder(XNamedElement.create(member, this, true, isLinterStaticAnalysisMode), (IELParamValue)this, instanceScope);
            if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                ((XValueHolder)memberValue).setElement(member);
            }
        } else if (member instanceof IRfPackageElement || member instanceof IRfDesignElement || member instanceof IRfModportElement || member instanceof IRfClockingBlockElement || member instanceof IRfClassElement) {
            memberValue = this.factory.createStaticValueHolder(XNamedElement.create(member, this, true, isLinterStaticAnalysisMode));
            if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                ((XValueHolder)memberValue).setElement(member);
            }
        } else if (member instanceof IRfCovergroup) {
            memberValue = this.factory.createValueHolder(XNamedElement.create(member, this, true, isLinterStaticAnalysisMode), (IELParamValue)this, instanceScope);
            if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                ((XValueHolder)memberValue).setElement(member);
            }
        } else if (member instanceof IRfActionBlockElement) {
            memberValue = this.factory.createValueHolder(XNamedElement.create(member, this, true, isLinterStaticAnalysisMode), (IELParamValue)this, instanceScope);
            if (!ELUtils.isUnsuccessfulEval(memberValue)) {
                ((XValueHolder)memberValue).setElement(member);
            }
        } else if (member instanceof IRfCompositeTypeElement) {
            BitVectorContext memberContext = this.getBitVectorContext(member);
            memberValue = this.createNumericScalarMemberValue(member, memberContext, member instanceof IRfTypeAliasElement);
        } else if (member instanceof IRfAssertExpectElement) {
            memberValue = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(0));
        }
        return memberValue;
    }

    public ELParamValueScope createMemberValue(IRfNamedElement member) {
        IELParamValue memberValue = this.createValue(member);
        if (ELUtils.isUnsuccessfulEval(memberValue)) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        if (memberValue != null) {
            if (this.isUnknown()) {
                this.factory.getEvaluationGuardian(false).guardValueUpdate(member, null, null, memberValue);
            }
            this.putValue(member.getName(), memberValue);
        }
        if (memberValue instanceof XValueHolder && XValueHolder.isStructOrUnion(memberValue.getNamedElement())) {
            ((XValueHolder)memberValue).initLocalVariables(false);
        }
        return ELParamValueScope.of(memberValue, this, member.getName(), null);
    }

    /*
     * WARNING - void declaration
     */
    protected IELParamValue createNumericScalarMemberValue(IRfNamedElement member, BitVectorContext memberContext, boolean isTypeAlias) {
        void enclosing;
        IRfClassElement iRfClassElement;
        IRfScopeElement iRfScopeElement;
        ELEnumTypeWrapper enumType;
        DVTNumber resultNumber;
        if (memberContext == null || memberContext.isUnpackedStructContext() || memberContext.isUnpackedArrayContext()) {
            return null;
        }
        boolean isVlog = member.getLanguageKind() == LanguageKind.VLOG;
        boolean isParameter = member instanceof IRfFieldElement && ((IRfFieldElement)member).isParameter();
        IRfNamedElement elementType = memberContext.getOrigin();
        IRfNamedElement.NetType netType = XUtils.netType(elementType);
        DVTNumber contextNumber = memberContext.getContextNumber();
        if (contextNumber == null && isParameter) {
            return ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.ZERO));
        }
        if (contextNumber == null) {
            IRfNamedElement contextType = memberContext.getContextType();
            if (contextType == null) {
                this.factory.logError("Fail to create scalar value for '" + member.getName() + "'");
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode() && contextType instanceof IRfTypeElement && ((IRfTypeElement)contextType).isPacked()) {
                return ELParamValues.ParamValueNumber.of(VlogBitVector.copy(VlogBitVector.BIT_UNKNOWN, true, null));
            }
            return null;
        }
        if (contextNumber instanceof VlogBitVector && (netType == IRfNamedElement.NetType.TRI_0 || netType == IRfNamedElement.NetType.TRI_1 || netType == IRfNamedElement.NetType.SUPPLY0 || netType == IRfNamedElement.NetType.SUPPLY1)) {
            resultNumber = VlogBitVector.getNetTypeDefault(netType, (VlogBitVector)contextNumber);
        } else if (contextNumber.is4State() && isVlog) {
            resultNumber = VlogBitVector.copy((VlogBitVector)contextNumber, VlogBitVector.createMaskOfType(member.xGetInitMaskType(), contextNumber.getSize()));
        } else if (contextNumber instanceof VhdlEnum) {
            resultNumber = ((VhdlEnum)contextNumber).copy();
        } else if (contextNumber instanceof VlogBitVector) {
            resultNumber = VlogBitVector.copy((VlogBitVector)contextNumber);
        } else if (contextNumber instanceof VlogShortrealNumber) {
            resultNumber = VlogShortrealNumber.copy((VlogShortrealNumber)contextNumber);
        } else if (contextNumber instanceof VlogRealNumber) {
            resultNumber = VlogRealNumber.copy((VlogRealNumber)contextNumber);
        } else {
            this.factory.logError("Fail to create scalar value for '" + member.getName() + "'");
            return IELParamValue.UNDEFINED_VALUE;
        }
        ELEnumTypeWrapper eLEnumTypeWrapper = enumType = XValueHolder.isEnum(elementType) ? this.factory.createEnumType(elementType) : null;
        if (enumType != null && enumType.getItemValues().isEmpty() && (iRfScopeElement = elementType.getEnclosingScope()) instanceof IRfClassElement && (iRfClassElement = (IRfClassElement)iRfScopeElement) == (IRfClassElement)iRfScopeElement && enclosing instanceof IRfSpecializedTypeElement) {
            enumType.updateValues(enclosing.getLocalElabConstantValues());
        }
        return isTypeAlias ? ELParamValues.ParamValueType.of(memberContext.getContextType(), resultNumber) : ELParamValues.ParamValueNumber.of(resultNumber, member, enumType);
    }

    public BitVectorContext getBitVectorContext(IRfNamedElement potentialFieldOrType) {
        IRfNamedElement origin = this.getElement() != null ? this.getElement() : null;
        ELManager elManager = this.getManager();
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        if (potentialFieldOrType instanceof IRfTypeAliasElement) {
            return ((IRfTypeAliasElement)potentialFieldOrType).getBitVectorContext(this, guardian, origin);
        }
        if (potentialFieldOrType instanceof IRfTypeElement && ELUtils.isVLOG(potentialFieldOrType)) {
            return ((IRfTypeElement)potentialFieldOrType).getBitVectorContext(this, guardian, potentialFieldOrType);
        }
        if (potentialFieldOrType instanceof IRfAssociatedTypeElement) {
            if (guardian.isLinterStaticAnalysisMode() && potentialFieldOrType instanceof IRfFieldElement && ((IRfFieldElement)potentialFieldOrType).isTypeParameter()) {
                return BitVectorContext.of(VlogBitVector.copy(VlogBitVector.BIT_UNKNOWN, true, null), null, potentialFieldOrType);
            }
            return ((IRfAssociatedTypeElement)potentialFieldOrType).getDataTypeBitVectorContext(this, true, null, elManager);
        }
        return null;
    }

    @Override
    public IELParamValue getValueDirectly(String name) {
        IELParamValue result = this.values.getValue(name);
        if (result instanceof XShadowHolder) {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    @Override
    public void putValueDirectly(String name, IELParamValue value) {
        this.values.putValueDirectly(name, value);
    }

    public void putValue(String name, IELParamValue value) {
        this.values.put(name, value);
    }

    @Override
    public IELParamValue getOriginal() {
        return this.original;
    }

    private ELParamValueScope getConstructor(boolean isSuperAccess, XInstValueHolder instanceScope) {
        XNamedElement member = this.getConstructor(instanceScope);
        if (isSuperAccess) {
            if (member != null) {
                return this.factory.createMethodValueHolder(member, this, instanceScope);
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        if (member != null) {
            XValueHolder newValueHolder = (XValueHolder)this.factory.createValueHolder(this.xAssociatedType, this.enclosing, instanceScope);
            newValueHolder.setIsNull(false);
            return this.factory.createMethodValueHolder(member, newValueHolder, instanceScope);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    private XNamedElement getConstructor(XInstValueHolder instanceScope) {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        if (namedElement instanceof IRfMethodElement && this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getConstructor(instanceScope);
        }
        IRfMethodElement localConstructor = namedElement.xGetConstructor();
        if (localConstructor == null) {
            return null;
        }
        return XNamedElement.create(localConstructor, this, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
    }

    protected ELParamValueScope getMethod(String name, IRfNamedElement element, boolean isSuperAccess, XInstValueHolder instanceScope) {
        if (element != null && element.getEnclosingScope() instanceof IRfPackageElement) {
            return this.getMehodSemantic(name, element, instanceScope);
        }
        ELParamValueScope result = this.getMethodMember(name, isSuperAccess, instanceScope);
        if (result == ELParamValueScope.UNDEFINED_VALUE) {
            result = this.getMehodSemantic(name, element, instanceScope);
        }
        return result;
    }

    private ELParamValueScope getMethodMember(String name, boolean isSuperAccess, XInstValueHolder instanceScope) {
        XNamedElement xMethod = this.getMethodMember(this, name, isSuperAccess, instanceScope);
        if (xMethod != null) {
            return this.factory.createMethodValueHolder(xMethod, this, instanceScope);
        }
        if (this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getMethodMember(name, isSuperAccess, instanceScope);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    private XNamedElement getMethodMember(XValueHolder value, String name, boolean isSuperAccess, XInstValueHolder instanceScope) {
        IELParamValue parentValue;
        IXSystemCFactory systemCFactory;
        IXValueHolderFactoryContributor vlogContributor;
        IRfNamedElement namedElement;
        IRfMethodElement methodElement;
        XNamedElement xAssociatedType;
        if (this.refValueHolder != null && !isSuperAccess && XValueHolderFactory.xIsClass(xAssociatedType = value.getXNamedElement()) && this.factory.isVirtual(methodElement = xAssociatedType.getNamedElement().xGetClassMethod(name))) {
            value = value.refValueHolder;
        }
        if ((namedElement = (xAssociatedType = value.xAssociatedType).getNamedElement()) == null) {
            return null;
        }
        IRfMethodElement localMember = namedElement.xGetLocalMethod(name);
        if (localMember == null && (vlogContributor = this.factory.getVlogContributor()) != null && (systemCFactory = vlogContributor.getSystemCFactory()) != null) {
            localMember = systemCFactory.getUserDefinedMethod(name);
        }
        if (localMember != null) {
            return XNamedElement.create(localMember, value, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
        }
        if (XValueHolderFactory.xIsClass(xAssociatedType) && ((IRfClassElement)xAssociatedType.getNamedElement()).xGetParent() != null && (parentValue = XUtils.getValue(value.getSuper(instanceScope))) instanceof XValueHolder) {
            return this.getMethodMember((XValueHolder)parentValue, name, true, instanceScope);
        }
        return null;
    }

    private ELParamValueScope getMehodSemantic(String name, IRfNamedElement element, XInstValueHolder instanceScope) {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        IRfNamedElement member = this.getMemberSemantic(name, element, namedElement);
        if (member instanceof IRfMethodElement) {
            IRfScopeElement memberEnclosingScope = member.getEnclosingScope();
            XValueHolder enclosingScope = null;
            if (memberEnclosingScope != null) {
                while (!(memberEnclosingScope instanceof IRfLibraryElement)) {
                    if (instanceScope != null && memberEnclosingScope == instanceScope.getNamedElement()) {
                        enclosingScope = instanceScope;
                    } else if ((memberEnclosingScope = memberEnclosingScope.getEnclosingScope()) != null) continue;
                    break;
                }
            } else {
                enclosingScope = this;
                while (enclosingScope.enclosing != null) {
                    enclosingScope = (XValueHolder)enclosingScope.enclosing;
                }
            }
            return this.factory.createMethodValueHolder(XNamedElement.create(member, enclosingScope, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), this, instanceScope);
        }
        if (this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getMehodSemantic(name, element, instanceScope);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    private ELParamValueScope getThis() {
        if (XValueHolderFactory.xIsClass(this.xAssociatedType)) {
            return ELParamValueScope.of(this, this);
        }
        if (this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getThis();
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    public ELParamValueScope getSuper(XInstValueHolder instanceScope) {
        if (XValueHolderFactory.xIsClass(this.xAssociatedType)) {
            XNamedElement parent = this.xGetParent();
            if (parent != null) {
                IELParamValue parentValueHolder = this.factory.createValueHolder(parent, this.enclosing, instanceScope);
                ((XValueHolder)parentValueHolder).updateValue((IELParamValue)this, true);
                return ELParamValueScope.of(parentValueHolder, this.enclosing);
            }
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        if (this.enclosing != null) {
            return ((XValueHolder)this.enclosing).getSuper(instanceScope);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    @Override
    public IELParamValue getResult(BitVectorContext context) {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (namedElement instanceof IRfMethodElement) {
            if (((IRfMethodElement)namedElement).isConstructor()) {
                return this.enclosing;
            }
            if (namedElement.isVoid()) {
                return IELParamValue.IMPLICIT_RESULT;
            }
            String name = namedElement.getName();
            ELParamValueScope value = this.getValueImpl(name, null, false, false, true, null);
            return XUtils.getValue(value);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    public XNamedElement xGetParent() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (namedElement == null) {
            return null;
        }
        IRfClassElement parent = namedElement.xGetParent();
        if (parent == null) {
            return null;
        }
        return XNamedElement.create(parent, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
    }

    @Override
    public IELParamValue vlogEq(IELParamValue obj, BitVectorContext context) {
        if (this.isUnknown() || obj.isUnknown()) {
            return IELParamValue.getAmbiguousInContext(context, true);
        }
        if (this.isNull() && obj.isNull()) {
            return IELParamValue.getTrueInContext(context);
        }
        if (this.isNull() || obj.isNull()) {
            return IELParamValue.getFalseInContext(context);
        }
        if (!(obj instanceof XValueHolder)) {
            return IELParamValue.getFalseInContext(context);
        }
        return this.values == ((XValueHolder)obj).values ? IELParamValue.getTrueInContext(context) : IELParamValue.getFalseInContext(context);
    }

    @Override
    public IELParamValue vlogNeq(IELParamValue obj, BitVectorContext context) {
        if (this.isUnknown() || obj.isUnknown()) {
            return IELParamValue.getAmbiguousInContext(context, true);
        }
        if (this.isNull() && obj.isNull()) {
            return IELParamValue.getFalseInContext(context);
        }
        if (this.isNull() || obj.isNull()) {
            return IELParamValue.getTrueInContext(context);
        }
        if (!(obj instanceof XValueHolder)) {
            return IELParamValue.getFalseInContext(context);
        }
        return this.values != ((XValueHolder)obj).values ? IELParamValue.getTrueInContext(context) : IELParamValue.getFalseInContext(context);
    }

    @Override
    public void updateValue(String name, IRfNamedElement element, IELParamValue newResult, boolean asDeclaration) {
        if (XValueHolder.isEnum(this.xAssociatedType.getNamedElement())) {
            this.putValue(name, newResult);
            return;
        }
        IELParamValue value = XUtils.getValue(this.getValueImpl(name, null, false, false, true, null));
        value.updateValue(newResult, this.factory.getEvaluationGuardian(false));
    }

    @Override
    public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
        IRfNamedElement namedElement = this.getNamedElement();
        return this.updateValue(newResult, !XValueHolder.isStructOrUnion(namedElement));
    }

    protected boolean updateValue(IELParamValue newResult, boolean keepRef) {
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        boolean isModified = false;
        if (IELParamValue.NULL_VALUE == newResult) {
            if (!this.isNull) {
                this.isNull = true;
                this.values = ELParamValues.create(XValueHolderFactory.isCaseSensitive(this.xAssociatedType));
                this.uniqueId = this.factory.getUniqueId();
                this.uniqueValuesId = this.factory.getUniqueId();
                this.refValueHolder = null;
                isModified = true;
            }
        } else if (newResult instanceof XValueHolder) {
            XValueHolder xNewResult = (XValueHolder)newResult;
            if (keepRef && xNewResult != this) {
                if (xNewResult.refValueHolder != null) {
                    if (xNewResult.refValueHolder != this) {
                        this.refValueHolder = xNewResult.refValueHolder;
                    }
                } else {
                    this.refValueHolder = xNewResult;
                }
            }
            this.isNull = xNewResult.isNull;
            this.isUnknown = xNewResult.isUnknown;
            this.uniqueValuesId = xNewResult.uniqueValuesId;
            this.isConstraintModeOn = xNewResult.isConstraintModeOn;
            IRfNamedElement namedElement = newResult.getNamedElement();
            if (XValueHolder.isStructOrUnion(namedElement)) {
                Map<String, IELParamValue> entries = xNewResult.values.getEntries();
                AtomicBoolean isModifiedTemp = new AtomicBoolean(false);
                for (Map.Entry<String, IELParamValue> entry : entries.entrySet()) {
                    IELParamValue currentValue = this.values.getValue(entry.getKey());
                    IELParamValue newValue = entry.getValue().copy();
                    if (currentValue != null) {
                        currentValue.doUpdate(null, newValue, 0, isModifiedTemp, this.uniqueId, this, null, guardian);
                        continue;
                    }
                    isModifiedTemp.set(true);
                    this.values.put(entry.getKey(), newValue);
                }
                isModified |= isModifiedTemp.get();
                Iterator<String> iterator = this.values.getEntries().keySet().iterator();
                while (iterator.hasNext()) {
                    if (entries.containsKey(iterator.next())) continue;
                    iterator.remove();
                    isModified |= true;
                }
                this.updateUnion(this);
            } else {
                isModified = this.uniqueId != xNewResult.uniqueId;
                this.values = xNewResult.values;
            }
        } else if (newResult != null && newResult.getDVTNumber() != null && newResult.getDVTNumber().hasUnknownSize()) {
            this.setIsUnknown(true);
        }
        if (this.original instanceof XValueHolder) {
            ((XValueHolder)this.original).updateValue(newResult, keepRef);
        }
        if (isModified |= this.updateProxy()) {
            guardian.callbackValueChanged(this);
        }
        this.factory.scheduleWaitingThreads(this.uniqueId, XSimRegion.XRegionKind.Active);
        return isModified;
    }

    private void updateUnion(XValueHolder structValueHolder) {
        if (structValueHolder.enclosing.isStruct(false)) {
            this.updateUnion((XValueHolder)structValueHolder.enclosing);
            return;
        }
        if (!structValueHolder.enclosing.isUnion()) {
            return;
        }
        XValueHolder unionValueHolder = (XValueHolder)structValueHolder.enclosing;
        block0: for (IELParamValue value : unionValueHolder.values.getEntries().values()) {
            if (value == structValueHolder || !(value instanceof XValueHolder) || !value.isStruct(true)) continue;
            List<ELParamValues.ParamValueNumber> values1 = structValueHolder.getParamValueNumbers();
            List<ELParamValues.ParamValueNumber> values2 = ((XValueHolder)value).getParamValueNumbers();
            Iterator<ELParamValues.ParamValueNumber> iterator1 = values1.iterator();
            Iterator<ELParamValues.ParamValueNumber> iterator2 = values2.iterator();
            ELParamValues.ParamValueNumber r1 = null;
            ELParamValues.ParamValueNumber r2 = null;
            while (iterator1.hasNext() || iterator2.hasNext()) {
                ELParamValues.ParamValueNumber var2;
                ELParamValues.ParamValueNumber var1;
                ELParamValues.ParamValueNumber paramValueNumber = r1 != null ? r1 : (var1 = iterator1.hasNext() ? iterator1.next() : null);
                ELParamValues.ParamValueNumber paramValueNumber2 = r2 != null ? r2 : (var2 = iterator2.hasNext() ? iterator2.next() : null);
                if (var1 == null || var2 == null) continue block0;
                int nofBits1 = var1.getSize();
                int nofBits2 = var2.getSize();
                int nofBits = Math.min(nofBits1, nofBits2);
                ELParamValues.ParamValueNumber v1 = this.getMasked(var1, nofBits);
                ELParamValues.ParamValueNumber v2 = this.getMasked(var2, nofBits);
                v2.updateValue(v1, this.factory.getEvaluationGuardian(false));
                r1 = this.getReminder(var1, nofBits);
                r2 = this.getReminder(var2, nofBits);
            }
        }
    }

    private ELParamValues.ParamValueNumber getReminder(ELParamValues.ParamValueNumber value, int nofBits) {
        if (value.getSize() <= nofBits) {
            return null;
        }
        IELParamValue selectValue = XValueHolderFactory.createSelectProxyValue(nofBits, value.getSize() - 1, value, null, false, false, this.factory.getEvaluationGuardian(true), LanguageKind.VLOG);
        return (ELParamValues.ParamValueNumber)selectValue;
    }

    private ELParamValues.ParamValueNumber getMasked(ELParamValues.ParamValueNumber value, int nofBits) {
        if (value.getSize() <= nofBits) {
            return value;
        }
        IELParamValue selectValue = XValueHolderFactory.createSelectProxyValue(0, nofBits - 1, value, null, false, false, this.factory.getEvaluationGuardian(true), LanguageKind.VLOG);
        return (ELParamValues.ParamValueNumber)selectValue;
    }

    private List<ELParamValues.ParamValueNumber> getParamValueNumbers() {
        ArrayList<ELParamValues.ParamValueNumber> result = new ArrayList<ELParamValues.ParamValueNumber>();
        this.collectParamValueNumbers(result);
        return result;
    }

    private void collectParamValueNumbers(List<ELParamValues.ParamValueNumber> result) {
        if (this.isStruct(false)) {
            for (IELParamValue value : this.values.getEntries().values()) {
                if (value instanceof XValueHolder) {
                    ((XValueHolder)value).collectParamValueNumbers(result);
                    continue;
                }
                result.add((ELParamValues.ParamValueNumber)value);
            }
            return;
        }
        for (IELParamValue value : this.values.getEntries().values()) {
            if (!(value instanceof XValueHolder) || !value.isStruct(true)) continue;
            ((XValueHolder)value).collectParamValueNumbers(result);
            return;
        }
    }

    @Override
    public XValueHolder copy() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (XValueHolder.isStructOrUnion(namedElement)) {
            XValueHolder result = new XValueHolder(this.factory, this.xAssociatedType, this.enclosing, this.instanceScope, this.isStaticHolder(), this.isNull, this.isUnknown);
            Map<String, IELParamValue> entries = this.values.getEntries();
            for (Map.Entry<String, IELParamValue> entry : entries.entrySet()) {
                result.values.put(entry.getKey(), entry.getValue().copy());
            }
            return result;
        }
        return this;
    }

    public XValueHolder partialCopy() {
        XValueHolder result = new XValueHolder(this.factory, this.xAssociatedType, this.enclosing, this.instanceScope, this.isStaticHolder(), this.isNull);
        Map<String, IELParamValue> entries = this.values.getEntries();
        result.values.getEntries().putAll(entries);
        return result;
    }

    @Override
    public XValueHolder shallowCopy() {
        if (XValueHolderFactory.xIsClass(this.xAssociatedType)) {
            XNamedElement xAssociatedType = (this.refValueHolder != null ? this.refValueHolder : this).xAssociatedType;
            XValueHolder result = new XValueHolder(this.factory, xAssociatedType, this.enclosing, this.instanceScope, this.isStaticHolder(), this.isNull, this.isUnknown);
            Map<String, IELParamValue> entries = this.values.getEntries();
            for (Map.Entry<String, IELParamValue> entry : entries.entrySet()) {
                if (entry.getValue() instanceof XValueHolder) {
                    result.values.put(entry.getKey(), entry.getValue());
                    continue;
                }
                result.values.put(entry.getKey(), entry.getValue().scalarCopy());
            }
            return result;
        }
        return this;
    }

    @Override
    public IELParamValue scalarCopy() {
        return IELParamValue.NULL_VALUE;
    }

    public IELParamValue createKeyCopy() {
        XValueHolder result = new XValueHolder(this.factory, this.xAssociatedType, this.enclosing, this.instanceScope, this.isStaticHolder(), this.isNull, this.isUnknown);
        result.values = this.values;
        result.uniqueId = this.uniqueId;
        result.uniqueValuesId = this.uniqueValuesId;
        result.refValueHolder = this.refValueHolder;
        return result;
    }

    protected boolean updateProxy() {
        if (this.selectProxy == null) {
            return false;
        }
        IELParamValue valueBeforeSelect = this.selectProxy.getValueBeforeSelect();
        if (valueBeforeSelect == null) {
            return false;
        }
        return valueBeforeSelect.updateProxyValue(this.selectProxy, this, false);
    }

    @Override
    public IELParamValue createEnclosedValueHolder(IRfNamedElement namedElement) {
        if (this.xAssociatedType.getNamedElement() == namedElement) {
            return this;
        }
        return this.factory.createValueHolder(XNamedElement.create(namedElement, this, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), (IELParamValue)this, this.getInstanceScope());
    }

    @Override
    public ELEnumTypeWrapper createEnumTypeWrapper(IRfNamedElement namedElement) {
        XNamedElement xAssociatedType = XNamedElement.create(namedElement, this, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
        this.factory.createEnclosingStaticValueHolder(xAssociatedType);
        return this.factory.createEnumType(xAssociatedType.getNamedElement());
    }

    public void initLocalVariables(final boolean onlyStaticMembers) {
        final IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(true);
        try {
            IRfPackageElement vhdlPackage;
            Collection<? extends IRfNamedElement> localMembers;
            final IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
            if (!onlyStaticMembers && XValueHolder.isStructOrUnion(namedElement) && (localMembers = namedElement.xGetLocalMembers()) != null && !localMembers.isEmpty()) {
                for (IRfNamedElement iRfNamedElement : localMembers) {
                    if (!(iRfNamedElement instanceof IRfFieldElement)) continue;
                    this.createMemberValue(iRfNamedElement);
                }
            }
            final boolean isInstanceHolder = this instanceof XInstValueHolder;
            final ArrayList arrayList = new ArrayList();
            HidOperatorVisitor visitor = new HidOperatorVisitor(ELConstants.DECLARATION_OPERATOR_QUALIFIERS_ARRAY){

                @Override
                public boolean visitHit(HidOperator operator, IRfNamedElement scope) {
                    IHidObject lhValue = operator.getLHValue();
                    if (!(lhValue instanceof IHid)) {
                        return true;
                    }
                    String name = XUtils.getName((IHid)lhValue);
                    if (onlyStaticMembers && XValueHolder.isEnum(scope)) {
                        IRfNamedElement candidate = scope.xGetMember(name);
                        arrayList.add(HidOperatorElementWrapper.of(operator, this.parserPath, candidate));
                    } else {
                        boolean isClockingOrModport;
                        IHidObject lhSide;
                        IRfNamedElement candidate = scope.xGetMember(name);
                        if (!(candidate instanceof IRfFieldElement)) {
                            return true;
                        }
                        if (isInstanceHolder) {
                            if (onlyStaticMembers && ((IRfFieldElement)candidate).isParameter() && XValueHolder.this.values.getValue(name) == null) {
                                XValueHolder.this.factory.logWarning("'" + name + "' parameter value is unknown (re-evaluate)", candidate.getDeclaration());
                                arrayList.add(HidOperatorElementWrapper.of(operator, this.parserPath, candidate));
                            }
                            if (onlyStaticMembers && ((IRfFieldElement)candidate).isConst()) {
                                arrayList.add(HidOperatorElementWrapper.of(operator, this.parserPath, candidate));
                            }
                            return true;
                        }
                        if (((IRfFieldElement)candidate).isTypeParameter()) {
                            return true;
                        }
                        if (((IRfFieldElement)candidate).isGenvar()) {
                            return true;
                        }
                        boolean isLinterStaticAnalysisMode = guardian.isLinterStaticAnalysisMode();
                        if (((IRfFieldElement)candidate).isParameter()) {
                            IRfNamedElement genericNamedElement;
                            if (!isLinterStaticAnalysisMode && ((IRfFieldElement)candidate).isInParameterPortList()) {
                                return true;
                            }
                            IRfNamedElement iRfNamedElement = genericNamedElement = namedElement instanceof IRfSpecializedTypeElement ? ((IRfSpecializedTypeElement)namedElement).getGenericElement() : namedElement;
                            if (candidate.getEnclosingScope() != genericNamedElement) {
                                return true;
                            }
                            IELParamValue existingValue = XValueHolder.this.values.getValueDirectly(candidate.getName());
                            if (existingValue != null && !(existingValue.getDVTNumber() instanceof DVTUnpackedArray) && !(existingValue.getDVTNumber() instanceof DVTUnpackedStruct)) {
                                return true;
                            }
                        }
                        if (isLinterStaticAnalysisMode && (lhSide = operator.getLHValue()) instanceof HidImplicit) {
                            operator = operator.shallowCopy();
                            operator.setLHValue(((IRfFieldElement)candidate).xMakeHid(operator.getOccurrence()));
                        }
                        boolean bl = isClockingOrModport = scope instanceof IRfClockingBlockElement || scope instanceof IRfModportElement;
                        if (!(onlyStaticMembers && candidate.xIsStaticMember() && candidate instanceof IRfPortElement && isClockingOrModport)) {
                            if (onlyStaticMembers && candidate.xIsStaticMember() && !MethodCallUtils.isValidMethodArgument(candidate)) {
                                arrayList.add(HidOperatorElementWrapper.of(operator, this.parserPath, candidate));
                            } else if (!onlyStaticMembers && !candidate.xIsStaticMember()) {
                                arrayList.add(HidOperatorElementWrapper.of(operator, this.parserPath, candidate));
                            }
                        }
                    }
                    return true;
                }
            };
            this.visitHidObjectsLocalAndEnums(visitor, namedElement, onlyStaticMembers);
            if (namedElement instanceof IRfPackageElement && ((IRfPackageElement)namedElement).isPackageBody() && (vhdlPackage = ((IRfPackageElement)namedElement).getPackage()) != null) {
                this.visitHidObjectsLocalAndEnums(visitor, vhdlPackage, onlyStaticMembers);
            }
            Collections.sort(arrayList, INIT_ASSIGN_WRAPPER_COMPARATOR);
            final Map<String, IELParamValue> entries = this.values.getEntries();
            final XValueHolder evaluator = this;
            if (arrayList.isEmpty()) {
                return;
            }
            IRfNamedElement enclosingNamedElement = this.getNamedElement();
            if (!(enclosingNamedElement instanceof IRfActionBlockElement)) {
                guardian.callbackStartInitVars(onlyStaticMembers);
            }
            if (onlyStaticMembers) {
                String name;
                for (final HidOperatorElementWrapper operatorWrapper : arrayList) {
                    name = operatorWrapper.element.getName();
                    entries.put(name, new XUninitValue(){

                        @Override
                        public void evaluate() {
                            entries.remove(name);
                            XValueHolder.this.initEvaluateAssign(onlyStaticMembers, operatorWrapper, evaluator, guardian);
                        }
                    });
                }
                for (final HidOperatorElementWrapper operatorWrapper : arrayList) {
                    name = operatorWrapper.element.getName();
                    IELParamValue existingValue = entries.get(name);
                    if (!(existingValue instanceof XUninitValue)) continue;
                    entries.remove(name);
                    this.initEvaluateAssign(onlyStaticMembers, operatorWrapper, evaluator, guardian);
                }
            } else {
                for (HidOperatorElementWrapper operatorWrapper : arrayList) {
                    this.initEvaluateAssign(onlyStaticMembers, operatorWrapper, evaluator, guardian);
                }
            }
            if (!(enclosingNamedElement instanceof IRfActionBlockElement)) {
                guardian.callbackEndInitVars(onlyStaticMembers);
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            if (guardian.isLinterStaticAnalysisMode()) {
                throw e;
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void initEvaluateAssign(boolean onlyStaticMembers, HidOperatorElementWrapper operatorWrapper, XValueHolder evaluator, IHidEvaluationGuardian guardian) {
        HidOperator operator = (HidOperator)operatorWrapper.hidObject;
        IRfNamedElement candidate = operatorWrapper.element;
        BitVectorContext noContext = ELUtils.makeEvaluatorContext(evaluator, candidate, null, this.getManager());
        XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, evaluator, noContext, guardian, operator, operatorWrapper.path, String.valueOf(onlyStaticMembers ? "init static var" : "init var") + " of " + evaluator.toNiceString(null, 10, false, false), true);
        XThread xThread = guardian.getActiveThread();
        try {
            guardian.startEvalScope(xEvalScope);
            guardian.callbackStartStatement(xThread, operator);
            IRfNamedElement namedElement = this.getNamedElement();
            if (onlyStaticMembers && candidate instanceof IRfFieldElement && ((IRfFieldElement)candidate).isEnumElement()) {
                IELParamValue value;
                ListContainer<IHidObject> valueHidObjects = operator.getRHValues();
                if (valueHidObjects == null || valueHidObjects.isEmpty()) {
                    return;
                }
                ELParamValues elabValues = this.getFactory().getManager().getExternalConstants(namedElement);
                IELParamValue elabValue = elabValues != null ? elabValues.getValue(candidate.getName()) : null;
                ELEnumTypeWrapper enumType = evaluator.createEnumTypeWrapper(((IRfFieldElement)candidate).getParentEnumType());
                IHidObject valueHidObject = valueHidObjects.get(0);
                IELParamValue iELParamValue = value = elabValue != null ? elabValue : XUtils.getValue(ELUtils.evaluate(valueHidObject, evaluator, noContext, guardian.copy()));
                if (ELUtils.isUnsuccessfulEval(value)) {
                    guardian.logError("Fail to evaluate '" + operator + "' in scope of '" + evaluator + "' (id:0008)");
                }
                value = ELParamValues.ParamValueNumber.of(value.getDVTNumber(), candidate, enumType);
                enumType.updateItemValue(candidate.getName(), value);
                this.values.put(candidate.getName(), value);
            } else {
                IELParamValue elabValue;
                ELParamValues elabValues = namedElement instanceof IRfPackageElement || namedElement instanceof IRfLibraryElement ? this.getFactory().getManager().getExternalConstants(namedElement) : null;
                IELParamValue iELParamValue = elabValue = elabValues != null ? elabValues.getValue(candidate.getName()) : null;
                if (elabValue != null && !(elabValue.getDVTNumber() instanceof DVTUnpackedArray) && !(elabValue.getDVTNumber() instanceof DVTUnpackedStruct)) {
                    return;
                }
                ELParamValueScope valueScope = ELUtils.evaluate(operator, evaluator, noContext, guardian.copy());
                if (ELUtils.isUnsuccessfulEval(valueScope)) {
                    guardian.logError("Fail to evaluate '" + operator + "' in scope of '" + evaluator + "' (id:0009)");
                }
            }
        }
        finally {
            guardian.callbackEndStatement(xThread, operator);
            guardian.endEvalScope(xEvalScope);
        }
    }

    private final boolean visitHidObjectsLocalAndEnums(IHidVisitor<?> visitor, IRfNamedElement visitNamedElement, boolean allowDepthEnumSearch) {
        if (visitNamedElement instanceof IRfCovergroup) {
            return true;
        }
        IHidHolder hidHolder = visitNamedElement.getHidHolder();
        if (visitNamedElement instanceof IRfSpecializedTypeElement) {
            hidHolder = ((IRfSpecializedTypeElement)visitNamedElement).getGenericElement().getHidHolder();
        }
        try {
            Collection<? extends IRfNamedElement> members;
            if (hidHolder != null) {
                hidHolder.visitHidObject(null, visitor);
            }
            if ((members = visitNamedElement.xGetLocalMembers()) != null) {
                for (IRfNamedElement iRfNamedElement : members) {
                    if (!XValueHolder.isEnum(iRfNamedElement) && (!allowDepthEnumSearch || !XValueHolder.isStructOrUnion(iRfNamedElement))) continue;
                    iRfNamedElement.visitHidObject(null, visitor);
                }
            }
        }
        catch (OperationCanceledException | BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    @Override
    public IRfNamedElement getNamedElement() {
        return (this.refValueHolder != null ? this.refValueHolder : this).xAssociatedType.getNamedElement();
    }

    @Override
    public String getDebuggerTypeName(boolean isFormal) {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (namedElement != null && (isFormal || this.refValueHolder == null)) {
            if (this instanceof XInstValueHolder && namedElement instanceof IRfDesignElement) {
                return namedElement.getName();
            }
            return this.xAssociatedType.getQualifiedName(false);
        }
        if (this.refValueHolder == null) {
            return "N/A";
        }
        namedElement = this.refValueHolder.xAssociatedType.getNamedElement();
        if (namedElement != null) {
            if (this.refValueHolder instanceof XInstValueHolder && namedElement instanceof IRfDesignElement) {
                return namedElement.getName();
            }
            return this.refValueHolder.xAssociatedType.getQualifiedName(false);
        }
        return "N/A";
    }

    @Override
    public boolean isNull() {
        return this.isNull && !XValueHolder.isStructOrUnion(this.getNamedElement());
    }

    @Override
    public boolean isUnknown() {
        return this.isUnknown;
    }

    @Override
    public void setIsNull(boolean isNull) {
        this.isNull = isNull && !this.isUnknown;
    }

    public void setIsUnknown(boolean isUnknown) {
        this.isNull = false;
        this.isUnknown = isUnknown;
        if (isUnknown) {
            this.values.getEntries().clear();
        }
        this.updateProxy();
    }

    @Override
    public ELManager getManager() {
        return this.factory.getManager();
    }

    public String toStringConfigDB() {
        return this.refValueHolder != null ? this.refValueHolder.toStringConfigDB() : this.xAssociatedType.getQualifiedName(true);
    }

    @Override
    public String toStringRadix(int radix) {
        return this.toNiceString(null, radix, false, false);
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (XValueHolder.isStructOrUnion(namedElement)) {
            StringBuilder result = new StringBuilder("'{");
            Collection<? extends IRfNamedElement> fields = namedElement.xGetLocalMembers();
            for (IRfNamedElement iRfNamedElement : fields) {
                if (result.length() > 2) {
                    result.append(", ");
                }
                IELParamValue fieldValue = this.getValueDirectly(iRfNamedElement.getName());
                result.append(iRfNamedElement.getName());
                if (fieldValue == null) {
                    result.append(":'hx");
                    continue;
                }
                if (fieldValue instanceof ELParamValues.ParamValueNumber && !fieldValue.isString()) {
                    result.append(":'h");
                    XUtils.stripLeadingZeroes(result, fieldValue.toStringRadix(16));
                    continue;
                }
                result.append(":").append(fieldValue.toStringRadix(16));
            }
            result.append("}");
            return result.toString();
        }
        return this.toUniqueString(true);
    }

    public String toString() {
        if (this.refValueHolder != null && this.refValueHolder != this) {
            return String.valueOf(this.internalUniqueString(true)) + " -> " + this.refValueHolder.internalUniqueString(true);
        }
        return this.internalUniqueString(true);
    }

    public String toUniqueString(boolean isFullQualified) {
        if (this.refValueHolder != null && this.refValueHolder != this) {
            return this.refValueHolder.toUniqueString(isFullQualified);
        }
        return this.internalUniqueString(isFullQualified);
    }

    @Override
    public int getSize() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (!XValueHolder.isStructOrUnion(namedElement)) {
            return -1;
        }
        int resultSize = 0;
        Collection<? extends IRfNamedElement> fields = namedElement.xGetLocalMembers();
        for (IRfNamedElement iRfNamedElement : fields) {
            IELParamValue fieldValue = XUtils.getValue(this.getValueImpl(iRfNamedElement.getName(), iRfNamedElement, false, false, true, null));
            int size = fieldValue.getSize();
            if (size < 0) {
                this.factory.logError("Fail to get size of '" + fieldValue + "'");
                return -1;
            }
            resultSize += size;
        }
        return resultSize;
    }

    private String internalUniqueString(boolean isFullQualified) {
        return (this instanceof XInstValueHolder ? ((XInstValueHolder)this).getInstancePath() : this.xAssociatedType.getQualifiedName(isFullQualified)) + '@' + this.uniqueValuesId + (this.isStaticHolder() ? "S" : "") + (this.isNull() ? "-NULL" : "") + (this.isUnknown() ? "-UNKNOWN" : "");
    }

    public int uniqueId() {
        return this.uniqueId;
    }

    public XNamedElement getXNamedElement() {
        return this.xAssociatedType;
    }

    public void setRandMode(String name, IELParamValue value) {
        boolean isRand;
        boolean bl = isRand = !ELUtils.isFalse(value);
        if ("this".equals(name)) {
            IRfNamedElement namedElement = this.getNamedElement();
            while (namedElement instanceof IRfClassElement) {
                Collection<? extends IRfNamedElement> members = namedElement.xGetLocalMembers();
                if (members != null && !members.isEmpty()) {
                    for (IRfNamedElement iRfNamedElement : members) {
                        if (!(iRfNamedElement instanceof IRfFieldElement) || !iRfNamedElement.isRand() && !iRfNamedElement.isRandc()) continue;
                        this.factory.setRandMode(this.uniqueValuesId, iRfNamedElement.getName(), isRand);
                    }
                }
                namedElement = namedElement.xGetParent();
            }
        }
        this.factory.setRandMode(this.uniqueValuesId, name, isRand);
    }

    public boolean getRandMode(String name, boolean isRand) {
        return this.factory.getRandMode(this.uniqueValuesId, name, isRand);
    }

    @Override
    public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
        Map<DVTXVariableInfo, IELParamValue> enclosingVariables;
        TreeMap<DVTXVariableInfo, IELParamValue> result = new TreeMap<DVTXVariableInfo, IELParamValue>((o1, o2) -> {
            DVTXVariableType o2Type;
            if (o1 == null || o2 == null) {
                return 0;
            }
            DVTXVariableType o1Type = o1.getVariableType();
            if (o1Type == (o2Type = o2.getVariableType())) {
                return o1.getVariableName().compareTo(o2.getVariableName());
            }
            return o1Type.compareTo(o2Type);
        });
        int instCount = 0;
        if (this.getNamedElement() instanceof IRfInterface && this.refValueHolder != null && this.refValueHolder.instanceScope != null) {
            result.put(new DVTXVariableInfo(XUtils.prefix(this.refValueHolder.instanceScope.path.lastSegment(), instCount++), DVTXVariableType.PARENT), this.refValueHolder.instanceScope);
            if (isBreakOnFirst) {
                return result;
            }
        }
        if (this.isStatic && this.getNamedElement().xIsClass(true)) {
            XValueHolder parentValueHolder;
            XNamedElement xParentElement = this.xGetParent();
            if (xParentElement != null && (parentValueHolder = this.factory.getStaticValueHolder(xParentElement)) != null) {
                result.putAll(parentValueHolder.debuggerGetVariables(isFirstStackFrame, isBreakOnFirst));
            }
            if (isBreakOnFirst && !result.isEmpty()) {
                return result;
            }
            this.debuggerCollectVariables(result, isBreakOnFirst, true);
            if (isBreakOnFirst && !result.isEmpty()) {
                return result;
            }
        } else {
            this.debuggerCollectVariables(result, isBreakOnFirst, false);
            if (isBreakOnFirst && !result.isEmpty()) {
                return result;
            }
            if (this.staticHolder != null && (!(this.xAssociatedType.getNamedElement() instanceof IRfMethodElement) || this.enclosing == null || ((XValueHolder)this.enclosing).isStaticHolder())) {
                result.putAll(this.staticHolder.debuggerGetVariables(isFirstStackFrame, isBreakOnFirst));
            }
            if (isBreakOnFirst && !result.isEmpty()) {
                return result;
            }
        }
        IRfNamedElement associatedType = this.xAssociatedType.getNamedElement();
        if (this.enclosing != null && (isFirstStackFrame && associatedType instanceof IRfActionBlockElement || this.hasForkBlockEnclosing())) {
            enclosingVariables = this.enclosing.debuggerGetVariables(isFirstStackFrame, isBreakOnFirst);
            for (Map.Entry<DVTXVariableInfo, IELParamValue> enclosingVariable : enclosingVariables.entrySet()) {
                result.putIfAbsent(enclosingVariable.getKey(), enclosingVariable.getValue());
            }
        }
        if (!(associatedType instanceof IRfMethodElement)) {
            return result;
        }
        if (this.enclosing != null && !((XValueHolder)this.enclosing).isStaticHolder()) {
            result.put(new DVTXVariableInfo("this", DVTXVariableType.THIS), this.enclosing);
            if (isBreakOnFirst) {
                return result;
            }
        } else if (this.enclosing != null && ((XValueHolder)this.enclosing).getInstanceScope() != this) {
            enclosingVariables = ((XValueHolder)this.enclosing).debuggerGetVariables(isFirstStackFrame, isBreakOnFirst);
            for (Map.Entry<DVTXVariableInfo, IELParamValue> enclosingVariable : enclosingVariables.entrySet()) {
                result.putIfAbsent(enclosingVariable.getKey(), enclosingVariable.getValue());
            }
        }
        return result;
    }

    private void debuggerCollectVariables(Map<DVTXVariableInfo, IELParamValue> result, boolean isBreakOnFirst, boolean staticVisualDecoration) {
        Map<String, IELParamValue> entries = this.values.getEntries();
        for (Map.Entry<String, IELParamValue> entry : entries.entrySet()) {
            Collection<IELParamValue> enumMemberValues;
            IRfNamedElement element;
            IELParamValue value = entry.getValue();
            IRfNamedElement namedElement = value.getNamedElement();
            if (namedElement instanceof IRfActionBlockElement || namedElement instanceof IRfBlockElement || namedElement instanceof IRfMethodElement || XValueHolder.isStructOrUnion(element = value.getElement()) || XUtils.isInternalSignal(entry.getKey())) continue;
            boolean isEnumMember = false;
            ELEnumTypeWrapper enumType = value.getEnumTypeWrapper();
            if (element != null && enumType != null && (enumMemberValues = enumType.getItemValues()) != null && !enumMemberValues.isEmpty()) {
                for (IELParamValue enumMemberValue : enumMemberValues) {
                    if (!element.equals(enumMemberValue.getElement())) continue;
                    DVTXVariableInfo varInfo = new DVTXVariableInfo(element.getName(), DVTXVariableType.NO_TYPE);
                    if (result.containsKey(varInfo)) {
                        result.remove(varInfo);
                    }
                    isEnumMember = true;
                    break;
                }
                if (isEnumMember) continue;
            }
            if (staticVisualDecoration && (element != null && element.xIsStaticMember() || value instanceof ELParamValues.ParamValueType || value instanceof XUninitValue)) {
                result.put(new DVTXVariableInfo(entry.getKey(), DVTXVariableType.STATIC), value);
            } else if (element instanceof IRfPortElement && element.getEnclosingScope() instanceof IRfClockingBlockElement && ((IRfPortElement)element).isInout() && entry.getKey().endsWith("<in_")) {
                result.put(new DVTXVariableInfo(element.getName(), DVTXVariableType.NO_TYPE), value);
            } else {
                result.put(new DVTXVariableInfo(entry.getKey(), DVTXVariableType.NO_TYPE), value);
            }
            if (!isBreakOnFirst) continue;
            return;
        }
    }

    private boolean hasForkBlockEnclosing() {
        IRfNamedElement temp = this.xAssociatedType == null ? null : this.xAssociatedType.getNamedElement();
        while (temp instanceof IRfActionBlockElement) {
            if (((IRfActionBlockElement)temp).hasForkJoin()) {
                return true;
            }
            temp = (IRfNamedElement)temp.getEnclosingScope();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IELParamValue debuggerGetVariable(String variableName, IRfNamedElement element) {
        try {
            if (variableName == null || variableName.startsWith("$")) {
                return null;
            }
            String[] variables = DVTStringUtil.split(".", variableName);
            IELParamValue variableScope = this;
            int i = 0;
            while (true) {
                if (i >= variables.length) {
                    if (!(variableScope.getElement() instanceof IRfMethodElement)) break;
                    return null;
                }
                if (!(variableScope instanceof XValueHolder)) {
                    return null;
                }
                String variable = variables[i];
                ELParamValueScope value = variableScope.getValueImpl(variable, i == variables.length - 1 ? element : null, false, false, false, null);
                if (ELUtils.isUnsuccessfulEval(value)) {
                    return null;
                }
                variableScope = XUtils.getValue(value);
                ++i;
            }
            return variableScope;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IELParamValue newHolder() {
        return this.factory.createValueHolder(this.getXNamedElement(), this.enclosing, this.getInstanceScope());
    }

    @Override
    public String debuggerGetValueString(String variableName, IELParamValue variableValue) {
        ELEnumTypeWrapper enumType;
        IRfNamedElement associatedType;
        IRfNamedElement member;
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        IRfNamedElement iRfNamedElement = member = variableValue.getElement() != null ? variableValue.getElement() : namedElement.xGetMember(variableName);
        if (member instanceof IRfAssociatedTypeElement && (associatedType = ((IRfAssociatedTypeElement)member).getAssociatedType()) instanceof IRfAssociatedTypeElement && !(associatedType instanceof IRfListType) && XValueHolder.isEnum(associatedType = ((IRfAssociatedTypeElement)associatedType).xGetAssociatedType(this)) && (enumType = this.createEnumTypeWrapper(associatedType)) != null) {
            DVTNumber number = variableValue.getDVTNumber();
            if (DVTNumber.isUndefined(number)) {
                return IELParamValue.super.debuggerGetValueString(variableName, variableValue);
            }
            IELParamValue enumStringValue = enumType.getItemValue(variableValue.toNiceString(null, 2, false, false));
            if (enumStringValue != null) {
                return enumStringValue.toNiceString(null, -2, false, false);
            }
        }
        return IELParamValue.super.debuggerGetValueString(variableName, variableValue);
    }

    /*
     * WARNING - void declaration
     */
    public static IRfClassElement getOriginClassScope(IRfNamedElement element) {
        void classEnclosing;
        IRfClassElement iRfClassElement;
        void classElement;
        void var3_1;
        IRfClassElement iRfClassElement2;
        IRfNamedElement iRfNamedElement = element;
        return iRfNamedElement instanceof IRfClassElement && (iRfClassElement2 = (IRfClassElement)iRfNamedElement) == (IRfClassElement)var3_1 ? classElement.getGenericClass() : (( instanceOfPatternExpressionValue = element.getEnclosingScope()) instanceof IRfClassElement && (iRfClassElement = (IRfClassElement) instanceOfPatternExpressionValue) == (IRfClassElement) instanceOfPatternExpressionValue ? classEnclosing.getGenericClass() : null);
    }

    @Override
    public boolean isInterpreter() {
        return IELParamValue.super.isInterpreter();
    }

    public boolean hasMember(String name) {
        return this.factory.hasMember(this.getNamedElement(), name);
    }

    public ParserPath getParserPath() {
        return XUtils.getParserPath(this.getNamedElement(), null);
    }

    public ElementPath getInstancePath() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (this.enclosing instanceof XValueHolder && namedElement.isAnonymous()) {
            return ((XValueHolder)this.enclosing).getInstancePath();
        }
        if (this.isStaticHolderPath()) {
            return ElementPath.create(new String[]{String.valueOf(namedElement.getName()) + "::"});
        }
        ElementPath prefixPath = null;
        if (this.enclosing != null && !(((XValueHolder)this.enclosing).getNamedElement() instanceof IRfSingleLangProject)) {
            prefixPath = ((XValueHolder)this.enclosing).getInstancePath();
        }
        String path = this.getTypeSignature();
        if (prefixPath == null && path == null) {
            return ElementPath.EMPTY_PATH;
        }
        if (prefixPath == null) {
            return ElementPath.join(null, path);
        }
        if (path == null) {
            return prefixPath;
        }
        return ElementPath.join(prefixPath, path);
    }

    protected String getTypeSignature() {
        IRfNamedElement namedElement = this.getNamedElement();
        return namedElement.getName();
    }

    private boolean isStaticHolderPath() {
        if (!this.isStaticHolder()) {
            return false;
        }
        if (this.enclosing == null) {
            return false;
        }
        IRfNamedElement namedElement = ((XValueHolder)this.enclosing).getNamedElement();
        if (namedElement instanceof IRfLibraryElement) {
            return true;
        }
        if (namedElement instanceof IRfPackageElement) {
            return true;
        }
        if (namedElement instanceof IRfInstanceElement) {
            return false;
        }
        if (namedElement instanceof IRfDesignElement) {
            return false;
        }
        return ((XValueHolder)this.enclosing).isStaticHolderPath();
    }

    public IELParamValue getInstanceValue(String instanceName) {
        XInstValueHolder instanceScope = this.getInstanceScope();
        if (instanceScope != null) {
            return instanceScope.getInstanceValue(instanceName);
        }
        return null;
    }

    @Override
    public void xSystemCPackValue(IRfNamedElement typeElement, int options, MessagePacker buffer, boolean preSpecifyMaker) throws Exception {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (!(namedElement instanceof IRfCompositeTypeElement) || namedElement instanceof IRfCompositeTypeElement && !((IRfCompositeTypeElement)namedElement).isStruct()) {
            return;
        }
        Collection<? extends IRfNamedElement> structMembers = namedElement.xGetLocalMembers();
        for (IRfNamedElement iRfNamedElement : structMembers) {
            if (!(iRfNamedElement instanceof IRfFieldElement)) {
                throw new IllegalStateException("Unknown field type in fields list " + iRfNamedElement);
            }
            IELParamValue memberValue = this.getValueDirectly(iRfNamedElement.getName());
            IRfNamedElement memeberType = IXDPICUtils.getTranslatedType(((IRfAssociatedTypeElement)iRfNamedElement).getResolvedType(true));
            if (memeberType == null) {
                throw new UnknownMethodEvaluationException("Unable to pack field '" + iRfNamedElement.getName() + "' of struct '" + namedElement.getName() + "'");
            }
            memberValue.xSystemCPackValue(memeberType, options, buffer, preSpecifyMaker);
        }
    }

    public String computeCStructName() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        if (!(namedElement instanceof IRfCompositeTypeElement) || namedElement instanceof IRfCompositeTypeElement && !((IRfCompositeTypeElement)namedElement).isStruct()) {
            return null;
        }
        String name = this.xAssociatedType.getQualifiedName(0);
        String enclosingScope = namedElement.getEnclosingScope().getName();
        return String.valueOf(enclosingScope) + "__" + name;
    }

    public boolean hasValue(String name) {
        return this.values != null && this.values.containsKey(name);
    }

    public int uniqueValuesId() {
        return this.uniqueValuesId;
    }

    public XValueHolder getStaticHolder() {
        return this.staticHolder;
    }

    public ELInstance getElInstance() {
        if (this.instanceScope != null) {
            return this.instanceScope.getElInstance();
        }
        this.instanceScope = this.getInstanceScope();
        if (this.instanceScope != null) {
            return this.instanceScope.getElInstance();
        }
        return null;
    }

    @Override
    public boolean isDVTNumber() {
        return false;
    }

    @Override
    public boolean hasUnknownSize() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (XValueHolder.isStructOrUnion(namedElement)) {
            return ((IRfCompositeTypeElement)namedElement).isPacked();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DVTNumber getDVTNumber() {
        try {
            void var11_19;
            void var9_11;
            IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
            if (!XValueHolder.isStructOrUnion(namedElement)) return DVTNumber.UNDEFINED;
            boolean isPacked = ((IRfCompositeTypeElement)namedElement).isPacked();
            boolean isUnion = ((IRfCompositeTypeElement)namedElement).isUnion();
            boolean hasUnknownSize = false;
            int totalSize = 0;
            int memberSize = 0;
            LinkedHashMap<String, StructMemberContextInfo> membersInfo = new LinkedHashMap<String, StructMemberContextInfo>();
            LinkedHashMap<String, DVTNumber> membersByName = new LinkedHashMap<String, DVTNumber>();
            VlogBitVector vlogBitVector = VlogBitVector.BIT_ZERO;
            Collection<? extends IRfNamedElement> fields = namedElement.xGetLocalMembers();
            for (IRfNamedElement iRfNamedElement : fields) {
                BitVectorContext memberContext = this.getBitVectorContext(iRfNamedElement);
                membersInfo.put(iRfNamedElement.getName(), new StructMemberContextInfo(totalSize, iRfNamedElement.getName(), memberContext));
                IELParamValue fieldValue = this.getValueDirectly(iRfNamedElement.getName());
                VlogBitVector tempOp = VlogBitVector.ZERO;
                if (ELUtils.isUnsuccessfulEval(fieldValue)) {
                    if (memberContext == null || !(memberContext.getContextNumber() instanceof VlogBitVector)) return DVTNumber.UNDEFINED;
                    tempOp = (VlogBitVector)memberContext.getContextNumber();
                    hasUnknownSize |= tempOp.hasUnknownSize();
                    memberSize = tempOp.getSize();
                } else if (isPacked) {
                    DVTNumber dvtNumber = fieldValue.getDVTNumber();
                    if (dvtNumber instanceof VlogBitVector) {
                        tempOp = (VlogBitVector)dvtNumber;
                    }
                    hasUnknownSize |= fieldValue.hasUnknownSize();
                    memberSize = fieldValue.getSize();
                    DVTNumber dVTNumber2 = DVTNumber.shiftLeft((DVTNumber)var9_11, tempOp.getSize(), totalSize + memberSize);
                    dVTNumber2 = DVTNumber.or(dVTNumber2, tempOp);
                } else {
                    DVTNumber fieldNumberValue = fieldValue.getDVTNumber();
                    membersByName.put(iRfNamedElement.getName(), fieldNumberValue);
                    hasUnknownSize |= fieldNumberValue.hasUnknownSize();
                    memberSize = fieldNumberValue.getSize();
                }
                if (isUnion) continue;
                totalSize += memberSize;
            }
            if (!isPacked) return new DVTUnpackedStruct(membersInfo, membersByName, isUnion);
            int[] nArray = new int[2];
            nArray[0] = isUnion ? memberSize - 1 : totalSize - 1;
            VlogBitVector vlogBitVector2 = VlogBitVector.create(((IRfCompositeTypeElement)namedElement).getSign() == 1, isUnion ? memberSize - 1 : totalSize - 1, 0, nArray, false, false, isUnion, false, membersInfo, var9_11.getMasks(), var9_11.bigIntegerValue());
            if (!hasUnknownSize) return var11_19;
            VlogBitVector vlogBitVector3 = VlogBitVector.copy(vlogBitVector2, true, null);
            return var11_19;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return DVTNumber.UNDEFINED;
        }
    }

    public List<XInstValueHolder.XEvalOverrideHid> getCbOutputPorts(String intfSignalName, int offset, int line) {
        return Collections.emptyList();
    }

    public String getVarName(boolean isAppendLast) {
        return this.toUniqueString(true);
    }

    private static class HidOperatorElementWrapper
    extends HidObjectWrapper<HidOperator> {
        private IRfNamedElement element;

        private HidOperatorElementWrapper(HidOperator hidObject, ParserPath path, IRfNamedElement element) {
            super(hidObject, path);
            this.element = element;
        }

        public static HidOperatorElementWrapper of(HidOperator hidObject, ParserPath path, IRfNamedElement element) {
            return new HidOperatorElementWrapper(hidObject, path, element);
        }
    }

    public static class XEventValueHolder
    extends XValueHolder {
        private BigDecimal[] triggerTimestamp = new BigDecimal[]{XUtils.MINUS_ONE_DECIMAL};
        private int[] triggerCount = new int[1];

        public XEventValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
            super(factory, xAssociatedType, enclosing, instanceScope, false, false);
        }

        @Override
        protected boolean updateValue(IELParamValue newResult, boolean keepRef) {
            boolean isModified = false;
            if (IELParamValue.NULL_VALUE == newResult) {
                isModified = this.triggerCount[0] != 0 || this.triggerTimestamp[0] != XUtils.MINUS_ONE_DECIMAL;
                this.triggerCount[0] = 0;
                this.triggerTimestamp[0] = XUtils.MINUS_ONE_DECIMAL;
            } else {
                isModified = this.triggerCount[0] != ((XEventValueHolder)newResult).triggerCount[0] || this.triggerTimestamp[0] != ((XEventValueHolder)newResult).triggerTimestamp[0];
                this.triggerCount = ((XEventValueHolder)newResult).triggerCount;
                this.triggerTimestamp = ((XEventValueHolder)newResult).triggerTimestamp;
            }
            return isModified |= super.updateValue(newResult, keepRef);
        }

        @Override
        public ELParamValueScope getValue(IHid hid, IHidEvaluator hidEvaluator, BitVectorContext context, boolean isMethod, IHidEvaluationGuardian guardian) {
            return super.getValueImpl(XUtils.getName(hid), hid.getElement(), false, isMethod, true, guardian);
        }

        public void trigger() {
            this.triggerCount[0] = this.triggerCount[0] + 1;
            this.triggerTimestamp[0] = this.factory.getCurrentSimTime();
            this.factory.scheduleWaitingThreads(this.uniqueId, XSimRegion.XRegionKind.Active);
        }

        @Override
        public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
            if (!isMethod && "triggered".equals(name)) {
                return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(this.isTriggered() ? VlogBitVector.BIT_ONE : VlogBitVector.BIT_ZERO), this);
            }
            return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(this.getDVTNumber()), this);
        }

        public boolean isTriggered() {
            if (this.isNull()) {
                return false;
            }
            BigDecimal currentSimTime = this.factory.getCurrentSimTime();
            return this.triggerTimestamp[0] == currentSimTime;
        }

        @Override
        public DVTNumber getDVTNumber() {
            return VlogBitVector.createConstant(this.triggerCount[0]);
        }
    }

    public static class XForIndexHolder
    extends XValueHolder {
        private final String indexName;
        private final IELParamValue indexValue;

        public XForIndexHolder(XValueHolder enclosing, String indexName, IELParamValue indexValue) {
            super(enclosing.getFactory(), enclosing.getXNamedElement(), enclosing, enclosing.instanceScope, enclosing.isStaticHolder(), enclosing.isNull());
            this.values = enclosing.values;
            this.refValueHolder = enclosing;
            this.indexName = indexName;
            this.indexValue = indexValue;
        }

        public IELParamValue getIndexValue() {
            return this.indexValue;
        }

        @Override
        public String toUniqueString(boolean isFullQualified) {
            return ((XValueHolder)this.enclosing).toUniqueString(isFullQualified);
        }

        @Override
        public ELParamValueScope getValue(IHid hid, BitVectorContext context, IHidEvaluationGuardian guardian) {
            IELParamValue value;
            IELParamValue iELParamValue = value = this.indexName.equals(XUtils.getName(hid)) ? this.indexValue : null;
            if (value != null) {
                return ELParamValueScope.of(value, this.enclosing);
            }
            return super.getValue(hid, context, guardian);
        }

        @Override
        public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
            IELParamValue value;
            IELParamValue iELParamValue = value = this.indexName.equals(name) ? this.indexValue : null;
            if (value != null) {
                return ELParamValueScope.of(value, this.enclosing);
            }
            return super.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
        }

        @Override
        public IELParamValue getValueDirectly(String name) {
            IELParamValue value;
            IELParamValue iELParamValue = value = this.indexName.equals(name) ? this.indexValue : null;
            if (value != null) {
                return value;
            }
            return super.getValueDirectly(name);
        }
    }

    public static class XShadowHolder
    implements IELParamValue {
        public List<IELParamValue> values;

        public XShadowHolder(IELParamValue ... values) {
            this.values = new ArrayList<IELParamValue>(Arrays.asList(values));
        }

        @Override
        public ELManager getManager() {
            return null;
        }

        @Override
        public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IELParamValue copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IELParamValue shallowCopy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IELParamValue scalarCopy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDebuggerTypeName(boolean isFormal) {
            throw new UnsupportedOperationException();
        }

        public void add(IELParamValue value) {
            this.values.add(value);
        }

        public IELParamValue get(IRfNamedElement element) {
            if (element == null) {
                throw new UnsupportedOperationException();
            }
            for (IELParamValue value : this.values) {
                if (value.getElement() != element) continue;
                return value;
            }
            return null;
        }

        public IELParamValue remove(IRfNamedElement scopeElement) {
            if (scopeElement == null) {
                throw new UnsupportedOperationException();
            }
            Iterator<IELParamValue> iterator = this.values.iterator();
            while (iterator.hasNext()) {
                IRfClassElement classScope2;
                IELParamValue value = iterator.next();
                IRfClassElement classScope1 = XValueHolder.getOriginClassScope(scopeElement);
                if (classScope1 != (classScope2 = XValueHolder.getOriginClassScope(value.getElement()))) continue;
                iterator.remove();
                return value;
            }
            return null;
        }

        public void setOrAdd(IELParamValue value) {
            if (value.getElement() == null) {
                throw new UnsupportedOperationException();
            }
            int i = 0;
            while (i < this.values.size()) {
                if (this.values.get(i).getElement() == value.getElement()) {
                    this.values.set(i, value);
                    return;
                }
                ++i;
            }
            this.values.add(value);
        }
    }

    static abstract class XUninitValue
    implements IELParamValue {
        protected XUninitValue() {
        }

        public abstract void evaluate();

        @Override
        public ELManager getManager() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean updateValue(IELParamValue newResult, IHidEvaluationGuardian guardian) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IELParamValue copy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IELParamValue shallowCopy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IELParamValue scalarCopy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
            return "[static init pending ...]";
        }

        @Override
        public String getDebuggerTypeName(boolean isFormal) {
            return "[static init pending ...]";
        }
    }
}

