/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.model.IStackFrame;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.debug.core.intrp.model.IntrpStackFrame;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXModel;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.IXValueHolderFactoryContributor;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XCGroupValueHolder;
import ro.amiq.dvt.interpreter.XCPointCrossValueHolder;
import ro.amiq.dvt.interpreter.XCPointSimpleValueHolder;
import ro.amiq.dvt.interpreter.XChandleValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMailboxValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedComputedSelect;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XSemaphoreValueHolder;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.interpreter.constraints.XCValue;
import ro.amiq.dvt.interpreter.dpi.IXSystemCFactory;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XResumeThreadEvent;
import ro.amiq.dvt.interpreter.sim.XSimEventScheduler;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfCompositeTypeElement;
import ro.amiq.dvt.model.reflection.IRfCovergroup;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPackageElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfSpecializedTypeElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ucis.UCISDBWriter;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.IDVTMemberSelectable;
import ro.amiq.dvt.utils.IDVTRangeSelectable;
import ro.amiq.dvt.utils.LRUCache;
import ro.amiq.dvt.utils.OptimizedUtils;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.XArrayAssignmentPatternBitVectorContext;
import ro.amiq.dvt.utils.XGlobalCache;
import ro.amiq.dvt.utils.XStructAssignmentPatternBitVectorContext;

public class XValueHolderFactory {
    public static final String DVT_NATIVE_TRACE = "+dvtx_native_trace";
    public static final String DVT_NATIVE_VERBOSITY = "+dvtx_native_verbosity";
    public static final String DVT_NATIVE_NO_GEN = "+dvtx_native_no_gen";
    public static final String DVT_NATIVE_JIMPL_UVM = "+dvtx_native_jimpl_uvm";
    public static final String DVTX_32BIT = "+dvtx_32bit";
    public static final String DVT_NATIVE_RUNTIME_DIR = "+dvtx_native_runtime_dir";
    public static final String DVT_UCIS = "+dvtx_ucis";
    public static final String DVT_COVERAGE = "+dvtx_coverage";
    public static final String DVT_DISABLE_OPT = "+dvt_disable_opt=";
    public static final String DVT_TOP_MODULE = "+dvt_top=";
    public static final String DVT_TEST_MODE = "+dvt_test_mode";
    public static final Pattern XVM_VERBOSITY_PATTERN = Pattern.compile("\\+[UO]VM_VERBOSITY=.*");
    private UCISDBWriter ucisDBWriter;
    private final ELManager manager;
    private final Map<XNamedElement, XValueHolder> staticHoldersMap;
    private final Map<IRfNamedElement, Set<String>> memberNamesCache;
    private final Map<IRfMethodElement, Boolean> virtualMethodsCache;
    private final Map<Integer, Integer> nextRandomSeeds;
    private final Map<ElementPath, XInstValueHolder> instanceValueHolders;
    private final Map<Integer, Map<String, Boolean>> randModeOverrides;
    private final List<IXSimEvent> terminateEvalEvents;
    private final Map<XInstValueHolder, Map<String, List<Driver>>> multipleDriversMap;
    private final LRUCache<XNamedElement, IRfNamedElement> associatedTypeCache;
    private final Map<Integer, List<WaitingThread>> awaitingThreadsMap;
    private final Map<Integer, Set<WaitingThread>> waitingThreadsMap;
    private final Map<Integer, Set<XInstValueHolder.XEvalOverrideHidOperator>> assignOperatorsMap;
    private final Map<Integer, List<XInstValueHolder.XEvalOverrideHidOperator>> releaseOperatorsMap;
    private final List<XInstValueHolder.XEvalOverrideHidOperator> initAssignOperators;
    private final Map<Integer, IELParamValue> initAssignValues;
    private final Map<Integer, ELParamValues.ParamValueNumber> sharedPortValueMap;
    private final Map<ELParamValues.ParamValueNumber, List<SharedPortReference>> sharedPortReferenceMap;
    private final List<XInstValueHolder.XClockingValueHolder> clockingValueHolders;
    private final Map<IRfEnumElement, ELEnumTypeWrapper> enumTypesCache;
    private final Map<Integer, ForceValue> forceAssignOperatorsMap;
    private final Map<Integer, ForceValue> proceduralAssignOperatorsMap;
    private final Map<String, IDomain> randcVariableDomains;
    private int nextSeedCounter;
    private BigDecimal currentSimTime;
    private long deltaCycleCount;
    private boolean isSimTerminated;
    public final List<String> argv;
    public int nextArgIndex;
    public IXSim xSim;
    private IRfNamedElement predefinedGatePortType;
    protected boolean isInstanceAllowed;
    private IXValueHolderFactoryContributor vlogFactoryContributor;
    private IXValueHolderFactoryContributor vhdlFactoryContributor;
    private int uniqueId;
    private XInstValueHolder topInstanceValueHolder;
    private boolean isStepIntoAssignEnable;
    private boolean isEnableEncryptedCodeAutoDefine;
    private boolean isDemoteUserErrorsAndWarnings;
    private boolean isPortOptDisabled;
    private boolean runTestCall;
    private Random randcaseRandom;
    private Random shuffleRandom;
    private XGlobalCache.TimeScale timeFormat;
    private int initialSeed;
    private boolean isAddExtraDebugInfo;
    public final Map<String, BuildConfigParser.Definition> runtimeEnvironmentVars;
    private String printUvmVerbosity = "UVM_MEDIUM";
    private BitSet changedVars;
    private IntOpenHashSet preponedVarsIds;
    private Map<Integer, IELParamValue> preponedVarsValues;
    private final Map<ElementPath, Set<AssertTM>> assertTMs;
    private final Map<ElementPath, Map<IRfAssertExpectElement, AssertTM.AssertResultHolder>> assertResults;
    private final Int2IntOpenHashMap changedVariableCounters;
    private final Int2IntOpenHashMap releaseTriggerIds;
    private int isCoverage;
    private int isUCIS;

    public XValueHolderFactory(ELManager manager, IXSim xSim, boolean isCaseSensitive) {
        this.manager = manager;
        this.xSim = xSim;
        this.uniqueId = 0;
        this.nextSeedCounter = -1;
        this.isCoverage = -1;
        this.isUCIS = -1;
        this.initialSeed = -1;
        this.timeFormat = null;
        this.argv = new LinkedList<String>();
        this.isInstanceAllowed = true;
        this.staticHoldersMap = new LinkedHashMap<XNamedElement, XValueHolder>();
        this.memberNamesCache = new LRUCache<IRfNamedElement, Set<String>>(1024);
        this.virtualMethodsCache = new IdentityHashMap<IRfMethodElement, Boolean>();
        this.nextRandomSeeds = new HashMap<Integer, Integer>();
        this.randModeOverrides = new HashMap<Integer, Map<String, Boolean>>();
        this.instanceValueHolders = new LinkedHashMap<ElementPath, XInstValueHolder>();
        this.terminateEvalEvents = new ArrayList<IXSimEvent>();
        this.predefinedGatePortType = this.getPredefinedGatePortType();
        this.multipleDriversMap = new IdentityHashMap<XInstValueHolder, Map<String, List<Driver>>>();
        this.associatedTypeCache = new LRUCache(1024);
        this.waitingThreadsMap = new HashMap<Integer, Set<WaitingThread>>();
        this.awaitingThreadsMap = new HashMap<Integer, List<WaitingThread>>();
        this.assignOperatorsMap = new LinkedHashMap<Integer, Set<XInstValueHolder.XEvalOverrideHidOperator>>();
        this.releaseOperatorsMap = new LinkedHashMap<Integer, List<XInstValueHolder.XEvalOverrideHidOperator>>();
        this.initAssignOperators = new ArrayList<XInstValueHolder.XEvalOverrideHidOperator>();
        this.forceAssignOperatorsMap = new HashMap<Integer, ForceValue>();
        this.proceduralAssignOperatorsMap = new HashMap<Integer, ForceValue>();
        this.sharedPortValueMap = new HashMap<Integer, ELParamValues.ParamValueNumber>();
        this.sharedPortReferenceMap = new IdentityHashMap<ELParamValues.ParamValueNumber, List<SharedPortReference>>();
        this.randcVariableDomains = new HashMap<String, IDomain>();
        this.runtimeEnvironmentVars = new HashMap<String, BuildConfigParser.Definition>();
        this.clockingValueHolders = new ArrayList<XInstValueHolder.XClockingValueHolder>();
        this.enumTypesCache = new HashMap<IRfEnumElement, ELEnumTypeWrapper>();
        this.changedVariableCounters = new Int2IntOpenHashMap();
        this.releaseTriggerIds = new Int2IntOpenHashMap();
        this.initAssignValues = new HashMap<Integer, IELParamValue>();
        IProject project = this.getProject();
        this.isStepIntoAssignEnable = BuildConfigManager.getXStepIntoAssigns(project);
        this.isEnableEncryptedCodeAutoDefine = BuildConfigManager.isEnableEncryptedCodeAutoDefine(project);
        this.isDemoteUserErrorsAndWarnings = BuildConfigManager.getXDemoteUserErrors(project);
        this.isPortOptDisabled = BuildConfigManager.getXDisablePortOptimizations(project);
        this.isAddExtraDebugInfo = BuildConfigManager.getXAddExtraDebugInfo(project);
        this.preponedVarsIds = new IntOpenHashSet();
        this.assertTMs = new IdentityHashMap<ElementPath, Set<AssertTM>>(16);
        this.assertResults = new IdentityHashMap<ElementPath, Map<IRfAssertExpectElement, AssertTM.AssertResultHolder>>();
        XGlobalCache.INSTANCE.setXSim(project, xSim);
    }

    protected IRfNamedElement getPredefinedGatePortType() {
        RfMixedLangProject rfMixedLangProject = this.xSim.getRfMixedLangProject();
        IRfNamedElement rfProject = (IRfNamedElement)((Object)rfMixedLangProject.getSingleLangProject("ro.amiq.vlogdt.VlogNature"));
        return rfProject.semanticGetMember("logic", null, null, rfProject, rfProject, true, true, false);
    }

    public int getUniqueId() {
        ++this.uniqueId;
        if (this.uniqueId == Integer.MAX_VALUE) {
            this.logError("Internal unique ID issue");
            throw new BuildCancelException();
        }
        return this.uniqueId;
    }

    public boolean isStepIntoAssignEnable() {
        return this.isStepIntoAssignEnable;
    }

    public ELManager getManager() {
        return this.manager;
    }

    public IHidEvaluationGuardian getEvaluationGuardian(boolean createCopy) {
        return this.xSim.getEvaluationGuardian(createCopy);
    }

    public XValueHolder createStaticValueHolder(XNamedElement xAssociatedType) {
        XValueHolder result = this.getStaticValueHolder(xAssociatedType);
        if (result != null) {
            return result;
        }
        XValueHolder enclosing = this.createEnclosingStaticValueHolder(xAssociatedType);
        result = this.getStaticValueHolder(xAssociatedType);
        if (result != null) {
            return result;
        }
        IRfNamedElement namedElement = xAssociatedType.getNamedElement();
        if (this.isAddExtraDebugInfo && namedElement instanceof IRfPackageElement var5_6 && pkg.getSemanticEnableRaw() != 3 && !pkg.isPredefined()) {
            this.logWarning("Package '" + pkg.getName() + "' is used but was not elaborated.");
        }
        if (namedElement instanceof IRfModportElement) {
            result = new XInstValueHolder.XModportValueHolder(this, xAssociatedType, enclosing);
        } else if (this.isCoverage() && namedElement instanceof IRfCovergroup) {
            HidEvalCenter.CovergroupStatement cgStatement = (HidEvalCenter.CovergroupStatement)HidEvalConverter.INSTANCE.convertCovergroup(xAssociatedType.getNamedElement(), this.getEvaluationGuardian(true), enclosing);
            XInstValueHolder instanceScope = null;
            if (enclosing instanceof XInstValueHolder) {
                instanceScope = (XInstValueHolder)enclosing;
            }
            result = new XCGroupValueHolder(this, xAssociatedType, (IELParamValue)enclosing, instanceScope, cgStatement, true);
            result.setElement(namedElement);
            cgStatement.setValueHolder((XCGroupValueHolder)result);
        } else {
            result = new XValueHolder(this, xAssociatedType, enclosing, null, true, false);
        }
        this.staticHoldersMap.put(xAssociatedType, result);
        XNamedElement parent = result.xGetParent();
        if (parent != null) {
            this.createStaticValueHolder(parent);
        }
        result.initLocalVariables(true);
        this.createReferredStaticHolders(result);
        return result;
    }

    public void createStaticHoldersForPackages(@NotNull IRfSingleLangProject project) {
        for (IRfLibraryElement iRfLibraryElement : project.getLibraries()) {
            XValueHolder libXVH = this.createStaticValueHolder(XNamedElement.create(iRfLibraryElement, null, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
            List<? extends IRfPackageElement> pkgs = iRfLibraryElement.getLocalPackages();
            if (pkgs == null) continue;
            for (IRfPackageElement iRfPackageElement : pkgs) {
                if (iRfPackageElement.getSemanticEnableRaw() != 3 && !iRfPackageElement.isPredefined()) continue;
                this.createStaticValueHolder(XNamedElement.create(iRfPackageElement, libXVH, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
                if (iRfPackageElement.getPackageBody() == null) continue;
                this.createStaticValueHolder(XNamedElement.create(iRfPackageElement.getPackageBody(), libXVH, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
            }
        }
    }

    public void createReferredStaticHolders(XValueHolder staticHolder) {
        Collection<? extends IRfNamedElement> localMembers = staticHolder.getNamedElement().xGetLocalMembers();
        if (localMembers == null) {
            return;
        }
        for (IRfNamedElement iRfNamedElement : localMembers) {
            if (iRfNamedElement instanceof IRfActionBlockElement || iRfNamedElement instanceof IRfMethodElement && !iRfNamedElement.isPredefined()) {
                this.createStaticValueHolder(XNamedElement.create(iRfNamedElement, staticHolder, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
                continue;
            }
            IRfNamedElement iRfNamedElement2 = this.unwrapTypeAlias(iRfNamedElement, staticHolder);
            if (!(iRfNamedElement2 instanceof IRfClassElement) || !((IRfClassElement)iRfNamedElement2).isComplete() && ((IRfClassElement)iRfNamedElement2).hasPortListParameters()) continue;
            this.createStaticValueHolder(XNamedElement.create(iRfNamedElement2, staticHolder, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
        }
    }

    public ELEnumTypeWrapper createEnumType(IRfNamedElement element) {
        if (!(element instanceof IRfEnumElement)) {
            return null;
        }
        ELEnumTypeWrapper enumType = this.enumTypesCache.get(element);
        if (enumType != null) {
            return enumType;
        }
        enumType = ELEnumTypeWrapper.create((IRfEnumElement)element);
        this.enumTypesCache.put((IRfEnumElement)element, enumType);
        return enumType;
    }

    public ELEnumTypeWrapper getEnumType(IRfNamedElement element) {
        if (element instanceof IRfEnumElement) {
            return this.enumTypesCache.get(element);
        }
        return null;
    }

    public static IRfNamedElement unwrapTypeAlias(IRfNamedElement namedElement) {
        int i = 0;
        while (namedElement instanceof IRfTypeAliasElement && i++ < 1000) {
            namedElement = ((IRfTypeAliasElement)namedElement).getAssociatedType();
        }
        return namedElement;
    }

    public IRfNamedElement unwrapTypeAlias(IRfNamedElement namedElement, XValueHolder enclosingHolder) {
        int i = 0;
        while (namedElement instanceof IRfTypeAliasElement && i++ < 1000) {
            namedElement = this.xGetAssociatedType((IRfTypeAliasElement)namedElement, enclosingHolder);
        }
        return namedElement;
    }

    public XValueHolder getStaticValueHolder(XNamedElement xAssociatedType) {
        return this.staticHoldersMap.get(xAssociatedType);
    }

    public XValueHolder createEnclosingStaticValueHolder(XNamedElement xNamedElement) {
        if (xNamedElement == null) {
            return null;
        }
        XNamedElement xEnclosingScope = xNamedElement.getEnclosing();
        while (xEnclosingScope != null) {
            if (!(xEnclosingScope.getNamedElement() instanceof IRfCompositeTypeElement)) {
                return this.createStaticValueHolder(xEnclosingScope);
            }
            xEnclosingScope = xEnclosingScope.getEnclosing();
        }
        return null;
    }

    public IELParamValue createValueHolder(IRfNamedElement namedElement, IELParamValue enclosing, XInstValueHolder instanceScope) {
        return this.createValueHolder(XNamedElement.create(namedElement, enclosing, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), enclosing, instanceScope);
    }

    public IELParamValue createValueHolder(XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        if (xAssociatedType == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IRfNamedElement namedElement = xAssociatedType.getNamedElement();
        if (namedElement == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (namedElement.xIsStaticValueHolder(this)) {
            return this.createStaticValueHolder(xAssociatedType);
        }
        if (enclosing instanceof XInstValueHolder) {
            instanceScope = (XInstValueHolder)enclosing;
        }
        if (enclosing == null) {
            enclosing = this.createEnclosingValueHolder(xAssociatedType, instanceScope);
        }
        IELParamValue result = this.newValueHolder(xAssociatedType, enclosing, instanceScope, false);
        if (XValueHolderFactory.xIsClass(namedElement)) {
            this.createStaticValueHolder(xAssociatedType);
        }
        return result;
    }

    private IELParamValue newValueHolder(XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder) {
        IRfNamedElement namedElement = xAssociatedType.getNamedElement();
        if (namedElement instanceof IRfListType) {
            return new XArrayValueHolder(this, xAssociatedType, enclosing, instanceScope);
        }
        if (namedElement instanceof IRfCoverpoint) {
            if (((IRfCoverpoint)namedElement).isCross()) {
                return new XCPointCrossValueHolder(this, xAssociatedType, enclosing, instanceScope);
            }
            return new XCPointSimpleValueHolder(this, xAssociatedType, enclosing, instanceScope);
        }
        if (namedElement instanceof IRfCovergroup) {
            if (!this.isCoverage()) {
                return new XCGroupValueHolder(this, xAssociatedType, enclosing, instanceScope, null, false);
            }
            HidEvalCenter.CovergroupStatement cgStatement = (HidEvalCenter.CovergroupStatement)HidEvalConverter.INSTANCE.convertCovergroup(xAssociatedType.getNamedElement(), this.getEvaluationGuardian(true), instanceScope);
            XCGroupValueHolder xcGroupValueHolder = new XCGroupValueHolder(this, xAssociatedType, enclosing, instanceScope, cgStatement, false);
            cgStatement.setValueHolder(xcGroupValueHolder);
            return xcGroupValueHolder;
        }
        boolean isPredefined = namedElement.isPredefined();
        String name = namedElement.getName();
        if (isPredefined && "mailbox".equals(name) || namedElement instanceof IRfSpecializedTypeElement var8_11 && "mailbox".equals(ste.getGenericElement().getName())) {
            return new XMailboxValueHolder(this, xAssociatedType, enclosing, instanceScope, isStaticHolder, namedElement.xIsNullableXValueHolder());
        }
        if (isPredefined && "semaphore".equals(name)) {
            return new XSemaphoreValueHolder(this, xAssociatedType, enclosing, instanceScope, isStaticHolder, namedElement.xIsNullableXValueHolder());
        }
        if (isPredefined && "event".equals(name)) {
            return new XValueHolder.XEventValueHolder(this, xAssociatedType, enclosing, instanceScope);
        }
        if (isPredefined && "chandle".equals(name)) {
            return new XChandleValueHolder(this, xAssociatedType, enclosing, instanceScope, isStaticHolder, 0L);
        }
        if (namedElement.getClass().getName().endsWith(".RfModule") && !this.getEvaluationGuardian(false).isLinterStaticAnalysisMode() && this.simulatorMode() != IXSim.XSimMode.STANDALONE_FUNCTION) {
            if (this.getEvaluationGuardian(false).simulatorMode() == IXSim.XSimMode.SIMULATOR) {
                String errorMessage = "Internal error evaluating design '" + name + "' reference (see error log for thrown exceptions)";
                this.logError(errorMessage);
                DVTLogger.INSTANCE.logError((Throwable)new Exception(errorMessage));
            }
            return IELParamValue.BLACK_BOX_VALUE;
        }
        return new XValueHolder(this, xAssociatedType, enclosing, instanceScope, isStaticHolder, namedElement.xIsNullableXValueHolder());
    }

    private IELParamValue createEnclosingValueHolder(XNamedElement xNamedElement, XInstValueHolder instanceScope) {
        IRfNamedElement occurence;
        IRfNamedElement namedElement = xNamedElement.getNamedElement();
        if (instanceScope != null && namedElement instanceof IRfListType && ((IRfListType)namedElement).xGetComputedBounds() == null && ((occurence = ((IRfListType)namedElement).getOccurrence()) instanceof IRfInstanceElement || occurence instanceof IRfPortElement)) {
            return instanceScope;
        }
        XNamedElement xEnclosingScope = xNamedElement.getEnclosing();
        if (xEnclosingScope == null) {
            return null;
        }
        if (xEnclosingScope.getNamedElement() instanceof IRfDesignElement) {
            if (instanceScope != null && instanceScope.getNamedElement() == xEnclosingScope.getNamedElement()) {
                return instanceScope;
            }
            XValueHolder enclosingValue = this.getStaticValueHolder(xEnclosingScope);
            if (enclosingValue != null) {
                return enclosingValue;
            }
        }
        return this.createValueHolder(xEnclosingScope, null, instanceScope);
    }

    public ELParamValueScope createMethodValueHolder(XNamedElement xMethodMember, XValueHolder refValueHolder, XInstValueHolder instanceScope) {
        IELParamValue enclosing;
        XNamedElement xEnclosingScope = xMethodMember.getEnclosing();
        if (xEnclosingScope == null) {
            return ELParamValueScope.UNDEFINED_VALUE;
        }
        IRfNamedElement namedElement = xMethodMember.getNamedElement();
        if (namedElement.xIsStaticMember()) {
            enclosing = this.createStaticValueHolder(xEnclosingScope);
        } else {
            if (refValueHolder != null && refValueHolder.enclosing instanceof XInstValueHolder) {
                instanceScope = (XInstValueHolder)refValueHolder.enclosing;
            }
            enclosing = instanceScope != null && instanceScope.getNamedElement() == xEnclosingScope.getNamedElement() ? this.createValueHolder(xEnclosingScope, (IELParamValue)instanceScope, instanceScope) : this.createValueHolder(xEnclosingScope, null, instanceScope);
            enclosing.updateValue((IELParamValue)refValueHolder, true);
        }
        XValueHolder result = this.createCustomMethodValueHolder(xMethodMember, enclosing, instanceScope, false);
        return ELParamValueScope.of(result, enclosing);
    }

    protected XValueHolder createCustomMethodValueHolder(XNamedElement method, IELParamValue enclosing, XInstValueHolder instanceScope, boolean staticHolder) {
        IRfNamedElement namedElement = method.getNamedElement();
        if (this.vlogFactoryContributor != null && namedElement.getLanguageKind() == LanguageKind.VLOG) {
            return this.vlogFactoryContributor.createContributorCustomMethodValueHolder(method, enclosing, instanceScope, staticHolder);
        }
        if (this.vhdlFactoryContributor != null && namedElement.getLanguageKind() == LanguageKind.VHDL) {
            return this.vhdlFactoryContributor.createContributorCustomMethodValueHolder(method, enclosing, instanceScope, staticHolder);
        }
        return new XMethodValueHolder(this, method, enclosing, instanceScope, staticHolder);
    }

    public static XSelectProxy createSelectProxy(HidAccess hidAccess, IELParamValue value, BitVectorContext context, IHidEvaluator evaluator, boolean evaluateForSize, IHidEvaluationGuardian guardian, LanguageKind languageKind) {
        if (hidAccess == null) {
            return null;
        }
        List<IHidObject> hidSelects = hidAccess.getSelects();
        if (hidSelects == null) {
            return null;
        }
        XArrayValueHolder arrayHolder = value instanceof XArrayValueHolder ? (XArrayValueHolder)value : null;
        ListContainer<XComputedSelect> computedSelects = XValueHolderFactory.computeSelects(hidSelects, context, evaluator, evaluateForSize, guardian, arrayHolder);
        XSelectProxy selectProxy = new XSelectProxy(value, computedSelects, context, guardian);
        return selectProxy;
    }

    public static IELParamValue createSelectProxyValue(HidAccess hidAccess, IELParamValue value, BitVectorContext context, IHidEvaluator evaluator, boolean evaluateForSize, boolean isConstraint, IHidEvaluationGuardian guardian, LanguageKind languageKind) {
        XSelectProxy selectProxy = XValueHolderFactory.createSelectProxy(hidAccess, value, context, evaluator, evaluateForSize, guardian, languageKind);
        if (selectProxy == null) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        return XValueHolderFactory.createSelectProxyValue(value, selectProxy, evaluateForSize, isConstraint, languageKind);
    }

    public static IELParamValue createSelectProxyValue(int left, int right, IELParamValue value, BitVectorContext context, boolean evaluateForSize, boolean isConstraint, IHidEvaluationGuardian guardian, LanguageKind languageKind) {
        IELParamValue[] computedValues = new IELParamValue[]{ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(left))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(right)))};
        XComputedSelect computedSelects = new XComputedSelect(HidUtils.makeStandInImplicit(Integer.toString(left), IHidImplicitConstants.ImplicitType.QUA_NUMBER.id), computedValues);
        XSelectProxy selectProxy = new XSelectProxy(value, computedSelects, context, guardian);
        return XValueHolderFactory.createSelectProxyValue(value, selectProxy, evaluateForSize, isConstraint, languageKind);
    }

    public static IELParamValue createSelectProxyValue(IELParamValue value, XSelectProxy selectProxy, boolean evaluateForSize, boolean isConstraint, LanguageKind languageKind) {
        if (value instanceof ELParamValues.ParamValueNumber) {
            return XValueHolderFactory.createParamValueNumberSelectProxy(selectProxy, evaluateForSize, languageKind);
        }
        if (value instanceof XArrayValueHolder) {
            return ((XArrayValueHolder)value).createXValueHolderSelectProxy(selectProxy, evaluateForSize, isConstraint, false, languageKind);
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    public static ListContainer<XComputedSelect> computeSelects(List<IHidObject> hidObjectSelects, BitVectorContext context, IHidEvaluator evaluator, boolean evaluateForSize, IHidEvaluationGuardian guardian, XArrayValueHolder arrayHolder) {
        if (hidObjectSelects == null) {
            return ListContainer.emptyContainer();
        }
        ListContainer<XComputedSelect> result = null;
        for (IHidObject hidObjectSelect : hidObjectSelects) {
            if (hidObjectSelect instanceof IHidOperator && ((IHidOperator)hidObjectSelect).isSelectList()) {
                IHidOperator op = (IHidOperator)hidObjectSelect;
                BitVectorContext defaultContext = BitVectorContext.of(context != null ? context.getOrigin() : null, true);
                ListContainer<IHidObject> rhValues = op.getRHValues();
                int i = rhValues.size() - 1;
                while (i >= 0) {
                    IHidObject select = op.getRHValues().get(i);
                    IELParamValue selectValue = XUtils.getValue(ELUtils.evaluate(select, evaluator, defaultContext, guardian.copy()));
                    if (ELUtils.isUnsuccessfulEval(selectValue)) {
                        result = OptimizedUtils.listContainerAdd(result, new XComputedSelect(select));
                    }
                    result = OptimizedUtils.listContainerAdd(result, new XComputedSelect(select, selectValue));
                    --i;
                }
                break;
            }
            result = OptimizedUtils.listContainerAdd(result, XValueHolderFactory.computeSelect(hidObjectSelect, evaluator, guardian, evaluateForSize, context != null ? context.getOrigin() : null, arrayHolder));
        }
        return result;
    }

    public static XComputedSelect computeSelect(IHidObject select, IHidEvaluator evaluator, IHidEvaluationGuardian guardian, boolean evaluateForSize, IRfNamedElement origin, XArrayValueHolder arrayHolder) {
        BitVectorContext defaultContext = BitVectorContext.of(origin, true);
        defaultContext.setArraySelectSource(arrayHolder);
        IHidEvaluationGuardian newGuardian = guardian.isEvaluateForSize() ? ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.RANGE, origin, null, false, evaluator.getManager()) : guardian;
        IELParamValue[] selectValues = null;
        ELParamValueScope value = null;
        switch (select.getHidKind()) {
            case IMPLICIT: {
                value = ELUtils.evaluate(select, evaluator, defaultContext, newGuardian);
                if (ELUtils.isUnsuccessfulEval(value)) {
                    if (evaluateForSize) {
                        return new XComputedSelect(select, ELParamValues.ParamValueNumber.of(VlogBitVector.ZERO));
                    }
                    return new XComputedSelect(select);
                }
                selectValues = new IELParamValue[]{XUtils.getValue(value)};
                break;
            }
            case HID: 
            case ACCESS: {
                if (select instanceof Hid && ((Hid)select).getParentAccess() != null && ((Hid)select).getParentAccess().isAttributeAccess() && "RANGE".equalsIgnoreCase(((Hid)select).getName())) {
                    value = ELUtils.evaluate(select, evaluator, defaultContext, newGuardian);
                    if (ELUtils.isUnsuccessfulEval(value)) {
                        return new XComputedSelect(select);
                    }
                    if (!(value.getDVTNumber() instanceof IDVTRangeSelectable)) break;
                    int[] firstDimension = ((IDVTRangeSelectable)((Object)value.getDVTNumber())).getFirstDimension();
                    selectValues = new IELParamValue[]{ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(firstDimension[0])), ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(firstDimension[1]))};
                    break;
                }
                if (evaluateForSize) {
                    return new XComputedSelect(select, ELParamValues.ParamValueNumber.of(VlogBitVector.ZERO));
                }
                value = ELUtils.evaluate(select, evaluator, defaultContext, newGuardian);
                if (ELUtils.isUnsuccessfulEval(value)) {
                    return new XComputedSelect(select);
                }
                selectValues = new IELParamValue[]{XUtils.getValue(value)};
                break;
            }
            case OPERATOR: {
                HidOperator op = (HidOperator)select;
                if (evaluateForSize && (op.isPlusIndexPartSelect() || op.isMinusIndexPartSelect())) {
                    IHidObject rh = op.getFirstRHValue();
                    if (rh == null) {
                        return new XComputedSelect(select);
                    }
                    ELParamValueScope rhValue = ELUtils.evaluate(rh, evaluator, defaultContext, newGuardian);
                    if (ELUtils.isUnsuccessfulEval(rhValue)) {
                        return new XComputedSelect(select);
                    }
                    return new XComputedSelect(select, ELParamValues.ParamValueNumber.of(VlogBitVector.ZERO), XUtils.getValue(rhValue));
                }
                if (op.isRangeOrPartSelect()) {
                    if (op.getRHValues() == null || op.getRHValues().isEmpty()) {
                        return new XComputedSelect(select);
                    }
                    IHidObject lh = op.getLHValue();
                    IHidObject rh = op.getFirstRHValue();
                    ELParamValueScope lhValue = ELUtils.evaluate(lh, evaluator, defaultContext, newGuardian);
                    ELParamValueScope rhValue = ELUtils.evaluate(rh, evaluator, defaultContext, newGuardian);
                    if (ELUtils.isUnsuccessfulEval(rhValue) || ELUtils.isUnsuccessfulEval(lhValue)) {
                        return new XComputedSelect(select);
                    }
                    selectValues = new IELParamValue[]{XUtils.getValue(lhValue), XUtils.getValue(rhValue)};
                    break;
                }
                if (value == null) {
                    value = ELUtils.evaluate(op, evaluator, defaultContext, newGuardian);
                }
                if (ELUtils.isUnsuccessfulEval(value)) {
                    if (evaluateForSize) {
                        return new XComputedSelect(select, ELParamValues.ParamValueNumber.of(VlogBitVector.ZERO));
                    }
                    return new XComputedSelect(select);
                }
                selectValues = new IELParamValue[]{XUtils.getValue(value)};
                break;
            }
        }
        return new XComputedSelect(select, selectValues);
    }

    private static DVTNumber computeNumber(XSelectProxy selectProxy, boolean evaluateForSize, LanguageKind languageKind) {
        if (selectProxy == null) {
            return DVTNumber.UNDEFINED;
        }
        IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelect();
        DVTNumber beforeSelectNumber = valueBeforeSelect.getDVTNumber();
        if (DVTNumber.isUndefined(beforeSelectNumber)) {
            return DVTNumber.UNDEFINED;
        }
        DVTNumber valueToSelect = beforeSelectNumber;
        int i = 0;
        while (i < selectProxy.computedSelects.size()) {
            if (!(valueToSelect instanceof IDVTRangeSelectable)) {
                return DVTNumber.UNDEFINED;
            }
            XComputedSelect select = selectProxy.computedSelects.get(i);
            if (select == null || select.computedValues == null) {
                return DVTNumber.UNDEFINED;
            }
            if (select instanceof XNamedComputedSelect) {
                if (!(valueToSelect instanceof IDVTMemberSelectable)) {
                    throw new UnknownHidObjectEvaluationException(select.getSelectObject());
                }
                valueToSelect = ((IDVTMemberSelectable)((Object)valueToSelect)).getMemberSelect((IHid)select.getSelectObject(), evaluateForSize);
            } else {
                valueToSelect = ((IDVTRangeSelectable)((Object)valueToSelect)).getRangeSelect(select, evaluateForSize, languageKind);
            }
            ++i;
        }
        return selectProxy.context != null ? selectProxy.context.transform(valueToSelect) : valueToSelect;
    }

    public static IELParamValue createParamValueNumberSelectProxy(XSelectProxy selectProxy, boolean evaluateForSize, LanguageKind languageKind) {
        DVTNumber selectNumber = XValueHolderFactory.computeNumber(selectProxy, evaluateForSize, languageKind);
        if (DVTNumber.isUndefined(selectNumber)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IRfNamedElement element = selectProxy.getValueBeforeSelect().getElement();
        IELParamValue result = ELParamValues.ParamValueNumber.of(selectNumber, element, null);
        result.setSelectProxy(selectProxy);
        return result;
    }

    public void setCommandLineArguments(List<String> argv) {
        this.argv.clear();
        if (argv != null) {
            this.argv.addAll(argv);
        }
        if (this.isUCIS() && this.ucisDBWriter == null) {
            IProject project = this.getProject();
            String projectPath = project.getLocation().toOSString();
            this.ucisDBWriter = new UCISDBWriter(String.valueOf(projectPath) + "/coverage.db");
        }
        this.initialSeed = this.getInitialSeed();
        this.nextArgIndex = 0;
    }

    public UCISDBWriter getUcisDBWriter() {
        return this.ucisDBWriter;
    }

    public String getWorkingDir() {
        return BuildConfigManager.getCompilationRoot(this.getProject(), Integer.MAX_VALUE);
    }

    public IELParamValue executeMethodCall(IHidObject hidObject, IRfMethodElement methodElement, IHidEvaluator methodEnclosingEvaluator, IHidEvaluator methodEvaluator, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
        if (this.vlogFactoryContributor != null && methodElement.getLanguageKind() == LanguageKind.VLOG) {
            return this.vlogFactoryContributor.executeMethodCall(hidObject, methodElement, methodEnclosingEvaluator, methodEvaluator, argumentsEvaluator, specifiedArgumentValues, guardian);
        }
        if (this.vhdlFactoryContributor != null && methodElement.getLanguageKind() == LanguageKind.VHDL) {
            return this.vhdlFactoryContributor.executeMethodCall(hidObject, methodElement, methodEnclosingEvaluator, methodEvaluator, argumentsEvaluator, specifiedArgumentValues, guardian);
        }
        return null;
    }

    public boolean isVlogSystemCallExecuted(String name) {
        if (this.vlogFactoryContributor != null) {
            return this.vlogFactoryContributor.isVlogSystemCallExecuted(name);
        }
        return false;
    }

    public static boolean isCaseSensitive(XNamedElement xAssociatedType) {
        if (xAssociatedType == null) {
            return false;
        }
        return XValueHolderFactory.isCaseSensitive(xAssociatedType.getNamedElement());
    }

    public static boolean isCaseSensitive(IRfNamedElement namedElement) {
        return namedElement == null || namedElement.getLanguageKind() != LanguageKind.VHDL;
    }

    public static BitVectorContext getNoContext() {
        return BitVectorContext.of(null, false);
    }

    /*
     * Unable to fully structure code
     */
    public static BitVectorContext getRightOpContext(IELParamValue leftValue, IHidObject rightValue, IRfNamedElement contextOrigin, XValueHolderFactory factory) {
        if (!(contextOrigin instanceof IRfFieldElement)) ** GOTO lbl7
        fieldOrigin = (IRfFieldElement)contextOrigin;
        dataType = fieldOrigin.getDataType();
        if (!fieldOrigin.isParameter() || dataType != null && (!dataType.hasImplicitType() || dataType.hasPackedDimension())) ** GOTO lbl7
        return BitVectorContext.of(contextOrigin, false);
lbl-1000:
        // 1 sources

        {
            rightValue = ((IHidOperator)rightValue).getRHValues().get(0);
lbl7:
            // 3 sources

            ** while (rightValue instanceof IHidOperator && ((IHidOperator)rightValue).isConditionalTernary())
        }
lbl8:
        // 1 sources

        if (leftValue instanceof ELParamValues.ParamValueType && factory != null) {
            namedElement = leftValue.getNamedElement();
            if (namedElement instanceof IRfListType && !((IRfListType)namedElement).isPacked()) {
                leftValue = new XArrayValueHolder(factory, XNamedElement.create(namedElement, null), null, null);
            }
            if (namedElement instanceof IRfCompositeTypeElement && ((IRfCompositeTypeElement)namedElement).isStruct() && !((IRfCompositeTypeElement)namedElement).isPacked()) {
                leftValue = new XValueHolder(factory, XNamedElement.create(namedElement, null), null, null, false, false);
            }
        }
        if (XValueHolderFactory.isStructValueHolderAssignmentPatternValues(leftValue, rightValue)) {
            return new XStructAssignmentPatternBitVectorContext(leftValue);
        }
        if (XValueHolderFactory.isArrayValueHolderAssignmentPatternValues(leftValue, rightValue)) {
            return new XArrayAssignmentPatternBitVectorContext(leftValue);
        }
        v0 = leftNumber = leftValue instanceof XValueHolder != false ? DVTNumber.UNDEFINED : leftValue.getDVTNumber();
        if (!DVTNumber.isUndefined(leftNumber)) {
            return BitVectorContext.of(leftNumber, contextOrigin);
        }
        return BitVectorContext.of(contextOrigin, false);
    }

    private static boolean isStructValueHolderAssignmentPatternValues(IELParamValue value, IHidObject operator) {
        if (!(operator instanceof HidOperator)) {
            return false;
        }
        if (!(((HidOperator)operator).isAssignmentPattern() || ((HidOperator)operator).isAggregate() || ((HidOperator)operator).isNonStandardAssignmentPattern())) {
            return false;
        }
        return value instanceof XValueHolder && ((XValueHolder)value).isStruct(true) && ((HidOperator)operator).getRHValues() != null;
    }

    private static boolean isArrayValueHolderAssignmentPatternValues(IELParamValue value, IHidObject rhValue) {
        if (!(value instanceof XArrayValueHolder)) {
            return false;
        }
        if (HidUtils.isHid(rhValue)) {
            return true;
        }
        if (HidUtils.isOperator(rhValue) && ((HidOperator)rhValue).getRHValues() != null) {
            return true;
        }
        return rhValue instanceof IHidImplicit && ((IHidImplicit)rhValue).isEmptyQueue() && (((XArrayValueHolder)value).isDynamicArray() || ((XArrayValueHolder)value).isQueueArray());
    }

    public static XValueHolder getSpecializedOrInstanceScope(XValueHolder scope) {
        while (!(scope instanceof XInstValueHolder)) {
            if (scope == null) {
                return null;
            }
            if (scope.xAssociatedType.getNamedElement() instanceof IRfSpecializedTypeElement) {
                return scope;
            }
            scope = (XValueHolder)scope.getEnclosingValue();
        }
        return scope;
    }

    public boolean hasMember(IRfNamedElement enclosing, String memberName) {
        if (enclosing == null) {
            return true;
        }
        if (!XValueHolderFactory.isCaseSensitive(enclosing)) {
            memberName = memberName.toLowerCase();
        }
        if (enclosing instanceof IRfTypeAliasElement) {
            return this.hasMember(((IRfTypeAliasElement)enclosing).getAssociatedType(), memberName);
        }
        if (XValueHolder.isEnum(enclosing)) {
            return true;
        }
        Set<String> memberNames = this.memberNamesCache.get(enclosing);
        if (memberNames != null) {
            return memberNames.contains(memberName);
        }
        memberNames = new HashSet<String>();
        enclosing.xCollectMemberNames(memberNames, true);
        this.memberNamesCache.put(enclosing, memberNames);
        return memberNames.contains(memberName);
    }

    public void prepareHotSwap() {
        this.memberNamesCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.clearContributorCache();
        }
        if (this.vhdlFactoryContributor != null) {
            this.vhdlFactoryContributor.clearContributorCache();
        }
        this.isCoverage = -1;
        this.isUCIS = -1;
        this.topInstanceValueHolder = null;
        this.initialSeed = this.getInitialSeed();
        this.timeFormat = null;
        this.randcaseRandom = null;
        this.shuffleRandom = null;
        this.uniqueId = 0;
        this.nextSeedCounter = -1;
        this.memberNamesCache.clear();
        this.virtualMethodsCache.clear();
        this.nextRandomSeeds.clear();
        this.randModeOverrides.clear();
        this.staticHoldersMap.clear();
        this.instanceValueHolders.clear();
        this.multipleDriversMap.clear();
        this.associatedTypeCache.clear();
        this.waitingThreadsMap.clear();
        this.awaitingThreadsMap.clear();
        this.assignOperatorsMap.clear();
        this.releaseOperatorsMap.clear();
        this.initAssignOperators.clear();
        this.initAssignValues.clear();
        this.forceAssignOperatorsMap.clear();
        this.proceduralAssignOperatorsMap.clear();
        this.sharedPortValueMap.clear();
        this.sharedPortReferenceMap.clear();
        this.randcVariableDomains.clear();
        this.runtimeEnvironmentVars.clear();
        this.clockingValueHolders.clear();
        this.enumTypesCache.clear();
        this.assertTMs.clear();
        this.assertResults.clear();
        List<IXSimEvent> list = this.terminateEvalEvents;
        synchronized (list) {
            this.terminateEvalEvents.clear();
        }
        if (this.manager != null) {
            this.manager.prepareHotSwap();
        }
    }

    public IRfNamedElement xGetAssociatedType(IRfAssociatedTypeElement member, IHidEvaluator memberEnclosingOrDescendant) {
        if (member instanceof DummyPort) {
            return this.predefinedGatePortType;
        }
        if (member instanceof IRfMethodElement && member.isVoid()) {
            return null;
        }
        IRfNamedElement associatedType = member.xGetFastAssocType();
        if (associatedType != null) {
            return associatedType;
        }
        if (member instanceof IRfFieldElement && ((IRfFieldElement)member).isFunctionResultImplicit()) {
            member = (IRfAssociatedTypeElement)member.getEnclosingScope();
        }
        if (member.isPredefined()) {
            return member.xGetAssociatedType(memberEnclosingOrDescendant);
        }
        XNamedElement xMember = XNamedElement.create(member, memberEnclosingOrDescendant, false, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
        IRfNamedElement associatedType2 = (IRfNamedElement)this.associatedTypeCache.get(xMember);
        if (associatedType2 != null) {
            return associatedType2;
        }
        associatedType2 = member.xGetAssociatedType(memberEnclosingOrDescendant);
        this.associatedTypeCache.put(xMember, associatedType2);
        return associatedType2;
    }

    public static boolean xIsClass(IRfNamedElement element, boolean resolveTypeAlias) {
        return element != null && element.xIsClass(resolveTypeAlias);
    }

    public static boolean xIsClass(IRfNamedElement element) {
        return element != null && element.xIsClass(false);
    }

    public static boolean xIsClass(XNamedElement element) {
        return element != null && XValueHolderFactory.xIsClass(element.getNamedElement(), false);
    }

    public boolean xvhIsMethodCallTrackingEnabled() {
        if (this.vlogFactoryContributor != null) {
            return this.vlogFactoryContributor.xvhIsMethodCallTrackingEnabled();
        }
        return false;
    }

    public void xvhStartMethodCall(IHidEvaluator methodEvaluator, IRfMethodElement methodElement, MethodCall methodCall, boolean fromExpression) {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.xvhStartMethodCall(methodEvaluator, methodElement, methodCall, fromExpression);
        }
    }

    public void xvhEndMethodCall() {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.xvhEndMethodCall();
        }
    }

    public long getNextSeed(XValueHolder methodValueHolder) {
        this.nextSeedCounter = this.nextSeedCounter >= 0 ? this.nextSeedCounter : this.getInitialSeed();
        int uniqueHolderId = ((XValueHolder)methodValueHolder.enclosing).uniqueValuesId;
        Integer nextSeed = this.nextRandomSeeds.get(uniqueHolderId);
        int seed = nextSeed == null ? (this.nextSeedCounter = this.nextSeedCounter + 1) : nextSeed;
        this.nextRandomSeeds.put(uniqueHolderId, seed + 1);
        return seed;
    }

    public List<ElementPath> getTopModulePaths() {
        if (this.argv == null || this.argv.isEmpty()) {
            return null;
        }
        ArrayList<ElementPath> topModulePaths = new ArrayList<ElementPath>();
        try {
            for (String arg : this.argv) {
                String topModuleName;
                if (!arg.toLowerCase().startsWith(DVT_TOP_MODULE) || (topModuleName = arg.substring(DVT_TOP_MODULE.length())).isEmpty()) continue;
                topModulePaths.add(ElementPath.join(null, topModuleName));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return topModulePaths;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getTestPlusarg(String name) {
        if (this.argv == null) return false;
        if (this.argv.isEmpty()) {
            return false;
        }
        try {
            Iterator<String> iterator = this.argv.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return false;
                }
                String arg = iterator.next();
                if (arg.length() < name.length() + 1) continue;
                if (arg.length() == name.length() + 1 && arg.charAt(0) == '+' && arg.regionMatches(1, name, 0, name.length())) {
                    return true;
                }
                if (arg.charAt(0) != '+' || !arg.regionMatches(1, name, 0, name.length())) continue;
                if (arg.charAt(name.length()) == '=') return true;
                if (arg.charAt(name.length() + 1) == '=') break;
            }
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public boolean getRuntimeElabDisableOpt() {
        if (this.argv == null || this.argv.isEmpty()) {
            return false;
        }
        try {
            for (String arg : this.argv) {
                if (!arg.toLowerCase().startsWith(DVT_DISABLE_OPT)) continue;
                String value = arg.substring(DVT_DISABLE_OPT.length());
                return "true".equalsIgnoreCase(value);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTestMode() {
        if (this.argv == null) return false;
        if (this.argv.isEmpty()) {
            return false;
        }
        try {
            String arg;
            Iterator<String> iterator = this.argv.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(arg = iterator.next()).equalsIgnoreCase(DVT_TEST_MODE));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public void setRandMode(int uniqueHolderId, String name, boolean isRand) {
        Map<String, Boolean> randModes = this.randModeOverrides.get(uniqueHolderId);
        if (randModes == null) {
            randModes = new HashMap<String, Boolean>();
            this.randModeOverrides.put(uniqueHolderId, randModes);
        }
        randModes.put(name, isRand);
    }

    public boolean getRandMode(int uniqueHolderId, String name, boolean isRand) {
        Map<String, Boolean> randModes = this.randModeOverrides.get(uniqueHolderId);
        if (randModes == null) {
            return isRand;
        }
        if (randModes.containsKey(name)) {
            return randModes.get(name);
        }
        return isRand;
    }

    public Map<Integer, Map<String, Boolean>> getRandModesCopy() {
        HashMap<Integer, Map<String, Boolean>> randModeOverridesCopy = new HashMap<Integer, Map<String, Boolean>>();
        for (Map.Entry<Integer, Map<String, Boolean>> randModeOverridesEntry : this.randModeOverrides.entrySet()) {
            Map<String, Boolean> randModeOverridesPerClass = randModeOverridesEntry.getValue();
            HashMap<String, Boolean> randModeOverridesPerClassCopy = new HashMap<String, Boolean>(randModeOverridesPerClass);
            randModeOverridesCopy.put(randModeOverridesEntry.getKey(), randModeOverridesPerClassCopy);
        }
        return randModeOverridesCopy;
    }

    public void setRandModesCopy(Map<Integer, Map<String, Boolean>> randModeOverridesCopy) {
        this.randModeOverrides.clear();
        this.randModeOverrides.putAll(randModeOverridesCopy);
    }

    public void terminate() {
        try {
            IXModel xModel;
            if (this.ucisDBWriter != null) {
                this.ucisDBWriter.writeCoverGroupInstances();
                this.ucisDBWriter = null;
            }
            IXModel iXModel = xModel = this.vlogFactoryContributor != null ? this.vlogFactoryContributor.getXModel() : null;
            if (xModel != null && !xModel.isAlreadyComputed() && xModel.getRunBuildPhaseHandler() != null) {
                xModel.build(true);
            }
            if (this.vlogFactoryContributor != null) {
                this.vlogFactoryContributor.terminateContributor();
            }
            if (this.vhdlFactoryContributor != null) {
                this.vhdlFactoryContributor.terminateContributor();
            }
            this.terminateEvalEvents();
            this.clearCache();
            IProject project = this.getProject();
            XGlobalCache.INSTANCE.removeXSim(project);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public XInstValueHolder createInstanceValueHolder(ELInstance instance, XThread xGlobalThread) {
        XInstValueHolder instanceValueHolder = this.instanceValueHolders.get(instance.getHierarchyPath());
        if (instanceValueHolder != null) {
            return instanceValueHolder;
        }
        ElementPath path = instance.getHierarchyPath();
        XInstValueHolder parentInstanceValueHolder = this.getParentInstanceValueHolder(path);
        IRfScopeElement enclosingScopeElement = instance.getBinding(false).getEnclosingScope();
        XValueHolder enclosingValueHolder = null;
        if (parentInstanceValueHolder != null && enclosingScopeElement == parentInstanceValueHolder.getNamedElement()) {
            enclosingValueHolder = parentInstanceValueHolder;
        } else if (enclosingScopeElement instanceof IRfNamedElement) {
            enclosingValueHolder = this.createStaticValueHolder(XNamedElement.create((IRfNamedElement)enclosingScopeElement, null, true, this.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
        }
        instanceValueHolder = instance.getDescription() == XSimEventScheduler.BBOX_INSTANCE ? new XInstValueHolder.XBBoxValueHolder(this, enclosingValueHolder, instance) : (instance.getBinding(false) instanceof IRfClockingBlockElement ? XInstValueHolder.XClockingValueHolder.create(this, enclosingValueHolder, instance) : new XInstValueHolder(this, enclosingValueHolder, instance));
        instanceValueHolder.setParentInstanceScope(parentInstanceValueHolder);
        this.instanceValueHolders.put(path, instanceValueHolder);
        this.staticHoldersMap.put(instanceValueHolder.xAssociatedType, instanceValueHolder);
        this.updateTimeFormat(instance);
        if (path.length() <= 1 && xGlobalThread != null && !(instanceValueHolder instanceof XInstValueHolder.XBBoxValueHolder) && !(instanceValueHolder instanceof XInstValueHolder.XClockingValueHolder)) {
            this.topInstanceValueHolder = instanceValueHolder;
            xGlobalThread.setInstanceScope(instanceValueHolder);
        }
        return instanceValueHolder;
    }

    private XInstValueHolder getParentInstanceValueHolder(ElementPath path) {
        ElementPath parentPath = ElementPath.upperPathOf(path);
        if (parentPath == null || parentPath.isEmpty()) {
            return null;
        }
        XInstValueHolder parentInstanceValueHolder = this.instanceValueHolders.get(parentPath);
        if (parentInstanceValueHolder != null) {
            return parentInstanceValueHolder;
        }
        this.logError("Child instance created before parent instance for path '" + path + "' (internal error)");
        throw new UnsupportedOperationException();
    }

    public IProject getProject() {
        return this.xSim.getProject();
    }

    public XInstValueHolder getInstValueHolder(ElementPath path) {
        return this.instanceValueHolders.get(path);
    }

    public void startRegisterChangedVars() {
        if (this.changedVars == null) {
            this.changedVars = new BitSet();
        }
    }

    public BitSet getChangedVars() {
        return this.changedVars;
    }

    public void startOfTimeSlot(BigDecimal currentSimTime) {
        if (this.changedVars != null) {
            this.changedVars.clear();
        }
        if (this.preponedVarsValues != null) {
            this.preponedVarsValues.clear();
        }
        this.currentSimTime = currentSimTime;
    }

    public void endOfTimeSlot(BigDecimal currentSimTime) {
        this.resetClockingBlocks();
    }

    public BigDecimal internalCurrentSimTime() {
        return this.currentSimTime;
    }

    public long getDeltaCycleCount() {
        return this.deltaCycleCount;
    }

    public void incDeltaCycleCount() {
        ++this.deltaCycleCount;
    }

    public BigDecimal getCurrentSimTime() {
        if (this.currentSimTime == null || this.currentSimTime.signum() < 0) {
            return BigDecimal.ZERO;
        }
        return this.currentSimTime;
    }

    public void setSimTerminated(boolean isSimTerminated) {
        this.isSimTerminated = isSimTerminated;
    }

    public boolean isSimTerminated() {
        return this.isSimTerminated;
    }

    public void initInstancesMembers1(List<Runnable> constantAssigns, boolean isRuntimeElabOptimizedMode, IHidEvaluationGuardian guardian) {
        try {
            if (!isRuntimeElabOptimizedMode) {
                ArrayList<XInstValueHolder> leafsToTopOrder = new ArrayList<XInstValueHolder>(this.instanceValueHolders.values());
                Collections.sort(leafsToTopOrder, (ivh1, ivh2) -> {
                    ElementPath e1 = ivh1.getInstancePath();
                    ElementPath e2 = ivh2.getInstancePath();
                    return e2.length() - e1.length();
                });
                for (XInstValueHolder instanceValueHolder : leafsToTopOrder) {
                    this.setInstanceScopeDebugContext(instanceValueHolder);
                    instanceValueHolder.computePortCoercion();
                }
            }
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                instanceValueHolder.collectInterfacePortConnections();
            }
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                instanceValueHolder.initLocalVariables(true);
            }
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                XInstValueHolder instanceScope;
                IELParamValue instancesArray;
                this.setInstanceScopeDebugContext(instanceValueHolder);
                ELInstance instance = instanceValueHolder.getElInstance();
                IRfInstanceElement description = instance.getDescription();
                if (description == null) continue;
                this.xSim.setCurrentLineNumber(description);
                IRfNamedElement associatedType = description.xGetAssociatedType(instanceValueHolder.getEnclosingValue());
                if (!(associatedType instanceof IRfListType) || !((instancesArray = XUtils.getValue((instanceScope = instanceValueHolder.getParentInstance()).getValueImpl(description.getName(), description, false, false, true, guardian))) instanceof XArrayValueHolder)) continue;
                instanceScope.getSubInstances().put(description.getName(), (XArrayValueHolder)instancesArray);
            }
            this.isInstanceAllowed = false;
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                instanceValueHolder.declareLocalVariables();
            }
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                if (!isRuntimeElabOptimizedMode) {
                    instanceValueHolder.collectPortConnections(constantAssigns);
                }
                instanceValueHolder.collectAssignOperators(constantAssigns, isRuntimeElabOptimizedMode);
            }
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                this.computeMultipleDrivers(instanceValueHolder);
            }
            this.multipleDriversMap.clear();
            this.sharedPortReferenceMap.clear();
            this.sharedPortValueMap.clear();
        }
        finally {
            this.setInstanceScopeDebugContext(null);
        }
    }

    public void initInstancesMembers2(List<Runnable> constantAssigns) {
        try {
            this.isInstanceAllowed = false;
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                instanceValueHolder.initAssignOperators();
            }
            this.initAssignOperators();
            this.propagateInitAssignOperators();
            for (XInstValueHolder instanceValueHolder : this.instanceValueHolders.values()) {
                this.setInstanceScopeDebugContext(instanceValueHolder);
                this.createReferredStaticHolders(instanceValueHolder);
            }
            for (Runnable constantAssign : constantAssigns) {
                constantAssign.run();
            }
        }
        finally {
            this.setInstanceScopeDebugContext(null);
        }
    }

    private void updateTimeFormat(ELInstance instance) {
        IRfNamedElement binding = instance.getBinding(true);
        if (binding == null || binding.getLanguageKind() != LanguageKind.VLOG) {
            return;
        }
        XGlobalCache.TimeScale timeScale = XUtils.getTimescaleFromElement(binding);
        if (this.timeFormat == null || timeScale.getPrecision() < this.timeFormat.getPrecision()) {
            this.timeFormat = timeScale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateEvalEvents() {
        List<IXSimEvent> list = this.terminateEvalEvents;
        synchronized (list) {
            for (IXSimEvent evalEvent : this.terminateEvalEvents) {
                evalEvent.execute();
            }
        }
    }

    public void addMonitor(IHidOperator monitorOperator) {
        this.addEvent(XSimRegion.XRegionKind.Postponed, new XMonitorEvent(monitorOperator, XValueHolderFactory.getNoContext(), this.getEvaluationGuardian(false)));
    }

    public void addTerminateEvent(IXSimEvent runnable) {
        this.terminateEvalEvents.add(runnable);
    }

    public XThread getActiveThread() {
        IXThreadScheduler xThreadScheduler = this.xSim.getXThreadScheduler();
        return xThreadScheduler.getActiveThread();
    }

    public Map<ElementPath, XInstValueHolder> getInstanceValueHolders() {
        return this.instanceValueHolders;
    }

    public void logMessage(String message) {
        this.xSim.logMessage(message);
    }

    public void logError(String errorMessage) {
        this.xSim.logError(errorMessage, true);
    }

    public void logWarning(String warningMessage) {
        this.xSim.logWarning(warningMessage, true);
    }

    public void logWarning(String warningMessage, IRfDefElement declaration) {
        this.xSim.logWarning(warningMessage, declaration);
    }

    public void logWarning(String warningMessage, IRfDefElement declaration, int line) {
        this.xSim.logWarning(warningMessage, declaration, line);
    }

    public void setInstanceScopeDebugContext(XInstValueHolder instanceScope) {
        this.xSim.setInstanceScopeDebugContext(instanceScope);
    }

    public void xInternalProcessXVMConfigDBSet(HidEvalCenter.MethodCallStatement methodCallStatement, XThread xThread) {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.xInternalProcessXVMConfigDBSet(methodCallStatement, xThread);
        }
    }

    public void xInternalProcessXVMConfigDBGet(HidEvalCenter.MethodCallStatement methodCallStatement, XThread xThread, boolean foundResource) {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.xInternalProcessXVMConfigDBGet(methodCallStatement, xThread, foundResource);
        }
    }

    private void computeMultipleDrivers(XInstValueHolder instValueHolder) {
        Map<String, List<Driver>> multipleDrivers = this.multipleDriversMap.remove(instValueHolder);
        if (multipleDrivers == null || multipleDrivers.isEmpty()) {
            return;
        }
        this.setCurrentParserPath(instValueHolder.getParserPath());
        Iterator<List<Driver>> iterator = multipleDrivers.values().iterator();
        ArrayList<List<Driver>> computedMultipleDrivers = new ArrayList<List<Driver>>();
        block0: while (iterator.hasNext()) {
            List<Driver> drivers = iterator.next();
            if (drivers.size() < 2) {
                iterator.remove();
                continue;
            }
            int n = 0;
            while (n < drivers.size()) {
                Driver driver1 = drivers.get(n);
                this.setCurrentLineNumber(driver1.operator.getLine());
                int j = n + 1;
                while (j < drivers.size()) {
                    block18: {
                        Driver driver2 = drivers.get(j);
                        if (driver1.computedSelects == null || driver2.computedSelects == null) {
                            computedMultipleDrivers.add(drivers);
                            continue block0;
                        }
                        int m = 0;
                        while (m < Math.min(driver1.computedSelects.size(), driver2.computedSelects.size())) {
                            if (driver1.computedSelects.get(m).intersect(driver2.computedSelects.get(m)) != null) {
                                ++m;
                                continue;
                            }
                            break block18;
                        }
                        computedMultipleDrivers.add(drivers);
                        continue block0;
                    }
                    ++j;
                }
                ++n;
            }
        }
        if (computedMultipleDrivers.isEmpty()) {
            return;
        }
        IHidEvaluationGuardian guardian = this.getEvaluationGuardian(false);
        block4: for (List list : computedMultipleDrivers) {
            for (Driver driver : list) {
                ELParamValueScope hidValue = ELUtils.evaluate(driver.hid, null, null, guardian.copy());
                if (ELUtils.isUnsuccessfulEval(hidValue)) {
                    this.logError("Fail to evaluate '" + driver.hid + "' in scope of '" + driver.hid.getOverrideEvaluator() + "' (id:0010).");
                    continue;
                }
                IELParamValue existingValue = hidValue.value;
                if (existingValue instanceof XArrayValueHolder && ((XArrayValueHolder)existingValue).isDynamicArray()) continue block4;
                if (existingValue instanceof XArrayValueHolder) {
                    XArrayValueHolder arrayValue = (XArrayValueHolder)existingValue;
                    List<IELParamValue> zValues = arrayValue.getZValues();
                    int i = 0;
                    while (i < zValues.size()) {
                        IELParamValue itemExistingValue = zValues.get(i);
                        if (!(itemExistingValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Tristate)) {
                            IELParamValue tristateValue = ELParamValues.ParamValueNumber.tristate(itemExistingValue);
                            zValues.set(i, tristateValue);
                            List<SharedPortReference> references = this.sharedPortReferenceMap.get(itemExistingValue);
                            if (references != null && !references.isEmpty()) {
                                for (SharedPortReference reference : references) {
                                    reference.valueHolder.putValueDirectly(reference.name, tristateValue);
                                }
                            }
                        }
                        ++i;
                    }
                    continue block4;
                }
                if (existingValue instanceof XValueHolder) continue block4;
                IELParamValue original = XUtils.getOriginal(hidValue.value, true);
                XUtils.addToSetInMap(this.getUniqueId(original, true), driver.operator, this.assignOperatorsMap);
                if (existingValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Tristate) continue;
                IELParamValue tristateValue = ELParamValues.ParamValueNumber.tristate(existingValue);
                String name = XUtils.getName(driver.hid);
                hidValue.scope.putValueDirectly(name, tristateValue);
                List<SharedPortReference> references = this.sharedPortReferenceMap.get(existingValue);
                if (references == null || references.isEmpty()) continue;
                for (SharedPortReference reference : references) {
                    reference.valueHolder.putValueDirectly(reference.name, tristateValue);
                }
            }
        }
    }

    public void setDrivers(XInstValueHolder instValueHolder, List<IHidObject> hidObjects, XInstValueHolder.XEvalOverrideHidOperator operator) {
        for (IHidObject hidObject : hidObjects) {
            String name;
            List<Driver> drivers;
            IHidEvaluationGuardian guardian;
            ELParamValueScope valueScope;
            IRfNamedElement.NetType netType;
            Hid hid = XUtils.getParentHid(hidObject);
            if (hid == null) continue;
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess != null && XUtils.isStructOrUnion(parentAccess.getAssociatedType())) {
                hid = parentAccess.getParentHid();
            }
            if ((netType = XUtils.netType(hid)) == IRfNamedElement.NetType.NONE) continue;
            if (!(hid instanceof XInstValueHolder.XEvalOverrideHid)) {
                hid = new XInstValueHolder.XEvalOverrideHid(instValueHolder, hid);
            }
            if (ELUtils.isUnsuccessfulEval(valueScope = ELUtils.evaluate(hidObject, instValueHolder, null, (guardian = this.getEvaluationGuardian(true)).copy()))) {
                this.logError("Fail to evaluate '" + hidObject + "' in scope of '" + instValueHolder + "' (id:0013)");
                continue;
            }
            if (!(valueScope.scope instanceof XInstValueHolder)) continue;
            XInstValueHolder nonGenBlockParent = (XInstValueHolder)valueScope.scope;
            Map<String, List<Driver>> multipleDrivers = this.multipleDriversMap.get(nonGenBlockParent);
            if (multipleDrivers == null) {
                multipleDrivers = new HashMap<String, List<Driver>>();
                this.multipleDriversMap.put(nonGenBlockParent, multipleDrivers);
            }
            if ((drivers = multipleDrivers.get(name = XUtils.getName(hid))) == null) {
                drivers = new LinkedList<Driver>();
                multipleDrivers.put(name, drivers);
            }
            Driver driver = new Driver((XInstValueHolder.XEvalOverrideHid)hid, operator);
            if (hidObject instanceof XInstValueHolder.XSelectOperator) {
                driver.computedSelects = ((XInstValueHolder.XSelectOperator)hidObject).getComputedSelects();
            } else if (hidObject instanceof HidAccess) {
                selectProxy = valueScope.value.getSelectProxy();
                driver.computedSelects = selectProxy.computedSelects;
            } else if (valueScope.value instanceof ELParamValues.ParamValueNumber.PackedStructMember) {
                selectProxy = valueScope.value.getSelectProxy();
                driver.computedSelects = selectProxy.computedSelects;
            }
            drivers.add(driver);
        }
    }

    public List<Driver> getDrivers(XInstValueHolder instValueHolder, String name, ListContainer<XComputedSelect> computedSelects) {
        Map<String, List<Driver>> multipleDrivers = this.multipleDriversMap.get(instValueHolder);
        if (multipleDrivers == null) {
            return null;
        }
        List<Driver> drivers = multipleDrivers.get(name);
        if (drivers == null) {
            return null;
        }
        if (computedSelects == null) {
            return drivers;
        }
        for (Driver driver : drivers) {
            if (driver.computedSelects != null) continue;
            return drivers;
        }
        Set<XComputedSelect> concurrentSelects = Collections.newSetFromMap(new IdentityHashMap());
        concurrentSelects.add(computedSelects.get(0));
        ArrayList<Driver> result = new ArrayList<Driver>();
        block1: while (true) {
            result.clear();
            for (Driver driver : drivers) {
                XComputedSelect driverSelect = driver.computedSelects.get(0);
                if (concurrentSelects.contains(driverSelect)) {
                    result.add(driver);
                    continue;
                }
                for (XComputedSelect concurrentSelect : concurrentSelects) {
                    if (driverSelect.intersect(concurrentSelect) == null) continue;
                    concurrentSelects.add(driverSelect);
                    continue block1;
                }
            }
            break;
        }
        return result;
    }

    public IXSim.XSimMode simulatorMode() {
        return this.xSim.simulatorMode();
    }

    public boolean isRunInBatch() {
        return this.xSim.isRunInBatch();
    }

    public void setCurrentParserPath(ParserPath parserPath) {
        this.xSim.setCurrentParserPath(parserPath);
    }

    public void setCurrentLineNumber(int lineNumber) {
        this.xSim.setCurrentLineNumber(lineNumber);
    }

    public ParserPath getCurrentParserPath() {
        return this.xSim.getCurrentParserPath();
    }

    public int getCurrentLineNumber() {
        return this.xSim.getCurrentLineNumber();
    }

    public int getNoInstances() {
        return this.instanceValueHolders.size();
    }

    public void addEvent(XSimRegion.XRegionKind kind, IXSimEvent event) {
        IXThreadScheduler xThreadScheduler = this.xSim.getXThreadScheduler();
        xThreadScheduler.addEvent(kind, event);
    }

    public void prepareBeginSimulation() {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.prepareContributorBeginSimulation();
        }
        if (this.vhdlFactoryContributor != null) {
            this.vhdlFactoryContributor.prepareContributorBeginSimulation();
        }
    }

    public void prepareEndSimulation() {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.prepareContributorEndSimulation();
        }
        if (this.vhdlFactoryContributor != null) {
            this.vhdlFactoryContributor.prepareContributorEndSimulation();
        }
    }

    public IXValueHolderFactoryContributor getVlogContributor() {
        return this.vlogFactoryContributor;
    }

    public IXValueHolderFactoryContributor getVhdlContributor() {
        return this.vhdlFactoryContributor;
    }

    public void setVlogContributor(IXValueHolderFactoryContributor vlogFactoryContributor) {
        this.vlogFactoryContributor = vlogFactoryContributor;
    }

    public void setVhdlContributor(IXValueHolderFactoryContributor vhdlFactoryContributor) {
        this.vhdlFactoryContributor = vhdlFactoryContributor;
    }

    public void resumeAwaitingThreads(int threadId) {
        if (this.awaitingThreadsMap.isEmpty()) {
            return;
        }
        List<WaitingThread> awaitingThreads = this.awaitingThreadsMap.remove(threadId);
        if (awaitingThreads == null) {
            return;
        }
        for (WaitingThread awaitingThread : awaitingThreads) {
            awaitingThread.resumeThread();
        }
    }

    public void addAwaitingThread(int threadId, WaitingThread waitingThread) {
        List<WaitingThread> awaitingThreads = this.awaitingThreadsMap.get(threadId);
        if (awaitingThreads == null) {
            awaitingThreads = new ArrayList<WaitingThread>();
            this.awaitingThreadsMap.put(threadId, awaitingThreads);
        }
        awaitingThreads.add(waitingThread);
    }

    public void scheduleWaitingThreads(int uniqueId, XSimRegion.XRegionKind regionKind) {
        if (uniqueId < 0) {
            return;
        }
        if (this.changedVars != null) {
            this.changedVars.set(uniqueId);
        }
        if (this.waitingThreadsMap.isEmpty()) {
            return;
        }
        if (!this.waitingThreadsMap.containsKey(uniqueId)) {
            return;
        }
        this.addEvent(regionKind, new XResumeThreadEvent(uniqueId, this));
    }

    public void resumeWaitingThreads(int uniqueId) {
        if (uniqueId < 0) {
            return;
        }
        if (this.changedVars != null) {
            this.changedVars.set(uniqueId);
        }
        if (this.waitingThreadsMap.isEmpty()) {
            return;
        }
        Set<WaitingThread> waitingThreads = this.waitingThreadsMap.get(uniqueId);
        if (waitingThreads == null) {
            return;
        }
        for (WaitingThread waitingThread : waitingThreads) {
            waitingThread.resumeThread();
        }
    }

    public void addWaitingThread(IELParamValue value, WaitingThread waitingThread) {
        int uniqueId = this.getUniqueId(value, true);
        Set<WaitingThread> waitingThreads = this.waitingThreadsMap.get(uniqueId);
        if (waitingThreads == null) {
            waitingThreads = new LinkedHashSet<WaitingThread>();
            this.waitingThreadsMap.put(uniqueId, waitingThreads);
        }
        waitingThreads.remove(waitingThread);
        waitingThreads.add(waitingThread);
    }

    public int getUniqueId(IELParamValue value, boolean createUniqueId) {
        if (value instanceof XValueHolder) {
            return ((XValueHolder)value).uniqueId();
        }
        if (value instanceof ELParamValues.ParamValueNumber || value instanceof ELParamValues.ParamValueType) {
            return this.uniqueId(value, createUniqueId);
        }
        if (value instanceof IELParamValue.BBoxValue) {
            return -1;
        }
        throw new UnsupportedOperationException();
    }

    private int uniqueId(IELParamValue value, boolean createUniqueId) {
        DVTNumber number = value.getDVTNumber();
        int uniqueId = number.getUniqueId();
        if (uniqueId < 0 && createUniqueId) {
            uniqueId = this.getUniqueId();
            number = number.setUniqueId(uniqueId, value instanceof ELParamValues.ParamValueNumber);
            if (value instanceof ELParamValues.ParamValueNumber) {
                ((ELParamValues.ParamValueNumber)value).setDVTNumber(number);
            }
        }
        return uniqueId;
    }

    public Collection<XInstValueHolder.XEvalOverrideHidOperator> getAssignOperators(int uniqueId) {
        return this.assignOperatorsMap.get(uniqueId);
    }

    public Map<Integer, Set<XInstValueHolder.XEvalOverrideHidOperator>> getAssignOperatorsMap() {
        return this.assignOperatorsMap;
    }

    public void addInitAssignOperator(int uniqueId, XInstValueHolder.XEvalOverrideHidOperator operator) {
        this.initAssignOperators.add(operator);
    }

    public List<XInstValueHolder.XEvalOverrideHidOperator> getInitAssignOperators() {
        return this.initAssignOperators;
    }

    public Map<Integer, List<XInstValueHolder.XEvalOverrideHidOperator>> getReleaseOperatorsMap() {
        return this.releaseOperatorsMap;
    }

    public void initAssignOperators() {
        if (this.initAssignOperators == null) {
            return;
        }
        IHidEvaluationGuardian guardian = this.getEvaluationGuardian(false);
        for (XInstValueHolder.XEvalOverrideHidOperator operator : this.initAssignOperators) {
            try {
                boolean isDeclarationAssign;
                boolean bl = isDeclarationAssign = operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) || operator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_EXPRESSION);
                if (isDeclarationAssign) {
                    ELParamValueScope valueAssign = this.evaluateAssignOperator(operator);
                    if (ELUtils.isUnsuccessfulEval(valueAssign)) continue;
                    IELParamValue value = XUtils.getValue(valueAssign);
                    IELParamValue original = XUtils.getOriginal(value, false);
                    int uniqueId = this.getUniqueId(original, false);
                    this.initAssignValues.put(uniqueId, value);
                    continue;
                }
                ParserPath parserPath = this.getCurrentParserPath();
                guardian.callbackDelayedAssign(BigDecimal.ZERO, XSimRegion.XRegionKind.Active, () -> {
                    this.setCurrentParserPath(parserPath);
                    this.setCurrentLineNumber(operator.getLine());
                    this.evaluateAssignOperator(operator);
                });
            }
            catch (IELParamValue.BBoxEvaluationException bBoxEvaluationException) {
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void propagateInitAssignOperators() {
        if (this.assignOperatorsMap == null) {
            return;
        }
        LinkedHashSet<XInstValueHolder.XEvalOverrideHidOperator> uniqueOperators = new LinkedHashSet<XInstValueHolder.XEvalOverrideHidOperator>();
        for (Set<XInstValueHolder.XEvalOverrideHidOperator> operators : this.assignOperatorsMap.values()) {
            for (XInstValueHolder.XEvalOverrideHidOperator operator : operators) {
                uniqueOperators.add(operator);
            }
        }
        ArrayList topToBottomList = new ArrayList(uniqueOperators);
        Collections.sort(topToBottomList, (o1, o2) -> {
            XValueHolder overrideEvaluator1 = o1.getOverrideEvaluator();
            XValueHolder overrideEvaluator2 = o2.getOverrideEvaluator();
            return overrideEvaluator1.getInstancePath().length() - overrideEvaluator2.getInstancePath().length();
        });
        for (XInstValueHolder.XEvalOverrideHidOperator operator : topToBottomList) {
            boolean isClockingOutputDriver;
            HidOperator assignOperator;
            IHidObject assignRHSide;
            IHidOperator overrideOperator = operator.getOverrideOperator();
            if (overrideOperator instanceof HidEvalCenter.DelayedContinuousAssign && HidUtils.isHid(assignRHSide = (assignOperator = (HidOperator)overrideOperator.getFirstRHValue()).getFirstRHValue()) && (isClockingOutputDriver = XUtils.isClockingOutputDriver(((Hid)assignRHSide).getElement()))) continue;
            this.evaluateAssignOperator(operator);
        }
    }

    private ELParamValueScope evaluateAssignOperator(XInstValueHolder.XEvalOverrideHidOperator operator) {
        boolean isPortConnection = operator.hasQualifier(HidOperatorQualifier.IS_PORT_CONNECTION.value());
        String additionalInfo = isPortConnection ? "port connection" : "assign";
        IHidEvaluationGuardian guardian = this.getEvaluationGuardian(true);
        ParserPath operatorParserPath = operator.getParserPath();
        int operatorLine = operator.getLine();
        this.setCurrentParserPath(operatorParserPath);
        this.setCurrentLineNumber(operatorLine);
        XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, operator.getOverrideEvaluator(), null, guardian, null, operator.getParserPath(), additionalInfo, true);
        try {
            XThread activeThread;
            if (this.isStepIntoAssignEnable()) {
                guardian.startEvalScope(xEvalScope);
            }
            IntrpStackFrame intrpStackFrame = (activeThread = guardian.getActiveThread()) != null ? this.getTopStackFrame(activeThread) : null;
            try {
                if (intrpStackFrame != null) {
                    intrpStackFrame.setParserPath(operatorParserPath);
                    intrpStackFrame.setInitialParserPath(operatorParserPath);
                    intrpStackFrame.currLine = operatorLine;
                    guardian.checkBuildCanceled();
                    guardian.callbackStartStatement(activeThread, operator);
                }
                ELParamValueScope eLParamValueScope = ELUtils.evaluate(operator, null, null, guardian.copy());
                if (intrpStackFrame != null) {
                    guardian.callbackEndStatement(activeThread, operator);
                }
                return eLParamValueScope;
            }
            catch (Throwable throwable) {
                try {
                    if (intrpStackFrame != null) {
                        guardian.callbackEndStatement(activeThread, operator);
                    }
                    throw throwable;
                }
                catch (XThread.XSuspendThreadException xSuspendThreadException) {
                }
                catch (BuildCancelException e) {
                    throw e;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        finally {
            if (this.isStepIntoAssignEnable()) {
                guardian.endEvalScope(xEvalScope);
            }
        }
        return null;
    }

    private IntrpStackFrame getTopStackFrame(XThread xThread) {
        XEvalScope enclosingScope = xThread.getEnclosingScope(false);
        if (enclosingScope == null) {
            return null;
        }
        IStackFrame stackFrame = enclosingScope.getStackFrame();
        if (!(stackFrame instanceof IntrpStackFrame)) {
            return null;
        }
        return (IntrpStackFrame)stackFrame;
    }

    public void applyForceOperators(ForceValue forceValue, ForceValue proceduralValue, IELParamValue releaseValue, IHidEvaluationGuardian guardian) {
        if (forceValue == null && proceduralValue == null) {
            return;
        }
        if (proceduralValue != null) {
            proceduralValue.applyForce(releaseValue, guardian);
        }
        if (forceValue != null) {
            forceValue.applyForce(releaseValue, guardian);
        }
    }

    public ForceValue removeForceValue(int uniqueId) {
        if (this.forceAssignOperatorsMap.isEmpty()) {
            return null;
        }
        return this.forceAssignOperatorsMap.remove(uniqueId);
    }

    public ForceValue removeProceduralValue(int uniqueId) {
        if (this.proceduralAssignOperatorsMap.isEmpty()) {
            return null;
        }
        return this.proceduralAssignOperatorsMap.remove(uniqueId);
    }

    public List<XInstValueHolder.XEvalOverrideHidOperator> getReleaseOperators(int uniqueId) {
        if (this.releaseOperatorsMap.isEmpty()) {
            return null;
        }
        return this.releaseOperatorsMap.get(uniqueId);
    }

    public void addForceValue(int uniqueId, ForceValue value) {
        if (value == null) {
            return;
        }
        this.forceAssignOperatorsMap.put(uniqueId, value);
    }

    public void addProceduralValue(int uniqueId, ForceValue value) {
        if (value == null) {
            return;
        }
        this.proceduralAssignOperatorsMap.put(uniqueId, value);
    }

    public void addForceOperator(XInstValueHolder.XEvalOverrideHidOperator operator) {
        this.addForceOperator(operator, false, this.forceAssignOperatorsMap);
    }

    public void addReleaseOperator(XInstValueHolder.XEvalOverrideHidOperator operator) {
        this.addForceOperator(operator, true, this.forceAssignOperatorsMap);
    }

    public void addProceduralAssignOperator(XInstValueHolder.XEvalOverrideHidOperator operator) {
        this.addForceOperator(operator, false, this.proceduralAssignOperatorsMap);
    }

    public void addProceduralDeassignOperator(XInstValueHolder.XEvalOverrideHidOperator operator) {
        this.addForceOperator(operator, true, this.proceduralAssignOperatorsMap);
    }

    public void addForceOperator(XInstValueHolder.XEvalOverrideHidOperator forceOperator, boolean isRelease, Map<Integer, ForceValue> forceOperators) {
        IHidEvaluationGuardian guardian = this.getEvaluationGuardian(false);
        IHidObject leftOperand = forceOperator.getLHValue();
        XValueHolder evaluator = forceOperator.getOverrideEvaluator();
        List<IHidObject> lhObjects = XUtils.getLHObjects(leftOperand);
        Set<Object> rhHids = isRelease ? Collections.emptySet() : XUtils.getDrivers(forceOperator.operator, XUtils.ASSIGN_HID_FLATTENING, evaluator, guardian.copy());
        int offset = 0;
        for (IHidObject lhObject : lhObjects) {
            ELParamValueScope hidValueScope;
            IELParamValue hidValue;
            Hid hid = XUtils.getParentHid(lhObject);
            if (hid == null || ELUtils.isUnsuccessfulEval(hidValue = XUtils.getValue(hidValueScope = ELUtils.evaluate(lhObject, evaluator, null, guardian.copy())))) continue;
            IELParamValue original = XUtils.getOriginal(hidValue, true);
            int uniqueId = this.getUniqueId(original, true);
            boolean isOverride = true;
            ForceValue.ForceDriver forceDriver = new ForceValue.ForceDriver(new XInstValueHolder.XEvalOverrideHid((XValueHolder)XUtils.getScope(hidValueScope), hid), forceOperator, isRelease);
            XSelectProxy selectProxy = hidValue.getSelectProxy();
            if (selectProxy != null) {
                forceDriver.computedSelects = selectProxy.computedSelects;
                isOverride = false;
            }
            if (lhObject instanceof XInstValueHolder.XSelectOperator) {
                forceDriver.computedSelects = ((XInstValueHolder.XSelectOperator)lhObject).getComputedSelects();
                isOverride = false;
            }
            if (lhObjects.size() > 1) {
                ELParamValueScope eLParamValueScope = ELUtils.evaluateForSize(lhObject, evaluator, null, guardian.copy());
                int size = XUtils.getValue(eLParamValueScope).getDVTNumber().getSize();
                HidOperator operatorChunk = forceOperator.operator.shallowCopy();
                operatorChunk.setLHValue(lhObject);
                operatorChunk.setRHValues(new XInstValueHolder.XSelectOperator(forceOperator.operator.getFirstRHValue(), size - 1 + offset, offset));
                forceDriver.operator = new XInstValueHolder.XEvalOverrideHidOperator(forceOperator.getOverrideEvaluator(), operatorChunk, forceOperator.getParserPath());
                offset += size;
            }
            this.addForceValue(uniqueId, isRelease, isOverride, forceDriver, forceOperators, guardian);
            for (IHid iHid : rhHids) {
                hidValue = XUtils.getValue(ELUtils.evaluate(iHid, evaluator, null, guardian.copy()));
                if (hidValue instanceof XInstValueHolder) continue;
                original = XUtils.getOriginal(hidValue, false);
                uniqueId = this.getUniqueId(original, true);
                this.addForceValue(uniqueId, isRelease, isOverride, forceDriver, forceOperators, guardian);
            }
        }
    }

    private void addForceValue(int uniqueId, boolean isRelease, boolean isOverride, ForceValue.ForceDriver forceDriver, Map<Integer, ForceValue> forceOperators, IHidEvaluationGuardian guardian) {
        if (isRelease && isOverride) {
            this.removeForceValue(uniqueId, forceOperators);
            return;
        }
        ForceValue existingForceValue = forceOperators.get(uniqueId);
        if (isRelease) {
            if (existingForceValue == null) {
                return;
            }
            existingForceValue.addReleaseValue(uniqueId, forceDriver, existingForceValue, guardian);
            if (existingForceValue.drivers.isEmpty()) {
                this.removeForceValue(uniqueId, forceOperators);
                return;
            }
            return;
        }
        if (existingForceValue == null) {
            forceOperators.put(uniqueId, new ForceValue().addDriver(forceDriver, uniqueId));
            return;
        }
        existingForceValue.addDriver(forceDriver, uniqueId);
    }

    private void removeForceValue(int uniqueId, Map<Integer, ForceValue> forceOperators) {
        ForceValue forceValue = forceOperators.remove(uniqueId);
        if (forceValue == null) {
            return;
        }
        for (ForceValue.ForceDriver driver : forceValue.drivers) {
            for (Integer removeUniqueId : driver.uniqueIds) {
                forceOperators.remove(removeUniqueId);
            }
        }
    }

    public XInstValueHolder getTopInstanceValueHolder() {
        return this.topInstanceValueHolder;
    }

    public boolean isVirtual(IRfMethodElement methodElement) {
        if (methodElement == null) {
            return false;
        }
        Boolean isVirtual = this.virtualMethodsCache.get(methodElement);
        if (isVirtual == null) {
            isVirtual = methodElement.isVirtual();
            this.virtualMethodsCache.put(methodElement, isVirtual);
        }
        return isVirtual;
    }

    public RfMixedLangProject getRfMixedLangProject() {
        RfMixedLangProject rfMixedLangProject = this.xSim.getRfMixedLangProject();
        return rfMixedLangProject;
    }

    public boolean hasEncryptedCode(IRfScopeElement element) {
        RfMixedLangProject rfMixedLangProject = this.xSim.getRfMixedLangProject();
        return rfMixedLangProject != null && rfMixedLangProject.xHasEncryptedCode(element);
    }

    public boolean isEnableEncryptedCodeAutoDefine() {
        return this.isEnableEncryptedCodeAutoDefine;
    }

    public boolean isDemoteUserErrorsAndWarnings() {
        return this.isDemoteUserErrorsAndWarnings;
    }

    public ELParamValues.ParamValueNumber getSharedPortValue(int inputUniqueId) {
        return this.sharedPortValueMap.get(inputUniqueId);
    }

    public void setSharedPortValue(int inputUniqueId, ELParamValues.ParamValueNumber portValue) {
        this.sharedPortValueMap.put(inputUniqueId, portValue);
    }

    public void setSharedPortReference(String name, ELParamValues.ParamValueNumber value, XInstValueHolder valueHolder) {
        XUtils.addToListInMap(value, new SharedPortReference(name, valueHolder), this.sharedPortReferenceMap);
    }

    public void flushWriterVCD() {
        if (this.vlogFactoryContributor != null) {
            this.vlogFactoryContributor.flushWriterVCD();
        }
    }

    public void setRunTestCall() {
        this.runTestCall = true;
    }

    public boolean isRunTestCall() {
        return this.runTestCall;
    }

    public HidOperator createInsideOperator(IHidObject expression, IHidObject insideRange) {
        if (this.vlogFactoryContributor == null) {
            throw new UnsupportedOperationException();
        }
        return this.vlogFactoryContributor.createInsideOperator(expression, insideRange);
    }

    public Random getRandcaseRandom() {
        if (this.randcaseRandom == null) {
            this.randcaseRandom = new Random(this.getInitialSeed());
        }
        return this.randcaseRandom;
    }

    public Random getShuffleRandom() {
        if (this.shuffleRandom == null) {
            this.shuffleRandom = new Random(this.getInitialSeed());
        }
        return this.shuffleRandom;
    }

    public boolean isUCIS() {
        if (this.argv == null || this.argv.isEmpty()) {
            return false;
        }
        if (this.isUCIS >= 0) {
            return this.isUCIS == 1;
        }
        for (String arg : this.argv) {
            if (!arg.equals(DVT_UCIS)) continue;
            this.isUCIS = 1;
            return true;
        }
        this.isUCIS = 0;
        return false;
    }

    public boolean isCoverage() {
        if (this.argv == null || this.argv.isEmpty()) {
            return false;
        }
        if (this.isCoverage >= 0) {
            return this.isCoverage == 1;
        }
        for (String arg : this.argv) {
            if (!arg.equals(DVT_COVERAGE)) continue;
            this.isCoverage = 1;
            return true;
        }
        this.isCoverage = 0;
        return false;
    }

    public String getInitialVerbosity() {
        String verbosity = "UVM_MEDIUM";
        if (this.argv == null || this.argv.isEmpty()) {
            return verbosity;
        }
        try {
            for (String arg : this.argv) {
                String verbosityText;
                if (!arg.startsWith("+UVM_VERBOSITY=") && !arg.startsWith("+OVM_VERBOSITY=") || (verbosityText = arg.substring("+UVM_VERBOSITY=".length())).isEmpty()) continue;
                verbosity = verbosityText;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return verbosity;
        }
        return verbosity;
    }

    public int getInitialSeed() {
        if (this.initialSeed >= 0) {
            return this.initialSeed;
        }
        this.initialSeed = 0;
        if (this.argv == null || this.argv.isEmpty()) {
            return this.initialSeed;
        }
        try {
            for (String arg : this.argv) {
                String seedText;
                if (!arg.startsWith("+SEED=") || (seedText = arg.substring("+SEED=".length())).isEmpty()) continue;
                this.initialSeed = seedText.equalsIgnoreCase("random") ? Math.abs((int)System.currentTimeMillis()) : Integer.parseInt(seedText);
                break;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.initialSeed;
    }

    @NotNull
    public XGlobalCache.TimeScale getTimeFormat() {
        return this.timeFormat == null ? XGlobalCache.TimeScale.DEFAULT_TIME_SCALE : this.timeFormat;
    }

    public void printExtraDebugMessage(boolean isAddExtraDebugInfo, String message, long startTime) {
        if (!isAddExtraDebugInfo) {
            return;
        }
        String debugMessage = null;
        debugMessage = startTime < 0L ? DVTStringUtil.appendString("DEBUG: ", message) : DVTStringUtil.appendString("DEBUG: ", message, " (done after ", System.currentTimeMillis() - startTime, " ms)");
        this.xSim.logWarning(debugMessage, false);
    }

    public boolean disablePortSharing() {
        return this.isPortOptDisabled;
    }

    public void setDeferredReporting(IRfAssertExpectElement.AssertKind assertKind, XThread activeThread) {
        this.xSim.setDeferredReporting(assertKind, activeThread);
    }

    public void resetDeferredReporting() {
        this.xSim.resetDeferredReporting();
    }

    public boolean isAddExtraDebugInfo() {
        return this.isAddExtraDebugInfo;
    }

    public HidOperator transformEdgeControl(HidOperator eventControl, IHidObject statement, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        if (this.vlogFactoryContributor == null) {
            return null;
        }
        return this.vlogFactoryContributor.transformEdgeControl(eventControl, statement, evaluator, guardian);
    }

    public void addRandcVariable(String fullName, XCModel model, XCValue xcValue) {
        xcValue.setRandcName(fullName);
        IDomain existingDomain = this.randcVariableDomains.get(fullName);
        if (existingDomain == null || existingDomain.isEmpty()) {
            existingDomain = xcValue.getIntVar().getDomain().copy();
            this.randcVariableDomains.put(fullName, existingDomain);
            return;
        }
        IntVariable intVar = xcValue.getIntVar();
        IntVariable dummyIntVar = new IntVariable((Model)model, intVar.isSigned(), intVar.nofBits());
        dummyIntVar.setDomain(existingDomain.copy());
        intVar.eq(dummyIntVar).reify().soft().ne(model.getCachedConstant(true, 32, BigInteger.ZERO));
    }

    public void updateRandcVariable(String fullName, IELParamValue value) {
        if (fullName == null) {
            return;
        }
        IDomain domain = this.randcVariableDomains.remove(fullName);
        domain = domain.remove(value.bigIntegerValue());
        this.randcVariableDomains.put(fullName, domain);
    }

    @NotNull
    public String replaceSysVars(String input) {
        try {
            Matcher matcher = IDVTConstants.SYSTEM_VARIABLE_PATTERN.matcher(input);
            boolean result = matcher.find();
            if (!result) {
                return input;
            }
            StringBuffer sb = new StringBuffer();
            do {
                String sysVarName = null;
                int i = 1;
                while (i <= matcher.groupCount()) {
                    sysVarName = matcher.group(i);
                    if (sysVarName != null) break;
                    ++i;
                }
                String sysVarValue = this.getenv(sysVarName);
                if (sysVarValue == null) {
                    this.xSim.logError(DVTStringUtil.appendString("System variable ", sysVarName, " could not be resolved."), true);
                    return input;
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(sysVarValue));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            input = sb.toString();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return input;
        }
        return input;
    }

    private String getenv(String sysVarName) {
        BuildConfigParser.Definition definition = this.runtimeEnvironmentVars.get(sysVarName);
        if (definition != null) {
            return definition.value;
        }
        return System.getenv(sysVarName);
    }

    public void addClockingBlock(XInstValueHolder.XClockingValueHolder clockingValueHolder) {
        this.clockingValueHolders.add(clockingValueHolder);
    }

    public void resetClockingBlocks() {
        for (XInstValueHolder.XClockingValueHolder clockingValueHolder : this.clockingValueHolders) {
            clockingValueHolder.resetDriven();
        }
    }

    public void setPrintVerbosity(String verbosity) {
        this.printUvmVerbosity = verbosity;
    }

    public String getPrintVerbosity() {
        return this.printUvmVerbosity;
    }

    public String getTestName() {
        if (this.argv == null) {
            return null;
        }
        for (String arg : this.argv) {
            String testText;
            boolean startsWithUVM = arg.startsWith("+UVM_TESTNAME");
            boolean startsWithOVM = arg.startsWith("+OVM_TESTNAME");
            if (!startsWithUVM && !startsWithOVM) continue;
            String string = testText = startsWithUVM ? arg.substring("+UVM_TESTNAME=".length()) : arg.substring("+OVM_TESTNAME=".length());
            if (testText.isEmpty()) continue;
            return testText;
        }
        return null;
    }

    public void putChangedVariableCount(int uniqueId) {
        this.changedVariableCounters.put(uniqueId, 0);
    }

    public int getChangedVariableCount(int uniqueId) {
        return this.changedVariableCounters.get(uniqueId);
    }

    public void incrementChangedVariableCount(int uniqueId) {
        if (!this.changedVariableCounters.containsKey(uniqueId)) {
            return;
        }
        int count = this.changedVariableCounters.get(uniqueId);
        this.changedVariableCounters.put(uniqueId, ++count);
    }

    public int putReleaseTriggerId(int uniqueId) {
        if (this.releaseTriggerIds.containsKey(uniqueId)) {
            return this.releaseTriggerIds.get(uniqueId);
        }
        int value = -(this.releaseTriggerIds.size() + 100);
        this.releaseTriggerIds.put(uniqueId, value);
        return value;
    }

    public int getReleaseTriggerId(int uniqueId) {
        if (this.releaseTriggerIds.containsKey(uniqueId)) {
            return this.releaseTriggerIds.get(uniqueId);
        }
        return 0;
    }

    public IELParamValue getInitAssignValue(int uniqueId) {
        if (this.initAssignValues == null || this.initAssignValues.isEmpty()) {
            return null;
        }
        return this.initAssignValues.get(uniqueId);
    }

    public void registerPreponedVar(ELParamValueScope valueScope) {
        IELParamValue original = XUtils.getOriginal(valueScope.value, false);
        int uniqueId = this.getUniqueId(original, true);
        this.preponedVarsIds.add(uniqueId);
    }

    public boolean isPreponedId(int uniqueId) {
        return this.preponedVarsIds.contains(uniqueId);
    }

    public void addPreponedValue(int uniqueId, IELParamValue preValue) {
        if (this.preponedVarsValues == null) {
            this.preponedVarsValues = new HashMap<Integer, IELParamValue>();
        }
        if (this.preponedVarsValues.containsKey(uniqueId)) {
            return;
        }
        this.preponedVarsValues.put(uniqueId, preValue.scalarCopy());
    }

    public ELParamValueScope getPreponedValue(ELParamValueScope valueScope) {
        IELParamValue original = XUtils.getOriginal(valueScope.value, false);
        int uniqueId = this.getUniqueId(original, true);
        IELParamValue preponedVarValue = this.preponedVarsValues.get(uniqueId);
        if (preponedVarValue != null) {
            return ELParamValueScope.of(preponedVarValue, valueScope.scope);
        }
        return valueScope;
    }

    public void registerAssertTM(XInstValueHolder instanceHolder, IRfAssertExpectElement assertElement, AssertTM assertTM) {
        AssertTM.AssertResultHolder assertResultHolder;
        ElementPath instancePath = instanceHolder.getInstancePath();
        Set<AssertTM> assertTMs = this.assertTMs.get(instancePath);
        if (assertTMs == null) {
            assertTMs = new IdentityHSet<AssertTM>(16);
            this.assertTMs.put(instancePath, assertTMs);
        }
        assertTMs.add(assertTM);
        if (!this.isAddExtraDebugInfo) {
            return;
        }
        Map<IRfAssertExpectElement, AssertTM.AssertResultHolder> instanceAssertionsResult = this.assertResults.get(instancePath);
        if (instanceAssertionsResult == null) {
            instanceAssertionsResult = new LinkedHashMap<IRfAssertExpectElement, AssertTM.AssertResultHolder>();
            this.assertResults.put(instancePath, instanceAssertionsResult);
        }
        if ((assertResultHolder = instanceAssertionsResult.get(assertElement)) == null) {
            assertResultHolder = new AssertTM.AssertResultHolder();
            instanceAssertionsResult.put(assertElement, assertResultHolder);
        }
    }

    public void printAssertionReport() {
        try {
            boolean isPrinting;
            boolean bl = isPrinting = this.assertTMs != null && !this.assertTMs.isEmpty() && this.assertResults != null && !this.assertResults.isEmpty();
            if (!isPrinting) {
                return;
            }
            StringBuilder sb = new StringBuilder(System.lineSeparator());
            XGlobalCache.TimeScale timeScale = XUtils.getTimeScale(this.getTopInstanceValueHolder());
            BigDecimal simTime = this.currentSimTime.divide(timeScale.unit).setScale(0, RoundingMode.HALF_UP);
            String precisionText = XUtils.reverseTimeUnitExponent(timeScale.getPrecision(), false);
            sb.append(String.format("%8s %8s %8s %8s   %s%n", "Kind", "Disabled", "Finish", "Failed", "Assertion Name"));
            IdentityHSet failingAssertions = new IdentityHSet(16);
            IdentityHSet uncheckedAssertions = new IdentityHSet(16);
            IdentityHSet errorAssertions = new IdentityHSet(16);
            AtomicInteger noCounts = new AtomicInteger();
            this.assertResults.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                Map instanceAssertionsResult = (Map)entry.getValue();
                ElementPath path = (ElementPath)entry.getKey();
                instanceAssertionsResult.entrySet().stream().sorted(Comparator.comparing(e -> e.toString())).forEach(entry2 -> {
                    IRfAssertExpectElement assertElement = (IRfAssertExpectElement)entry2.getKey();
                    AssertTM.AssertResultHolder resultHolder = (AssertTM.AssertResultHolder)entry2.getValue();
                    sb.append(String.format("%8s %8d %8d %8d   %s%n", assertElement.getAssertionKindName(), resultHolder.disabledCount, resultHolder.finishedCount, resultHolder.failedCount, String.valueOf(path.toString(".")) + "." + assertElement.getName()));
                    noCounts.incrementAndGet();
                    if (resultHolder.failedCount > 0) {
                        failingAssertions.add(assertElement);
                    }
                    if (resultHolder.disabledCount == 0 && resultHolder.finishedCount == 0 && resultHolder.failedCount == 0) {
                        uncheckedAssertions.add(assertElement);
                    }
                    if (resultHolder.errorCount > 0) {
                        errorAssertions.add(assertElement);
                    }
                });
            });
            sb.append("Assertion summary at time " + simTime + precisionText.toUpperCase()).append(System.lineSeparator());
            sb.append(String.format("Total Assertions = %d, Failing Assertions = %d, Unchecked Assertions = %d", noCounts.get(), failingAssertions.size(), uncheckedAssertions.size()));
            if (!errorAssertions.isEmpty()) {
                sb.append(String.format(", Internal Errors Assertions = %d", errorAssertions.size()));
            }
            sb.append(System.lineSeparator());
            this.logMessage(sb.toString());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void registerAssertResult(ElementPath instancePath, IRfAssertExpectElement assertElement, AssertTM.AssertResult result) {
        AssertTM.AssertResultHolder assertResultHolder;
        if (!this.isAddExtraDebugInfo) {
            return;
        }
        Map<IRfAssertExpectElement, AssertTM.AssertResultHolder> instanceAssertionsResult = this.assertResults.get(instancePath);
        if (instanceAssertionsResult == null) {
            instanceAssertionsResult = new LinkedHashMap<IRfAssertExpectElement, AssertTM.AssertResultHolder>();
            this.assertResults.put(instancePath, instanceAssertionsResult);
        }
        if ((assertResultHolder = instanceAssertionsResult.get(assertElement)) == null) {
            assertResultHolder = new AssertTM.AssertResultHolder();
            instanceAssertionsResult.put(assertElement, assertResultHolder);
        }
        if (result == AssertTM.AssertResult.DISABLED) {
            ++assertResultHolder.disabledCount;
        } else if (result == AssertTM.AssertResult.FINISH) {
            ++assertResultHolder.finishedCount;
        } else if (result == AssertTM.AssertResult.FAILED) {
            ++assertResultHolder.failedCount;
        } else if (result == AssertTM.AssertResult.ERROR) {
            ++assertResultHolder.errorCount;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public Map<ElementPath, Set<AssertTM>> getAssertTMs() {
        return this.assertTMs;
    }

    public void triggerVPICallbackEvents(int eventType) {
        if (this.vlogFactoryContributor == null) {
            return;
        }
        this.vlogFactoryContributor.triggerVPICallbackEvents(eventType);
    }

    public void registerVPICallbackEvents() {
        if (this.vlogFactoryContributor == null) {
            return;
        }
        IXSystemCFactory systemCFactory = this.vlogFactoryContributor.getSystemCFactory();
        if (systemCFactory == null) {
            return;
        }
        systemCFactory.registerVPICallbackEvents();
    }

    public static class Driver {
        public XInstValueHolder.XEvalOverrideHid hid;
        public ListContainer<XComputedSelect> computedSelects;
        public XInstValueHolder.XEvalOverrideHidOperator operator;

        public Driver(XInstValueHolder.XEvalOverrideHid hid, XInstValueHolder.XEvalOverrideHidOperator operator) {
            this.hid = hid;
            this.operator = operator;
        }

        public String toString() {
            StringBuilder resultText = new StringBuilder();
            resultText.append("'").append(this.hid.getName());
            if (this.computedSelects != null && !this.computedSelects.isEmpty()) {
                resultText.append("[");
                resultText.append(this.computedSelects.get(0).toString());
                if (this.computedSelects.size() == 2) {
                    resultText.append(":");
                    resultText.append(this.computedSelects.get(1).toString());
                }
                resultText.append("]");
            }
            resultText.append("': ");
            resultText.append(this.operator.toString());
            return resultText.toString();
        }
    }

    public static class ForceValue {
        private List<ForceDriver> drivers = new ArrayList<ForceDriver>();

        public ForceValue addDriver(ForceDriver forceDriver, int uniqueId) {
            forceDriver.uniqueIds.add(uniqueId);
            for (ForceDriver driver : this.drivers) {
                if (driver.operator != forceDriver.operator) continue;
                return this;
            }
            this.drivers.add(forceDriver);
            return this;
        }

        public void addReleaseValue(int uniqueId, ForceDriver releaseDriver, ForceValue existingForceValue, IHidEvaluationGuardian guardian) {
            ListContainer releaseSelects = releaseDriver.computedSelects;
            Iterator<ForceDriver> iterator = this.drivers.iterator();
            while (iterator.hasNext()) {
                XComputedSelect[] diff;
                ForceDriver driver = iterator.next();
                ListContainer selects = driver.computedSelects;
                if (selects == null) continue;
                if (driver.isRelease) {
                    diff = ((XComputedSelect)selects.get(0)).diff((XComputedSelect)releaseSelects.get(0));
                    if (diff != null) continue;
                    return;
                }
                diff = ((XComputedSelect)selects.get(0)).diff((XComputedSelect)releaseSelects.get(0));
                if (diff != null) continue;
                iterator.remove();
                return;
            }
            existingForceValue.addDriver(releaseDriver, uniqueId);
        }

        public void applyForce(final IELParamValue releaseValue, IHidEvaluationGuardian guardian) {
            for (ForceDriver driver : this.drivers) {
                if (driver.isRelease) {
                    driver.operator.operator.setRHValues(new Hid("", null, -1, -1, 0L){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                            return ELParamValueScope.of(releaseValue);
                        }

                        @Override
                        public LanguageKind getLanguageKind() {
                            return LanguageKind.VLOG;
                        }
                    });
                }
                ELUtils.evaluate(driver.operator, driver.operator.getOverrideEvaluator(), null, guardian.copy());
            }
        }

        static class ForceDriver
        extends Driver {
            private boolean isRelease;
            private List<Integer> uniqueIds;

            public ForceDriver(XInstValueHolder.XEvalOverrideHid hid, XInstValueHolder.XEvalOverrideHidOperator operator, boolean isRelease) {
                super(hid, operator);
                this.isRelease = isRelease;
                this.uniqueIds = new ArrayList<Integer>();
            }
        }
    }

    static class SharedPortReference {
        String name;
        XInstValueHolder valueHolder;

        public SharedPortReference(String name, XInstValueHolder valueHolder) {
            this.name = name;
            this.valueHolder = valueHolder;
        }
    }

    public static class WaitingThread {
        private final XThread xThread;
        private final boolean isWait;
        private boolean isConsumed;

        public WaitingThread(XThread xThread, boolean isWait) {
            this.xThread = xThread;
            this.isWait = isWait;
        }

        public void resumeThread() {
            if (this.isConsumed) {
                return;
            }
            this.isConsumed = true;
            this.xThread.resumeThread();
        }

        public boolean isConsumed() {
            return this.isConsumed;
        }

        public XThread getThread() {
            return this.xThread;
        }

        public boolean isWait() {
            return this.isWait;
        }

        public void setConsumed(boolean isConsumed) {
            this.isConsumed = isConsumed;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.isWait ? 1231 : 1237);
            result = 31 * result + (this.xThread == null ? 0 : this.xThread.getId());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WaitingThread)) {
                return false;
            }
            WaitingThread other = (WaitingThread)obj;
            if (this.isWait != other.isWait) {
                return false;
            }
            return this.xThread == other.xThread;
        }
    }

    public static class XMonitorEvent
    implements IXSimEvent {
        private IHidOperator monitorOperator;
        private BitVectorContext context;
        private IHidEvaluationGuardian guardian;

        public XMonitorEvent(IHidOperator monitorOperator, BitVectorContext context, IHidEvaluationGuardian guardian) {
            this.monitorOperator = monitorOperator;
            this.context = context;
            this.guardian = guardian;
        }

        @Override
        public void execute() {
            ELUtils.evaluate(this.monitorOperator, null, this.context, this.guardian.copy());
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }

    public static enum XTestHelperCheckDisable {
        DISABLE_NULL_CHECK;

    }
}

