/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.ThreadByViewType;
import ro.amiq.dvt.interpreter.ThreadByViewWrapper;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.model.reflection.ParserPath;

public class XViewsThreadCache {
    private Map<IProject, List<ThreadByViewWrapper>> threadsCache = new LinkedHashMap<IProject, List<ThreadByViewWrapper>>();
    private static XViewsThreadCache fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private XViewsThreadCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XViewsThreadCache getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new XViewsThreadCache();
            }
        }
        return fInstance;
    }

    private void put(IProject project, XThread xThread, ThreadByViewType viewType) {
        if (project == null || xThread == null || viewType == null) {
            return;
        }
        List<ThreadByViewWrapper> projectThreads = this.threadsCache.get(project);
        ThreadByViewWrapper threadElement = new ThreadByViewWrapper(viewType, xThread);
        projectThreads.add(threadElement);
    }

    public XThread get(IProject project, IXSim xSim, ThreadByViewType viewType) {
        List<ThreadByViewWrapper> projectThreads = this.threadsCache.get(project);
        if (projectThreads == null) {
            projectThreads = new ArrayList<ThreadByViewWrapper>();
            this.threadsCache.put(project, projectThreads);
        }
        for (ThreadByViewWrapper threadElement : projectThreads) {
            if (threadElement.getViewType() != viewType) continue;
            return threadElement.getXThread();
        }
        XThreadDefinition createThreadDefinition = xSim.createThreadDefinition(null, null, new ParserPath(""), null, XThreadDefinition.ThreadKind.NONE);
        XThread xThread = new XThread(createThreadDefinition, 1, -2, null, xSim.getXThreadScheduler(), null);
        createThreadDefinition.setXThread(xThread, false);
        this.put(project, xThread, viewType);
        return xThread;
    }

    public void clear() {
        this.threadsCache.clear();
    }
}

