/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.interpreter.IXFactoryOverridesConstants;
import ro.amiq.dvt.interpreter.IXVHContributor;
import ro.amiq.dvt.interpreter.XContributors;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.config.db.ConfigDBRevealType;
import ro.amiq.dvt.ui.views.config.db.ConfigDBView;
import ro.amiq.dvt.ui.views.config.db.IXConfigDBContributor;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesView;
import ro.amiq.dvt.ui.views.factory.overrides.IXFactoryOverridesContributor;
import ro.amiq.dvt.ui.views.registers.IXRegistersContributor;
import ro.amiq.dvt.ui.views.registers.RegistersView;

public interface XViewsUtils {
    public static final String UVM_RUNTIME_ELABORATION_LAUNCH_CONFIGURATION_ID = "ro.amiq.vlogdt.interp.UVMRuntimeElaborationLaunchConfiguration";
    public static final String XSIM_LAUNCH_CONFIGURATION_ID = "ro.amiq.vlogdt.interp.DVTRunAllLaunchConfiguration";
    public static final String UVM_RUNTIME_ELABORATION_STRING = "UVM Runtime Elaboration";
    public static final String XSIM_STRING = "DVT Run All";
    public static final String UVM_RUNTIME_ELABORATION_JOB_NAME = "UVM Runtime Elaboration";
    public static final String XSIM_JOB_NAME = "DVT Run All";

    @NotNull
    public static IXVHContributor getXVHContributor() {
        Object contributor = XContributors.getContributor(LanguageKind.VLOG, "ro.amiq.dvt.ui.views.VerificationHierarchyView");
        if (!(contributor instanceof IXVHContributor)) {
            throw new IllegalStateException("VLOG XVH contributor not found");
        }
        return (IXVHContributor)contributor;
    }

    @NotNull
    public static IXRegistersContributor getXRegistersViewContributor() {
        Object contributor = XContributors.getContributor(LanguageKind.VLOG, "ro.amiq.dvt.ui.views.RegistersView");
        if (!(contributor instanceof IXRegistersContributor)) {
            throw new IllegalStateException("VLOG Registers contributor not found");
        }
        return (IXRegistersContributor)contributor;
    }

    @NotNull
    public static IXFactoryOverridesContributor getXFactoryOverridesViewContributor() {
        Object contributor = XContributors.getContributor(LanguageKind.VLOG, "ro.amiq.dvt.ui.views.FactoryOverridesView");
        if (!(contributor instanceof IXFactoryOverridesContributor)) {
            throw new IllegalStateException("VLOG Factory Overrides contributor not found!");
        }
        return (IXFactoryOverridesContributor)contributor;
    }

    public static boolean hasXFactoryOverridesViewContributor() {
        Object contributor = XContributors.getContributor(LanguageKind.VLOG, "ro.amiq.dvt.ui.views.FactoryOverridesView");
        return contributor != null;
    }

    public static List<IXContributor> getXContributors() {
        return XContributors.getContributors(LanguageKind.VLOG);
    }

    public static void openFactoryOverridesForElementAtCursor() {
        IRfNamedElement rfFunction = RfMixedLangManager.getInstance().getElementAtExactCursor();
        if (!(rfFunction instanceof IRfMethodElement)) {
            ViewsUtils.popOKDialog(2, "Factory Overrides", "The Factory Overrides view shows factory overrides functions calls.\nPlease place the cursor on a valid element.");
            return;
        }
        String methodName = rfFunction.getName();
        if (!IXFactoryOverridesConstants.isFactoryOverrideSetCall(methodName)) {
            ViewsUtils.popOKDialog(2, "Factory Overrides", "The Factory Overrides view shows factory overrides functions calls.\nPlease place the cursor on a valid element.");
            return;
        }
        GoToInfo goToInfo = XViewsUtils.computeGoToInfoForElementAtExactCursor();
        IViewPart viewById = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.FactoryOverridesView", true);
        if (!(viewById instanceof FactoryOverridesView)) {
            return;
        }
        ((FactoryOverridesView)viewById).revealInView(goToInfo, rfFunction);
    }

    public static GoToInfo computeGoToInfoForElementAtExactCursor() {
        IEditorPart editor = DVTUiUtils.getActivePage().getActiveEditor();
        IEditorInput editorInput = editor.getEditorInput();
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        int offset = ((DVTEditor)editor).getCursor();
        int line = ((DVTEditor)editor).getCursorLineNumber();
        String path = file.getLocation().toOSString();
        BreadcrumbInput breadcrumbInput = VHBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, (DVTEditor)editor);
        if (breadcrumbInput != null) {
            return GoToInfo.of(path, offset, -1, line, breadcrumbInput.toString(), LanguageKind.VLOG);
        }
        return GoToInfo.of(path, offset, -1, line, null, LanguageKind.VLOG);
    }

    @NotNull
    public static IXConfigDBContributor getXConfigDBViewContributor() {
        Object contributor = XContributors.getContributor(LanguageKind.VLOG, "ro.amiq.dvt.ui.views.ConfigDBView");
        if (!(contributor instanceof IXConfigDBContributor)) {
            throw new IllegalStateException("VLOG Config DB contributor not found!");
        }
        return (IXConfigDBContributor)contributor;
    }

    public static void openRegistersViewForElementAtCursor() {
        IRfNamedElement rfField = RfMixedLangManager.getInstance().getElementAtExactCursor();
        if (!(rfField instanceof IRfFieldElement)) {
            ViewsUtils.popOKDialog(2, "Registers View", "The Registers View shows registers/registers block create calls.\nPlease place the cursor on a valid element.");
            return;
        }
        IEditorPart editor = DVTUiUtils.getActivePage().getActiveEditor();
        IEditorInput editorInput = editor.getEditorInput();
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        int offset = ((DVTEditor)editor).getCursor();
        int line = ((DVTEditor)editor).getCursorLineNumber();
        String path = file.getLocation().toOSString();
        GoToInfo goToInfo = GoToInfo.of(path, offset, -1, line, null, LanguageKind.VLOG);
        IRfSingleLangProject rfProject = rfField.getRfProject();
        if (rfProject == null) {
            return;
        }
        IViewPart viewById = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.RegistersView", true);
        if (!(viewById instanceof RegistersView)) {
            return;
        }
        ((RegistersView)viewById).revealInRegistersView(goToInfo, rfField);
    }

    public static void openConfigDBForElementAtCursor(ConfigDBRevealType type) {
        IRfNamedElement rfFunction = RfMixedLangManager.getInstance().getElementAtExactCursor();
        if (!(rfFunction instanceof IRfMethodElement)) {
            ViewsUtils.popOKDialog(2, "Config DB", "The Config DB view shows setters and getters functions calls.\nPlease place the cursor on a valid element.");
            return;
        }
        GoToInfo goToInfo = XViewsUtils.computeGoToInfoForElementAtExactCursor();
        IViewPart viewById = ViewsUtils.getViewById("ro.amiq.dvt.ui.views.ConfigDBView", true);
        if (!(viewById instanceof ConfigDBView)) {
            return;
        }
        ((ConfigDBView)viewById).revealInView(new GoToInfoWithRevealType(goToInfo, type), rfFunction);
    }

    public static boolean isSimulatorModeAllowed(boolean isSimulatorMode) {
        if (!XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
            return false;
        }
        return isSimulatorMode;
    }

    public static class GoToInfoWithRevealType
    extends GoToInfo {
        private final ConfigDBRevealType type;

        public GoToInfoWithRevealType(GoToInfo info, ConfigDBRevealType type) {
            super(info.filePath, info.offset, info.virtualOffset, info.line, info.endLine, info.text, info.languageKind);
            this.type = type;
        }

        public ConfigDBRevealType getType() {
            return this.type;
        }
    }
}

