/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XWaitControlEvalScope
extends XEvalScope {
    private IHidOperator.XEventControl waitControl;
    private boolean isDone;
    private boolean isEvent;

    public XWaitControlEvalScope(HidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian) {
        super(null, parentOperator, evaluator, bvContext, guardian);
        this.waitControl = new IHidOperator.XEventControl(parentOperator.getLHValue(), IHidOperator.XEventControlKind.CHANGE, null, null);
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        XThread activeThread = this.guardian.getActiveThread();
        if (this.evaluateNoThreadSwitch(activeThread)) {
            return ELParamValueScope.IMPLICIT_RESULT;
        }
        activeThread.doYield(!this.isEvent);
        return ELParamValueScope.IMPLICIT_RESULT;
    }

    public boolean evaluateNoThreadSwitch(XThread activeThread) {
        if (this.isDisabled) {
            return true;
        }
        if (this.isDone) {
            return true;
        }
        ELParamValueScope value = ELUtils.evaluate(this.waitControl.hidObject, this.evaluator, this.bvContext, this.guardian.copy());
        if (ELUtils.isUnsuccessfulEval(value)) {
            this.isDone = true;
            this.guardian.logError("Fail to evaluate wait expression");
            return true;
        }
        this.isEvent = value.value instanceof XValueHolder.XEventValueHolder;
        if (!this.isEvent) {
            DVTNumber number = value.getDVTNumber();
            if (DVTNumber.isUndefined(number)) {
                this.isDone = true;
                this.guardian.logError("Fail to evaluate wait expression");
                return true;
            }
            if (!number.isAmbiguous() && !DVTNumber.eq(number, VlogBitVector.BIT_ZERO)) {
                this.isDone = true;
                return true;
            }
        }
        XValueHolderFactory.WaitingThread waitingThread = new XValueHolderFactory.WaitingThread(activeThread, true);
        XValueHolderFactory factory = this.guardian.getFactory();
        if (this.isEvent) {
            this.isDone = true;
            IELParamValue original = XUtils.getOriginal(value.value, true);
            factory.addWaitingThread(original, waitingThread);
            return false;
        }
        this.guardian.setDisableNullChecks(true);
        try {
            for (IHid hid : this.waitControl.hids) {
                ELParamValueScope hidValue;
                if (hid == Hid.EVALUATE_SKIP_HID) continue;
                if (hid.getElement() instanceof IRfMethodElement) {
                    if (((Hid)hid).getParentAccess() == null) {
                        hidValue = ELUtils.evaluate(hid, this.evaluator, this.bvContext, this.guardian.copy());
                        factory.addWaitingThread((IELParamValue)hidValue.scope, waitingThread);
                        continue;
                    }
                    hidValue = ELUtils.evaluate(((Hid)hid).getParentAccess(), this.evaluator, this.bvContext, this.guardian.copy());
                    factory.addWaitingThread(hidValue.value, waitingThread);
                    continue;
                }
                hidValue = ELUtils.evaluate(hid, this.evaluator, this.bvContext, this.guardian.copy());
                IELParamValue original = XUtils.getOriginal(hidValue.value, true);
                factory.addWaitingThread(original, waitingThread);
            }
        }
        finally {
            this.guardian.setDisableNullChecks(false);
        }
        return false;
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.isDone) {
            return null;
        }
        return this.parentOperator;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return false;
    }

    public static class XWaitCbControlEvalScope
    extends XWaitControlEvalScope {
        private IELParamValue cbEnclosingInstance;
        private String cbEvCtrlName;

        public XWaitCbControlEvalScope(HidOperator parentOperator, Hid eventControlHid, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian) {
            super(parentOperator, evaluator, bvContext, guardian);
            this.cbEnclosingInstance = (IELParamValue)XUtils.getScope(ELUtils.evaluate(eventControlHid, evaluator, null, guardian.copy()));
            this.cbEvCtrlName = XUtils.getEvCtrlName(eventControlHid.getElement());
        }

        @Override
        protected ELParamValueScope executeStatement(IHidObject nextStatement) {
            XThread activeThread = this.guardian.getActiveThread();
            if (this.evaluateNoThreadSwitch(activeThread)) {
                return ELParamValueScope.IMPLICIT_RESULT;
            }
            activeThread.doYield(false);
            return ELParamValueScope.IMPLICIT_RESULT;
        }

        @Override
        public final boolean evaluateNoThreadSwitch(XThread activeThread) {
            if (this.isDisabled) {
                return true;
            }
            this.isDisabled = true;
            IELParamValue value = this.cbEnclosingInstance.getValueDirectly(this.cbEvCtrlName);
            if (value == null) {
                if (this.cbEnclosingInstance instanceof XValueHolder && !(this.cbEnclosingInstance instanceof XInstValueHolder)) {
                    this.guardian.logError("Virtual interface not connected to interface instance");
                }
                return false;
            }
            XValueHolderFactory.WaitingThread waitingThread = new XValueHolderFactory.WaitingThread(activeThread, true);
            XValueHolderFactory factory = this.guardian.getFactory();
            factory.addWaitingThread(value, waitingThread);
            return false;
        }
    }
}

