/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.console;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.debug.core.intrp.model.IntrpDebugTarget;
import ro.amiq.dvt.externaltools.ExternalToolsConsolePageParticipant;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IConsoleScanListener;
import ro.amiq.dvt.externaltools.IDVTRunConsoleDebugActions;
import ro.amiq.dvt.externaltools.IDVTTerminatable;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.console.XConsoleCommon;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.XGlobalCache;

public class XConsole
extends XConsoleCommon
implements IResourceChangeListener {
    public static final int RUN_BUILD_PHASE_CODE_START = 1000;
    public static final int RUN_BUILD_PHASE_CODE_STOP = -1000;
    public static final String CONSOLE_FOR_PROJECT = " Console for project";
    public static final String UVM_RE_CONSOLE_NAME_PREFIX = "UVM Runtime Elaboration Console for project";
    public static final String XSIM_CONSOLE_NAME_PREFIX = "DVT Run All Console for project";
    private static final Pattern PATTERN_TIME_INFO = Pattern.compile("\\s+\\[[0-9]+\\s+ms\\]");
    private static final Set<String> PATTERN_NAMES = new HashSet<String>(Arrays.asList("DVT Error Filter", "DVT Warning Filter", "DVT StackTrace Filter", "General Note Filter", "GCC Error Filter", "GCC Warning Filter"));
    private static final String SECTION_FORMAT = "*** {0} ***";
    private XMessageConsole console;
    private IConsoleManager consoleManager;
    private MessageConsoleStream outputStream;
    private boolean isTerminated;
    private IntrpDebugTarget debugTarget;
    private StringBuilder testConsoleContent;
    private boolean fail;
    private boolean isStartedInBatch;

    public XConsole(IProject project, boolean isSimulatorMode, boolean isStartedInBatch) {
        try {
            this.project = project;
            this.isSimulatorMode = isSimulatorMode;
            this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            this.console = new XMessageConsole(project, String.valueOf(isSimulatorMode ? XSIM_CONSOLE_NAME_PREFIX : UVM_RE_CONSOLE_NAME_PREFIX) + " [" + project.getName() + "]", null, new DVTConsoleButtonsDescription(true, false, true));
            this.consoleManager.addConsoles(new IConsole[]{this.console});
            this.outputStream = this.console.newMessageStream();
            this.testConsoleContent = TestHelper.isTestMode() || TestHelper.isDebugMode() ? new StringBuilder() : null;
            this.isStartedInBatch = isStartedInBatch;
            this.setProcessConsole();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void setProcessConsole() {
        ExternalToolsConfiguration config = new ExternalToolsConfiguration();
        ExternalToolsModelManager.getInstance().setProcessConsole((IConsole)this.console, this.project, config, null, 1, this.project.getLocation().toOSString());
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void setTerminated(boolean isTerminated, IProject project) {
        this.isTerminated = isTerminated;
        ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)project, 8, 1000);
    }

    public void clean() {
        this.clearConsole();
        this.messageQueue.clear();
        if (this.logWriter != null) {
            try {
                try {
                    DVTUtilsCommon.INSTANCE.closeClosable(this.logWriter);
                }
                catch (Throwable e) {
                    DVTLogger.INSTANCE.logError(e);
                    this.logWriter = null;
                }
            }
            finally {
                this.logWriter = null;
            }
        }
    }

    public void done() {
        try {
            try {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    try {
                        if (this.outputStream != null && !this.outputStream.isClosed()) {
                            this.outputStream.flush();
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    try {
                        ObjectionManager.getInstance().clear(Objection.CONSOLE_OUTPUT_COMPLETE);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    try {
                        if (this.logWriter != null) {
                            this.logWriter.flush();
                        }
                        this.refreshLogFile();
                    }
                    catch (Throwable e) {
                        DVTLogger.INSTANCE.logError(e);
                    }
                });
                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.project, 16, -1000);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.debugTarget = null;
            }
        }
        finally {
            this.debugTarget = null;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.project.equals((Object)event.getResource()) && (event.getType() == 4 || event.getType() == 2)) {
            this.removeConsole();
        }
    }

    private void clearConsole() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            this.console.activate();
            this.console.clearConsole();
            ExternalToolsModelManager.fAppliedPatterns.clear();
            ExternalToolsModelManager.fAppliedProblemsPatterns.clear();
        });
    }

    public void bringToTop() {
        this.setProcessConsole();
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.console.activate());
    }

    private void removeConsole() {
        try {
            this.console.clearConsole();
            this.consoleManager.removeConsoles(new IConsole[]{this.console});
            XConsoleRegistry.removeConsole(this.project);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void updateVerbosityMenuSelection() {
        this.console.updateVerbosityMenuSelection();
    }

    @Override
    public void print(String message) {
        if (!this.isTerminated) {
            ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)this.project, 8, 1000);
        }
        super.print(message);
    }

    @Override
    protected void scheduleProcessMessages(String message) {
        if (this.testConsoleContent != null) {
            this.testConsoleContent.append(message);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            try {
                if (this.outputStream != null && !this.outputStream.isClosed()) {
                    this.outputStream.print(message);
                    if (!this.outputStream.isClosed()) {
                        this.outputStream.flush();
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            try {
                while (!this.messageQueue.isEmpty()) {
                    String msg = (String)this.messageQueue.poll();
                    if (msg == null || this.logWriter == null) continue;
                    this.logWriter.write(msg);
                }
                if (this.logWriter != null) {
                    this.logWriter.flush();
                }
                this.refreshLogFile();
            }
            catch (Exception e2) {
                DVTLogger.INSTANCE.logError((Throwable)e2);
            }
        });
    }

    private void refreshLogFile() throws CoreException {
        File logFile = this.getLogFile();
        if (logFile == null) {
            return;
        }
        IPath projectLocation = this.project.getLocation();
        if (projectLocation == null) {
            return;
        }
        IPath logFilePath = Path.fromOSString((String)logFile.getAbsolutePath());
        if (!projectLocation.isPrefixOf(logFilePath)) {
            return;
        }
        IFile logIFile = this.project.getWorkspace().getRoot().getFileForLocation(logFilePath);
        if (logIFile == null) {
            return;
        }
        try {
            logIFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {}
    }

    public void printSection(String message) {
        this.print(MessageFormat.format(SECTION_FORMAT, message));
    }

    public String toString() {
        return "XConsole [project=" + this.project + "]";
    }

    public void setTerminateListener(IntrpDebugTarget debugTarget) {
        this.debugTarget = debugTarget;
    }

    public String testGetConsoleContent() {
        return this.testConsoleContent.toString();
    }

    public XMessageConsole getMessageConsole() {
        return this.console;
    }

    public void testCleanConsole() {
        this.testConsoleContent.delete(0, this.testConsoleContent.length());
    }

    public boolean isStartedInBatchMode() {
        return this.isStartedInBatch;
    }

    class ConsoleListener
    implements IConsoleScanListener {
        private TextConsole console;
        private Pattern pattern;
        private String lineQualifier;
        private TextConsoleViewer consoleViewer;

        ConsoleListener(Pattern pattern, String lineQualifier) {
            this.pattern = pattern;
            this.lineQualifier = lineQualifier;
        }

        @Override
        public TextConsole getConsole() {
            return this.console;
        }

        @Override
        public TextConsoleViewer getConsoleViewer() {
            return this.consoleViewer;
        }

        public void connect(TextConsole console) {
            this.console = console;
        }

        public void disconnect() {
            this.console = null;
            this.consoleViewer = null;
        }

        @Override
        public void addHyperlink(int offset, int length) {
            try {
                IDocument document = this.console.getDocument();
                String filePath = "";
                int lineNumber = 0;
                String text = document.get(offset, length);
                if (text.startsWith("***") && text.endsWith("***")) {
                    return;
                }
                Matcher m = this.pattern.matcher(text);
                if (!m.matches() || m.groupCount() < 1) {
                    return;
                }
                filePath = m.group(1);
                if (m.groupCount() >= 2) {
                    lineNumber = DVTStringUtil.parseInt(m.group(2), 0);
                }
                offset += m.start(1);
                length = filePath.length();
                m = PATTERN_TIME_INFO.matcher(filePath);
                if (m.find()) {
                    filePath = filePath.substring(0, m.start());
                    length = filePath.length();
                }
                if (XConsole.this.project == null) {
                    return;
                }
                ((DVTMessageConsole)this.console).addHyperlink(new DVTMessageConsole.DummyHyperlinkLineContainer(lineNumber == 0 ? 1 : lineNumber), offset, length);
            }
            catch (Exception exception) {}
        }

        public int getCompilerFlags() {
            return 0;
        }

        public String getLineQualifier() {
            return this.lineQualifier;
        }

        public String getPattern() {
            return this.pattern.pattern();
        }

        @Override
        public Pattern getWholePattern() {
            return this.pattern;
        }

        @Override
        public void setConsoleViewer(TextConsoleViewer newConsoleViewer) {
            this.consoleViewer = newConsoleViewer;
        }
    }

    private final class ExternalToolsConfiguration
    implements IExternalToolsConfiguration {
        private ExternalToolsConfiguration() {
        }

        @Override
        public void setWorkingDir(String workingDir) {
        }

        @Override
        public void setWSLink(boolean wSLink) {
        }

        @Override
        public void setPatterns(ExternalToolsPattern[] patterns) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public void setFullCommand(String fullCommand) {
        }

        @Override
        public void setFilterKinds(String[] filterKinds) {
        }

        @Override
        public void setEnable(boolean builderEnable) {
        }

        @Override
        public void setCleanCommand(String cleanCommand) {
        }

        @Override
        public void setAutoCommand(String autoCommand) {
        }

        @Override
        public boolean isWSLink() {
            return false;
        }

        @Override
        public String getWorkingDir() {
            return null;
        }

        @Override
        public ExternalToolsPattern[] getPatterns() {
            ArrayList<ExternalToolsPattern> result = new ArrayList<ExternalToolsPattern>();
            List<ExternalToolsPattern> patterns = ExternalToolsUtil.getCategoryPatterns("Specman");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("DVT");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("General");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("UVM");
            for (ExternalToolsPattern pattern : patterns) {
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("OVM");
            for (ExternalToolsPattern pattern : patterns) {
                result.add(pattern);
            }
            patterns = ExternalToolsUtil.getCategoryPatterns("GCC");
            for (ExternalToolsPattern pattern : patterns) {
                if (!PATTERN_NAMES.contains(pattern.getName())) continue;
                result.add(pattern);
            }
            return result.toArray(result.toArray(new ExternalToolsPattern[result.size()]));
        }

        @Override
        public String getName() {
            return "[" + XConsole.this.project + "] " + (XConsole.this.isSimulatorMode ? XConsole.XSIM_CONSOLE_NAME_PREFIX : XConsole.UVM_RE_CONSOLE_NAME_PREFIX);
        }

        @Override
        public String getFullCommand() {
            return null;
        }

        @Override
        public String[] getFilterKinds() {
            return new String[0];
        }

        @Override
        public boolean getEnable() {
            return false;
        }

        @Override
        public String getConfigurationType() {
            return null;
        }

        @Override
        public String getCleanCommand() {
            return null;
        }

        @Override
        public String getAutoCommand() {
            return null;
        }

        @Override
        public boolean getAttribute(String attributeName, boolean defaultValue) {
            return false;
        }

        @Override
        public int getAttribute(String attributeName, int defaultValue) {
            return 0;
        }

        @Override
        public String getAttribute(String attributeName, String defaultValue) {
            return null;
        }

        @Override
        public List getAttribute(String attributeName, List defaultValue) {
            return null;
        }

        @Override
        public Set getAttribute(String attributeName, Set defaultValue) {
            return null;
        }

        @Override
        public Map getAttribute(String attributeName, Map defaultValue) {
            return null;
        }

        @Override
        public void setAttribute(String attributeName, Object attributeValue) {
        }

        @Override
        public void removeAttribute(String attributeName) {
        }

        @Override
        public boolean hasAttribute(String attributeName) {
            return false;
        }

        @Override
        public Map getAttributes() {
            return null;
        }

        @Override
        public void setAttributes(Map attributes) {
        }

        @Override
        public IExternalToolsConfiguration getWorkingCopy() {
            return this;
        }
    }

    class XMessageConsole
    extends DVTMessageConsole
    implements IDVTTerminatable,
    IDVTRunConsoleDebugActions {
        ExternalToolsConsolePageParticipant.XPrintChangeVerbosityAction verbosityAction;

        public XMessageConsole(IProject project, String name, ImageDescriptor imageDescriptor, DVTConsoleButtonsDescription buttons) {
            super(project, name, imageDescriptor, buttons);
        }

        @Override
        public void terminate() {
            try {
                XConsole.this.isTerminated = true;
                if (XConsole.this.debugTarget != null) {
                    XConsole.this.debugTarget.terminate();
                } else {
                    XConsole.this.print("*** Error: TERMINATED!" + System.lineSeparator());
                }
                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)XConsole.this.project, 16, -1000);
            }
            finally {
                XConsole.this.debugTarget = null;
            }
        }

        @Override
        public boolean hasPrintStackTraceOption() {
            return true;
        }

        @Override
        public String getVerbosity() {
            IXSim xSim = XGlobalCache.INSTANCE.getXSim(XConsole.this.project);
            if (xSim != null) {
                return xSim.getPrintVerbosity();
            }
            return null;
        }

        @Override
        public void changeVerbosity(String verbosity) {
            IXSim xSim;
            if (!XConsole.this.isTerminated) {
                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)XConsole.this.project, 8, 1000);
            }
            if ((xSim = XGlobalCache.INSTANCE.getXSim(XConsole.this.project)) != null) {
                xSim.setPrintVerbosity(verbosity);
            }
        }

        @Override
        public void printStackTrace() {
            IXSim xSim;
            if (!XConsole.this.isTerminated) {
                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)XConsole.this.project, 8, 1000);
            }
            if ((xSim = XGlobalCache.INSTANCE.getXSim(XConsole.this.project)) != null) {
                xSim.printStackTrace(true);
            }
        }

        @Override
        public void printConcurrentAssertionsCursors() {
            IXSim xSim;
            if (!XConsole.this.isTerminated) {
                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)XConsole.this.project, 8, 1000);
            }
            if ((xSim = XGlobalCache.INSTANCE.getXSim(XConsole.this.project)) != null) {
                xSim.printConcurrentAssertionsCursors();
            }
        }

        @Override
        public void printSimTime() {
            IXSim xSim;
            if (!XConsole.this.isTerminated) {
                ((Workspace)ResourcesPlugin.getWorkspace()).broadcastBuildEvent((Object)XConsole.this.project, 8, 1000);
            }
            if ((xSim = XGlobalCache.INSTANCE.getXSim(XConsole.this.project)) != null) {
                xSim.printSimTime();
            }
        }

        @Override
        public void setVerbosityAction(ExternalToolsConsolePageParticipant.XPrintChangeVerbosityAction action) {
            this.verbosityAction = action;
        }

        public void updateVerbosityMenuSelection() {
            if (this.verbosityAction == null) {
                return;
            }
            String verbosityLevel = this.getVerbosity();
            if (verbosityLevel == null) {
                return;
            }
            Display.getDefault().asyncExec(() -> {
                this.verbosityAction.setText(verbosityLevel);
                this.verbosityAction.setSelection(verbosityLevel);
            });
        }
    }
}

