/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.console;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class XConsoleCommon {
    protected IProject project;
    protected boolean isSimulatorMode;
    public static final String RUNTIME_ELAB_LOG_FILE_NAME = "dvt_uvm_runtime_elaboration.log";
    public static final String SIMULATION_LOG_FILE_NAME = "dvt_run_all.log";
    protected ConcurrentLinkedQueue<String> messageQueue = new ConcurrentLinkedQueue();
    protected BufferedWriter logWriter;

    public void initLogWriter() {
        if (this.logWriter != null) {
            return;
        }
        File logFile = this.getLogFile();
        if (logFile == null) {
            return;
        }
        try {
            this.logWriter = new BufferedWriter(new FileWriter(logFile));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public File getLogFile() {
        IPath projectLocation = this.project.getLocation();
        if (projectLocation == null) {
            return null;
        }
        String projectLocationString = projectLocation.toOSString();
        if (this.isSimulatorMode) {
            return new File(projectLocationString, SIMULATION_LOG_FILE_NAME);
        }
        return new File(projectLocationString, RUNTIME_ELAB_LOG_FILE_NAME);
    }

    public void print(String message) {
        this.messageQueue.add(message);
        this.initLogWriter();
        this.scheduleProcessMessages(message);
    }

    public abstract void updateVerbosityMenuSelection();

    protected abstract void scheduleProcessMessages(String var1);
}

