/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.console;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.interpreter.XViewsUtils;
import ro.amiq.dvt.interpreter.console.XConsole;
import ro.amiq.dvt.interpreter.console.XConsoleRegistry;

public abstract class XConsoleRegistryCommon {
    private static final EnumMap<XConsoleType, Map<IProject, XConsole>> xConsoleMapByType = new EnumMap(XConsoleType.class);

    public static XConsole getConsole(IProject project, boolean isSimulatorMode, boolean isStartedInBatch) {
        return XViewsUtils.isSimulatorModeAllowed(isSimulatorMode) ? XConsoleRegistryCommon.getConsole(project, XConsoleType.XSIM, isStartedInBatch) : XConsoleRegistryCommon.getConsole(project, XConsoleType.UVM_RUNTIME_ELABORATION, isStartedInBatch);
    }

    private static XConsole getConsole(IProject project, XConsoleType consoleType, boolean isStartedInBatch) {
        XConsole console;
        Map<IProject, XConsole> consoleMapByProject = xConsoleMapByType.get((Object)consoleType);
        if (consoleMapByProject == null) {
            consoleMapByProject = new HashMap<IProject, XConsole>();
            xConsoleMapByType.put(consoleType, consoleMapByProject);
        }
        if ((console = consoleMapByProject.get(project)) != null) {
            return console;
        }
        console = new XConsole(project, consoleType == XConsoleType.XSIM, isStartedInBatch);
        consoleMapByProject.put(project, console);
        XConsoleRegistry.addResourceListenerForConsole(console);
        return console;
    }

    protected static void removeConsole(IProject project) {
        XConsoleType[] xConsoleTypeArray = XConsoleType.values();
        int n = xConsoleTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            XConsole console;
            XConsoleType consoleType = xConsoleTypeArray[n2];
            Map<IProject, XConsole> consoleMapByProject = xConsoleMapByType.get((Object)consoleType);
            if (consoleMapByProject != null && (console = consoleMapByProject.remove(project)) != null) {
                XConsoleRegistry.removeResourceListenerForConsole(console);
            }
            ++n2;
        }
    }

    static enum XConsoleType {
        XSIM,
        UVM_RUNTIME_ELABORATION;

    }
}

