/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.constraints;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import ro.amiq.dvt.csp.constraints.AbstractConstraint;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.solver.string.IStringMapping;
import ro.amiq.dvt.csp.variables.IDomain;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.csp.variables.Variable;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XNamedComputedSelect;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.constraints.XCValue;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.LazyString;
import ro.amiq.dvt.utils.VlogBitVector;

public class XCModel
extends Model {
    public static final XCRandomField NULL_ELEMENT = new XCRandomField("null", -1);
    private static final int[] NO_SELECT = new int[]{-1, -1};
    private Map<String, XCValue> leafVariables = new LinkedHashMap<String, XCValue>();
    private Set<XCRandomField> randomFields = new HashSet<XCRandomField>();
    private Set<IELParamValue> randomValueHolders = Collections.newSetFromMap(new IdentityHashMap());
    private Map<AbstractConstraint, Text> cspToReadableTextMap;

    public XCModel(BooleanSupplier isCanceled, IStringMapping stringVariableMapping) {
        super(isCanceled, stringVariableMapping);
    }

    public void addRandomField(IELParamValue value) {
        this.randomValueHolders.add(value);
        IELParamValue original = XUtils.getOriginal(value, true);
        this.randomValueHolders.add(original);
    }

    public void addRandomField(String name, XValueHolder scopeHolder) {
        this.randomFields.add(new XCRandomField(name, scopeHolder.uniqueValuesId()));
    }

    public void addNullRandomField() {
        this.randomFields.add(NULL_ELEMENT);
    }

    public boolean isRandCandidate(IRfNamedElement element, XValueHolder scope) {
        XCRandomField randomField;
        if (element == null) {
            return false;
        }
        if (this.randomFields.contains(NULL_ELEMENT)) {
            return false;
        }
        if (!this.randomFields.isEmpty() && this.randomFields.contains(randomField = new XCRandomField(element.getName(), scope.uniqueValuesId()))) {
            return true;
        }
        return scope.getRandMode(element.getName(), element.isRand() || element.isRandc());
    }

    public boolean isRand(IELParamValue value) {
        if (this.randomValueHolders.contains(IELParamValue.NULL_VALUE)) {
            return false;
        }
        if (ELUtils.isUnsuccessfulEval(value)) {
            return false;
        }
        if (this.randomValueHolders.contains(value)) {
            return true;
        }
        IELParamValue original = XUtils.getOriginal(value, true);
        if (ELUtils.isUnsuccessfulEval(original)) {
            return false;
        }
        return this.randomValueHolders.contains(original);
    }

    public XCValue createVariable(String name, ELParamValueScope value, boolean isRand, IHidEvaluationGuardian guardian) {
        String uniqueVariableName = XCModel.getUniqueVariableName(name, value, guardian.getFactory());
        XCValue result = this.getLeafVariable(uniqueVariableName);
        if (result == null) {
            result = XCValue.createVariable(this, value.value, uniqueVariableName, value.getArrayValueHolder(name), isRand, guardian);
            this.putLeafVariable(uniqueVariableName, result);
        }
        IntVariable intVar = result.getIntVar();
        if (!value.value.hasSign() && intVar.isSigned() && !result.isEnum()) {
            intVar.setSigned(false);
            intVar.setDomain((IDomain)new IntDomain(false, intVar.nofBits()));
        }
        return result;
    }

    public XCValue createConstant(IELParamValue value, IHidEvaluationGuardian guardian) {
        return XCValue.createConstant(this, null, value, guardian);
    }

    public XCValue createVariable(IntVariable intVar, boolean isRand, IHidOperator hidOperator) {
        XCValue xCValue = XCValue.createVariable(intVar, isRand);
        xCValue.setHidOperator(hidOperator);
        return xCValue;
    }

    public XCValue createSelectVariable(String name, ELParamValueScope value, ELParamValueScope selectValue, boolean isRand, IHidEvaluationGuardian guardian) {
        String uniqueVariableName = XCModel.getUniqueVariableName(name, selectValue, guardian.getFactory());
        XCValue result = this.getLeafVariable(uniqueVariableName);
        if (result == null) {
            result = this.internalCreateSelectVariable(name, value, selectValue, isRand, guardian);
            this.putLeafVariable(uniqueVariableName, result);
        }
        return result;
    }

    private XCValue internalCreateSelectVariable(String name, ELParamValueScope value, ELParamValueScope selectValue, boolean isRand, IHidEvaluationGuardian guardian) {
        IntVariable intVar;
        XCValue selectXCValue = this.createVariable(name, selectValue, isRand, guardian);
        if (value.value instanceof XArrayValueHolder) {
            return selectXCValue;
        }
        XSelectProxy selectProxy = selectValue.value.getSelectProxy();
        if (selectProxy == null) {
            return selectXCValue;
        }
        int lastIndex = selectProxy.computedSelects.size() - 1;
        int[] lastSelect = XCModel.getSelect(lastIndex, selectProxy);
        if (lastSelect[0] == -1) {
            return selectXCValue;
        }
        int lb = Math.min(lastSelect[0], lastSelect[1]);
        int ub = Math.max(lastSelect[0], lastSelect[1]);
        int nofItems = ub - lb + 1;
        DVTNumber number = XUtils.getOriginal(value.value, false).getDVTNumber();
        int arraySize = ((VlogBitVector)number).getFirstDimensionSize();
        int arrayNofBits = number.getSize();
        int[] packed = number.getPacked();
        boolean isPacked = packed != null && packed.length > 0;
        boolean isReversed = packed != null && isPacked && packed[packed.length - 2] < packed[packed.length - 1];
        int itemNofBits = arrayNofBits / arraySize;
        int rangeNofBits = nofItems * itemNofBits;
        IntVariable selectIntVar = selectXCValue.getIntVar();
        selectIntVar.setNonRandom(!isPacked);
        selectIntVar.setSigned(false);
        selectIntVar.setNofBits(rangeNofBits);
        String varName = selectIntVar.getName();
        int index = varName.lastIndexOf("[");
        varName = varName.substring(0, index);
        XCValue xCValue = this.getLeafVariable(varName);
        if (xCValue == null) {
            xCValue = XCValue.createVariable(this, value.value, varName, null, isRand, guardian);
            this.putLeafVariable(varName, xCValue);
        }
        if (rangeNofBits == (intVar = xCValue.getIntVar()).nofBits()) {
            IDomain domain = selectIntVar.getDomain().intersect(intVar.getDomain());
            intVar.setDomain(domain);
            selectIntVar.setDomain(domain);
            if (!(selectValue.value instanceof ELParamValues.ParamValueNumber.PackedStructMember) || selectValue.value.getEnumTypeWrapper() == null) {
                this.removeVariable((Variable)selectIntVar);
                return xCValue;
            }
        }
        if (number instanceof VlogBitVector && ((VlogBitVector)number).isStruct(false)) {
            intVar.setNonRandom(true);
        }
        XCValue rangeXCValue = this.rangeEq(xCValue, lb * itemNofBits, rangeNofBits, isReversed);
        rangeXCValue.getIntVar().eq(selectIntVar).setIgnore(true);
        selectXCValue.setNoValueUpdate(true);
        return selectXCValue;
    }

    public XCValue rangeEq(XCValue xCValue, int lsb, int rangeNofBits, boolean isReversed) {
        int adjustedLsb = lsb - xCValue.getLsb();
        IntVariable lsbVar = this.getCachedConstant(true, 32, BigInteger.valueOf(adjustedLsb));
        IntVariable shiftedVar = adjustedLsb == 0 ? xCValue.getIntVar() : xCValue.getIntVar().sr(lsbVar);
        shiftedVar.setNofBits(xCValue.getIntVar().nofBits() - adjustedLsb);
        IDomain domain = shiftedVar.getDomain().intersect((IDomain)new IntDomain(shiftedVar.isSigned(), shiftedVar.nofBits()));
        shiftedVar.setDomain(domain);
        BigInteger bitsMask = VlogBitVector.getPowerOfTwoMask(rangeNofBits);
        IntVariable maskedVar = shiftedVar.and(this.getCachedConstant(false, rangeNofBits, bitsMask));
        maskedVar.setNofBits(rangeNofBits);
        IDomain domain2 = maskedVar.getDomain().intersect((IDomain)new IntDomain(false, maskedVar.nofBits()));
        maskedVar.setDomain(domain2);
        return XCValue.createVariable(maskedVar, xCValue.isRand());
    }

    public static int[] getSelect(int i, XSelectProxy selectProxy) {
        if (selectProxy == null) {
            return NO_SELECT;
        }
        ListContainer<XComputedSelect> computedSelects = selectProxy.computedSelects;
        if (computedSelects == null || computedSelects.isEmpty()) {
            return NO_SELECT;
        }
        XComputedSelect select = computedSelects.get(i);
        if (select.computedValues != null && select.computedValues.length == 0) {
            return NO_SELECT;
        }
        IELParamValue ub = select.computedValues[0];
        if (DVTNumber.isUndefined(ub.getDVTNumber())) {
            return NO_SELECT;
        }
        IELParamValue lb = ub;
        if (select.computedValues.length > 1 && DVTNumber.isUndefined((lb = select.computedValues[1]).getDVTNumber())) {
            return NO_SELECT;
        }
        int ubInt = ub.intValue();
        int lbInt = lb.intValue();
        if (select.isPlusIndexPartSelect) {
            return new int[]{ubInt + lbInt - 1, ubInt};
        }
        if (select.isMinusIndexPartSelect) {
            return new int[]{ubInt, ubInt - lbInt + 1};
        }
        return new int[]{ubInt, lbInt};
    }

    public void updateValues(IHidEvaluationGuardian guardian) {
        if (this.leafVariables.isEmpty()) {
            guardian.logWarning("Check only randomize call (no rand variable found)");
            return;
        }
        for (XCValue xCValue : this.leafVariables.values()) {
            xCValue.initArrays(guardian);
        }
        XValueHolderFactory factory = guardian.getFactory();
        StringBuilder extraInfoText = null;
        if (factory.isAddExtraDebugInfo()) {
            extraInfoText = new StringBuilder();
            extraInfoText.append("\n");
        }
        for (XCValue xCValue : this.leafVariables.values()) {
            xCValue.updateValue(extraInfoText, guardian);
            IELParamValue value = xCValue.getValue();
            if (value == null) continue;
            guardian.callbackValueAccessed(value.getElement());
        }
        if (extraInfoText != null) {
            factory.logWarning(extraInfoText.toString());
        }
    }

    public void partialUpdateValues(IHidEvaluationGuardian guardian) {
        IntVariable intVar;
        for (XCValue xCValue : this.leafVariables.values()) {
            intVar = xCValue.getIntVar();
            if (!intVar.isInstantiated()) continue;
            xCValue.initArrays(guardian);
        }
        for (XCValue xCValue : this.leafVariables.values()) {
            intVar = xCValue.getIntVar();
            if (!intVar.isInstantiated()) continue;
            xCValue.updateValue(null, guardian);
        }
    }

    public XCValue getLeafVariable(String uniqueVariableName) {
        return this.leafVariables.get(uniqueVariableName);
    }

    public void putLeafVariable(String uniqueVariableName, XCValue result) {
        this.leafVariables.put(uniqueVariableName, result);
    }

    public static String getUniqueVariableName(String name, ELParamValueScope value, XValueHolderFactory factory) {
        StringBuilder result = new StringBuilder();
        XArrayValueHolder arrayScope = value.getArrayValueHolder(name);
        if (arrayScope != null) {
            result.append(arrayScope.getVarName(true)).append(".");
        } else if (value.scope instanceof XArrayValueHolder) {
            result.append(((XValueHolder)value.scope).getVarName(false)).append(".");
        } else if (value.scope instanceof XValueHolder) {
            result.append(((XValueHolder)value.scope).getVarName(true)).append(".");
        }
        IELParamValue original = value.value.getOriginal();
        result.append(name);
        XSelectProxy selectProxy = value.value.getSelectProxy();
        if (selectProxy == null && original != null) {
            selectProxy = original.getSelectProxy();
        }
        if (selectProxy == null) {
            return result.toString();
        }
        int lastIndex = selectProxy.computedSelects.size() - 1;
        XComputedSelect computedSelect = selectProxy.computedSelects.get(lastIndex);
        IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelect();
        if (valueBeforeSelect instanceof XArrayValueHolder && ((XArrayValueHolder)valueBeforeSelect).isAssociativeArray()) {
            IELParamValue selectValue;
            ListContainer<XComputedSelect> computedSelects = selectProxy.computedSelects;
            if (computedSelects == null || computedSelects.isEmpty()) {
                return result.toString();
            }
            XComputedSelect select = computedSelects.get(0);
            if (select.computedValues != null && select.computedValues.length == 0) {
                return result.toString();
            }
            BitVectorContext indexContext = ((XArrayValueHolder)valueBeforeSelect).getIndexElementContext();
            IELParamValue iELParamValue = selectValue = indexContext == null ? select.computedValues[0] : indexContext.transform(select.computedValues[0]);
            if (selectValue instanceof XValueHolder) {
                result.append("[").append(((XValueHolder)selectValue).toUniqueString(true)).append("]");
            } else if (selectValue instanceof ELParamValues.ParamValueNumber && selectValue.getDVTNumber().isString()) {
                result.append("[").append(((VlogBitVector)selectValue.getDVTNumber()).stringValue(false)).append("]");
            } else {
                result.append("[").append(selectValue.toStringRadix(10)).append("]");
            }
            return result.toString();
        }
        int[] lastSelect = XCModel.getSelect(lastIndex, selectProxy);
        if (lastSelect[0] == -1) {
            return result.toString();
        }
        boolean isNamedSelect = computedSelect instanceof XNamedComputedSelect;
        if (isNamedSelect) {
            StringBuilder lastSelectText = new StringBuilder();
            lastSelectText.append("[").append(lastSelect[0]);
            if (lastSelect[0] != lastSelect[1]) {
                lastSelectText.append(": ").append(lastSelect[1]);
            }
            lastSelectText.append("]");
            if (result.toString().endsWith(lastSelectText.toString())) {
                return result.toString();
            }
        }
        result.append("[").append(lastSelect[0]);
        if (lastSelect[0] != lastSelect[1]) {
            result.append(": ").append(lastSelect[1]);
        }
        result.append("]");
        return result.toString();
    }

    public static void appendSelects(StringBuilder result, XSelectProxy selectProxy, int selectsToSkip) {
        IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelectRaw();
        if (valueBeforeSelect instanceof XArrayValueHolder && ((XArrayValueHolder)valueBeforeSelect).isAssociativeArray() && selectsToSkip == 0) {
            IELParamValue selectValue;
            ListContainer<XComputedSelect> computedSelects = selectProxy.computedSelects;
            if (computedSelects == null || computedSelects.isEmpty()) {
                return;
            }
            XComputedSelect select = computedSelects.get(0);
            if (select.computedValues != null && select.computedValues.length == 0) {
                return;
            }
            BitVectorContext indexContext = ((XArrayValueHolder)valueBeforeSelect).getIndexElementContext();
            IELParamValue iELParamValue = selectValue = indexContext == null ? select.computedValues[0] : indexContext.transform(select.computedValues[0]);
            if (selectValue instanceof XValueHolder) {
                result.append("[").append(((XValueHolder)selectValue).toUniqueString(true)).append("]");
            } else if (selectValue instanceof ELParamValues.ParamValueNumber && selectValue.getDVTNumber().isString()) {
                result.append("[").append(((VlogBitVector)selectValue.getDVTNumber()).stringValue(false)).append("]");
            } else {
                result.append("[").append(selectValue.toStringRadix(10)).append("]");
            }
            return;
        }
        int[] prevSelect = new int[]{-1, -1};
        int i = 0;
        while (i < selectProxy.computedSelects.size() - selectsToSkip) {
            XComputedSelect computedSelect = selectProxy.computedSelects.get(i);
            int[] select = XCModel.getSelect(i, selectProxy);
            if (select[0] == -1) {
                return;
            }
            boolean isNamedSelect = computedSelect instanceof XNamedComputedSelect;
            if (!isNamedSelect || !Arrays.equals(prevSelect, select)) {
                prevSelect = select;
                result.append("[").append(select[0]);
                if (select[0] != select[1]) {
                    result.append(": ").append(select[1]);
                }
                result.append("]");
            }
            ++i;
        }
    }

    public static String variableNameSuffix(String name, XSelectProxy selectProxy) {
        StringBuilder result = new StringBuilder(name);
        XCModel.appendSelects(result, selectProxy, 1);
        return result.toString();
    }

    public boolean isRandListSumVariable(String name, ELParamValueScope value, Hid parentHid) {
        if (parentHid.getParentAccess() == null) {
            return false;
        }
        return value.isRandListSumVariable(this, name);
    }

    public boolean isRandListSizeVariable(String name, ELParamValueScope value, Hid parentHid) {
        if (parentHid.getParentAccess() == null) {
            return false;
        }
        return value.isRandListSizeVariable(this, name);
    }

    public XCValue getListSumVariableIfExists(XArrayValueHolder xArrayValueHolder, IHidEvaluationGuardian guardian) {
        IELParamValue sumValue = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(0));
        String uniqueVariableName = XCModel.getUniqueVariableName("sum", ELParamValueScope.of(sumValue, xArrayValueHolder), guardian.getFactory());
        return this.getLeafVariable(uniqueVariableName);
    }

    public XCValue getListSizeVariable(XArrayValueHolder xArrayValueHolder, IHidEvaluationGuardian guardian) {
        IELParamValue sizeValue = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(xArrayValueHolder.size()));
        XCValue sizeXCValue = this.createVariable("size", ELParamValueScope.of(sizeValue, xArrayValueHolder), true, guardian);
        IntVariable sizeIntVar = sizeXCValue.getIntVar();
        sizeIntVar.setRandomCandidateDelegate((domain, searchStrategy, random, store) -> {
            BigInteger size = BigInteger.valueOf(xArrayValueHolder.size());
            return domain.contains(size) ? size : domain.getLowerBound();
        });
        return sizeXCValue;
    }

    public static void setDefaultForeachExpander(final XCModel model, final XCValue sizeXCValue, final String namePrefix, final XArrayValueHolder arrayValueHolder, final IHidEvaluationGuardian guardian) {
        final XCValue sumXCValue = model.getListSumVariableIfExists(arrayValueHolder, guardian);
        Model.IForeachExpander expander = new Model.IForeachExpander(){

            /*
             * Exception decompiling
             */
            public void expand() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 3[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public Variable getVariable() {
                return sizeXCValue.getIntVar();
            }
        };
        model.addForeachExpander(expander);
    }

    public void addCspToReadableTextMap(AbstractConstraint constraint, Text text) {
        this.cspToReadableTextMap.put(constraint, text);
    }

    public Map<AbstractConstraint, Text> setCspToReadableTextMap(Map<AbstractConstraint, Text> cspToReadableTextMap) {
        this.cspToReadableTextMap = cspToReadableTextMap;
        return cspToReadableTextMap;
    }

    public boolean hasLeafVariables() {
        return !this.leafVariables.isEmpty();
    }

    public static class Text {
        public LazyString lazyText;
        public int line;
        public ParserPath parserPath;

        public Text(LazyString text, int line, ParserPath parserPath) {
            this.lazyText = text;
            this.line = line;
            this.parserPath = parserPath;
        }

        public String toString() {
            return this.lazyText.toString();
        }
    }

    static class XCRandomField {
        private String name;
        private int uniqueId;

        private XCRandomField(String name, int uniqueId) {
            this.name = name;
            this.uniqueId = uniqueId;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.uniqueId;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            XCRandomField other = (XCRandomField)obj;
            if (this.uniqueId != other.uniqueId) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

