/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.constraints;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.csp.solver.Model;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.csp.variables.IntVariable;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELEnumTypeWrapper;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XArrayValueHolder;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.StructMemberContextInfo;
import ro.amiq.dvt.utils.VlogBitVector;

public class XCValue {
    private IELParamValue value;
    private XArrayValueHolder xArrayValueHolder;
    private IntVariable intVar;
    private IHidOperator hidOperator;
    private boolean isRand;
    private boolean isOriginalRand;
    private String randcVariableName;
    private boolean isNoValueUpdate;

    protected static XCValue createVariable(XCModel model, IELParamValue value, String name, XArrayValueHolder xArrayValueHolder, boolean isRand, IHidEvaluationGuardian guardian) {
        ELEnumTypeWrapper enumTypeWrapper;
        if (ELUtils.isUnsuccessfulEval(value)) {
            guardian.logError("Undefined value! ('" + name + "' is undefined)");
        }
        if ((enumTypeWrapper = value.getEnumTypeWrapper()) != null) {
            Collection<IELParamValue> itemValues = enumTypeWrapper.getItemValues();
            ArrayList<BigInteger> enumItemValues = new ArrayList<BigInteger>(itemValues.size());
            for (IELParamValue itemValue : itemValues) {
                if (!(itemValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Element_Enum)) continue;
                enumItemValues.add(itemValue.getDVTNumber().bigIntegerValue());
            }
            Collections.sort(enumItemValues);
            XCValue result = XCValue.createVariable(model, value, name, xArrayValueHolder, enumItemValues.toArray(new BigInteger[enumItemValues.size()]), isRand, guardian);
            return result;
        }
        if (value instanceof XValueHolder) {
            if (value.isNull()) {
                return model.createVariable(model.getCachedConstant(true, 32, BigInteger.ZERO), false, null);
            }
            BigInteger uniqueId = BigInteger.valueOf(((XValueHolder)value).uniqueValuesId());
            XCValue result = XCValue.createVariable(model, value, name, xArrayValueHolder, true, 32, uniqueId, uniqueId, isRand, guardian);
            return result;
        }
        DVTNumber number = value.getDVTNumber();
        boolean sign = number.hasSign();
        int nofBits = number.getSize();
        BigInteger lb = sign ? VlogBitVector.getPowerOfTwo(nofBits - 1).negate() : BigInteger.ZERO;
        BigInteger ub = sign ? VlogBitVector.getPowerOfTwoMask(nofBits - 1) : VlogBitVector.getPowerOfTwoMask(nofBits);
        XCValue result = XCValue.createVariable(model, value, name, xArrayValueHolder, sign, nofBits, lb, ub, isRand, guardian);
        return result;
    }

    protected static XCValue createVariable(Model model, IELParamValue value, String name, XArrayValueHolder xArrayValueHolder, BigInteger[] values, boolean isRand, IHidEvaluationGuardian guardian) {
        if (ELUtils.isUnsuccessfulEval(value)) {
            guardian.logError("Undefined value! ('" + name + "' is undefined)");
        }
        XCValue result = new XCValue(value, isRand);
        boolean sign = value.hasSign();
        int nofBits = value.getSize();
        result.intVar = model.intVar(name, sign, nofBits, values);
        result.xArrayValueHolder = xArrayValueHolder;
        return result;
    }

    public static XCValue createRandVariable() {
        XCValue result = new XCValue(null, true);
        result.isRand = true;
        result.isOriginalRand = true;
        return result;
    }

    private static XCValue createVariable(XCModel model, IELParamValue value, String name, XArrayValueHolder xArrayValueHolder, boolean sign, int nofBits, BigInteger lb, BigInteger ub, boolean isRand, IHidEvaluationGuardian guardian) {
        int index;
        if (ELUtils.isUnsuccessfulEval(value)) {
            guardian.logError("Undefined value! ('" + name + "' is undefined)");
        }
        XCValue result = new XCValue(value, isRand);
        result.intVar = model.intVar(name, sign, nofBits, lb, ub);
        result.xArrayValueHolder = xArrayValueHolder;
        if (xArrayValueHolder != null && name != null && (index = name.lastIndexOf(".")) > 0 && name.regionMatches(index + 1, "size", 0, 4)) {
            XCModel.setDefaultForeachExpander(model, result, name.substring(0, index), xArrayValueHolder, guardian);
        }
        if (result.isRand && result.intVar.isInstantiated()) {
            result.isRand = false;
        }
        return result;
    }

    protected static XCValue createConstant(Model model, String name, IELParamValue value, IHidEvaluationGuardian guardian) {
        if (ELUtils.isUnsuccessfulEval(value)) {
            guardian.logError("Undefined constant variable value!");
            return null;
        }
        XCValue result = new XCValue(value, false);
        if (value instanceof XArrayValueHolder) {
            boolean itemSign;
            int itemNofBits;
            HashSet<BigInteger> values = new HashSet<BigInteger>();
            int size = ((XArrayValueHolder)value).size();
            if (size == 0) {
                IELParamValue itemValueHolder = ((XArrayValueHolder)value).createElementValueHolder();
                itemNofBits = itemValueHolder.getSize();
                itemSign = itemValueHolder.hasSign();
            } else {
                int offset = ((XArrayValueHolder)value).getIndexOffset();
                IELParamValue itemValueHolder = ((XArrayValueHolder)value).getZValue(0 + offset);
                itemNofBits = itemValueHolder.getSize();
                itemSign = itemValueHolder.hasSign();
                int i = 0;
                while (i < size) {
                    IELParamValue zValue = ((XArrayValueHolder)value).getZValue(i + offset);
                    BigInteger itemNumber = zValue.bigIntegerValue();
                    if (!values.contains(itemNumber)) {
                        values.add(itemNumber);
                    }
                    ++i;
                }
            }
            if (values.isEmpty()) {
                result.intVar = model.intVar(name, itemSign, itemNofBits, new IntDomain());
                result.intVar.setConstant(true);
                return result;
            }
            ArrayList valuesList = new ArrayList(values);
            Collections.sort(valuesList);
            result.intVar = model.intVar(name, itemSign, itemNofBits, valuesList.toArray(new BigInteger[valuesList.size()]));
            return result;
        }
        DVTNumber number = value.getDVTNumber();
        boolean sign = value.hasSign();
        int nofBits = value.getSize();
        result.intVar = name != null ? model.intVar(name, sign, nofBits, number.bigIntegerValue()) : model.getCachedConstant(sign, nofBits, number.bigIntegerValue());
        return result;
    }

    public boolean isRand() {
        return this.isRand;
    }

    public boolean isOriginalRand() {
        return this.isOriginalRand;
    }

    public IELParamValue getValue() {
        return this.value;
    }

    protected static XCValue createVariable(IntVariable intVar, boolean isRand) {
        return new XCValue(intVar, isRand);
    }

    private XCValue(IELParamValue value, boolean isRand) {
        this.value = value;
        this.isRand = isRand;
        this.isOriginalRand = isRand;
    }

    private XCValue(IntVariable intVar, boolean isRand) {
        this.intVar = intVar;
        this.isRand = isRand;
    }

    public XCValue() {
    }

    public IntVariable getIntVar() {
        return this.intVar;
    }

    public void setIntVar(IntVariable intVar) {
        this.intVar = intVar;
    }

    public IHidOperator getHidOperator() {
        return this.hidOperator;
    }

    public void setHidOperator(IHidOperator hidOperator) {
        this.hidOperator = hidOperator;
    }

    public void initArrays(IHidEvaluationGuardian guardian) {
        boolean isArraySizeVariable;
        boolean bl = isArraySizeVariable = this.xArrayValueHolder != null && this.intVar.getName().endsWith(".size");
        if (!isArraySizeVariable) {
            return;
        }
        this.internalUpdateValue(null, guardian);
        if (guardian.getFactory().isAddExtraDebugInfo()) {
            guardian.logWarning("Array '" + this.intVar.getName() + "' size is " + this.intVar.value().intValue());
        }
        this.xArrayValueHolder.constrainArraySize(this.intVar.value().intValue());
    }

    public void updateValue(StringBuilder extraInfoText, IHidEvaluationGuardian guardian) {
        boolean isArraySizeVariable;
        boolean bl = isArraySizeVariable = this.xArrayValueHolder != null && this.intVar.getName().endsWith(".size");
        if (isArraySizeVariable) {
            return;
        }
        this.internalUpdateValue(extraInfoText, guardian);
    }

    private void internalUpdateValue(StringBuilder extraInfoText, IHidEvaluationGuardian guardian) {
        if (this.value == null || this.isNoValueUpdate) {
            return;
        }
        if (this.value instanceof XValueHolder) {
            return;
        }
        try {
            guardian.setOnlyIfArrayItemExists(true);
            DVTNumber number = this.value.getDVTNumber();
            int nofBits = number.getSize();
            boolean sign = number.hasSign();
            boolean is4State = number.is4State();
            boolean isString = number.isString();
            boolean isUnion = number.isUnion();
            boolean isReversed = number instanceof VlogBitVector && ((VlogBitVector)number).isReversed();
            Map<String, StructMemberContextInfo> memberInfoByName = number instanceof VlogBitVector ? ((VlogBitVector)number).getMemberInfoByName() : null;
            int msb = isReversed ? 0 : nofBits - 1;
            int lsb = isReversed ? nofBits - 1 : 0;
            VlogBitVector generatedNumber = VlogBitVector.create(sign, msb, lsb, null, is4State, isString, isUnion, false, memberInfoByName, null, this.intVar.value());
            BitVectorContext context = BitVectorContext.of(number, this.value.getElement());
            IELParamValue generatedValue = ELParamValues.ParamValueNumber.of(ELParamValues.ParamValueNumber.of(generatedNumber));
            generatedValue = context.transform(generatedValue);
            this.value = this.refreshValueBeforeUpdate(this.value);
            this.value.updateValue(generatedValue, guardian);
            if (extraInfoText != null) {
                extraInfoText.append("        ").append(this.intVar.getName()).append(" == ");
                if (this.value instanceof VlogBitVector && ((VlogBitVector)((Object)this.value)).isString()) {
                    extraInfoText.append(ELUtils.valueToString(this.value));
                } else {
                    extraInfoText.append(this.value.getSize()).append("'h").append(this.value.toStringRadix(16));
                }
                extraInfoText.append(";\n");
            }
            if (this.randcVariableName != null) {
                guardian.getFactory().updateRandcVariable(this.randcVariableName, generatedValue);
            }
        }
        finally {
            guardian.setOnlyIfArrayItemExists(false);
        }
    }

    private IELParamValue refreshValueBeforeUpdate(IELParamValue value) {
        if (!(value instanceof ELParamValues.ParamValueNumber.PackedStructMember)) {
            return value;
        }
        IRfNamedElement structItem = ((ELParamValues.ParamValueNumber.PackedStructMember)value).getStructItem();
        BitVectorContext structItemContext = ((ELParamValues.ParamValueNumber.PackedStructMember)value).getStructItemContext();
        XSelectProxy selectProxy = ((ELParamValues.ParamValueNumber.PackedStructMember)value).getSelectProxy();
        if (selectProxy != null) {
            IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelectRaw();
            value = this.refreshValueBeforeUpdate(valueBeforeSelect);
        }
        if (selectProxy == null) {
            return value;
        }
        XSelectProxy updatedSelectProxy = new XSelectProxy(value, selectProxy.computedSelects, selectProxy.context, selectProxy.guardian);
        IELParamValue selectedValue = XValueHolderFactory.createSelectProxyValue(value, updatedSelectProxy, false, true, LanguageKind.VLOG);
        return new ELParamValues.ParamValueNumber.PackedStructMember(structItemContext.transform(selectedValue), structItem, structItemContext, null);
    }

    public void setRandcName(String randcVariableName) {
        this.randcVariableName = randcVariableName;
    }

    public void setNoValueUpdate(boolean isNoValueUpdate) {
        this.isNoValueUpdate = isNoValueUpdate;
    }

    public boolean isNoValueUpdate() {
        return this.isNoValueUpdate;
    }

    public int getLsb() {
        if (this.value == null) {
            return 0;
        }
        DVTNumber dvtNumber = this.value.getDVTNumber();
        if (dvtNumber == null) {
            return 0;
        }
        int[] packed = dvtNumber.getPacked();
        int lsb = Math.min(packed[packed.length - 1], packed[packed.length - 2]);
        return lsb >= 0 ? lsb : 0;
    }

    public boolean isEnum() {
        return this.value != null && this.value instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Element_Enum;
    }
}

