/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.sim;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELDesign;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.IXThreadImpl;
import ro.amiq.dvt.interpreter.IXThreadListener;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XAlwaysBlockEvalScope;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XConcurrentAssertBlockEvalScope;
import ro.amiq.dvt.interpreter.XConcurrentAssertThread;
import ro.amiq.dvt.interpreter.XEvalScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodBlockEvalScope;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XSeqBlockEvalScope;
import ro.amiq.dvt.interpreter.XStopThreadException;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUVMElaborationStarters;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XSimEvaluationEvent;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.interpreter.sim.XSimTimeSlot;
import ro.amiq.dvt.interpreter.sim.XSimUpdateEvent;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.DummyInstance;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.ErrorDesignElement;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalConverter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.optimized.collections.Stack;
import ro.amiq.dvt.optimized.collections.fast.IdentityHSet;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;

public class XSimEventScheduler
implements IXThreadScheduler {
    public static final ParserPath INIT_PARSER_PATH = new ParserPath("<init>");
    public static final boolean BREAK_ON_FIRST_THREAD_STATEMENT = "true".equals(System.getenv("DVTX_BREAK_ON_FIRST_THREAD_STATEMENT"));
    public static final IRfInstanceElement BBOX_INSTANCE = DummyInstance.of("bbox", ErrorDesignElement.BLACK_BOX_TYPE);
    public static final String DVT_DEBUG_UVMRE_LOG = "dvt_debug_uvmre.log";
    private final IXSim xSim;
    private final Map<Integer, XThread> threads;
    private final Object threadsLock;
    private final Set<IXThreadListener> listeners = new LinkedHashSet<IXThreadListener>();
    private final List<XSimTimeSlot> timeSlots = new ArrayList<XSimTimeSlot>();
    private XSimTimeSlot currTimeSlot;
    private BigDecimal currentSimTime;
    private XThread xActiveThread;
    protected int threadCounter = 0;
    protected volatile boolean isTerminated = false;
    private long simulationTime;
    private boolean isSimStopped;
    private int valueChangeStackCount;
    private final Set<Change> visitedChanges;
    protected final EnumMap<XSimRegion.XRegionKind, Set<IXSimEvent>> regionEvents;
    private List<XActionBlock> xFinalActionBlocks;
    private final IProgressMonitor monitor;
    private boolean isForceApplyLock;
    private int timeout;
    private long startTime;

    public XSimEventScheduler(IXSim xSim, IProgressMonitor monitor) {
        this.xSim = xSim;
        this.threads = new LinkedHashMap<Integer, XThread>();
        this.threadsLock = new Object();
        this.visitedChanges = new HashSet<Change>();
        this.regionEvents = new EnumMap(XSimRegion.XRegionKind.class);
        this.regionEvents.put(XSimRegion.XRegionKind.Preponed, new LinkedHashSet());
        this.regionEvents.put(XSimRegion.XRegionKind.PreActive, new LinkedHashSet());
        this.regionEvents.put(XSimRegion.XRegionKind.PrePostponed, new LinkedHashSet());
        this.regionEvents.put(XSimRegion.XRegionKind.Postponed, new LinkedHashSet());
        this.currTimeSlot = new XSimTimeSlot(this, XUtils.MINUS_ONE_DECIMAL);
        this.timeSlots.add(this.currTimeSlot);
        this.currentSimTime = this.currTimeSlot.getTime();
        this.timeout = BuildConfigManager.getXTimeoutFinish(xSim.getProject());
        this.monitor = monitor;
    }

    /*
     * Exception decompiling
     */
    public void executeSimulation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void suspendExecution() {
        if (!this.isSimStopped) {
            this.simulationTime += System.currentTimeMillis() - this.startTime;
        }
        this.isSimStopped = true;
    }

    @Override
    public void resumeExecution() {
        if (this.isSimStopped) {
            this.startTime = System.currentTimeMillis();
        }
        this.isSimStopped = false;
    }

    public void printSimDuration() {
        this.suspendExecution();
        if (TestHelper.isTestMode()) {
            return;
        }
        this.xSim.logMessage("Duration: " + this.simulationTime + " ms\n");
    }

    public XSimTimeSlot getCurrTimeSlot() {
        return this.currTimeSlot;
    }

    public List<XActionBlock> createTimeZeroSlot() {
        final ELManager elManager = this.xSim.getELManager();
        if (elManager == null) {
            return Collections.emptyList();
        }
        final XValueHolderFactory factory = this.xSim.getFactory();
        XValueHolder evaluator = factory.createStaticValueHolder(XNamedElement.create(new RfDummyElement("[global init]"), null, true, factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
        XThreadDefinition xThreadDefinition = this.xSim.createThreadDefinition(null, null, INIT_PARSER_PATH, "elaborate", XThreadDefinition.ThreadKind.GLOBAL_INIT);
        final XThread xGlobalThread = new XThread(xThreadDefinition, this.threadCounter, -2, null, this, null);
        xThreadDefinition.setXThread(xGlobalThread, false);
        final ArrayList xActionBlocks = new ArrayList();
        final ArrayList xWaitingAlwaysBlocks = new ArrayList();
        final HashMap xConcurrentAssertionBlocks = new HashMap();
        final ArrayList<XActionBlock> xFinalActionBlocks = new ArrayList<XActionBlock>();
        final int runtimeElabMaxDepth = BuildConfigManager.getXRuntimeElabMaxDepth(this.xSim.getProject());
        final boolean isAddExtraDebugInfo = factory.isAddExtraDebugInfo();
        XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, evaluator, null, xThreadDefinition.getHidEvaluationGuardian(), null, xThreadDefinition.getFirstStatementParserPath(), null, false){
            boolean isStepIntoThread;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5, $anonymous6, $anonymous7);
                this.isStepIntoThread = BREAK_ON_FIRST_THREAD_STATEMENT;
            }

            @Override
            public ELParamValueScope execute(XThread xThread) {
                XThreadDefinition xThreadDefinition;
                IHidObject edgeOperator;
                ListContainer<IHidObject> rhValues;
                IRfDefElement declaration;
                List<IELMemory> elMemories = this.getTopMemories(elManager, factory);
                RfMixedLangProject mixedLangProject = XSimEventScheduler.this.xSim.getRfMixedLangProject();
                IRfSingleLangProject vlogLangProject = mixedLangProject.getSingleLangProject(LanguageKind.VLOG.NATURE_ID);
                if (vlogLangProject == null) {
                    return ELParamValueScope.IMPLICIT_RESULT;
                }
                factory.createStaticValueHolder(XNamedElement.create((IRfNamedElement)((Object)vlogLangProject), null, true, factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()));
                boolean isRuntimeElab = this.guardian.simulatorMode() == IXSim.XSimMode.UVM_RUNTIME_ELAB;
                boolean isRuntimeElabOptimizedMode = isRuntimeElab && runtimeElabMaxDepth > 0 && !factory.getRuntimeElabDisableOpt();
                boolean isSim = this.guardian.simulatorMode() == IXSim.XSimMode.SIMULATOR;
                IProject project = mixedLangProject.getProject();
                List<ElementPath> bboxPaths = BuildConfigManager.getXRuntimeElabBBoxFilterPrefixes(project);
                if (isSim && elManager.hasSimRelevantProblems()) {
                    this.guardian.logWarning("Design elaboration is incomplete. Rebuild project with +dvt_elaboration_debug+STATS+EVAL for details.", false);
                }
                ArrayList<ELInstance> instances = new ArrayList<ELInstance>();
                long time = System.currentTimeMillis();
                for (IELMemory elMemory : elMemories) {
                    if (isRuntimeElabOptimizedMode) {
                        XSimEventScheduler.this.collectRuntimeElabInstances(instances, elMemory, elManager, bboxPaths, runtimeElabMaxDepth, project, factory);
                        continue;
                    }
                    if (isRuntimeElab) {
                        XSimEventScheduler.this.collectInstances(instances, elMemory, bboxPaths, this.guardian);
                        continue;
                    }
                    XSimEventScheduler.this.collectInstances(instances, elMemory, null, this.guardian);
                }
                factory.printExtraDebugMessage(isAddExtraDebugInfo, "Collect relevant instances", time);
                if (isRuntimeElab && !isRuntimeElabOptimizedMode) {
                    this.guardian.logWarning("UVM runtime elaboration optimizations are disabled (using " + XUtils.getNofInstances() + " instances).", false);
                } else if (isRuntimeElab && isRuntimeElabOptimizedMode) {
                    this.guardian.logWarning("UVM runtime elaboration optimizations are enabled (using " + XUtils.getNofInstances() + " instances).", false);
                }
                factory.createStaticHoldersForPackages(vlogLangProject);
                IRfSingleLangProject vhdlLangProject = mixedLangProject.getSingleLangProject(LanguageKind.VHDL.NATURE_ID);
                if (vhdlLangProject != null) {
                    factory.createStaticHoldersForPackages(vhdlLangProject);
                }
                ArrayList<ELInstance> instancesCopy = new ArrayList<ELInstance>(instances);
                Collections.sort(instancesCopy, (o1, o2) -> o1.getHierarchyPath().compareTo(o2.getHierarchyPath()));
                time = System.currentTimeMillis();
                for (ELInstance instance : instancesCopy) {
                    IRfNamedElement binding = instance.getBinding(false);
                    XSimEventScheduler.this.xSim.setCurrentLineNumber(binding);
                    ElementPath elementPath = instance.getHierarchyPath();
                    factory.createInstanceValueHolder(instance, xGlobalThread);
                    List<? extends IRfClockingBlockElement> clockingBlocks = binding.xGetClockingBlocks();
                    if (clockingBlocks == null || clockingBlocks.isEmpty()) continue;
                    Iterator<IRfClockingBlockElement> iterator = clockingBlocks.iterator();
                    while (iterator.hasNext()) {
                        IRfClockingBlockElement clockingBlock = iterator.next();
                        ElementPath cbElementPath = ElementPath.join(elementPath, clockingBlock.getName());
                        ELInstance cbInstance = ELInstance.of(DummyInstance.of(clockingBlock.getName(), clockingBlock), cbElementPath, elManager);
                        cbInstance.setBinding(clockingBlock);
                        factory.createInstanceValueHolder(cbInstance, xGlobalThread);
                    }
                }
                factory.printExtraDebugMessage(isAddExtraDebugInfo, "Create all instances", time);
                ArrayList<Runnable> constantAssigns = new ArrayList<Runnable>();
                time = System.currentTimeMillis();
                factory.initInstancesMembers1(constantAssigns, isRuntimeElabOptimizedMode, this.guardian);
                factory.printExtraDebugMessage(isAddExtraDebugInfo, "Variable declaration, assigns, port connections, multiple-drivers", time);
                LinkedHashMap<String, ListContainer<IHidObject>> sensitivityMap = new LinkedHashMap<String, ListContainer<IHidObject>>();
                time = System.currentTimeMillis();
                List<ELInstance> sortedInstances = XSimEventScheduler.this.instancesSort(instances);
                for (ELInstance instance : sortedInstances) {
                    IRfNamedElement binding = instance.getBinding(false);
                    if (binding == null) continue;
                    XSimEventScheduler.this.xSim.setCurrentLineNumber(binding);
                    boolean isUDPInstantiation = DesignUtils.getDesignKind(binding) == IRfNamedElement.ElementKind.VLOG_PRIMITIVE;
                    IRfInstanceElement description = instance.getDescription();
                    HidOperator driveStrength = isUDPInstantiation ? XUtils.getInstanceDriveStrength(description) : null;
                    HidOperator delayControl = isUDPInstantiation ? XUtils.getInstanceDelayControl(description) : null;
                    try {
                        ElementPath path = instance.getHierarchyPath();
                        XInstValueHolder instanceValueHolder = factory.getInstValueHolder(path);
                        List<IRfActionBlockElement> actionBlocks = binding.xGetExecBlocks(driveStrength, delayControl, instanceValueHolder, false);
                        if (actionBlocks == null || actionBlocks.isEmpty()) continue;
                        if (XSimEventScheduler.this.xSim.isGenerateVcdFile() && instance.isTop()) {
                            List<IReflectionContributor> enabledContributors = RfMixedLangManager.getInstance().getEnabledContributors(project);
                            for (IReflectionContributor iReflectionContributor : enabledContributors) {
                                IRfActionBlockElement vcdActionBlock = iReflectionContributor.createVcdActionBlock(binding);
                                if (vcdActionBlock == null) continue;
                                actionBlocks.add(vcdActionBlock);
                                break;
                            }
                        }
                        for (IRfActionBlockElement actionBlock : actionBlocks) {
                            HidOperator edgeOperator2;
                            IHidOperator statementBlock;
                            if (isRuntimeElabOptimizedMode && !XUtils.isInitialBlock(actionBlock)) continue;
                            boolean isConcurrentAssertionStatement = XUtils.isConcurrentAssertion(actionBlock);
                            IHidOperator iHidOperator = statementBlock = isConcurrentAssertionStatement ? HidEvalConverter.INSTANCE.convertConcurrentAssertion((IRfAssertExpectElement)actionBlock, this.guardian, instanceValueHolder) : HidEvalConverter.INSTANCE.convertElement(actionBlock, this.guardian, instanceValueHolder);
                            if (statementBlock == null) continue;
                            if (actionBlock.isInitial()) {
                                xActionBlocks.add(new XActionBlock(ActionKind.INITIAL, actionBlock, instanceValueHolder, statementBlock));
                                continue;
                            }
                            if (actionBlock.isFinal()) {
                                xFinalActionBlocks.add(new XActionBlock(ActionKind.FINAL, actionBlock, instanceValueHolder, statementBlock));
                                continue;
                            }
                            if (XUtils.isAlwaysComb(actionBlock) || XUtils.isAlwaysLatch(actionBlock)) {
                                xWaitingAlwaysBlocks.add(new XActionBlock(ActionKind.ALWAYS_COMB, actionBlock, instanceValueHolder, statementBlock));
                                continue;
                            }
                            if (XUtils.isAlwaysBlock(actionBlock)) {
                                ListContainer<IHidObject> statements = statementBlock.getRHValues();
                                if (statements == null) continue;
                                if (!statements.isEmpty() && XUtils.isSensitiveAllEdgeControl(statements.get(0))) {
                                    snstvtEventControl = actionBlock.xGetSnsvtEventControlOperator((HidOperator)statements.get(0), true, instanceValueHolder, this.guardian);
                                    snstvtEventControl.addQualifier(HidQualifierCache.IS_ALWAYS_SENSITIVITY_LIST_QUALIFIER);
                                    if (statements.size() == 1) {
                                        ((HidOperator)statementBlock).setRHValues(snstvtEventControl);
                                    } else {
                                        ((ArrayListContainer)statements).set(0, snstvtEventControl);
                                    }
                                    if (this.concatenateAlwaysBlocks(sensitivityMap, snstvtEventControl, statements, instanceValueHolder, actionBlock)) {
                                        XUtils.increment("concat blocks");
                                        continue;
                                    }
                                } else if (!statements.isEmpty() && XUtils.isEventControl(statements.get(0))) {
                                    snstvtEventControl = (HidOperator)statements.get(0);
                                    snstvtEventControl.addQualifier(HidQualifierCache.IS_ALWAYS_SENSITIVITY_LIST_QUALIFIER);
                                    ListContainer<IHidObject> newRHValues = this.optimizeAlwaysBlock(actionBlock, statements, snstvtEventControl, instanceValueHolder);
                                    if (newRHValues != null) {
                                        ((HidOperator)statementBlock).setRHValues(newRHValues);
                                    }
                                    if (this.concatenateAlwaysBlocks(sensitivityMap, snstvtEventControl, statementBlock.getRHValues(), instanceValueHolder, actionBlock)) {
                                        XUtils.increment("concat blocks");
                                        continue;
                                    }
                                    if (snstvtEventControl.getLanguageKind() == LanguageKind.VHDL) {
                                        xActionBlocks.add(new XActionBlock(ActionKind.PROCESS, actionBlock, instanceValueHolder, statementBlock));
                                        continue;
                                    }
                                } else {
                                    xActionBlocks.add(new XActionBlock(ActionKind.ALWAYS, actionBlock, instanceValueHolder, statementBlock));
                                    continue;
                                }
                                xWaitingAlwaysBlocks.add(new XActionBlock(ActionKind.ALWAYS, actionBlock, instanceValueHolder, statementBlock));
                            }
                            if (!isConcurrentAssertionStatement || (edgeOperator2 = (HidOperator)((HidEvalCenter.ConcurrentAssertStatement)statementBlock).getFirstClockEvent()) == null) continue;
                            String edgeControlKey = edgeOperator2.xGetCanonicEventControlKey(instanceValueHolder, this.guardian);
                            ArrayList<XActionBlock> similarEdgeSensitiveConcurrentAssertStatement = (ArrayList<XActionBlock>)xConcurrentAssertionBlocks.get(edgeControlKey);
                            if (similarEdgeSensitiveConcurrentAssertStatement == null) {
                                similarEdgeSensitiveConcurrentAssertStatement = new ArrayList<XActionBlock>();
                                xConcurrentAssertionBlocks.put(edgeControlKey, similarEdgeSensitiveConcurrentAssertStatement);
                            } else {
                                XUtils.increment("concat concurrent asserts");
                            }
                            similarEdgeSensitiveConcurrentAssertStatement.add(new XActionBlock(ActionKind.ASSERT, actionBlock, instanceValueHolder, statementBlock));
                        }
                    }
                    catch (XStopThreadException | BuildCancelException runtimeException) {
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
                Comparator actionBlockComparator = (b1, b2) -> {
                    int fileComparatorResult;
                    ElementPath path1 = b1.instanceValueHolder != null ? b1.instanceValueHolder.getInstancePath() : null;
                    ElementPath path2 = b2.instanceValueHolder != null ? b2.instanceValueHolder.getInstancePath() : null;
                    IRfDefElement decl1 = b1.actionBlock != null ? b1.actionBlock.getDeclaration() : null;
                    IRfDefElement decl2 = b1.actionBlock != null ? b2.actionBlock.getDeclaration() : null;
                    int off1 = decl1 != null ? decl1.getStartOffset() : -1;
                    int off2 = decl2 != null ? decl2.getStartOffset() : -1;
                    int voff1 = decl1 != null ? decl1.getStartVirtualOffset() : -1;
                    int voff2 = decl2 != null ? decl2.getStartVirtualOffset() : -1;
                    int fileOff1 = decl1 != null && decl1.getDefFile() != null ? decl1.getDefFile().getIndex() : -1;
                    int fileOff2 = decl2 != null && decl2.getDefFile() != null ? decl2.getDefFile().getIndex() : -1;
                    List<Object> subPaths1 = path1 != null ? path1.getSubPaths() : Collections.emptyList();
                    List<Object> subPaths2 = path2 != null ? path2.getSubPaths() : Collections.emptyList();
                    boolean pathsMatch = true;
                    int i = 0;
                    while (i < subPaths1.size() && i < subPaths2.size()) {
                        String n1 = ((ElementPath)subPaths1.get(i)).getSegmentName();
                        String n2 = ((ElementPath)subPaths2.get(i)).getSegmentName();
                        int[] i1 = ((ElementPath)subPaths1.get(i)).getSegmentIndices();
                        int[] i2 = ((ElementPath)subPaths2.get(i)).getSegmentIndices();
                        if (!Objects.equals(n1, n2)) {
                            ElementPath subPath1 = (ElementPath)subPaths1.get(i);
                            ElementPath subPath2 = (ElementPath)subPaths2.get(i);
                            IRfNamedElement el1 = null;
                            IRfNamedElement el2 = null;
                            for (IELMemory memory : elMemories) {
                                ELInstance inst;
                                if (el1 == null) {
                                    inst = memory.instanceFor(subPath1);
                                    IRfNamedElement iRfNamedElement = el1 = inst != null ? inst.getDescription() : null;
                                }
                                if (el2 == null) {
                                    inst = memory.instanceFor(subPath2);
                                    IRfNamedElement iRfNamedElement = el2 = inst != null ? inst.getDescription() : null;
                                }
                                if (el1 != null && el2 != null) break;
                            }
                            IRfDefElement def1 = el1 != null ? el1.getDeclaration() : null;
                            IRfDefElement def2 = el2 != null ? el2.getDeclaration() : null;
                            off1 = def1 != null ? def1.getStartOffset() : -1;
                            off2 = def2 != null ? def2.getStartOffset() : -1;
                            voff1 = def1 != null ? def1.getStartVirtualOffset() : -1;
                            voff2 = def2 != null ? def2.getStartVirtualOffset() : -1;
                            fileOff1 = def1 != null && def1.getDefFile() != null ? def1.getDefFile().getIndex() : -1;
                            fileOff2 = def2 != null && def2.getDefFile() != null ? def2.getDefFile().getIndex() : -1;
                            pathsMatch = false;
                            break;
                        }
                        int result = Arrays.compare(i1, i2);
                        if (result != 0) {
                            return result;
                        }
                        ++i;
                    }
                    if (pathsMatch) {
                        if (subPaths1.size() < subPaths2.size()) {
                            ElementPath subPath2 = (ElementPath)subPaths2.get(subPaths1.size());
                            el = null;
                            for (IELMemory memory : elMemories) {
                                inst = memory.instanceFor(subPath2);
                                IRfNamedElement iRfNamedElement = el = inst != null ? inst.getDescription() : null;
                                if (el != null) break;
                            }
                            def = el != null ? el.getDeclaration() : null;
                            off2 = def != null ? def.getStartOffset() : -1;
                            voff2 = def != null ? def.getStartVirtualOffset() : -1;
                            fileOff2 = def != null && def.getDefFile() != null ? def.getDefFile().getIndex() : -1;
                        } else if (subPaths2.size() < subPaths1.size()) {
                            ElementPath subPath1 = (ElementPath)subPaths1.get(subPaths2.size());
                            el = null;
                            for (IELMemory memory : elMemories) {
                                inst = memory.instanceFor(subPath1);
                                IRfNamedElement iRfNamedElement = el = inst != null ? inst.getDescription() : null;
                                if (el != null) break;
                            }
                            def = el != null ? el.getDeclaration() : null;
                            off1 = def != null ? def.getStartOffset() : -1;
                            voff1 = def != null ? def.getStartVirtualOffset() : -1;
                            int n = fileOff1 = def != null && def.getDefFile() != null ? def.getDefFile().getIndex() : -1;
                        }
                    }
                    if ((fileComparatorResult = Integer.compare(fileOff1, fileOff2)) != 0) {
                        return fileComparatorResult;
                    }
                    int offsetComparatorResult = Integer.compare(off1, off2);
                    if (offsetComparatorResult != 0) {
                        return offsetComparatorResult;
                    }
                    return Integer.compare(voff1, voff2);
                };
                xActionBlocks.sort(actionBlockComparator);
                xFinalActionBlocks.sort(actionBlockComparator);
                xWaitingAlwaysBlocks.sort(actionBlockComparator);
                factory.printExtraDebugMessage(isAddExtraDebugInfo, "Collect initial, always and final blocks", time);
                time = System.currentTimeMillis();
                factory.initInstancesMembers2(constantAssigns);
                factory.printExtraDebugMessage(isAddExtraDebugInfo, "Initialize and propagate values", time);
                for (XActionBlock xActionBlock : xWaitingAlwaysBlocks) {
                    IRfDefElement declaration2 = xActionBlock.actionBlock.getDeclaration();
                    XSimEventScheduler.this.xSim.setCurrentParserPath(declaration2.getParserPath());
                    XSimEventScheduler.this.xSim.setCurrentLineNumber(declaration2.getStartLine());
                    if (xActionBlock.actionKind != ActionKind.ALWAYS) continue;
                    XThreadDefinition xThreadDefinition2 = XSimEventScheduler.this.xSim.createThreadDefinition(xActionBlock.hidOperator, xActionBlock.instanceValueHolder, declaration2.getParserPath(), "always", XThreadDefinition.ThreadKind.ALWAYS);
                    XSimEventScheduler.this.forkThread(null, XUtils.getName(xActionBlock.actionBlock), xThreadDefinition2, true, this.isStepIntoThread, xActionBlock.instanceValueHolder);
                    this.isStepIntoThread = false;
                }
                for (Map.Entry assertionEntry : xConcurrentAssertionBlocks.entrySet()) {
                    final List xActionBlocks2 = (List)assertionEntry.getValue();
                    XActionBlock candidateActionBlock = (XActionBlock)xActionBlocks2.iterator().next();
                    XInstValueHolder instanceValueHolder = candidateActionBlock.instanceValueHolder;
                    ParserPath parserPath = instanceValueHolder.getNamedElement().getDeclaration().getParserPath();
                    IHidOperator drivenEdgeOperator = ((HidEvalCenter.ConcurrentAssertStatement)candidateActionBlock.hidOperator).getFirstClockEvent();
                    ArrayListContainer<IHidObject> statements = new ArrayListContainer<IHidObject>(2);
                    statements.add(drivenEdgeOperator);
                    HidOperator assertSpawnerOp = new HidOperator(-1, IHidOperatorConstants.OperatorKind.UNARY_OPERATOR, "assert_spawner", -1, -1, -1, -1, 0L){
                        private static final long serialVersionUID = 1L;

                        @Override
                        public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                            XThread activeThread = factory.getActiveThread();
                            if (activeThread == null) {
                                return ELParamValueScope.IMPLICIT_RESULT;
                            }
                            for (XActionBlock xActionBlock : xActionBlocks2) {
                                IHidOperator hidOperator = xActionBlock.getHidOperator();
                                XInstValueHolder instanceValueHolder = xActionBlock.getInstanceValueHolder();
                                IRfActionBlockElement actionBlock = xActionBlock.getActionBlock();
                                IRfDefElement declaration = actionBlock.getDeclaration();
                                guardian.callbackStartThread(hidOperator, actionBlock.getName(), hidOperator, instanceValueHolder, declaration.getParserPath(), "assertion", XThreadDefinition.ThreadKind.ASSERTION);
                            }
                            return ELParamValueScope.IMPLICIT_RESULT;
                        }

                        @Override
                        public LanguageKind getLanguageKind() {
                            return LanguageKind.VLOG;
                        }
                    };
                    statements.add(assertSpawnerOp);
                    HidOperator dummyAssertionSpawnerBlockStatement = HidEvalCenter.INSTANCE.createStatement(null, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, -1, -1, -1, false, statements);
                    XThreadDefinition xThreadDefinition2 = XSimEventScheduler.this.xSim.createThreadDefinition(dummyAssertionSpawnerBlockStatement, instanceValueHolder, parserPath, "assertion_spawner", XThreadDefinition.ThreadKind.PREPONED);
                    XSimEventScheduler.this.forkThread(null, "assertion_fork " + HidUtils.toNiceString(drivenEdgeOperator), xThreadDefinition2, true, this.isStepIntoThread, instanceValueHolder);
                    this.isStepIntoThread = false;
                }
                XSimTimeSlot prevTimeSlot = XSimEventScheduler.this.currTimeSlot;
                XSimEventScheduler.this.currTimeSlot = XSimEventScheduler.this.getTimeSlot(BigDecimal.ZERO);
                time = System.currentTimeMillis();
                for (XActionBlock xActionBlock : xActionBlocks) {
                    declaration = xActionBlock.actionBlock.getDeclaration();
                    XSimEventScheduler.this.xSim.setCurrentParserPath(declaration.getParserPath());
                    XSimEventScheduler.this.xSim.setCurrentLineNumber(declaration.getStartLine());
                    switch (xActionBlock.actionKind) {
                        case ALWAYS: {
                            XThreadDefinition xThreadDefinition4 = XSimEventScheduler.this.xSim.createThreadDefinition(xActionBlock.hidOperator, xActionBlock.instanceValueHolder, declaration.getParserPath(), "always", XThreadDefinition.ThreadKind.ALWAYS);
                            XSimEventScheduler.this.forkThread(null, XUtils.getName(xActionBlock.actionBlock), xThreadDefinition4, true, this.isStepIntoThread, xActionBlock.instanceValueHolder);
                            this.isStepIntoThread = false;
                            break;
                        }
                        case PROCESS: {
                            rhValues = xActionBlock.hidOperator.getRHValues();
                            if (rhValues instanceof ArrayListContainer && rhValues.size() > 1 && rhValues.get(0) instanceof HidOperator && ((HidOperator)rhValues.get(0)).hasOccurrence(HidQualifierCache.IS_ALWAYS_SENSITIVITY_LIST_QUALIFIER)) {
                                edgeOperator = (IHidObject)((ArrayListContainer)rhValues).remove(0);
                                ((HidOperator)xActionBlock.hidOperator).addRHValue(edgeOperator, false);
                            }
                            xThreadDefinition = XSimEventScheduler.this.xSim.createThreadDefinition(xActionBlock.hidOperator, xActionBlock.instanceValueHolder, declaration.getParserPath(), "process", XThreadDefinition.ThreadKind.PROCESS);
                            XSimEventScheduler.this.forkThread(null, XUtils.getName(xActionBlock.actionBlock), xThreadDefinition, true, this.isStepIntoThread, xActionBlock.instanceValueHolder);
                            this.isStepIntoThread = false;
                            break;
                        }
                        case INITIAL: {
                            XThreadDefinition xThreadDefinition3 = XSimEventScheduler.this.xSim.createThreadDefinition(xActionBlock.hidOperator, xActionBlock.instanceValueHolder, declaration.getParserPath(), "initial", XThreadDefinition.ThreadKind.INITIAL);
                            XSimEventScheduler.this.forkThread(null, XUtils.getName(xActionBlock.actionBlock), xThreadDefinition3, false, this.isStepIntoThread, xActionBlock.instanceValueHolder);
                            this.isStepIntoThread = false;
                            break;
                        }
                    }
                }
                for (XActionBlock xActionBlock : xWaitingAlwaysBlocks) {
                    declaration = xActionBlock.actionBlock.getDeclaration();
                    XSimEventScheduler.this.xSim.setCurrentParserPath(declaration.getParserPath());
                    XSimEventScheduler.this.xSim.setCurrentLineNumber(declaration.getStartLine());
                    if (xActionBlock.actionKind != ActionKind.ALWAYS_COMB) continue;
                    rhValues = xActionBlock.hidOperator.getRHValues();
                    if (!rhValues.isEmpty()) {
                        edgeOperator = xActionBlock.actionBlock.xCreateEventControlOperator(xActionBlock.instanceValueHolder, this.guardian);
                        edgeOperator.addQualifier(HidQualifierCache.IS_ALWAYS_SENSITIVITY_LIST_QUALIFIER);
                        ((ArrayListContainer)rhValues).add(edgeOperator);
                    }
                    xThreadDefinition = XSimEventScheduler.this.xSim.createThreadDefinition(xActionBlock.hidOperator, xActionBlock.instanceValueHolder, declaration.getParserPath(), "always_comb", XThreadDefinition.ThreadKind.ALWAYS_COMB);
                    XSimEventScheduler.this.forkThread(null, XUtils.getName(xActionBlock.actionBlock), xThreadDefinition, true, this.isStepIntoThread, xActionBlock.instanceValueHolder);
                    this.isStepIntoThread = false;
                }
                factory.printExtraDebugMessage(isAddExtraDebugInfo, "Create threads for initial and always blocks", time);
                XSimEventScheduler.this.xSim.setCurrentParserPath(null);
                XSimEventScheduler.this.currTimeSlot = prevTimeSlot;
                xGlobalThread.popEvalScope();
                xThread.localTerminate(false);
                return ELParamValueScope.IMPLICIT_RESULT;
            }

            /*
             * WARNING - void declaration
             */
            private ListContainer<IHidObject> optimizeAlwaysBlock(IRfActionBlockElement actionBlock, ListContainer<IHidObject> rhValues, final HidOperator snstvtEventControl, XInstValueHolder instanceValueHolder) {
                ArrayListContainer<IHidObject> statements;
                ListContainer<IHidObject> driverHid;
                IHidObject driver;
                boolean isInternalBlock;
                if (!XUtils.isClockResetEventControl(snstvtEventControl, this.guardian)) {
                    return null;
                }
                String name = actionBlock.getName();
                boolean bl = isInternalBlock = !actionBlock.isAnonymous() && name.startsWith("<");
                if (isInternalBlock) {
                    return null;
                }
                if (XUtils.hasDelayBlockingStatement(rhValues)) {
                    return null;
                }
                XUtils.increment("optimized blocks (total candidates)");
                LinkedHashSet<IHidObject> drivers = new LinkedHashSet<IHidObject>();
                LinkedHashSet<IHidObject> loads = new LinkedHashSet<IHidObject>();
                actionBlock.xCollectDrivers(Collections.newSetFromMap(new IdentityHashMap()), drivers, loads, true, snstvtEventControl, instanceValueHolder, this.guardian.copy());
                if (drivers.isEmpty()) {
                    return null;
                }
                if (drivers.size() == 1 && (driver = (IHidObject)drivers.iterator().next()) == Hid.EVALUATE_SKIP_HID) {
                    return null;
                }
                final Int2IntOpenHashMap uniqueIds = new Int2IntOpenHashMap();
                try {
                    this.guardian.setDisableNullChecks(true);
                    for (IHidObject load : loads) {
                        Hid loadHid = null;
                        if (load instanceof Hid) {
                            loadHid = (Hid)load;
                        } else if (load instanceof HidAccess) {
                            loadHid = ((HidAccess)load).getParentHid();
                        } else {
                            return null;
                        }
                        IRfNamedElement element = loadHid.getElement();
                        if (element != null && element.getEnclosingScope() instanceof IRfClassElement) continue;
                        IELParamValue value = XUtils.getValue(ELUtils.evaluate(loadHid, instanceValueHolder, null, this.guardian.copy()));
                        if (ELUtils.isUnsuccessfulEval(value)) {
                            return null;
                        }
                        IELParamValue original = XUtils.getOriginal(value, true);
                        int uniqueId = factory.getUniqueId(original, true);
                        int releaseUniqueId = factory.putReleaseTriggerId(uniqueId);
                        factory.putChangedVariableCount(releaseUniqueId);
                        uniqueIds.put(releaseUniqueId, 0);
                    }
                    for (IHidObject driver2 : drivers) {
                        driverHid = null;
                        if (driver2 instanceof Hid) {
                            driverHid = (Hid)driver2;
                        } else if (driver2 instanceof HidAccess) {
                            driverHid = ((HidAccess)driver2).getParentHid();
                        } else {
                            return null;
                        }
                        IELParamValue value = XUtils.getValue(ELUtils.evaluate(driverHid, instanceValueHolder, null, this.guardian.copy()));
                        if (ELUtils.isUnsuccessfulEval(value)) {
                            return null;
                        }
                        IELParamValue original = XUtils.getOriginal(value, true);
                        int uniqueId = factory.getUniqueId(original, true);
                        factory.putChangedVariableCount(uniqueId);
                        uniqueIds.put(uniqueId, -1);
                    }
                }
                finally {
                    this.guardian.setDisableNullChecks(false);
                }
                HidOperator condition = new HidOperator(IHidOperatorConstants.OperatorType.INTR_DUMMY_STATEMENT.id, IHidOperatorConstants.OperatorKind.BINARY_OPERATOR, "@" + ((Object)drivers).toString(), -1, -1, -1, -1, 0L){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public ELParamValueScope evaluate(IHidEvaluator evaluator, BitVectorContext context, IHidEvaluationGuardian guardian) {
                        boolean hasChange = false;
                        for (Map.Entry entry : uniqueIds.entrySet()) {
                            int currCount;
                            int prevCount = (Integer)entry.getValue();
                            if (prevCount == (currCount = factory.getChangedVariableCount((Integer)entry.getKey()))) continue;
                            hasChange = true;
                            entry.setValue(currCount);
                        }
                        return ELParamValueScope.of(ELParamValues.ParamValueNumber.of(hasChange ? VlogBitVector.ONE : VlogBitVector.ZERO));
                    }

                    @Override
                    public LanguageKind getLanguageKind() {
                        return snstvtEventControl.getLanguageKind();
                    }
                };
                if (rhValues.size() == 2) {
                    statements = (ArrayListContainer<IHidObject>)((Object)rhValues.get(1));
                } else {
                    statements = new ArrayListContainer<IHidObject>(rhValues.size() - 1);
                    ListContainer<IHidObject> listContainer = rhValues;
                    if (listContainer instanceof ArrayListContainer && (driverHid = (ArrayListContainer)listContainer) == (ArrayListContainer)listContainer) {
                        void rhv;
                        int i = 1;
                        while (i < rhv.size()) {
                            statements.add((IHidObject)rhv.get(i));
                            ++i;
                        }
                    }
                }
                HidOperator condStatement = HidEvalCenter.INSTANCE.createIfStatement(condition, statements);
                ArrayListContainer<IHidObject> newRHValues = new ArrayListContainer<IHidObject>(2);
                newRHValues.add(snstvtEventControl);
                newRHValues.add(condStatement);
                XUtils.increment("optimized blocks");
                return newRHValues;
            }

            private boolean concatenateAlwaysBlocks(Map<String, ListContainer<IHidObject>> sensitivityMap, HidOperator snstvtEventControl, ListContainer<IHidObject> statements, XInstValueHolder instanceValueHolder, IRfActionBlockElement actionBlock) {
                if (!XSimEventScheduler.this.xSim.getEvaluationGuardian(false).isRunMode()) {
                    return false;
                }
                if (XUtils.hasDelayBlockingStatement(statements)) {
                    return false;
                }
                String edgeOperatorKey = snstvtEventControl.xGetCanonicEventControlKey(instanceValueHolder, this.guardian);
                if (edgeOperatorKey == null) {
                    return false;
                }
                ListContainer<IHidObject> existingStatements = sensitivityMap.get(edgeOperatorKey);
                if (existingStatements == null || !(existingStatements instanceof ArrayListContainer)) {
                    sensitivityMap.put(edgeOperatorKey, statements);
                    return false;
                }
                ParserPath parserPath = XUtils.getParserPath(actionBlock, null);
                for (IHidObject statement : statements) {
                    if (statement instanceof HidOperator && ((HidOperator)statement).hasOccurrence(HidOperatorQualifier.IS_ALWAYS_SENSITIVITY_LIST)) continue;
                    ((ArrayListContainer)existingStatements).add(new XInstValueHolder.XEvalOverrideHidOperator(instanceValueHolder, (HidOperator)statement, parserPath));
                }
                sensitivityMap.put(edgeOperatorKey, existingStatements);
                return true;
            }

            private List<IELMemory> getTopMemories(ELManager elManager2, XValueHolderFactory factory2) {
                ArrayList<IELMemory> elMemories = new ArrayList<IELMemory>();
                List<ElementPath> topModulePaths = factory2.getTopModulePaths();
                IELMemory elMemory = elManager2.getMemory();
                if (topModulePaths == null || topModulePaths.isEmpty()) {
                    elMemories.add(elMemory);
                } else {
                    for (ElementPath topModulePath : topModulePaths) {
                        IELMemory elSubMemory = elMemory.subMemory(topModulePath);
                        if (elSubMemory == null || elSubMemory.isEmpty()) {
                            this.guardian.logError("Top module '" + topModulePath + "' specified as " + "+dvt_top=" + " argument does not exist.");
                            continue;
                        }
                        elMemories.add(elSubMemory);
                    }
                }
                return elMemories;
            }
        };
        xGlobalThread.pushEvalScope(xEvalScope);
        this.addThread(xGlobalThread);
        XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(xGlobalThread);
        this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
        return xFinalActionBlocks;
    }

    private void collectRuntimeElabInstances(final List<ELInstance> instances, final IELMemory elMemory, final ELManager elManager, final List<ElementPath> bboxPaths, final int runtimeElabMaxDepth, IProject project, XValueHolderFactory factory) {
        try {
            IRfSingleLangProject rfVlogProject;
            final IdentityHSet<IRfNamedElement> virtualInterfaces = new IdentityHSet<IRfNamedElement>(64);
            RfMixedLangProject rfMixedLangProject = this.xSim.getRfMixedLangProject();
            if (rfMixedLangProject != null && (rfVlogProject = rfMixedLangProject.getSingleLangProject("ro.amiq.vlogdt.VlogNature")) != null) {
                rfVlogProject.xCollectVirtualInterfaces(virtualInterfaces);
            }
            final TreeMap runtimeElabPaths = new TreeMap();
            elMemory.visitBindings(new IELMemory.IELMemoryVisitor(){

                @Override
                public boolean visitBindings(ElementPath path, ELInstance instance) {
                    XUtils.incrementNofInstancesTotal();
                    if (path.length() > runtimeElabMaxDepth) {
                        return true;
                    }
                    IRfNamedElement binding = instance.getBinding(false);
                    if (binding instanceof IRfInterface && virtualInterfaces.contains(binding)) {
                        XUtils.addRuntimeElabPath(runtimeElabPaths, path, bboxPaths, "virtual_interface");
                        return true;
                    }
                    if (binding instanceof IRfInterface && runtimeElabPaths.containsKey(path.removeLastSegment())) {
                        runtimeElabPaths.put(path, "subinstance_interface");
                        return true;
                    }
                    List<IRfActionBlockElement> initialBlocks = binding.xGetExecBlocks(null, null, null, true);
                    if (initialBlocks != null && !initialBlocks.isEmpty()) {
                        boolean isIgnoreInitialBlock = true;
                        for (IRfActionBlockElement initialBlock : initialBlocks) {
                            if (XUtils.isIgnoreInitialBlock(initialBlock, elMemory, instance, runtimeElabPaths, bboxPaths)) continue;
                            isIgnoreInitialBlock = false;
                            break;
                        }
                        if (isIgnoreInitialBlock) {
                            return true;
                        }
                        XUtils.addRuntimeElabPath(runtimeElabPaths, path, bboxPaths, "initial_blocks_" + initialBlocks.size());
                    }
                    return true;
                }
            });
            final TreeSet bboxes = new TreeSet();
            elMemory.visitBindings(new IELMemory.IELMemoryVisitor(){

                @Override
                public boolean visitBindings(ElementPath path, ELInstance instance) {
                    if (path.length() > runtimeElabMaxDepth + 1) {
                        return true;
                    }
                    ElementPath parentPath = path.removeLastSegment();
                    if (bboxes.contains(parentPath)) {
                        bboxes.add(path);
                        return true;
                    }
                    if (!runtimeElabPaths.containsKey(path)) {
                        ELInstance bbox = ELInstance.of(BBOX_INSTANCE, path, elManager);
                        bbox.setBinding((IELDesign)BBOX_INSTANCE.getAssociatedBaseType());
                        instances.add(bbox);
                        bboxes.add(path);
                        return true;
                    }
                    instances.add(instance);
                    XUtils.incrementNofInstancesUsed();
                    return true;
                }
            });
            boolean isAddExtraDebugInfo = factory.isAddExtraDebugInfo();
            if (isAddExtraDebugInfo) {
                StringBuilder textToFile = new StringBuilder();
                for (ELInstance instance : instances) {
                    ElementPath elementPath;
                    IRfNamedElement binding = instance.getBinding(true);
                    if (binding == null || (elementPath = instance.getHierarchyPath()) == null) continue;
                    textToFile.append(elementPath.toString()).append(", ").append(binding.getName()).append(", ").append((String)runtimeElabPaths.get(elementPath)).append("\n");
                }
                IPath filePath = project.getLocation().append(DVT_DEBUG_UVMRE_LOG);
                DVTFileUtils.getInstance().writeStringToFile(filePath.toFile(), textToFile.toString(), false);
                factory.printExtraDebugMessage(true, "Write info to debug file '" + filePath.toOSString() + "' done", -1L);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<ELInstance> instancesSort(List<ELInstance> instances) {
        sortedInstances = new ArrayList<ELInstance>(instances.size());
        instancesStack = new Stack<ELInstance>();
        for (ELInstance instance : instances) {
            length = this.pathLength(instance);
            if (instancesStack.isEmpty()) {
                instancesStack.push(instance);
                continue;
            }
            if (this.pathLength((ELInstance)instancesStack.peek()) >= length) ** GOTO lbl13
            instancesStack.push(instance);
            continue;
lbl-1000:
            // 1 sources

            {
                sortedInstances.add((ELInstance)instancesStack.pop());
lbl13:
                // 2 sources

                ** while (!instancesStack.isEmpty() && this.pathLength((ELInstance)((ELInstance)instancesStack.peek())) >= length)
            }
lbl14:
            // 1 sources

            instancesStack.push(instance);
        }
        while (!instancesStack.isEmpty()) {
            sortedInstances.add((ELInstance)instancesStack.pop());
        }
        return sortedInstances;
    }

    private void collectInstances(final List<ELInstance> instances, IELMemory elMemory, final List<ElementPath> bboxPaths, final IHidEvaluationGuardian guardian) {
        try {
            elMemory.visitBindings(new IELMemory.IELMemoryVisitor(){

                @Override
                public boolean visitBindings(ElementPath elementPath, ELInstance instance) {
                    IRfNamedElement binding = instance.getBinding(false);
                    IRfInstanceElement description = instance.getDescription();
                    if (binding instanceof ErrorDesignElement) {
                        guardian.logError("Instance '" + elementPath + "' could not be resolved.", description.getDeclaration());
                    }
                    XUtils.incrementNofInstancesTotal();
                    if (bboxPaths != null && !bboxPaths.isEmpty()) {
                        for (ElementPath bboxPath : bboxPaths) {
                            if (!bboxPath.isPrefixOf(elementPath)) continue;
                            return true;
                        }
                    }
                    XUtils.incrementNofInstancesUsed();
                    instances.add(instance);
                    return true;
                }
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int pathLength(ELInstance instance) {
        if (instance == null || instance.getHierarchyPath() == null) {
            return 0;
        }
        return instance.getHierarchyPath().length();
    }

    @Override
    public void start() {
        try {
            try {
                this.prepareBeginSimulation();
                this.executeSimulation();
            }
            catch (BuildCancelException buildCancelException) {
                if (this.xSim != null && this.xSim.getRunBuildPhaseHandler() != null) {
                    XUVMElaborationStarters.getStarter(LanguageKind.VLOG).notifyContributorsErrorMode(this.xSim.getRunBuildPhaseHandler().getCurrJobUvmRESetup());
                }
                this.prepareEndSimulation();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                this.prepareEndSimulation();
            }
        }
        finally {
            this.prepareEndSimulation();
        }
    }

    protected XValueHolderFactory getFactory() {
        XValueHolderFactory factory = this.xSim.getFactory();
        if (factory == null) {
            throw new IllegalStateException("Unable to locate factory in sim environment");
        }
        return factory;
    }

    private void prepareBeginSimulation() {
        this.getFactory().prepareBeginSimulation();
    }

    private void prepareEndSimulation() {
        XValueHolderFactory factory = this.getFactory();
        factory.triggerVPICallbackEvents(12);
        factory.prepareEndSimulation();
        this.xSim.terminate();
    }

    @Override
    public IXThreadImpl getActiveThreadImpl() {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return null;
        }
        return activeThread.getXThreadDefinition().getXThreadImpl();
    }

    protected int getActiveThreadId() {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return -1;
        }
        return activeThread.getId();
    }

    public void executeRegion(XSimRegion.XRegionKind regionKind) {
        Set<IXSimEvent> events = this.regionEvents.get((Object)regionKind);
        if (events == null || events.isEmpty()) {
            return;
        }
        Iterator<IXSimEvent> iterator = events.iterator();
        while (iterator.hasNext()) {
            IXSimEvent evalEvent = iterator.next();
            evalEvent.execute();
            if (evalEvent.isPersistent()) continue;
            iterator.remove();
        }
    }

    public void addListener(IXThreadListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IXThreadListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean isTerminated() {
        return this.isTerminated;
    }

    @Override
    public void terminate() {
        try {
            for (XSimTimeSlot timeSlot : this.timeSlots) {
                timeSlot.clean();
            }
            this.currTimeSlot.clean();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate(boolean isDollarFinished, boolean isTimeout) {
        try {
            if (this.isTerminated) {
                return;
            }
            if (!isTimeout) {
                this.executeFinalBlocks();
            }
            this.isTerminated = true;
            Object object = this.threadsLock;
            synchronized (object) {
                Collection<XThread> threads = this.getThreads();
                ArrayList<XThread> threadsWorkingCopy = new ArrayList<XThread>(threads);
                for (XThread xThread : threadsWorkingCopy) {
                    if (xThread.isTerminated()) continue;
                    try {
                        xThread.localTerminate(false);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
            this.timeSlots.clear();
            this.currTimeSlot.clean();
            this.threads.clear();
            this.visitedChanges.clear();
            for (XSimTimeSlot xSimTimeSlot : this.timeSlots) {
                xSimTimeSlot.clean();
            }
            for (Set set : this.regionEvents.values()) {
                set.clear();
            }
            XValueHolderFactory xValueHolderFactory = this.xSim.getFactory();
            if (isTimeout) {
                xValueHolderFactory.logWarning("Simulation finished due to timeout");
            }
            xValueHolderFactory.setSimTerminated(true);
            this.printSimDuration();
        }
        catch (BuildCancelException buildCancelException) {}
    }

    private void executeFinalBlocks() {
        if (this.isTerminated) {
            return;
        }
        if (this.xSim.simulatorMode() == IXSim.XSimMode.UVM_RUNTIME_ELAB) {
            return;
        }
        if (this.xFinalActionBlocks == null || this.xFinalActionBlocks.isEmpty()) {
            return;
        }
        XActionBlock[] workingCopy = this.xFinalActionBlocks.toArray(new XActionBlock[this.xFinalActionBlocks.size()]);
        this.xFinalActionBlocks.clear();
        this.xFinalActionBlocks = null;
        XActionBlock[] xActionBlockArray = workingCopy;
        int n = workingCopy.length;
        int n2 = 0;
        while (n2 < n) {
            XActionBlock xFinalBlock = xActionBlockArray[n2];
            IRfDefElement declaration = xFinalBlock.actionBlock.getDeclaration();
            XThreadDefinition xThreadDefinition = this.xSim.createThreadDefinition(xFinalBlock.hidOperator, xFinalBlock.instanceValueHolder, declaration.getParserPath(), "final", XThreadDefinition.ThreadKind.FINAL);
            XThread xThread = new XThread(xThreadDefinition, this.threadCounter, -1, Collections.singleton("final"), this, xFinalBlock.instanceValueHolder);
            xThreadDefinition.setXThread(xThread, false);
            XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, xThreadDefinition.getHidEvaluator(), null, xThreadDefinition.getHidEvaluationGuardian(), xThreadDefinition.getFirstStatement(), xThreadDefinition.getFirstStatementParserPath(), null, false);
            xThread.pushEvalScope(xEvalScope);
            this.setActiveThread(xThread);
            xThread.run();
            ++n2;
        }
    }

    @Override
    public void yieldThread(boolean reExecuteStatement) {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return;
        }
        activeThread.doYield(reExecuteStatement);
    }

    @Override
    public void disableFork() {
        XThread xThread = this.getActiveThread();
        if (xThread == null) {
            return;
        }
        HashSet<Integer> ancestorsThreadIds = new HashSet<Integer>();
        ancestorsThreadIds.add(xThread.getId());
        ArrayList<XThread> xThreadsWorkingCopy = new ArrayList<XThread>(this.getThreads());
        block0: while (true) {
            Iterator iterator = xThreadsWorkingCopy.iterator();
            while (iterator.hasNext()) {
                XThread xThreadCandidate = (XThread)iterator.next();
                if (xThread == xThreadCandidate) continue;
                int spawnedById = xThreadCandidate.getSpawnedById();
                int nonTerminatedAncestorId = xThreadCandidate.getNonTerminatedAncestorId();
                if (!ancestorsThreadIds.contains(spawnedById) && !ancestorsThreadIds.contains(nonTerminatedAncestorId)) continue;
                xThreadCandidate.localTerminate(true);
                iterator.remove();
                int threadId = xThreadCandidate.getId();
                if (ancestorsThreadIds.contains(threadId)) continue;
                ancestorsThreadIds.add(threadId);
                continue block0;
            }
            break;
        }
    }

    @Override
    public void disable(IHid hid, IHidEvaluator evaluator) {
        XThread xThread = this.getActiveThread();
        if (xThread == null) {
            return;
        }
        String disableLabel = XUtils.getName(hid);
        for (XThread xThreadCandidate : this.getThreads()) {
            boolean hasLabel = xThreadCandidate.hasAncestorLabel(disableLabel);
            if (!hasLabel) continue;
            xThreadCandidate.setDisabled(disableLabel);
            if (xThreadCandidate == xThread) continue;
            XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(xThreadCandidate);
            this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
        }
    }

    @Override
    public void kill(int xThreadId) {
        XThread xThread = this.getThread(xThreadId);
        if (xThread == null || xThread.isInitialBlock() || xThread.isAlwaysBlock() || xThread.isFinalBlock()) {
            return;
        }
        LinkedHashSet<XThread> xKilledThreads = new LinkedHashSet<XThread>();
        HashSet<Integer> ancestorsThreadIds = new HashSet<Integer>();
        ancestorsThreadIds.add(xThread.getId());
        xKilledThreads.add(xThread);
        ArrayList<XThread> xThreadsWorkingCopy = new ArrayList<XThread>(this.getThreads());
        block0: while (true) {
            Iterator iterator = xThreadsWorkingCopy.iterator();
            while (iterator.hasNext()) {
                XThread xThreadCandidate = (XThread)iterator.next();
                if (xThread == xThreadCandidate) continue;
                int spawnedById = xThreadCandidate.getSpawnedById();
                int nonTerminatedAncestorId = xThreadCandidate.getNonTerminatedAncestorId();
                if ((!ancestorsThreadIds.contains(spawnedById) || this.getThread(spawnedById) == null) && (!ancestorsThreadIds.contains(nonTerminatedAncestorId) || this.getThread(nonTerminatedAncestorId) == null)) continue;
                xKilledThreads.add(xThreadCandidate);
                iterator.remove();
                int threadId = xThreadCandidate.getId();
                if (ancestorsThreadIds.contains(threadId)) continue;
                ancestorsThreadIds.add(threadId);
                continue block0;
            }
            break;
        }
        for (XThread xKilledThread : xKilledThreads) {
            xKilledThread.localTerminate(true);
        }
    }

    @Override
    public String getAllThreadStackTraceString() {
        StringBuilder result = new StringBuilder();
        for (XThread xThread : this.getThreads()) {
            result.append("Thread ").append(xThread.getId()).append(" Stack Trace:\n");
            String stackTraceString = xThread.getStackTraceString();
            if (stackTraceString == null) continue;
            result.append(stackTraceString);
        }
        return result.toString();
    }

    @Override
    public String getActiveThreadStackTraceString() {
        XThread xThread = this.getActiveThread();
        if (xThread != null) {
            return xThread.getStackTraceString();
        }
        ParserPath currentParserPath = this.xSim.getCurrentParserPath();
        int currentLineNumber = this.xSim.getCurrentLineNumber();
        String path = currentParserPath == null ? INIT_PARSER_PATH.toString() : currentParserPath.toString();
        return DVTStringUtil.appendString("    ", "[global init]", " at line ", currentLineNumber > -1 ? currentLineNumber : 0, " in ", path);
    }

    @Override
    public String getActiveThreadStackPeekString() {
        IXThreadImpl activeThreadImpl = this.getActiveThreadImpl();
        if (activeThreadImpl == null) {
            return null;
        }
        return activeThreadImpl.getStackPeekString();
    }

    @Override
    public void startEvalScope(XEvalScope xEvalScope) {
        if (xEvalScope == null) {
            return;
        }
        if (xEvalScope instanceof XMethodBlockEvalScope && ((XMethodBlockEvalScope)xEvalScope).getParserPath() == null) {
            return;
        }
        XThread activeThread = this.getActiveThread();
        if (activeThread != null) {
            activeThread.startEvalScope(xEvalScope);
        }
    }

    @Override
    public void endEvalScope(XEvalScope xEvalScope) {
        if (xEvalScope == null) {
            return;
        }
        if (xEvalScope instanceof XMethodBlockEvalScope && ((XMethodBlockEvalScope)xEvalScope).getParserPath() == null) {
            return;
        }
        XThread activeThread = this.getActiveThread();
        if (activeThread != null) {
            activeThread.endEvalScope(xEvalScope);
        }
    }

    @Override
    public XThread forkThread(IHidOperator parentOperator, String forkLabel, XThreadDefinition xThreadDefinition, boolean isAlwaysThread, boolean isStepInto, XInstValueHolder instanceScope) {
        XThread xActiveThread = this.getActiveThread();
        if (instanceScope == null && xActiveThread != null) {
            instanceScope = xActiveThread.getInstanceScope();
        }
        XThread xThread = new XThread(xThreadDefinition, this.threadCounter, xActiveThread == null ? -1 : xActiveThread.getId(), XUtils.getAncestorLabels(forkLabel, xActiveThread), this, instanceScope);
        xThreadDefinition.setXThread(xThread, isStepInto);
        XFrameBlockEvalScope xEvalScope = isAlwaysThread ? new XAlwaysBlockEvalScope(parentOperator, xThreadDefinition.getHidEvaluator(), null, xThreadDefinition.getHidEvaluationGuardian(), xThreadDefinition.getFirstStatement(), xThreadDefinition.getFirstStatementParserPath(), null, false) : new XFrameBlockEvalScope(parentOperator, xThreadDefinition.getHidEvaluator(), null, xThreadDefinition.getHidEvaluationGuardian(), xThreadDefinition.getFirstStatement(), xThreadDefinition.getFirstStatementParserPath(), null, false);
        xThread.pushEvalScope(xEvalScope);
        this.addThread(xThread);
        if (xActiveThread != null) {
            xActiveThread.addSpawnedThread(xThread);
        }
        boolean isPreponed = xThreadDefinition.getThreadKind() == XThreadDefinition.ThreadKind.PREPONED;
        XSimRegion.XRegionKind regionKind = isPreponed ? XSimRegion.XRegionKind.Preponed : XSimRegion.XRegionKind.Active;
        XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(xThread, isPreponed);
        this.currTimeSlot.addEvent(regionKind, evaluationEvent);
        return xThread;
    }

    @Override
    public XThread forkConcurrentAssertion(String forkLabel, XThreadDefinition xThreadDefinition, XValueHolder evaluator) {
        return this.startConcurrentAssertionCursor(forkLabel, xThreadDefinition, evaluator, null, AssertTM.AssertTMCursor.AssertTMCursorKind.NONE);
    }

    @Override
    public XThread startConcurrentAssertionCursor(String forkLabel, XThreadDefinition xThreadDefinition, XValueHolder evaluator, AssertTM.AssertTMCursor parentCursor, AssertTM.AssertTMCursor.AssertTMCursorKind kind) {
        AssertTM.AssertTMCursor cursor;
        IHidEvaluationGuardian guardian = xThreadDefinition.getHidEvaluationGuardian();
        if (!guardian.isInterpreter()) {
            guardian.logError("Unsuported concurrent assert evaluation. Expected runtime guardian");
            return null;
        }
        XThread xActiveThread = this.getActiveThread();
        XInstValueHolder instanceScope = evaluator.getInstanceScope() == null && xActiveThread != null ? xActiveThread.getInstanceScope() : evaluator.getInstanceScope();
        IHidObject statement = xThreadDefinition.getFirstStatement();
        if (!(statement instanceof HidEvalCenter.ConcurrentAssertStatement) || !((HidEvalCenter.ConcurrentAssertStatement)statement).isComputed()) {
            guardian.logError("Fail to start assertion '" + HidUtils.toNiceString(statement) + "' in scope '" + evaluator + "'");
            return null;
        }
        HidEvalCenter.ConcurrentAssertStatement concurrentAssertionStatement = (HidEvalCenter.ConcurrentAssertStatement)statement;
        AssertTM assertTM = concurrentAssertionStatement.getAssertTM();
        try {
            assertTM.evaluateDisableIffExpression(evaluator, guardian);
        }
        catch (XStopThreadException xStopThreadException) {
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
        XConcurrentAssertBlockEvalScope xEvalScope = new XConcurrentAssertBlockEvalScope(xThreadDefinition.getHidEvaluator(), null, guardian, concurrentAssertionStatement, xThreadDefinition.getFirstStatementParserPath(), false);
        XConcurrentAssertThread xThread = new XConcurrentAssertThread(xEvalScope, xThreadDefinition, this.threadCounter, xActiveThread == null ? -1 : xActiveThread.getId(), XUtils.getAncestorLabels(forkLabel, xActiveThread), this, instanceScope);
        xThreadDefinition.setXThread(xThread, false);
        xThread.pushEvalScope(xEvalScope);
        this.addThread(xThread);
        if (xActiveThread != null) {
            xActiveThread.addSpawnedThread(xThread);
        }
        if ((cursor = assertTM.spawnCursor(xThread, parentCursor, this.currentSimTime, kind)) == null) {
            return null;
        }
        xEvalScope.setCursor(cursor);
        XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(xThread);
        this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Observed, evaluationEvent);
        return xThread;
    }

    @Override
    public XThread nbaThread(XThreadDefinition xThreadDefinition) {
        XThread xActiveThread = this.getActiveThread();
        XThread xThread = new XThread(xThreadDefinition, -3, -3, null, this, xActiveThread.getInstanceScope());
        xThreadDefinition.setXThread(xThread, false);
        XSeqBlockEvalScope xEvalScope = new XSeqBlockEvalScope(null, xThreadDefinition.getHidEvaluator(), null, xThreadDefinition.getHidEvaluationGuardian(), xThreadDefinition.getFirstStatement());
        xThread.pushEvalScope(xEvalScope);
        XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(xThread);
        this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
        return xThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addThread(XThread xThread) {
        Object object = this.threadsLock;
        synchronized (object) {
            this.threads.put(this.threadCounter, xThread);
            ++this.threadCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<XThread> getThreads() {
        Object object = this.threadsLock;
        synchronized (object) {
            return this.threads.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XThread getThread(int xThreadId) {
        Object object = this.threadsLock;
        synchronized (object) {
            return this.threads.get(xThreadId);
        }
    }

    @Override
    public void resumeThread(XThread xThread) {
        if (!xThread.isYielding()) {
            return;
        }
        XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(xThread);
        this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
    }

    @Override
    public void yieldWaitThread() {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return;
        }
        activeThread.doYield(true);
    }

    @Override
    public void yieldThread(BigDecimal delay) {
        XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return;
        }
        this.setActiveThread(null);
        XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(activeThread);
        if (delay == BigDecimal.ZERO) {
            this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Inactive, evaluationEvent);
        } else {
            XSimTimeSlot timeSlot = this.getTimeSlot(delay);
            timeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
        }
        activeThread.doYield(false);
    }

    @Override
    public void waitJoin(final Set<XThread> threads, final boolean all) {
        final XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return;
        }
        IXThreadListener forkListener = new IXThreadListener(){

            @Override
            public void isTerminated(XThread xThread) {
                int size = threads.size();
                threads.remove(xThread);
                if (all && !threads.isEmpty()) {
                    return;
                }
                if (!all && size == threads.size()) {
                    return;
                }
                XSimEventScheduler.this.removeListener(this);
                XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(activeThread);
                XSimEventScheduler.this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
            }
        };
        this.addListener(forkListener);
        activeThread.doYield(false);
    }

    @Override
    public void waitFork() {
        final XThread activeThread = this.getActiveThread();
        if (activeThread == null) {
            return;
        }
        final IdentityHSet allSpawnedThreads = new IdentityHSet(16);
        for (XThread xThread : this.getThreads()) {
            if (activeThread == xThread || activeThread.getId() != xThread.getSpawnedById()) continue;
            allSpawnedThreads.add(xThread);
        }
        if (allSpawnedThreads.isEmpty()) {
            return;
        }
        IXThreadListener forkListener = new IXThreadListener(){

            @Override
            public void isTerminated(XThread xThread) {
                allSpawnedThreads.remove(xThread);
                if (!allSpawnedThreads.isEmpty()) {
                    return;
                }
                XSimEventScheduler.this.removeListener(this);
                XSimEvaluationEvent evaluationEvent = new XSimEvaluationEvent(activeThread);
                XSimEventScheduler.this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, evaluationEvent);
            }
        };
        this.addListener(forkListener);
        activeThread.doYield(false);
    }

    protected XSimTimeSlot getTimeSlot(BigDecimal delay) {
        BigDecimal absoluteDelay = delay.add(this.currentSimTime);
        int index = -1;
        int i = 0;
        while (i < this.timeSlots.size()) {
            XSimTimeSlot timeSlot = this.timeSlots.get(i);
            int compareTo = timeSlot.getTime().compareTo(absoluteDelay);
            if (compareTo == 0) {
                return timeSlot;
            }
            if (compareTo > 0) {
                index = i;
                break;
            }
            ++i;
        }
        XSimTimeSlot timeSlot = new XSimTimeSlot(this, absoluteDelay);
        if (index < 0) {
            this.timeSlots.add(timeSlot);
        } else {
            this.timeSlots.add(index, timeSlot);
        }
        return timeSlot;
    }

    @Override
    public void processDelayedAssign(BigDecimal delay, XSimRegion.XRegionKind regionKind, IXSimEvent updateEvent) {
        XSimTimeSlot timeSlot = this.currTimeSlot;
        if (delay != null && delay.signum() > 0 || timeSlot.getTime().signum() < 0) {
            timeSlot = this.getTimeSlot(delay);
        }
        timeSlot.addEvent(regionKind, updateEvent);
    }

    @Override
    public void valueChanged(int uniqueId, IHidOperator parentOperator, IHidEvaluator evaluator, Hid hid, ListContainer<XComputedSelect> computedSelects, IELParamValue currValue) {
        try {
            if (this.isTerminated) {
                return;
            }
            ++this.valueChangeStackCount;
            if (uniqueId < 0) {
                return;
            }
            if (!(evaluator instanceof XValueHolder)) {
                return;
            }
            if (hid instanceof XInstValueHolder.XEvalOverrideHid) {
                evaluator = ((XInstValueHolder.XEvalOverrideHid)hid).getOverrideEvaluator();
            }
            boolean isForcedOperator = parentOperator.hasOccurrence(HidQualifierCache.IS_PROCESSED_PROCEDURAL_FORCE_ASSIGN_QUALIFIER);
            Change change = new Change(uniqueId, currValue);
            if (this.visitedChanges.contains(change) && !isForcedOperator) {
                return;
            }
            this.visitedChanges.add(change);
            this.updateEvents(uniqueId, currValue, parentOperator, (XValueHolder)evaluator, hid, computedSelects);
        }
        finally {
            --this.valueChangeStackCount;
            if (this.valueChangeStackCount == 0) {
                this.visitedChanges.clear();
            }
        }
    }

    @Override
    public void addEvent(XSimRegion.XRegionKind kind, IXSimEvent event) {
        this.currTimeSlot.addEvent(kind, event);
    }

    protected void updateEvents(int uniqueId, IELParamValue currValue, IHidOperator parentOperator, XValueHolder currEvaluator, Hid hid, ListContainer<XComputedSelect> computedSelects) {
        block9: {
            XValueHolderFactory factory = this.xSim.getFactory();
            IHidEvaluationGuardian guardian = this.xSim.getEvaluationGuardian(false);
            XValueHolderFactory.ForceValue forceValue = factory.removeForceValue(uniqueId);
            XValueHolderFactory.ForceValue proceduralValue = factory.removeProceduralValue(uniqueId);
            try {
                Collection<XInstValueHolder.XEvalOverrideHidOperator> operators = factory.getAssignOperators(uniqueId);
                if (forceValue == null && proceduralValue == null) {
                    if (this.isForceApplyLock) {
                        return;
                    }
                    this.scheduleAssignOperators(parentOperator, operators, currValue.isTristate(), guardian);
                    break block9;
                }
                try {
                    this.isForceApplyLock = true;
                    this.applyAssignOperators(operators, parentOperator, currEvaluator, true, guardian);
                    factory.applyForceOperators(forceValue, proceduralValue, currValue, guardian);
                }
                finally {
                    this.isForceApplyLock = false;
                }
                this.applyAssignOperators(operators, parentOperator, currEvaluator, false, guardian);
            }
            finally {
                factory.addForceValue(uniqueId, forceValue);
                factory.addProceduralValue(uniqueId, proceduralValue);
            }
        }
    }

    private void scheduleAssignOperators(IHidOperator parentOperator, Collection<XInstValueHolder.XEvalOverrideHidOperator> operators, boolean isTristate, IHidEvaluationGuardian guardian) {
        if (operators == null || operators.isEmpty()) {
            return;
        }
        boolean isDepositAssign = parentOperator.hasOccurrence(HidOperatorQualifier.IS_PROCEDURAL_DEPOSIT.value());
        for (XInstValueHolder.XEvalOverrideHidOperator operator : operators) {
            boolean isConstantAssign = operator.hasOccurrence(HidOperatorQualifier.IS_DRIVEN_BY_CONSTANT.value());
            if (isConstantAssign && isDepositAssign) continue;
            if (isTristate) {
                ELUtils.evaluate(operator, null, null, guardian.copy());
                continue;
            }
            this.addEvent(XSimRegion.XRegionKind.Active, new XSimUpdateEvent(operator, guardian));
        }
    }

    private void applyAssignOperators(Collection<XInstValueHolder.XEvalOverrideHidOperator> operators, IHidOperator parentOperator, XValueHolder currEvaluator, boolean constantAssigns, IHidEvaluationGuardian guardian) {
        if (operators == null || operators.isEmpty()) {
            return;
        }
        for (XInstValueHolder.XEvalOverrideHidOperator operator : operators) {
            IHidOperator overrideOperator = operator.getOverrideOperator();
            XValueHolder overrideEvaluator = operator.getOverrideEvaluator();
            if (overrideOperator == parentOperator && currEvaluator == overrideEvaluator) continue;
            boolean isConstantAssign = operator.hasOccurrence(HidOperatorQualifier.IS_DRIVEN_BY_CONSTANT.value());
            if (isConstantAssign && constantAssigns) {
                ELUtils.evaluate(overrideOperator, overrideEvaluator, null, guardian.copy());
                continue;
            }
            if (isConstantAssign || constantAssigns) continue;
            ELUtils.evaluate(overrideOperator, overrideEvaluator, null, guardian.copy());
        }
    }

    @Override
    public void resumeAwaitingThreads(int threadId) {
        if (this.currTimeSlot == null) {
            return;
        }
        XValueHolderFactory factory = this.xSim.getFactory();
        this.currTimeSlot.addEvent(XSimRegion.XRegionKind.Active, () -> factory.resumeAwaitingThreads(threadId));
    }

    @Override
    public void setActiveThread(XThread xThread) {
        if (xThread != null) {
            this.xSim.setCurrentParserPath(xThread.getParserPath());
        }
        this.xActiveThread = xThread;
    }

    @Override
    public XThread getActiveThread() {
        return this.xActiveThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTerminated(XThread xThread) {
        Object object = this.threadsLock;
        synchronized (object) {
            ArrayList<IXThreadListener> listenersWorkingCopy = new ArrayList<IXThreadListener>(this.listeners);
            for (IXThreadListener listener : listenersWorkingCopy) {
                listener.isTerminated(xThread);
            }
            this.threads.remove(xThread.getId());
            if (this.xActiveThread == xThread) {
                this.xActiveThread = null;
            }
        }
    }

    @Override
    public BigDecimal getCurrSimTime() {
        return this.currentSimTime;
    }

    @Override
    public ParserPath getCurrentParserPath() {
        ParserPath parserPath;
        if (this.xActiveThread != null && (parserPath = this.xActiveThread.getParserPath()) != INIT_PARSER_PATH) {
            return parserPath;
        }
        return this.xSim.getCurrentParserPath();
    }

    @Override
    public int getCurrentLineNumber() {
        return this.xSim.getCurrentLineNumber();
    }

    @Override
    public void setCurrentParserPath(ParserPath parserPath) {
        this.xSim.setCurrentParserPath(parserPath);
    }

    @Override
    public boolean isMonitorCanceled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }

    private static enum ActionKind {
        INITIAL,
        ALWAYS_COMB,
        ALWAYS,
        PROCESS,
        FINAL,
        ASSERT;

    }

    private static class Change {
        private int uniqueId;
        private DVTNumber currNumber;

        public Change(int uniqueId, IELParamValue currValue) {
            this.uniqueId = uniqueId;
            this.currNumber = currValue instanceof ELParamValues.ParamValueNumber ? currValue.getDVTNumber() : null;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.uniqueId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Change other = (Change)obj;
            if (this.uniqueId != other.uniqueId) {
                return false;
            }
            return !(this.currNumber == null ? other.currNumber != null : !this.currNumber.equals(other.currNumber));
        }
    }

    public static class XActionBlock {
        private ActionKind actionKind;
        private IRfActionBlockElement actionBlock;
        private XInstValueHolder instanceValueHolder;
        private IHidOperator hidOperator;

        public XActionBlock(ActionKind actionKind, IRfActionBlockElement actionBlock, XInstValueHolder instanceValueHolder, IHidOperator hidOperator) {
            this.actionKind = actionKind;
            this.actionBlock = actionBlock;
            this.instanceValueHolder = instanceValueHolder;
            this.hidOperator = hidOperator;
        }

        public IHidOperator getHidOperator() {
            return this.hidOperator;
        }

        public XInstValueHolder getInstanceValueHolder() {
            return this.instanceValueHolder;
        }

        public IRfActionBlockElement getActionBlock() {
            return this.actionBlock;
        }
    }
}

