/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.sim;

import java.util.Collection;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XSimEventScheduler;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownEvaluationException;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.fast.LinkedHSet;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XSimRegion {
    private XSimEventScheduler xEventScheduler;
    private XRegionKind kind;
    private LinkedHSet<IXSimEvent> events;

    public XSimRegion(XSimEventScheduler xEventScheduler, XRegionKind kind) {
        this.xEventScheduler = xEventScheduler;
        this.kind = kind;
        this.events = new LinkedHSet(16);
    }

    public void execute() {
        while (!this.events.isEmpty()) {
            IXSimEvent[] eventsTable = this.events.toArray(new IXSimEvent[this.events.size()]);
            this.events.clear();
            if (this.xEventScheduler.isTerminated()) {
                return;
            }
            IXSimEvent[] iXSimEventArray = eventsTable;
            int n = eventsTable.length;
            int n2 = 0;
            while (n2 < n) {
                IXSimEvent event = iXSimEventArray[n2];
                if (!this.events.contains(event)) {
                    this.execute(event);
                }
                ++n2;
            }
        }
    }

    private void execute(IXSimEvent event) {
        try {
            if (event == null) {
                return;
            }
            event.execute();
        }
        catch (UnknownHidObjectEvaluationException e) {
            XValueHolderFactory factory = this.xEventScheduler.getFactory();
            factory.logError("UnknownEvaluation: " + DVTStringUtil.truncateLongText(e.getCauseObject(), 200, 300));
        }
        catch (UnknownEvaluationException e) {
            XValueHolderFactory factory = this.xEventScheduler.getFactory();
            factory.logError("UnknownEvaluation: " + e.getMessage());
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public XRegionKind getKind() {
        return this.kind;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public Collection<IXSimEvent> getEvents() {
        return this.events;
    }

    public void addEvent(IXSimEvent event) {
        this.events.removeAdd(event);
    }

    public void swapEvents(XSimRegion region) {
        assert (this.events.isEmpty());
        LinkedHSet<IXSimEvent> tempEvents = this.events;
        this.events = region.events;
        region.events = tempEvents;
    }

    public static enum XRegionKind {
        Preponed,
        PreActive,
        Active,
        Inactive,
        PreNBA,
        NBA,
        PostNBA,
        Observed,
        ReActive,
        ReNBA,
        PrePostponed,
        Postponed;

    }
}

