/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.sim;

import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.sim.IXSimEvent;
import ro.amiq.dvt.interpreter.sim.XSimEventScheduler;
import ro.amiq.dvt.interpreter.sim.XSimRegion;

public class XSimTimeSlot {
    private XSimEventScheduler xEventScheduler;
    private BigDecimal time;
    private EnumMap<XSimRegion.XRegionKind, XSimRegion> activeRegions;
    private EnumMap<XSimRegion.XRegionKind, XSimRegion> reActiveRegions;

    public XSimTimeSlot(XSimEventScheduler xEventScheduler, BigDecimal time) {
        this.xEventScheduler = xEventScheduler;
        this.time = time;
        this.activeRegions = new EnumMap(XSimRegion.XRegionKind.class);
        this.activeRegions.put(XSimRegion.XRegionKind.Active, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.Active));
        this.activeRegions.put(XSimRegion.XRegionKind.Inactive, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.Inactive));
        this.activeRegions.put(XSimRegion.XRegionKind.PreNBA, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.PreNBA));
        this.activeRegions.put(XSimRegion.XRegionKind.NBA, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.NBA));
        this.activeRegions.put(XSimRegion.XRegionKind.PostNBA, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.PostNBA));
        this.activeRegions.put(XSimRegion.XRegionKind.Observed, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.Observed));
        this.reActiveRegions = new EnumMap(XSimRegion.XRegionKind.class);
        this.reActiveRegions.put(XSimRegion.XRegionKind.ReActive, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.ReActive));
        this.reActiveRegions.put(XSimRegion.XRegionKind.ReNBA, new XSimRegion(xEventScheduler, XSimRegion.XRegionKind.ReNBA));
    }

    public BigDecimal getTime() {
        return this.time;
    }

    public void execute(XValueHolderFactory factory) {
        this.xEventScheduler.executeRegion(XSimRegion.XRegionKind.Preponed);
        do {
            if (this.xEventScheduler.isTerminated()) {
                return;
            }
            this.executeRegions(XSimRegion.XRegionKind.Active, this.activeRegions, factory);
            this.executeRegions(XSimRegion.XRegionKind.ReActive, this.reActiveRegions, factory);
            if (this.isEmpty(this.activeRegions)) continue;
            this.xEventScheduler.executeRegion(XSimRegion.XRegionKind.PrePostponed);
        } while (!this.isEmpty(this.activeRegions));
        this.xEventScheduler.executeRegion(XSimRegion.XRegionKind.Postponed);
    }

    private void executeRegions(XSimRegion.XRegionKind kind, EnumMap<XSimRegion.XRegionKind, XSimRegion> activeRegions, XValueHolderFactory factory) {
        XSimRegion activeRegion = activeRegions.get((Object)kind);
        block5: do {
            if (this.xEventScheduler.isTerminated() || activeRegion == null) {
                return;
            }
            activeRegion.execute();
            for (Map.Entry<XSimRegion.XRegionKind, XSimRegion> regionEntry : activeRegions.entrySet()) {
                XSimRegion.XRegionKind regionKind = regionEntry.getKey();
                try {
                    XSimRegion currentRegion;
                    if (regionKind == kind || (currentRegion = regionEntry.getValue()).isEmpty()) continue;
                    activeRegion.swapEvents(currentRegion);
                    continue block5;
                }
                finally {
                    if (regionKind == XSimRegion.XRegionKind.Observed) {
                        factory.incDeltaCycleCount();
                    }
                }
            }
        } while (!activeRegion.isEmpty());
    }

    private boolean isEmpty(EnumMap<XSimRegion.XRegionKind, XSimRegion> regions) {
        for (XSimRegion region : regions.values()) {
            if (region.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void addEvent(XSimRegion.XRegionKind kind, IXSimEvent event) {
        EnumMap<XSimRegion.XRegionKind, Set<IXSimEvent>> regionEvents = this.xEventScheduler.regionEvents;
        if (regionEvents.containsKey((Object)kind)) {
            regionEvents.get((Object)kind).add(event);
            return;
        }
        XSimRegion region = this.activeRegions.get((Object)kind);
        if (region == null) {
            region = this.reActiveRegions.get((Object)kind);
        }
        if (region == null) {
            return;
        }
        region.addEvent(event);
    }

    public void clean() {
        this.activeRegions.clear();
        this.reActiveRegions.clear();
    }
}

