/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter.systemc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.atomic.AtomicBoolean;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XDVTCServerUtils {
    public static final String VALGRIND_LOG_FILE = "valgrind.log";
    public static final String DPIC_SERVER_VALGRIND_ENV_VAR = "DPIC_SERVER_VALGRIND";
    protected static final String DVT_NATIVE_BRIDGE_SO = "dvt_native_bridge.so";
    protected static final String DVT_BRIDGE_LIB_SO = "dvt_user_lib.so";
    protected static final String DVT_SERVER = "dvt_native_bridge";
    public static final String MAKE = "make -f";
    private static final String STARTING_SERVER = "Starting server!";

    public static boolean isDPICValgrind() {
        return Boolean.parseBoolean(System.getenv(DPIC_SERVER_VALGRIND_ENV_VAR));
    }

    public static void inheritIOs(Process process, IXSim xSim, AtomicBoolean waitAtomic) {
        new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var4_5 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String message = "";
                    while ((message = reader.readLine()) != null) {
                        if (message.contains(STARTING_SERVER)) {
                            waitAtomic.set(true);
                        }
                        if (TestHelper.isTestMode() && message.contains(STARTING_SERVER)) continue;
                        xSim.logMessage(String.valueOf(message) + System.lineSeparator());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }).start();
        new Thread(() -> {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                    String message = "";
                    while ((message = reader.readLine()) != null) {
                        if ((message = message.trim()).contains("\\n")) {
                            message = DVTStringUtil.join(DVTStringUtil.split("\\n", message), System.lineSeparator());
                        }
                        xSim.logNativeError(message);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }).start();
    }
}

