/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsColorManager;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.launch.DVTAbstractLaunchConfigurationDelegateCommon;
import ro.amiq.dvt.ui.actions.ProjectSelectionDialog;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public abstract class DVTAbstractLaunchConfigurationDelegate
extends DVTAbstractLaunchConfigurationDelegateCommon {
    private static final String DVT_PVLOG_G_PATH = "DVT_PVERILOG_G_FILE";
    private static final String DVT_PVLOG_P_PATH = "DVT_PVERILOG_P_FILE";
    public static final String KEY_EXIT_VALUE = "ro.amiq.dvt.launch.DVTLaunchConfigurationDelegate.ExitValue";
    protected static final String NO_PROJECT_IN_WORKSPACE = "No project in the current workspace";
    protected static final String EMPTY_STRING = "";
    protected String fProjectName;
    protected IProject project;
    protected static final int PROCESS_EXECUTE = 0;
    protected static final int PROCESS_SKIP = 1;
    protected static final int PROCESS_CANCEL = 2;

    protected boolean associateIProject(ILaunchConfiguration config) throws CoreException {
        IProject lastSelectedProject;
        this.fProjectName = config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", EMPTY_STRING);
        if ((this.fProjectName == null || this.fProjectName.trim().length() == 0) && (lastSelectedProject = DVTPlugin.getSelectionManager().getLastSelectedProject()) != null) {
            this.fProjectName = lastSelectedProject.getName();
        }
        if (this.fProjectName == null || this.fProjectName.trim().length() == 0) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                IProject selectedProject = ProjectSelectionDialog.selectProject();
                if (selectedProject == null) {
                    return;
                }
                this.fProjectName = selectedProject.getName();
            });
        }
        if (this.fProjectName != null && this.fProjectName.trim().length() != 0) {
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjectName.trim());
        }
        if (this.project == null || !this.project.exists()) {
            this.fProjectName = "DVT-Settings";
            this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjectName.trim());
        }
        if (this.project == null || !this.project.exists()) {
            String errorMessage = this.fProjectName == null || this.fProjectName.trim().length() == 0 ? NO_PROJECT_IN_WORKSPACE : " Project '" + this.fProjectName + "' does not exist.";
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                CoreException e = new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, errorMessage, null));
                DVTExceptionHandler.handle(e, EMPTY_STRING, "DVT Launch Error");
            });
            return false;
        }
        return true;
    }

    protected void setProjectNameAndLocation(ILaunchConfiguration config, boolean setProjectVariables) {
        ExternalToolsUtil.setVariables(this.project, config, setProjectVariables);
        ExternalToolsColorManager.getInstance().init(this.project);
    }

    protected IPath computeWorkingDirectoryPath(ExternalToolsConfiguration configuration) throws CoreException {
        IPath workingDirectoryPath = ExternalToolsUtil.getWorkingDirectory(configuration);
        if (workingDirectoryPath == null) {
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, "Working directory '" + configuration.getWorkingDir() + "' does not exist.", null));
        }
        return workingDirectoryPath;
    }

    protected List<String> computeEnvProcessVariables(ILaunchConfiguration config, String mode, IPath workingDirectoryPath) throws CoreException {
        List<String> envpForProcess = ExternalToolsUtil.getEnvironment(this.project, config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null), config.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true));
        ExternalToolsUtil.addCustomEnv(envpForProcess, this.project);
        if ("debug".equals(mode)) {
            envpForProcess.add("DVT_LAUNCH_MODE=generic_debug");
            envpForProcess.add("DVT_DEBUGGER_WORKING_DIRECTORY=" + workingDirectoryPath.toOSString());
        }
        return envpForProcess;
    }

    protected void checkPreProcessBuildRequests(ILaunchConfiguration config) throws CoreException {
        boolean externalBuildBeforeLaunch;
        boolean internalBuildBeforeLaunch = config.getAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_BEFORE_RUN", false);
        if (internalBuildBeforeLaunch) {
            DVTBuildUtils.runInternalBuilder(this.project, true);
        }
        if (externalBuildBeforeLaunch = config.getAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_BEFORE_RUN", false)) {
            DVTBuildUtils.externalBuildWithProgress(this.project, true);
        }
    }

    protected void checkPostProcessBuildRequests(ILaunchConfiguration config) throws CoreException {
        boolean externalBuildAfterLaunch;
        boolean internalBuildAfterLaunch = config.getAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_AFTER_RUN", false);
        if (internalBuildAfterLaunch) {
            DVTBuildUtils.runInternalBuilder(this.project, true);
        }
        if (externalBuildAfterLaunch = config.getAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_AFTER_RUN", false)) {
            DVTBuildUtils.externalBuildWithProgress(this.project, true);
        }
    }

    protected abstract int preProcessExecution(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4, IProject var5, ExternalToolsConfiguration var6) throws CoreException;

    protected abstract void postProcessExecution(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4, IProject var5, ExternalToolsConfiguration var6, int var7) throws CoreException;

    protected abstract IStatus performExecuteProcess(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4, boolean var5, ExternalToolsConfiguration var6, IPath var7, List<String> var8) throws CoreException;

    protected void performCancelProcess(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, ExternalToolsConfiguration configuration) throws CoreException {
        this.postProcessExecution(config, mode, launch, monitor, this.project, configuration, 2);
        throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, "Cancelled.", null));
    }

    protected void performSkipProcess(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, ExternalToolsConfiguration configuration) throws CoreException {
        this.postProcessExecution(config, mode, launch, monitor, this.project, configuration, 1);
        IDebugTarget debugTarget = launch.getDebugTarget();
        while (!(monitor.isCanceled() || debugTarget != null && debugTarget.isTerminated())) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected static void handleException(Exception ex) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            CoreException e = new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, ex.getMessage(), ex.getCause()));
            DVTExceptionHandler.handle(e, EMPTY_STRING, "DVT Launch Error");
        });
    }
}

