/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.TextConsole;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IAccumulatingValueReturningVariableResolver;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.launch.DVTAbstractLaunchConfigurationDelegate;
import ro.amiq.dvt.launch.ExternalToolsConfigurationBuilder;
import ro.amiq.dvt.launch.ui.DVTLaunchMainTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTLaunchConfigurationDelegate
extends DVTAbstractLaunchConfigurationDelegate {
    private boolean setProjectVariables;
    private final String REFRESH_RESOURCES_JOB_NAME = "Refresh resources";

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        block7: {
            block6: {
                boolean preCheck = super.preLaunchCheck(configuration, mode, monitor);
                if (!preCheck) {
                    return false;
                }
                if (DVTPlugin.getDefault().collect().c()) break block6;
                return false;
            }
            DVTLaunchMainTab.LaunchMode supportedLaunchMode = DVTLaunchMainTab.LaunchMode.getLaunchMode(configuration);
            if (supportedLaunchMode.fModes.contains(mode)) break block7;
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)"Unsupported Launch Mode", (String)("Unsupported launch mode: " + mode + "\nLaunch configuration '" + configuration.getName() + "' supports only " + DVTStringUtil.join(launchMode.fModes, ", ") + " mode.")));
            return false;
        }
        try {
            this.setProjectVariables = this.associateIProject(configuration);
            this.setProjectNameAndLocation(configuration, this.setProjectVariables);
        }
        catch (CoreException e) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTExceptionHandler.handle(e, configuration.getName(), " [DVT Generic] Command Process Error"));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public void launch(final ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            IStatus executeProcessStatement;
            ExternalToolsConfiguration configuration = new ExternalToolsConfigurationBuilder(config, this.project).withName(" [DVT Generic] Command Process").associateWorkingDirectory().associateFilterKinds().associateWSLink().associatePatterns().build();
            IPath workingDirectoryPath = this.computeWorkingDirectoryPath(configuration);
            List<String> envpForProcess = this.computeEnvProcessVariables(config, mode, workingDirectoryPath);
            this.checkPreProcessBuildRequests(config);
            int doProcess = this.preProcessExecution(config, mode, launch, monitor, this.project, configuration);
            if (doProcess == 2) {
                this.performCancelProcess(config, mode, launch, monitor, configuration);
            }
            if (doProcess == 1) {
                this.performSkipProcess(config, mode, launch, monitor, configuration);
            }
            if (doProcess == 0 && (executeProcessStatement = this.performExecuteProcess(config, mode, launch, monitor, this.setProjectVariables, configuration, workingDirectoryPath, envpForProcess)) == Status.CANCEL_STATUS) {
                return;
            }
            try {
                new Job("Refresh resources"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            IJobManager jobManager = Job.getJobManager();
                            while (jobManager.find(ResourcesPlugin.FAMILY_AUTO_BUILD).length > 0 || jobManager.find(ResourcesPlugin.FAMILY_MANUAL_BUILD).length > 0) {
                                Thread.sleep(50L);
                            }
                            RefreshUtil.refreshResources((ILaunchConfiguration)config, (IProgressMonitor)monitor);
                        }
                        catch (InterruptedException | CoreException e) {
                            DVTLogger.INSTANCE.logError(e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
                this.checkPostProcessBuildRequests(config);
            }
            catch (CoreException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTExceptionHandler.handle(e, config.getName(), " [DVT Generic] Command Process Error"));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        finally {
            launch.terminate();
            if (this.setProjectVariables) {
                ExternalToolsUtil.removeVariables();
            }
        }
    }

    @Override
    protected int preProcessExecution(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, IProject project, ExternalToolsConfiguration configuration) throws CoreException {
        return 0;
    }

    @Override
    protected void postProcessExecution(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, IProject project, ExternalToolsConfiguration configuration, int processState) throws CoreException {
    }

    @Override
    protected IStatus performExecuteProcess(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, boolean setProjectVariables, ExternalToolsConfiguration configuration, IPath workingDirectoryPath, List<String> envpForProcess) throws CoreException {
        String session;
        String genericCommand = config.getAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", "");
        String[] commandAsArguments = null;
        String scriptPath = null;
        if (genericCommand.contains("dvt_dialog_prompt:non-blocking:") && !CommonTab.isLaunchInBackground((ILaunchConfiguration)config)) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)DVTUiUtils.getActiveWorkbenchShell(), (String)"Invalid Run Configuration", (String)("Invalid Run Configuration: '" + config.getName() + "' uses ${dvt_dialog_prompt:non-blocking} and is configured to run in foreground.\n\n" + "Consider removing the 'non-blocking' option from the 'Main' tab or checking 'Launch in background' on the 'Common' tab.")));
            return Status.CANCEL_STATUS;
        }
        IAccumulatingValueReturningVariableResolver.AccumulatingValueReturningVariableResolverRepo.reset("ro.amiq.dvt.DVTCustomDialog.titleContribution");
        if ("script".equals(config.getAttribute("ro.amiq.dvt.launch.RUN_AS", "command"))) {
            String expandedCommand = DVTLaunchConfigurationDelegate.performStringSubstitution(genericCommand, false);
            if (expandedCommand == null) {
                return Status.CANCEL_STATUS;
            }
            scriptPath = ExternalToolsUtil.createScript(config.getName(), expandedCommand);
            if (scriptPath == null) {
                throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, "Could not create script from content (see the log for detailed errors)!", null));
            }
            commandAsArguments = ExternalToolsUtil.IS_WINDOWS ? (ExternalToolsUtil.DISTRO_BUSYBOX != null && expandedCommand.startsWith("#!/bin/sh") ? new String[]{ExternalToolsUtil.DISTRO_BUSYBOX, "sh", scriptPath} : new String[]{"cmd", "/c", scriptPath}) : new String[]{scriptPath};
        } else {
            commandAsArguments = DVTLaunchConfigurationDelegate.getCommandLine(genericCommand);
        }
        if (commandAsArguments == null || commandAsArguments.length == 0) {
            return Status.CANCEL_STATUS;
        }
        String[] executableCommandAsArguments = commandAsArguments;
        if (!ExternalToolsUtil.IS_WINDOWS && ("new".equals(session = config.getAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "same")) && ExternalToolsUtil.HAS_SESSION_SUPPORT || "xterm".equals(session) && ExternalToolsUtil.HAS_XTERM_SUPPORT)) {
            String runnerScript = ExternalToolsUtil.createRunnerScript();
            if (runnerScript == null) {
                DVTLogger.INSTANCE.logError("Error when trying to create runner script, launching without it!");
            } else {
                ArrayList<String> newArguments = new ArrayList<String>();
                newArguments.add(runnerScript);
                if (config.getAttribute("ro.amiq.dvt.launch.SESSION_TERMINATE_ON_EXIT", true)) {
                    newArguments.add("--terminate-on-exit");
                }
                if ("xterm".equals(session)) {
                    newArguments.add("--use-xterm-session");
                    if (config.getAttribute("ro.amiq.dvt.launch.XTERM_HOLD", false)) {
                        newArguments.add("--hold-xterm-window");
                    }
                    if (config.getAttribute("ro.amiq.dvt.launch.XTERM_REDIRECT", false) && ExternalToolsUtil.HAS_SESSION_SUPPORT) {
                        newArguments.add("--redirect-xterm-out");
                    }
                }
                executableCommandAsArguments = ExternalToolsUtil.prependArguments(commandAsArguments, newArguments);
            }
        }
        Process process = DebugPlugin.exec((String[])executableCommandAsArguments, (File)workingDirectoryPath.toFile(), (String[])envpForProcess.toArray(new String[envpForProcess.size()]));
        String projectLocation = setProjectVariables ? this.project.getLocation().toOSString() : "";
        String consoleTitle = IAccumulatingValueReturningVariableResolver.AccumulatingValueReturningVariableResolverRepo.get("ro.amiq.dvt.DVTCustomDialog.titleContribution");
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", ExternalToolsUtil.commandToString(commandAsArguments));
        attributes.put("ro.amiq.dvt.launch.WORKING_DIRECTORY", workingDirectoryPath.toOSString());
        attributes.put("ro.amiq.dvt.launch.PROJECT_LOCATION_ATTR", projectLocation);
        String originalConsoleTitle = "[" + this.fProjectName.trim() + "] " + "[" + config.getName() + "] ";
        attributes.put(IProcess.ATTR_PROCESS_LABEL, String.valueOf(originalConsoleTitle) + consoleTitle);
        IProcess runtimeProcess = DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)"Command Process", attributes);
        IConsole console = DVTJobsUtils.waitForConsole(runtimeProcess, monitor);
        if (console instanceof TextConsole) {
            ((TextConsole)console).setAttribute("ro.amiq.dvt.launch.ORIGINAL_CONSOLE_TITLE", (Object)originalConsoleTitle);
            TestHelper.setTextConsole((TextConsole)console);
        }
        ExternalToolsModelManager.getInstance().setProcessConsole(console, this.project, configuration, null, 1, this.getExpandedWorkingDirectory(configuration));
        if (config.getAttribute("ro.amiq.dvt.launchENABLE_AUTO_REMOVE_OLD_LAUNCHES", false)) {
            DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.auto_remove_old_launches", true);
        }
        this.postProcessExecution(config, mode, launch, monitor, this.project, configuration, 0);
        while (!runtimeProcess.isTerminated()) {
            try {
                if (monitor.isCanceled()) {
                    runtimeProcess.terminate();
                    break;
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.setProperty("ro.amiq.dvt.launch.DVTLaunchConfigurationDelegate.ExitValue", Integer.toString(process.exitValue()));
        if (scriptPath != null) {
            new File(scriptPath).delete();
        }
        return Status.OK_STATUS;
    }

    private String getExpandedWorkingDirectory(ExternalToolsConfiguration configuration) {
        String expandedWorkingDirectory = null;
        try {
            File path;
            expandedWorkingDirectory = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(configuration.getWorkingDir());
            if (expandedWorkingDirectory.length() > 0 && !(path = new File(expandedWorkingDirectory)).isDirectory()) {
                String msg = NLS.bind((String)ExternalToolsMessages.ExternalToolsUtil_invalidDirectory__0_, (Object[])new Object[]{expandedWorkingDirectory, configuration.getName()});
                ExternalToolsUtil.abort(msg, null, 0);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return expandedWorkingDirectory;
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if ("DVT_CHECKOUT_HOOK".equalsIgnoreCase(configuration.getName())) {
            return true;
        }
        return super.saveBeforeLaunch(configuration, mode, monitor);
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        if (!super.isLaunchProblem(problemMarker)) {
            return false;
        }
        return problemMarker.getType().startsWith("ro.amiq.") || problemMarker.getType().startsWith("org.eclipse.cdt");
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        if (this.project == null) {
            return null;
        }
        if (DVTNature.hasAnyDVTNatureEnabled(this.project)) {
            return new IProject[]{this.project};
        }
        return null;
    }
}

