/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IProcessFactory;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IFlushableStreamMonitor;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.IStreamsProxy2;
import org.eclipse.debug.core.model.RuntimeProcess;

public class DVTProcessFactory
implements IProcessFactory {
    public static final String ID = "ro.amiq.dvt.launch.DVTProcessFactory";

    public IProcess newProcess(ILaunch launch, Process process, String label, final Map attributes) {
        RuntimeProcess runtimeProcess = new RuntimeProcess(launch, process, label, attributes){
            private StreamsProxy fStreamsProxy;

            protected IStreamsProxy createStreamsProxy() {
                String encoding = this.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
                this.fStreamsProxy = new StreamsProxy(this.getSystemProcess(), encoding, attributes);
                return this.fStreamsProxy;
            }

            public void terminate() throws DebugException {
                if (!this.isTerminated()) {
                    this.fStreamsProxy.kill();
                    super.terminate();
                }
            }

            protected void terminated() {
                this.fStreamsProxy.close();
                super.terminated();
            }
        };
        return runtimeProcess;
    }

    public static class InputStreamMonitor {
        private OutputStream fStream;
        private List<String> fQueue;
        private Thread fThread;
        private Object fLock;
        private boolean fClosed = false;
        private String fEncoding;

        public InputStreamMonitor(OutputStream stream) {
            this(stream, null);
        }

        public InputStreamMonitor(OutputStream stream, String encoding) {
            this.fStream = stream;
            this.fQueue = new ArrayList<String>();
            this.fLock = new Object();
            this.fEncoding = encoding;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(String text) {
            Object object = this.fLock;
            synchronized (object) {
                this.fQueue.add(text);
                this.fLock.notifyAll();
            }
        }

        public void startMonitoring() {
            if (this.fThread == null) {
                this.fThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.write();
                    }
                }, "Input Stream Monitor");
                this.fThread.setDaemon(true);
                this.fThread.start();
            }
        }

        public void close() {
            if (this.fThread != null) {
                Thread thread = this.fThread;
                this.fThread = null;
                thread.interrupt();
            }
        }

        protected void write() {
            while (this.fThread != null) {
                this.writeNext();
            }
            if (!this.fClosed) {
                try {
                    this.fStream.close();
                }
                catch (IOException e) {
                    DebugPlugin.log((Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void writeNext() {
            while (!this.fQueue.isEmpty() && !this.fClosed) {
                String text = this.fQueue.get(0);
                this.fQueue.remove(0);
                try {
                    if (this.fEncoding != null) {
                        this.fStream.write(text.getBytes(this.fEncoding));
                    } else {
                        this.fStream.write(text.getBytes());
                    }
                    this.fStream.flush();
                }
                catch (IOException e) {
                    DebugPlugin.log((Throwable)e);
                }
            }
            try {
                Object object = this.fLock;
                synchronized (object) {
                    if (this.fQueue.isEmpty()) {
                        this.fLock.wait();
                    }
                }
            }
            catch (InterruptedException interruptedException) {}
        }

        public void closeInputStream() throws IOException {
            if (this.fClosed) {
                throw new IOException();
            }
            this.fClosed = true;
            this.fStream.close();
        }
    }

    public static class OutputStreamMonitor
    implements IFlushableStreamMonitor {
        private InputStream fStream;
        private ListenerList fListeners = new ListenerList();
        private boolean fBuffered = true;
        private StringBuilder fContents;
        private Thread fThread;
        private static final int BUFFER_SIZE = 8192;
        private boolean fKilled = false;
        private long lastSleep;
        private String fEncoding;

        public OutputStreamMonitor(InputStream stream, String encoding, Map<?, ?> attributes) {
            this.fStream = new BufferedInputStream(stream, 8192);
            this.fEncoding = encoding;
            this.fContents = attributes == null ? new StringBuilder() : new StringBuilder("Executing command:\n    " + attributes.get("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR")).append("\n\nWorking directory:\n    " + attributes.get("ro.amiq.dvt.launch.WORKING_DIRECTORY")).append("\n\nProject directory:\n    " + attributes.get("ro.amiq.dvt.launch.PROJECT_LOCATION_ATTR")).append("\n\n");
        }

        public synchronized void addListener(IStreamListener listener) {
            this.fListeners.add((Object)listener);
        }

        protected void close() {
            if (this.fThread != null) {
                Thread thread = this.fThread;
                this.fThread = null;
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                this.fListeners = new ListenerList();
            }
        }

        private void fireStreamAppended(String text) {
            this.getNotifier().notifyAppend(text);
        }

        public synchronized String getContents() {
            return this.fContents.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void read() {
            long currentTime = this.lastSleep = System.currentTimeMillis();
            byte[] bytes = new byte[8192];
            int read = 0;
            while (read >= 0) {
                block14: {
                    try {
                        if (this.fKilled) break;
                        read = this.fStream.read(bytes);
                        if (read <= 0) break block14;
                        String text = this.fEncoding != null ? new String(bytes, 0, read, this.fEncoding) : new String(bytes, 0, read);
                        OutputStreamMonitor outputStreamMonitor = this;
                        synchronized (outputStreamMonitor) {
                            if (this.isBuffered()) {
                                this.fContents.append(text);
                            }
                            this.fireStreamAppended(text);
                        }
                    }
                    catch (IOException ioe) {
                        if (!this.fKilled) {
                            DebugPlugin.log((Throwable)ioe);
                        }
                        return;
                    }
                    catch (NullPointerException e) {
                        if (!this.fKilled && this.fThread != null) {
                            DebugPlugin.log((Throwable)e);
                        }
                        return;
                    }
                }
                if ((currentTime = System.currentTimeMillis()) - this.lastSleep <= 1000L) continue;
                this.lastSleep = currentTime;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.fStream.close();
            }
            catch (IOException e) {
                DebugPlugin.log((Throwable)e);
            }
        }

        protected void kill() {
            this.fKilled = true;
        }

        public synchronized void removeListener(IStreamListener listener) {
            this.fListeners.remove((Object)listener);
        }

        protected void startMonitoring() {
            if (this.fThread == null) {
                this.fThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        this.read();
                    }
                }, "Output Stream Monitor");
                this.fThread.setDaemon(true);
                this.fThread.setPriority(1);
                this.fThread.start();
            }
        }

        public synchronized void setBuffered(boolean buffer) {
            this.fBuffered = buffer;
        }

        public synchronized void flushContents() {
            this.fContents.setLength(0);
        }

        public synchronized boolean isBuffered() {
            return this.fBuffered;
        }

        private ContentNotifier getNotifier() {
            return new ContentNotifier();
        }

        class ContentNotifier
        implements ISafeRunnable {
            private IStreamListener fListener;
            private String fText;

            ContentNotifier() {
            }

            public void handleException(Throwable exception) {
                DebugPlugin.log((Throwable)exception);
            }

            public void run() throws Exception {
                this.fListener.streamAppended(this.fText, (IStreamMonitor)OutputStreamMonitor.this);
            }

            public void notifyAppend(String text) {
                if (text == null) {
                    return;
                }
                this.fText = text;
                Object[] copiedListeners = OutputStreamMonitor.this.fListeners.getListeners();
                int i = 0;
                while (i < copiedListeners.length) {
                    this.fListener = (IStreamListener)copiedListeners[i];
                    SafeRunner.run((ISafeRunnable)this);
                    ++i;
                }
                this.fListener = null;
                this.fText = null;
            }
        }
    }

    public static class StreamsProxy
    implements IStreamsProxy2 {
        private OutputStreamMonitor fOutputMonitor;
        private OutputStreamMonitor fErrorMonitor;
        private InputStreamMonitor fInputMonitor;
        private boolean fClosed;

        public StreamsProxy(Process process, String encoding, Map<?, ?> attributes) {
            if (process == null) {
                return;
            }
            this.fOutputMonitor = new OutputStreamMonitor(process.getInputStream(), encoding, attributes);
            this.fErrorMonitor = new OutputStreamMonitor(process.getErrorStream(), encoding, null);
            this.fInputMonitor = new InputStreamMonitor(process.getOutputStream(), encoding);
            this.fOutputMonitor.startMonitoring();
            this.fErrorMonitor.startMonitoring();
            this.fInputMonitor.startMonitoring();
        }

        public void close() {
            if (!this.isClosed(true)) {
                this.fOutputMonitor.close();
                this.fErrorMonitor.close();
                this.fInputMonitor.close();
            }
        }

        private synchronized boolean isClosed(boolean setClosed) {
            boolean closed = this.fClosed;
            if (setClosed) {
                this.fClosed = true;
            }
            return closed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kill() {
            StreamsProxy streamsProxy = this;
            synchronized (streamsProxy) {
                this.fClosed = true;
            }
            this.fOutputMonitor.kill();
            this.fErrorMonitor.kill();
            this.fInputMonitor.close();
        }

        public IStreamMonitor getErrorStreamMonitor() {
            return this.fErrorMonitor;
        }

        public IStreamMonitor getOutputStreamMonitor() {
            return this.fOutputMonitor;
        }

        public void write(String input) throws IOException {
            if (this.isClosed(false)) {
                throw new IOException();
            }
            this.fInputMonitor.write(input);
        }

        public void closeInputStream() throws IOException {
            if (this.isClosed(false)) {
                throw new IOException();
            }
            this.fInputMonitor.closeInputStream();
        }
    }
}

