/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.RunProjectContributorsProxy;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.launch.DVTAbstractLaunchConfigurationDelegate;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public class DVTSimLaunchConfigDelegate
extends DVTAbstractLaunchConfigurationDelegate {
    private static boolean isLaunchRunMode;
    private static final String DVT_SIM = "DVT Run All";

    public void launch(final ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
            return;
        }
        try {
            try {
                this.associateIProject(config);
                this.setProjectNameAndLocation(config, true);
                final boolean isDebugMode = "debug".equals(mode);
                DVTSimLaunchConfigDelegate.setLaunchRunMode(!isDebugMode);
                if (this.project == null) {
                    throw new IllegalStateException("Unable to identify project while starting launch configuration");
                }
                Job runSimJob = new Job(String.valueOf(isDebugMode ? "Debug " : "") + DVT_SIM){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            DVTSimLaunchConfigDelegate.runSim(config, isDebugMode, DVTSimLaunchConfigDelegate.this.project, monitor);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                runSimJob.schedule();
            }
            catch (CoreException e) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> DVTExceptionHandler.handle(e, config.getName(), " [DVT Run All] Command Process Error"));
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
            }
        }
        finally {
            DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
        }
    }

    public static void runSim(ILaunchConfiguration config, boolean isDebugMode, IProject project, IProgressMonitor monitor) throws Exception {
        String[] commandLine;
        boolean isRunMode;
        String arguments = config.getAttribute("ro.amiq.dvt.launch.ARGUMENTS_BUILD_PHASE_ATTR", "");
        boolean isArgumentsInCustomDialog = false;
        boolean bl = isRunMode = !isDebugMode;
        if (arguments != null && arguments.contains("${dvt_dialog_prompt")) {
            isArgumentsInCustomDialog = true;
            DVTXRunBuildPhaseUtils.getOrCreateFileCustomDialog("RunAllDefaultCustomDialog.swtxml");
        }
        if ((commandLine = DVTSimLaunchConfigDelegate.getCommandLineWithCancelStatus(arguments, true)) != null && commandLine.length == 1 && Integer.toString(8).equals(commandLine[0])) {
            return;
        }
        if (isArgumentsInCustomDialog) {
            isRunMode = commandLine != null && Arrays.asList(commandLine).contains("+dvt_sim_run_mode");
        }
        RunProjectContributorsProxy.INSTNACE.startXSim(project, commandLine, isRunMode);
    }

    @Override
    protected int preProcessExecution(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, IProject project, ExternalToolsConfiguration configuration) throws CoreException {
        return 0;
    }

    @Override
    protected void postProcessExecution(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, IProject project, ExternalToolsConfiguration configuration, int processState) throws CoreException {
    }

    @Override
    protected IStatus performExecuteProcess(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor, boolean setProjectVariables, ExternalToolsConfiguration configuration, IPath workingDirectoryPath, List<String> envpForProcess) throws CoreException {
        return Status.CANCEL_STATUS;
    }

    public static boolean isLaunchRunMode() {
        return isLaunchRunMode;
    }

    public static void setLaunchRunMode(boolean isLaunchRunMode) {
        DVTSimLaunchConfigDelegate.isLaunchRunMode = isLaunchRunMode;
    }
}

