/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch;

import java.io.IOException;
import java.io.StringReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.pattern.PatternReaderWriter;
import ro.amiq.dvt.utils.DVTStringUtil;

public class ExternalToolsConfigurationBuilder {
    private final ExternalToolsConfiguration configuration = new ExternalToolsConfiguration();
    private final ILaunchConfiguration config;
    private final IProject project;
    private static final String EMPTY_STRING = "";

    public ExternalToolsConfigurationBuilder(ILaunchConfiguration config, IProject project) {
        this.config = config;
        this.project = project;
    }

    public ExternalToolsConfigurationBuilder withName(String customName) {
        this.configuration.setName(String.valueOf(this.config.getName()) + customName);
        return this;
    }

    public ExternalToolsConfigurationBuilder associateWorkingDirectory() throws CoreException {
        String workingDirectoryName = this.config.getAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", EMPTY_STRING);
        if (EMPTY_STRING.equals(workingDirectoryName)) {
            workingDirectoryName = this.project.getLocation().toOSString();
        }
        this.configuration.setWorkingDir(workingDirectoryName);
        return this;
    }

    public ExternalToolsConfigurationBuilder associateFilterKinds() throws CoreException {
        String filterKinds = this.config.getAttribute("ro.amiq.dvt.launch.FILTERS_KIND", EMPTY_STRING);
        this.configuration.setFilterKinds(DVTStringUtil.split(",", filterKinds));
        return this;
    }

    public ExternalToolsConfigurationBuilder associateWSLink() throws CoreException {
        this.configuration.setWSLink(this.config.getAttribute("ro.amiq.dvt.launch.WORKING_SET_LINK_FILTER", true));
        return this;
    }

    public ExternalToolsConfigurationBuilder associatePatterns() throws CoreException, IOException {
        String patternsXML = this.config.getAttribute("ro.amiq.dvt.launch.LAUNCH_PATTERNS", EMPTY_STRING);
        if (patternsXML.length() != 0) {
            StringReader reader = new StringReader(patternsXML);
            ExternalToolsPattern[] patterns = new PatternReaderWriter().read(reader);
            reader.close();
            this.configuration.setPatterns(patterns);
        }
        return this;
    }

    public ExternalToolsConfiguration build() {
        return this.configuration;
    }
}

