/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.quickrun;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigUtils;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.StringMatcher;

public class QuickRunHandler
implements IHandler {
    public IPreferenceStore fPrefStore;

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (!DVTPlugin.getDefault().collect().c()) {
            return null;
        }
        this.fPrefStore = DVTPlugin.getDefault().getPreferenceStore();
        List<ILaunchConfiguration> runModeLaunchConfigurations = this.getLaunchConfigList(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS"));
        if (runModeLaunchConfigurations.isEmpty()) {
            new MessageDialog(DVTUiUtils.getActiveWorkbenchShell(), "No Run Configurations Available", MessageDialog.getDefaultImage(), "There are no Run Configurations defined. Go to Run > Run Configurations to define a new one.", 1, new String[]{IDialogConstants.OK_LABEL}, 0).open();
            return null;
        }
        QuickRunElementListSelectionDialog dialog = new QuickRunElementListSelectionDialog(runModeLaunchConfigurations);
        dialog.open();
        ILaunchConfiguration selectedILaunchConfiguration = (ILaunchConfiguration)dialog.getFirstResult();
        if (selectedILaunchConfiguration == null) {
            return null;
        }
        String mode = "run";
        try {
            if (selectedILaunchConfiguration.getType().getIdentifier().equals("ro.amiq.dvt.linter.launch.SVLintLaunchConfiguration")) {
                mode = "ro.amiq.dvt.linter.launch.mode";
            }
        }
        catch (CoreException coreException) {}
        DebugUITools.launch((ILaunchConfiguration)selectedILaunchConfiguration, (String)mode);
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }

    public List<ILaunchConfiguration> getLaunchConfigList(boolean applyWorkingSet) throws ExecutionException {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations();
            IWorkingSet[] workingSets = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getWorkingSets();
            ArrayList<IAdaptable> elems = new ArrayList<IAdaptable>();
            IWorkingSet[] iWorkingSetArray = workingSets;
            int n = workingSets.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet iWorkingSet = iWorkingSetArray[n2];
                elems.addAll(Arrays.asList(iWorkingSet.getElements()));
                ++n2;
            }
            HashSet<String> wsProjectNames = new HashSet<String>();
            for (IAdaptable iAdaptable : elems) {
                String refString = iAdaptable.toString();
                String[] refStringParts = new String[]{};
                if (refString.contains(File.separator)) {
                    refStringParts = refString.split(Pattern.quote(File.separator));
                } else if (refString.contains("/")) {
                    refStringParts = refString.split("/");
                }
                if (refStringParts.length < 2) continue;
                String projectName = refStringParts[1];
                wsProjectNames.add(projectName);
            }
            ArrayList<ILaunchConfiguration> runModeLaunchConfigurations = new ArrayList<ILaunchConfiguration>();
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n3 = launchConfigurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject proj;
                ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n4];
                if ((launchConfiguration.supportsMode("run") || launchConfiguration.supportsMode("ro.amiq.dvt.linter.launch.mode")) && ((proj = DynamicLaunchConfigUtils.getProject(launchConfiguration)) == null || proj.isAccessible())) {
                    if (!wsProjectNames.isEmpty() && applyWorkingSet && proj != null) {
                        Map attr = launchConfiguration.getAttributes();
                        String projectName = (String)attr.get("ro.amiq.dvt.launch.PROJECT_ATTR");
                        if (wsProjectNames.contains(projectName)) {
                            runModeLaunchConfigurations.add(launchConfiguration);
                        }
                    } else {
                        runModeLaunchConfigurations.add(launchConfiguration);
                    }
                }
                ++n4;
            }
            return runModeLaunchConfigurations;
        }
        catch (CoreException e) {
            throw new ExecutionException("Failed to perform Quick Run:", (Throwable)e);
        }
    }

    private class QuickRunElementListSelectionDialog
    extends ElementListSelectionDialog {
        private Button fApplyWorkingSetFilter;

        public QuickRunElementListSelectionDialog(List<ILaunchConfiguration> launchConfigurations) {
            super(DVTUiUtils.getActiveWorkbenchShell(), (ILabelProvider)new QuickRunLabelProvider(launchConfigurations));
            this.setElements(launchConfigurations.toArray());
            this.setMultipleSelection(false);
            this.setTitle("DVT Quick Run");
            this.setImage(DVTImages.imageCache.getImage(DVTImages.QUICK_RUN));
            this.setMessage("Select a Run Configuration to launch");
            this.setHelpAvailable(false);
        }

        protected FilteredList createFilteredList(Composite parent) {
            FilteredList list = super.createFilteredList(parent);
            list.setFilterMatcher(new FilteredList.FilterMatcher(){
                private StringMatcher fMatcher;

                public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                    this.fMatcher = new StringMatcher(String.valueOf('*') + pattern + '*', ignoreCase, ignoreWildCards);
                }

                public boolean match(Object element) {
                    return this.fMatcher.match(QuickRunElementListSelectionDialog.this.fFilteredList.getLabelProvider().getText(element));
                }
            });
            return list;
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            this.fApplyWorkingSetFilter = new Button(area, 32);
            this.fApplyWorkingSetFilter.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fApplyWorkingSetFilter.setText("Show run configurations from working set");
            this.fApplyWorkingSetFilter.setSelection(DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS"));
            this.fApplyWorkingSetFilter.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        boolean applyWS = QuickRunElementListSelectionDialog.this.fApplyWorkingSetFilter.getSelection();
                        List<ILaunchConfiguration> configs = QuickRunHandler.this.getLaunchConfigList(applyWS);
                        QuickRunElementListSelectionDialog.this.setListElements(configs.toArray());
                        DebugUIPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS", applyWS);
                    }
                    catch (ExecutionException executionException) {
                        return;
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            return area;
        }
    }

    private static class QuickRunLabelProvider
    implements ILabelProvider {
        List<ILaunchConfiguration> fLaunchConfigurations;

        public QuickRunLabelProvider(List<ILaunchConfiguration> launchConfigurations) {
            this.fLaunchConfigurations = launchConfigurations;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return DVTImages.imageCache.getImage(DebugUITools.getDefaultImageDescriptor((Object)element));
        }

        public String getText(Object element) {
            if (!(element instanceof ILaunchConfiguration)) {
                return element.toString();
            }
            String result = ((ILaunchConfiguration)element).getName();
            if (this.hasDuplicates((ILaunchConfiguration)element) && ((ILaunchConfiguration)element).getFile() != null) {
                result = String.valueOf(result) + " [" + ((ILaunchConfiguration)element).getFile().getProject().getName() + "]";
            }
            return result;
        }

        private boolean hasDuplicates(ILaunchConfiguration launchConfiguration) {
            int count = 0;
            for (ILaunchConfiguration lc : this.fLaunchConfigurations) {
                if (!lc.getName().equals(launchConfiguration.getName())) continue;
                ++count;
            }
            return count > 1;
        }
    }
}

