/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.startup.core.DVTLogger;

public abstract class DVTBaseLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected static final String EMPTY_STRING = "";
    private ILaunchConfiguration fLaunchConfig;

    protected ILaunchConfiguration getCurrentLaunchConfiguration() {
        return this.fLaunchConfig;
    }

    protected void setCurrentLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfig = config;
    }

    protected void updateLaunchConfigurationDialog() {
        try {
            ILaunchConfigurationDialog launchConfigDialog = this.getLaunchConfigurationDialog();
            if (launchConfigDialog != null) {
                launchConfigDialog.updateButtons();
                launchConfigDialog.updateMessage();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected String getAttributeValueFrom(Text text) {
        if (text == null) {
            return null;
        }
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    protected String getAttributeValueFrom(StyledText styledText) {
        if (styledText == null) {
            return null;
        }
        String content = styledText.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    protected String getAttributeValueFrom(Combo combo) {
        if (combo == null) {
            return null;
        }
        String content = combo.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    protected boolean getAttributeValueFrom(Button button) {
        return button.getSelection();
    }

    public Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setVisible(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.heightHint = 4;
        separator.setLayoutData((Object)gd);
        return separator;
    }

    public static Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(JFaceResources.getString((String)key));
        GridData gd = new GridData(768);
        int widthHint = DVTBaseLaunchConfigurationTab.convertHorizontalDLUsToPixels((Control)button, 61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        gd.horizontalSpan = 1;
        button.setLayoutData((Object)gd);
        return button;
    }

    public static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }
}

