/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import ro.amiq.dvt.launch.ui.DVTBaseLaunchConfigurationTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class DVTBuildTab
extends DVTBaseLaunchConfigurationTab {
    private static final String NOTE_PROJECT_REFRESHED = "Note! When the launch command modifies resources please make sure the project is refreshed\nbefore build (see Refresh tab).";
    private Button fInternalBuildBeforeRun;
    private Button fInternalBuildAfterRun;
    private Button fExternalBuildBeforeRun;
    private Button fExternalBuildAfterRun;
    private Group fGroup;
    private Label fNote1Label;
    private Label fNote2Label;

    public void dispose() {
        if (this.fNote1Label != null) {
            this.fNote1Label.dispose();
        }
        if (this.fNote2Label != null) {
            this.fNote2Label.dispose();
        }
        if (this.fInternalBuildBeforeRun != null) {
            this.fInternalBuildBeforeRun.dispose();
        }
        if (this.fInternalBuildAfterRun != null) {
            this.fInternalBuildAfterRun.dispose();
        }
        if (this.fExternalBuildBeforeRun != null) {
            this.fExternalBuildBeforeRun.dispose();
        }
        if (this.fExternalBuildAfterRun != null) {
            this.fExternalBuildAfterRun.dispose();
        }
        if (this.fGroup != null) {
            this.fGroup.dispose();
        }
        super.dispose();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid((ILaunchConfiguration)configuration) && !configuration.isReadOnly()) {
            try {
                ILaunchConfiguration currentConfig = this.getCurrentLaunchConfiguration();
                if (this.fInternalBuildBeforeRun.getSelection() != currentConfig.getAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_BEFORE_RUN", false) || this.fInternalBuildAfterRun.getSelection() != currentConfig.getAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_AFTER_RUN", false) || this.fExternalBuildBeforeRun.getSelection() != currentConfig.getAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_BEFORE_RUN", false) || this.fExternalBuildAfterRun.getSelection() != currentConfig.getAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_AFTER_RUN", false)) {
                    configuration.setAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_BEFORE_RUN", this.fInternalBuildBeforeRun.getSelection());
                    configuration.setAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_AFTER_RUN", this.fInternalBuildAfterRun.getSelection());
                    configuration.setAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_BEFORE_RUN", this.fExternalBuildBeforeRun.getSelection());
                    configuration.setAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_AFTER_RUN", this.fExternalBuildAfterRun.getSelection());
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fInternalBuildBeforeRun.setEnabled(!configuration.isReadOnly());
            this.fInternalBuildAfterRun.setEnabled(!configuration.isReadOnly());
            this.fExternalBuildBeforeRun.setEnabled(!configuration.isReadOnly());
            this.fExternalBuildAfterRun.setEnabled(!configuration.isReadOnly());
            this.fInternalBuildBeforeRun.setSelection(configuration.getAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_BEFORE_RUN", false));
            this.fInternalBuildAfterRun.setSelection(configuration.getAttribute("ro.amiq.dvt.launch.INTERNAL_BUILD_AFTER_RUN", false));
            this.fExternalBuildBeforeRun.setSelection(configuration.getAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_BEFORE_RUN", false));
            this.fExternalBuildAfterRun.setSelection(configuration.getAttribute("ro.amiq.dvt.launch.EXTERNAL_BUILD_AFTER_RUN", false));
            if (configuration.getAttribute("ro.amiq.dvt.launch.BUILD_BEFORE_RUN", false)) {
                this.fInternalBuildBeforeRun.setSelection(true);
                this.fExternalBuildBeforeRun.setSelection(true);
            }
            if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                this.setAttribute("ro.amiq.dvt.launch.BUILD_BEFORE_RUN", (ILaunchConfigurationWorkingCopy)configuration, false, false);
            }
            if (configuration.getAttribute("ro.amiq.dvt.launch.BUILD_AFTER_RUN", false)) {
                this.fInternalBuildAfterRun.setSelection(true);
                this.fExternalBuildAfterRun.setSelection(true);
            }
            if (configuration instanceof ILaunchConfigurationWorkingCopy) {
                this.setAttribute("ro.amiq.dvt.launch.BUILD_AFTER_RUN", (ILaunchConfigurationWorkingCopy)configuration, false, false);
            }
            if (this.fInternalBuildAfterRun.getSelection() || this.fExternalBuildAfterRun.getSelection()) {
                this.fNote2Label.setText(NOTE_PROJECT_REFRESHED);
            } else {
                this.fNote2Label.setText("");
            }
            this.setCurrentLaunchConfiguration(configuration);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4));
        composite.setFont(parent.getFont());
        this.createMainCompositeContents(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    private void createMainCompositeContents(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gd);
        mainComposite.setFont(parent.getFont());
        this.fGroup = new Group(mainComposite, 0);
        this.fGroup.setFont(mainComposite.getFont());
        layout = new GridLayout();
        this.fGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.fGroup.setLayoutData((Object)gd);
        this.fGroup.setText("Project Build");
        this.fNote1Label = new Label((Composite)this.fGroup, 64);
        this.fNote1Label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fNote1Label.setVisible(true);
        this.fNote1Label.setFont(mainComposite.getFont());
        this.fNote1Label.setText("Perform a build of the specified project if any (see Main tab),\nor of the project enclosing the last selected resource.");
        this.fInternalBuildBeforeRun = new Button((Composite)this.fGroup, 32);
        this.fInternalBuildBeforeRun.setText("Run internal builder before the launch command");
        this.fInternalBuildBeforeRun.setSelection(false);
        this.fInternalBuildBeforeRun.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fInternalBuildBeforeRun.setFont(mainComposite.getFont());
        this.fInternalBuildBeforeRun.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTBuildTab.this.isValid(DVTBuildTab.this.getCurrentLaunchConfiguration());
                DVTBuildTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fExternalBuildBeforeRun = new Button((Composite)this.fGroup, 32);
        this.fExternalBuildBeforeRun.setText("Run external builder(s) before the launch command");
        this.fExternalBuildBeforeRun.setSelection(false);
        this.fExternalBuildBeforeRun.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fExternalBuildBeforeRun.setFont(mainComposite.getFont());
        this.fExternalBuildBeforeRun.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTBuildTab.this.isValid(DVTBuildTab.this.getCurrentLaunchConfiguration());
                DVTBuildTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fInternalBuildAfterRun = new Button((Composite)this.fGroup, 32);
        this.fInternalBuildAfterRun.setText("Run internal builder after the launch command");
        this.fInternalBuildAfterRun.setSelection(false);
        this.fInternalBuildAfterRun.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fInternalBuildAfterRun.setFont(mainComposite.getFont());
        this.fInternalBuildAfterRun.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!DVTBuildTab.this.fExternalBuildAfterRun.getSelection()) {
                    boolean selected;
                    boolean bl = selected = DVTBuildTab.this.fInternalBuildAfterRun.getSelection() && !DVTBuildTab.this.getCurrentLaunchConfiguration().isReadOnly();
                    if (selected) {
                        DVTBuildTab.this.fNote2Label.setText(DVTBuildTab.NOTE_PROJECT_REFRESHED);
                    } else {
                        DVTBuildTab.this.fNote2Label.setText("");
                    }
                }
                DVTBuildTab.this.isValid(DVTBuildTab.this.getCurrentLaunchConfiguration());
                DVTBuildTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fExternalBuildAfterRun = new Button((Composite)this.fGroup, 32);
        this.fExternalBuildAfterRun.setText("Run external builder(s) after the launch command");
        this.fExternalBuildAfterRun.setSelection(false);
        this.fExternalBuildAfterRun.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fExternalBuildAfterRun.setFont(mainComposite.getFont());
        this.fExternalBuildAfterRun.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!DVTBuildTab.this.fInternalBuildAfterRun.getSelection()) {
                    boolean selected;
                    boolean bl = selected = DVTBuildTab.this.fExternalBuildAfterRun.getSelection() && !DVTBuildTab.this.getCurrentLaunchConfiguration().isReadOnly();
                    if (selected) {
                        DVTBuildTab.this.fNote2Label.setText(DVTBuildTab.NOTE_PROJECT_REFRESHED);
                    } else {
                        DVTBuildTab.this.fNote2Label.setText("");
                    }
                }
                DVTBuildTab.this.isValid(DVTBuildTab.this.getCurrentLaunchConfiguration());
                DVTBuildTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fNote2Label = new Label((Composite)this.fGroup, 64);
        this.fNote2Label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.fNote2Label.setFont(mainComposite.getFont());
        this.fNote2Label.setVisible(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fInternalBuildBeforeRun != null && this.fInternalBuildAfterRun != null && this.fExternalBuildBeforeRun != null && this.fExternalBuildAfterRun != null) {
            this.fInternalBuildBeforeRun.setSelection(false);
            this.fInternalBuildAfterRun.setSelection(false);
            this.fExternalBuildBeforeRun.setSelection(false);
            this.fExternalBuildAfterRun.setSelection(false);
        }
    }

    public String getName() {
        return "Build";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.REBUILD_FULL);
    }
}

