/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.launch.DVTDebugConnectionPortValidator;
import ro.amiq.dvt.launch.DVTDebugConnectionTimeoutValidator;
import ro.amiq.dvt.launch.ui.DVTSyncBreakpointsPolicyGroup;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class DVTConnectionTab
extends AbstractLaunchConfigurationTab {
    private static final String DEFAULT_PORT = "3333";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_DELTA = "30";
    private static final String DEFAULT_TIMEOUT = "10000";
    private DVTDebugConnectionPortValidator fPortValidator;
    private DVTDebugConnectionTimeoutValidator fTimeoutValidator;
    private Text fHostText;
    private Text fPortText;
    private DVTSyncBreakpointsPolicyGroup fSyncBreakpointsPolicyGroup;
    private Text fTimeoutText;
    private Text fTimeoutDeltaSendText;
    private boolean fHasConnectionGroup;

    public DVTConnectionTab(boolean hasConnectionGroup) {
        this.fHasConnectionGroup = hasConnectionGroup;
        this.setDirty(false);
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.IMG_TAB_CONNECTION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        composite.setLayout((Layout)topLayout);
        composite.setFont(parent.getFont());
        if (this.fHasConnectionGroup) {
            this.createConnectionGroup(composite);
            new Label(composite, 0);
        }
        this.createTimingGroup(composite);
        new Label(composite, 0);
        this.fSyncBreakpointsPolicyGroup = new DVTSyncBreakpointsPolicyGroup(false);
        this.fSyncBreakpointsPolicyGroup.createGroup(composite, 1);
        this.fSyncBreakpointsPolicyGroup.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DVTConnectionTab.this.setDirty(true);
                DVTConnectionTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(composite, 0);
        this.setDirty(true);
    }

    private void createConnectionGroup(Composite composite) {
        this.fPortValidator = new DVTDebugConnectionPortValidator();
        Group group = new Group(composite, 0);
        group.setText("Connection: ");
        GridData connectionData = new GridData(4, 0x1000000, true, false, 2, 1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)connectionData);
        Label hostLabel = new Label((Composite)group, 0);
        hostLabel.setText("Host:");
        this.fHostText = new Text((Composite)group, this.getInputTextStyle());
        this.fHostText.setText(DEFAULT_HOST);
        this.fHostText.setLayoutData((Object)new GridData(768));
        this.fHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTConnectionTab.this.setDirty(true);
                DVTConnectionTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label portLabel = new Label((Composite)group, 64);
        portLabel.setText("Port:");
        this.fPortText = new Text((Composite)group, this.getInputTextStyle());
        this.fPortText.setLayoutData((Object)new GridData(768));
        this.fPortText.setTextLimit(7);
        this.fPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTConnectionTab.this.validateInput();
            }
        });
    }

    private void createTimingGroup(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Connection Parameters: ");
        GridData connectionData = new GridData(4, 0x1000000, true, false, 2, 1);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)connectionData);
        Label timeoutLabel = new Label((Composite)group, 0);
        timeoutLabel.setText("Message timeout [ms]:");
        this.fTimeoutValidator = new DVTDebugConnectionTimeoutValidator();
        this.fTimeoutText = new Text((Composite)group, this.getInputTextStyle());
        this.fTimeoutText.setText(DEFAULT_TIMEOUT);
        this.fTimeoutText.setLayoutData((Object)new GridData(768));
        this.fTimeoutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTConnectionTab.this.validateInput();
                DVTConnectionTab.this.setDirty(true);
                DVTConnectionTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label timeoutDeltaLabel = new Label((Composite)group, 0);
        timeoutDeltaLabel.setText("Delta between messages [ms]:");
        this.fTimeoutDeltaSendText = new Text((Composite)group, this.getInputTextStyle());
        this.fTimeoutDeltaSendText.setText(DEFAULT_DELTA);
        this.fTimeoutDeltaSendText.setLayoutData((Object)new GridData(768));
        this.fTimeoutDeltaSendText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTConnectionTab.this.validateInput();
                DVTConnectionTab.this.setDirty(true);
                DVTConnectionTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void validateInput() {
        String errorMessage = null;
        if (this.fPortValidator != null) {
            errorMessage = this.fPortValidator.isValid(this.fPortText.getText());
        }
        if (this.fTimeoutValidator != null) {
            errorMessage = this.fTimeoutValidator.isValid(this.fTimeoutText.getText());
        }
        this.setErrorMessage(errorMessage);
        this.setDirty(errorMessage != null);
        this.updateLaunchConfigurationDialog();
    }

    protected int getInputTextStyle() {
        return 2052;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (this.fHasConnectionGroup) {
                this.fHostText.setText(configuration.getAttribute("debug host", DEFAULT_HOST));
                this.fPortText.setText(configuration.getAttribute("debug port", DEFAULT_PORT));
            }
            this.fTimeoutText.setText(configuration.getAttribute("debug timeout", DEFAULT_TIMEOUT));
            this.fTimeoutDeltaSendText.setText(configuration.getAttribute("debug timeout delta", DEFAULT_DELTA));
            int syncBreakpointsPolicy = configuration.getAttribute("breakpoint use", 1);
            this.fSyncBreakpointsPolicyGroup.setSyncBreakpointsPolicy(syncBreakpointsPolicy);
            this.setErrorMessage(null);
            this.validateInput();
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fHasConnectionGroup) {
            configuration.setAttribute("debug host", this.fHostText.getText());
            configuration.setAttribute("debug port", this.fPortText.getText());
        }
        int syncBreakpointsPolicy = this.fSyncBreakpointsPolicyGroup.getSyncBreakpointsPolicy();
        configuration.setAttribute("breakpoint use", syncBreakpointsPolicy);
        this.setDirty(false);
        configuration.setAttribute("debug timeout", this.fTimeoutText.getText());
        configuration.setAttribute("debug timeout delta", this.fTimeoutDeltaSendText.getText());
    }

    public String getName() {
        return "Connection";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return !this.isDirty();
    }

    protected void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }
}

