/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.launch.IDVTLaunchConfigurationConstants;
import ro.amiq.dvt.launch.ui.DVTBaseLaunchConfigurationTab;
import ro.amiq.dvt.launch.ui.DVTLaunchMainTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;

public class DVTLaunchMain2Tab
extends DVTBaseLaunchConfigurationTab {
    private Text fProjectField;
    private Button fProjectButton;
    protected WidgetListener fListener = new WidgetListener();
    public static final String ATTR_MAPPED_RESOURCE_PATHS = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".MAPPED_RESOURCE_PATHS";
    public static final String ATTR_MAPPED_RESOURCE_TYPES = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".MAPPED_RESOURCE_TYPES";

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_LAUNCH_MAIN_TAB);
    }

    public void dispose() {
        if (this.fProjectField != null) {
            this.fProjectField.dispose();
        }
        if (this.fProjectButton != null) {
            this.fProjectButton.dispose();
        }
        this.fListener = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        this.createProjectComponent(composite);
        this.createVerticalSpacer(composite, 1);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createProjectComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = ExternalToolsMessages.ExternalToolsMainTab_Project;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fProjectField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fProjectField.setLayoutData((Object)data);
        this.fProjectField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fProjectField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fProjectButton = DVTLaunchMain2Tab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab__Browse_Workspace____3);
        this.fProjectButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fProjectButton, String.valueOf(group.getText()) + " " + this.fProjectButton.getText());
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public boolean isValid(ILaunchConfiguration config) {
        block7: {
            block5: {
                String projectName;
                block6: {
                    try {
                        this.setErrorMessage(null);
                        this.setMessage(null);
                        projectName = this.fProjectField.getText().trim();
                        if (projectName.length() == 0) break block5;
                        Path projectPath = new Path(null, projectName);
                        if (projectPath.isValidSegment(projectName)) break block6;
                        this.setErrorMessage("Project name '" + projectName + "' not valid.");
                        return false;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project == null || !project.exists()) {
                    this.setErrorMessage("Project '" + projectName + "' does not exist.");
                    return false;
                }
                break block7;
            }
            this.setErrorMessage("Project name not specified.");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", null);
        config.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", null);
        config.setAttribute("ro.amiq.dvt.launch.RUN_AS", "script");
        config.setAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_SCRIPT);
        if (!ExternalToolsUtil.IS_WINDOWS) {
            if (ExternalToolsUtil.HAS_SESSION_SUPPORT) {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "new");
                config.setAttribute("ro.amiq.dvt.launch.SESSION_TERMINATE_ON_EXIT", true);
            } else {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "same");
            }
        }
        config.setAttribute("process_factory_id", "ro.amiq.dvt.launch.DVTProcessFactory");
        DVTLaunchMainTab.LaunchMode.setLaunchMode(config, DVTLaunchMainTab.LaunchMode.DEBUG);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fProjectField.setText(config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", ""));
            this.setCurrentLaunchConfiguration(config);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", this.getAttributeValueFrom(this.fProjectField));
        config.setAttribute("process_factory_id", "ro.amiq.dvt.launch.DVTProcessFactory");
        String projectName = this.getAttributeValueFrom(this.fProjectField);
        IProject project = null;
        if (projectName != null && !projectName.isEmpty()) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        if (project != null && project.exists()) {
            config.setAttribute(ATTR_MAPPED_RESOURCE_PATHS, Arrays.asList(project.getName()));
            config.setAttribute(ATTR_MAPPED_RESOURCE_TYPES, Arrays.asList("4"));
        }
        DVTLaunchMainTab.LaunchMode.setLaunchMode(config, DVTLaunchMainTab.LaunchMode.DEBUG);
    }

    protected void handleProjectButtonSelected() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project");
        dialog.setMessage("Select the project");
        ArrayList<IProject> dvtProjects = Utils.getNatureMatchingProjects(new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.pssdt.pssnature", "ro.amiq.dvt.dvtnature"});
        if (dvtProjects == null) {
            dialog.setElements((Object[])new IProject[0]);
        } else {
            dialog.setElements(dvtProjects.toArray());
        }
        if (dialog.open() == 0) {
            this.fProjectField.setText(((IProject)dialog.getFirstResult()).getName());
        }
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.validateAndUpdate();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == DVTLaunchMain2Tab.this.fProjectButton) {
                DVTLaunchMain2Tab.this.handleProjectButtonSelected();
            }
        }

        private void validateAndUpdate() {
            DVTLaunchMain2Tab.this.isValid(DVTLaunchMain2Tab.this.getCurrentLaunchConfiguration());
            DVTLaunchMain2Tab.this.updateLaunchConfigurationDialog();
        }
    }
}

