/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.launch.IDVTLaunchConfigurationConstants;
import ro.amiq.dvt.launch.ui.DVTBaseLaunchConfigurationTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.StyledTextUndoRedo;
import ro.amiq.dvt.ui.Utils;

public class DVTLaunchMainTab
extends DVTBaseLaunchConfigurationTab {
    protected Text fProjectField;
    private Button fProjectButton;
    protected Text fWorkDirectoryField;
    private Button fWorkspaceWorkDirectoryButton;
    private Button fFileWorkDirectoryButton;
    private Button fVariablesWorkDirectoryButton;
    private Combo fRunAsCombo;
    protected StyledText fCommandText;
    private Button fLaunchInSameSessionRadio;
    private Button fLaunchInNewSessionRadio;
    private Button fLaunchInXtermSessionRadio;
    private Button fRedirectOutputToConsoleCheck;
    private Button fHoldXtermOpenCheck;
    private Button fTerminateOnExitCheck;
    protected Button fCommandVariablesButton;
    private Button fLaunchModeRunRadio;
    private Button fLaunchModeDebugRadio;
    private Button fLaunchModeBothRadio;
    protected WidgetListener fListener = new WidgetListener();
    public static final String ATTR_MAPPED_RESOURCE_PATHS = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".MAPPED_RESOURCE_PATHS";
    public static final String ATTR_MAPPED_RESOURCE_TYPES = String.valueOf(DebugPlugin.getUniqueIdentifier()) + ".MAPPED_RESOURCE_TYPES";

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_LAUNCH_MAIN_TAB);
    }

    public void dispose() {
        if (this.fProjectField != null) {
            this.fProjectField.dispose();
        }
        if (this.fProjectButton != null) {
            this.fProjectButton.dispose();
        }
        if (this.fWorkDirectoryField != null) {
            this.fWorkDirectoryField.dispose();
        }
        if (this.fWorkspaceWorkDirectoryButton != null) {
            this.fWorkspaceWorkDirectoryButton.dispose();
        }
        if (this.fFileWorkDirectoryButton != null) {
            this.fFileWorkDirectoryButton.dispose();
        }
        if (this.fVariablesWorkDirectoryButton != null) {
            this.fVariablesWorkDirectoryButton.dispose();
        }
        if (this.fRunAsCombo != null) {
            this.fRunAsCombo.dispose();
        }
        if (this.fCommandText != null) {
            this.fCommandText.dispose();
        }
        if (this.fLaunchInSameSessionRadio != null) {
            this.fLaunchInSameSessionRadio.dispose();
        }
        if (this.fLaunchInNewSessionRadio != null) {
            this.fLaunchInNewSessionRadio.dispose();
        }
        if (this.fLaunchInXtermSessionRadio != null) {
            this.fLaunchInXtermSessionRadio.dispose();
        }
        if (this.fRedirectOutputToConsoleCheck != null) {
            this.fRedirectOutputToConsoleCheck.dispose();
        }
        if (this.fHoldXtermOpenCheck != null) {
            this.fHoldXtermOpenCheck.dispose();
        }
        if (this.fTerminateOnExitCheck != null) {
            this.fTerminateOnExitCheck.dispose();
        }
        if (this.fCommandVariablesButton != null) {
            this.fCommandVariablesButton.dispose();
        }
        if (this.fLaunchModeRunRadio != null) {
            this.fLaunchModeRunRadio.dispose();
        }
        if (this.fLaunchModeDebugRadio != null) {
            this.fLaunchModeDebugRadio.dispose();
        }
        if (this.fLaunchModeBothRadio != null) {
            this.fLaunchModeBothRadio.dispose();
        }
        this.fListener = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        this.createProjectComponent(composite);
        this.createWorkDirectoryComponent(composite);
        this.createCommandComponent(composite);
        this.createLaunchModesComponent(composite);
        this.createVerticalSpacer(composite, 1);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected void createProjectComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = ExternalToolsMessages.ExternalToolsMainTab_Project;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fProjectField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fProjectField.setLayoutData((Object)data);
        this.fProjectField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fProjectField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fProjectButton = DVTLaunchMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab__Browse_Workspace____3);
        this.fProjectButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fProjectButton, String.valueOf(group.getText()) + " " + this.fProjectButton.getText());
    }

    protected void createWorkDirectoryComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = ExternalToolsMessages.ExternalToolsMainTab_Working__Directory__5;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fWorkDirectoryField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fWorkDirectoryField.setLayoutData((Object)data);
        this.fWorkDirectoryField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fWorkDirectoryField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fWorkspaceWorkDirectoryButton = DVTLaunchMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6);
        this.fWorkspaceWorkDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fWorkspaceWorkDirectoryButton, String.valueOf(group.getText()) + " " + this.fWorkspaceWorkDirectoryButton.getText());
        this.fFileWorkDirectoryButton = DVTLaunchMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7);
        this.fFileWorkDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fFileWorkDirectoryButton, String.valueOf(group.getText()) + " " + this.fFileWorkDirectoryButton.getText());
        this.fVariablesWorkDirectoryButton = DVTLaunchMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32);
        this.fVariablesWorkDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fVariablesWorkDirectoryButton, String.valueOf(group.getText()) + " " + this.fVariablesWorkDirectoryButton.getText());
    }

    protected void createLaunchModesComponent(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        group.setText(ExternalToolsMessages.ExternalToolsMainTab_Launch_Mode);
        this.fLaunchModeRunRadio = new Button((Composite)group, 16);
        this.fLaunchModeRunRadio.setText(LaunchMode.RUN.fDisplayName);
        this.fLaunchModeRunRadio.addSelectionListener((SelectionListener)this.fListener);
        this.fLaunchModeDebugRadio = new Button((Composite)group, 16);
        this.fLaunchModeDebugRadio.setText(LaunchMode.DEBUG.fDisplayName);
        this.fLaunchModeDebugRadio.addSelectionListener((SelectionListener)this.fListener);
        this.fLaunchModeBothRadio = new Button((Composite)group, 16);
        this.fLaunchModeBothRadio.setText(LaunchMode.BOTH.fDisplayName);
        this.fLaunchModeBothRadio.addSelectionListener((SelectionListener)this.fListener);
    }

    protected void createCommandComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Label runAsLabel = new Label((Composite)group, 0);
        runAsLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        runAsLabel.setText(ExternalToolsMessages.ExternalToolsMainTab_Run_As);
        this.fRunAsCombo = new Combo((Composite)group, 12);
        this.fRunAsCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fRunAsCombo.setItems(IDVTLaunchConfigurationConstants.VALUES_RUN_AS);
        this.fRunAsCombo.select(0);
        this.fRunAsCombo.addSelectionListener((SelectionListener)this.fListener);
        Composite buttonComposite = new Composite((Composite)group, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.fCommandVariablesButton = DVTLaunchMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_31);
        this.fCommandVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fCommandVariablesButton, String.valueOf(group.getText()) + " " + this.fCommandVariablesButton.getText());
        this.fCommandText = new StyledText((Composite)group, 2626);
        GridData gd = new GridData(4, 4, true, true, 6, 1);
        gd.heightHint = 150;
        gd.widthHint = 200;
        this.fCommandText.setLayoutData((Object)gd);
        this.addControlAccessibleListener((Control)this.fCommandText, group.getText());
        this.fCommandText.addModifyListener((ModifyListener)this.fListener);
        this.fCommandText.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fCommandText.addLineStyleListener((LineStyleListener)new StyledTextVariableStyleListener());
        StyledTextUndoRedo.install(this.fCommandText);
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.fCommandText, (IControlContentAdapter)new StyledTextContentAdapter(), (IContentProposalProvider)new VariableProposalProvider(), "org.eclipse.ui.edit.text.contentAssist.proposals", null, true);
        adapter.setPopupSize(new Point(300, 300));
        if (!ExternalToolsUtil.IS_WINDOWS) {
            GridData ld = null;
            this.fLaunchInSameSessionRadio = new Button((Composite)group, 16);
            this.fLaunchInSameSessionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.fLaunchInSameSessionRadio.setText(ExternalToolsMessages.ExternalToolsMainTab_Launch_In_Same_Session);
            this.fLaunchInSameSessionRadio.addSelectionListener((SelectionListener)this.fListener);
            this.fLaunchInSameSessionRadio.setEnabled(true);
            this.fLaunchInNewSessionRadio = new Button((Composite)group, 16);
            this.fLaunchInNewSessionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.fLaunchInNewSessionRadio.setText(ExternalToolsMessages.ExternalToolsMainTab_Launch_In_New_Session);
            this.fLaunchInNewSessionRadio.addSelectionListener((SelectionListener)this.fListener);
            this.fLaunchInNewSessionRadio.setEnabled(ExternalToolsUtil.HAS_SESSION_SUPPORT);
            this.fLaunchInXtermSessionRadio = new Button((Composite)group, 16);
            this.fLaunchInXtermSessionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.fLaunchInXtermSessionRadio.setText(ExternalToolsMessages.ExternalToolsMainTab_Launch_In_Xterm_Session);
            this.fLaunchInXtermSessionRadio.addSelectionListener((SelectionListener)this.fListener);
            this.fLaunchInXtermSessionRadio.setEnabled(ExternalToolsUtil.HAS_XTERM_SUPPORT);
            this.fRedirectOutputToConsoleCheck = new Button((Composite)group, 32);
            ld = new GridData(4, 0x1000000, true, false, 3, 1);
            ld.horizontalIndent = 20;
            this.fRedirectOutputToConsoleCheck.setLayoutData((Object)ld);
            this.fRedirectOutputToConsoleCheck.setText(ExternalToolsMessages.ExternalToolsMainTab_Redirect_Xterm_Output);
            this.fRedirectOutputToConsoleCheck.addSelectionListener((SelectionListener)this.fListener);
            this.fRedirectOutputToConsoleCheck.setEnabled(ExternalToolsUtil.HAS_XTERM_SUPPORT && ExternalToolsUtil.HAS_REDIRECT_SUPPORT);
            this.fHoldXtermOpenCheck = new Button((Composite)group, 32);
            ld = new GridData(4, 0x1000000, true, false, 3, 1);
            ld.horizontalIndent = 20;
            this.fHoldXtermOpenCheck.setLayoutData((Object)ld);
            this.fHoldXtermOpenCheck.setText(ExternalToolsMessages.ExternalToolsMainTab_Leave_Xterm_Window_Open);
            this.fHoldXtermOpenCheck.addSelectionListener((SelectionListener)this.fListener);
            this.fHoldXtermOpenCheck.setEnabled(ExternalToolsUtil.HAS_XTERM_SUPPORT);
            this.fTerminateOnExitCheck = new Button((Composite)group, 32);
            this.fTerminateOnExitCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
            this.fTerminateOnExitCheck.setText(ExternalToolsMessages.ExternalToolsMainTab_Terminate_On_Exit);
            this.fTerminateOnExitCheck.addSelectionListener((SelectionListener)this.fListener);
            this.fTerminateOnExitCheck.setEnabled(ExternalToolsUtil.HAS_SESSION_SUPPORT && ExternalToolsUtil.HAS_XTERM_SUPPORT);
        }
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    public boolean isValid(ILaunchConfiguration config) {
        String genericCommand;
        block8: {
            block6: {
                String projectName;
                block7: {
                    try {
                        this.setErrorMessage(null);
                        this.setMessage(null);
                        projectName = this.fProjectField.getText().trim();
                        if (projectName.length() == 0) break block6;
                        Path projectPath = new Path(null, projectName);
                        if (projectPath.isValidSegment(projectName)) break block7;
                        this.setErrorMessage("Project name '" + projectName + "' not valid.");
                        return false;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.exists()) break block6;
                this.setErrorMessage("Project '" + projectName + "' does not exist.");
                return false;
            }
            genericCommand = this.fCommandText.getText();
            if (genericCommand.length() != 0) break block8;
            this.setErrorMessage("Command not specified.");
            return false;
        }
        if (!ExternalToolsUtil.IS_WINDOWS && "script".equals(this.getAttributeValueFrom(this.fRunAsCombo)) && !genericCommand.startsWith("#!")) {
            this.setErrorMessage("Script must start with a hash exclam #!interpreter [optional-arg] (like #!/bin/bash -i)");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", null);
        config.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", null);
        config.setAttribute("ro.amiq.dvt.launch.RUN_AS", "script");
        config.setAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_SCRIPT);
        if (!ExternalToolsUtil.IS_WINDOWS) {
            if (ExternalToolsUtil.HAS_SESSION_SUPPORT) {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "new");
                config.setAttribute("ro.amiq.dvt.launch.SESSION_TERMINATE_ON_EXIT", true);
            } else {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "same");
            }
        }
        config.setAttribute("process_factory_id", "ro.amiq.dvt.launch.DVTProcessFactory");
        LaunchMode.setLaunchMode(config, LaunchMode.from(this.getLaunchConfigurationDialog().getMode()));
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fProjectField.setText(config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", ""));
            this.fWorkDirectoryField.setText(config.getAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", ""));
            String runAs = config.getAttribute("ro.amiq.dvt.launch.RUN_AS", "command");
            int index = 0;
            index = 0;
            while (index < IDVTLaunchConfigurationConstants.VALUES_RUN_AS.length) {
                if (IDVTLaunchConfigurationConstants.VALUES_RUN_AS[index].equals(runAs)) break;
                ++index;
            }
            index = index >= IDVTLaunchConfigurationConstants.VALUES_RUN_AS.length ? 0 : index;
            this.fRunAsCombo.select(index);
            this.fCommandText.setText(config.getAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", index == 0 ? IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_SCRIPT : IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_COMMAND));
            if (!ExternalToolsUtil.IS_WINDOWS) {
                this.fHoldXtermOpenCheck.setSelection(config.getAttribute("ro.amiq.dvt.launch.XTERM_HOLD", false));
                this.fRedirectOutputToConsoleCheck.setSelection(config.getAttribute("ro.amiq.dvt.launch.XTERM_REDIRECT", false));
                this.fTerminateOnExitCheck.setSelection(config.getAttribute("ro.amiq.dvt.launch.SESSION_TERMINATE_ON_EXIT", true));
                String session = config.getAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "same");
                if ("new".equals(session) && ExternalToolsUtil.HAS_SESSION_SUPPORT) {
                    this.selectSessionRadio(session);
                } else if ("xterm".equals(session) && ExternalToolsUtil.HAS_XTERM_SUPPORT) {
                    this.selectSessionRadio(session);
                } else {
                    this.selectSessionRadio("same");
                }
                this.handleSessionRadioSelected();
            }
            LaunchMode launchMode = LaunchMode.getLaunchMode(config);
            this.setLaunchMode(launchMode);
            this.setCurrentLaunchConfiguration(config);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void setLaunchMode(LaunchMode launchMode) {
        this.fLaunchModeRunRadio.setSelection(launchMode == LaunchMode.RUN);
        this.fLaunchModeDebugRadio.setSelection(launchMode == LaunchMode.DEBUG);
        this.fLaunchModeBothRadio.setSelection(launchMode == LaunchMode.BOTH);
    }

    private LaunchMode getLaunchMode() {
        if (this.fLaunchModeDebugRadio.getSelection()) {
            return LaunchMode.DEBUG;
        }
        if (this.fLaunchModeBothRadio.getSelection()) {
            return LaunchMode.BOTH;
        }
        if (this.fLaunchModeRunRadio.getSelection()) {
            return LaunchMode.RUN;
        }
        return LaunchMode.DEFAULT;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", this.getAttributeValueFrom(this.fProjectField));
        config.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", this.getAttributeValueFrom(this.fWorkDirectoryField));
        config.setAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR", this.getAttributeValueFrom(this.fCommandText));
        config.setAttribute("ro.amiq.dvt.launch.RUN_AS", this.getAttributeValueFrom(this.fRunAsCombo));
        if (!ExternalToolsUtil.IS_WINDOWS) {
            String session = this.getSelectedSession();
            config.setAttribute("ro.amiq.dvt.launch.SESSION_TERMINATE_ON_EXIT", this.getAttributeValueFrom(this.fTerminateOnExitCheck));
            config.setAttribute("ro.amiq.dvt.launch.XTERM_HOLD", this.getAttributeValueFrom(this.fHoldXtermOpenCheck));
            config.setAttribute("ro.amiq.dvt.launch.XTERM_REDIRECT", this.getAttributeValueFrom(this.fRedirectOutputToConsoleCheck));
            if ("new".equals(session) && ExternalToolsUtil.HAS_SESSION_SUPPORT) {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", session);
            } else if ("xterm".equals(session) && ExternalToolsUtil.HAS_XTERM_SUPPORT) {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", session);
            } else {
                config.setAttribute("ro.amiq.dvt.launch.LAUNCH_SESSION", "same");
            }
        }
        config.setAttribute("process_factory_id", "ro.amiq.dvt.launch.DVTProcessFactory");
        String projectName = this.getAttributeValueFrom(this.fProjectField);
        IProject project = null;
        try {
            if (projectName != null && !projectName.isEmpty()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (Exception exception) {}
        if (project != null && project.exists()) {
            config.setAttribute(ATTR_MAPPED_RESOURCE_PATHS, Arrays.asList(project.getName()));
            config.setAttribute(ATTR_MAPPED_RESOURCE_TYPES, Arrays.asList("4"));
        }
        LaunchMode.setLaunchMode(config, this.getLaunchMode());
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private void handleVariablesButtonSelected(StyledText styledTextField) {
        String variable = this.getVariable();
        if (variable != null) {
            styledTextField.insert(variable);
        }
    }

    protected String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    protected void handleProjectButtonSelected() {
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project");
        dialog.setMessage("Select the project");
        ArrayList<IProject> dvtProjects = Utils.getNatureMatchingProjects(new String[]{"ro.amiq.vhdldt.VhdlNature", "ro.amiq.vlogdt.VlogNature", "ro.amiq.edt.enature", "ro.amiq.slndt.slnnature", "ro.amiq.msdldt.msdlnature", "ro.amiq.dvt.dvtnature", "ro.amiq.pssdt.pssnature"});
        if (dvtProjects == null) {
            dialog.setElements((Object[])new IProject[0]);
        } else {
            dialog.setElements(dvtProjects.toArray());
        }
        if (dialog.open() == 0) {
            this.fProjectField.setText(((IProject)dialog.getFirstResult()).getName());
        }
    }

    protected void handleWorkspaceWorkingDirectoryButtonSelected() {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, ExternalToolsMessages.ExternalToolsMainTab_23);
        containerDialog.open();
        Object[] resource = containerDialog.getResult();
        String text = null;
        if (resource != null && resource.length > 0) {
            text = this.newVariableExpression("workspace_loc", ((IPath)resource[0]).toOSString());
        }
        if (text != null) {
            this.fWorkDirectoryField.setText(text);
        }
    }

    private void handleRunAsComboSelected() {
        if (this.fCommandText.getText().equals(IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_SCRIPT) || this.fCommandText.getText().equals(IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_COMMAND)) {
            if (this.fRunAsCombo.getSelectionIndex() == 0) {
                this.fCommandText.setText(IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_SCRIPT);
            } else {
                this.fCommandText.setText(IDVTLaunchConfigurationConstants.ATTR_DEFAULT_GENERIC_COMMAND_AS_COMMAND);
            }
        }
    }

    protected void handleFileWorkingDirectoryButtonSelected() {
        String text;
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        dialog.setMessage(ExternalToolsMessages.ExternalToolsMainTab_23);
        try {
            if (this.fWorkDirectoryField.getText().length() != 0) {
                dialog.setFilterPath(this.resolveValue(this.fWorkDirectoryField.getText()));
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if ((text = dialog.open()) != null) {
            this.fWorkDirectoryField.setText(text);
        }
    }

    protected void handleSessionRadioSelected() {
        String session = this.getSelectedSession();
        this.fHoldXtermOpenCheck.setEnabled("xterm".equals(session) && ExternalToolsUtil.HAS_XTERM_SUPPORT);
        this.fRedirectOutputToConsoleCheck.setEnabled("xterm".equals(session) && ExternalToolsUtil.HAS_XTERM_SUPPORT && ExternalToolsUtil.HAS_REDIRECT_SUPPORT);
        this.fTerminateOnExitCheck.setEnabled("new".equals(session) && ExternalToolsUtil.HAS_SESSION_SUPPORT || "xterm".equals(session) && ExternalToolsUtil.HAS_XTERM_SUPPORT);
    }

    protected void selectSessionRadio(String text) {
        if ("same".equalsIgnoreCase(text)) {
            this.fLaunchInSameSessionRadio.setSelection(true);
            this.fLaunchInNewSessionRadio.setSelection(false);
            this.fLaunchInXtermSessionRadio.setSelection(false);
        } else if ("new".equalsIgnoreCase(text)) {
            this.fLaunchInSameSessionRadio.setSelection(false);
            this.fLaunchInNewSessionRadio.setSelection(true);
            this.fLaunchInXtermSessionRadio.setSelection(false);
        } else if ("xterm".equalsIgnoreCase(text)) {
            this.fLaunchInSameSessionRadio.setSelection(false);
            this.fLaunchInNewSessionRadio.setSelection(false);
            this.fLaunchInXtermSessionRadio.setSelection(true);
        }
    }

    protected String getSelectedSession() {
        if (this.fLaunchInNewSessionRadio != null && this.fLaunchInNewSessionRadio.getSelection()) {
            return "new";
        }
        if (this.fLaunchInXtermSessionRadio != null && this.fLaunchInXtermSessionRadio.getSelection()) {
            return "xterm";
        }
        return "same";
    }

    private void validateVaribles(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    private String resolveValue(String expression) throws CoreException {
        String expanded = null;
        try {
            expanded = this.getValue(expression);
        }
        catch (CoreException coreException) {
            this.validateVaribles(expression);
            return null;
        }
        return expanded;
    }

    private String getValue(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }

    protected String newVariableExpression(String varName, String arg) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, arg);
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    public static enum LaunchMode {
        RUN("Run", Arrays.asList("run")),
        DEBUG("Debug", Arrays.asList("debug")),
        BOTH("Both", Arrays.asList("run", "debug"));

        public static final String ATTRIBUTE = "ro.amiq.dvt.launch.LAUNCH_MODE";
        public static final LaunchMode DEFAULT;
        public final List<String> fModes;
        private final String fDisplayName;

        static {
            DEFAULT = RUN;
        }

        private LaunchMode(String displayName, List<String> modes) {
            this.fModes = modes;
            this.fDisplayName = displayName;
        }

        public static LaunchMode from(String string) {
            LaunchMode result = DEFAULT;
            try {
                result = LaunchMode.valueOf(string.toUpperCase());
            }
            catch (Exception exception) {}
            return result;
        }

        public static void setLaunchMode(ILaunchConfigurationWorkingCopy config, LaunchMode launchMode) {
            config.setAttribute(ATTRIBUTE, launchMode.name());
        }

        public static LaunchMode getLaunchMode(ILaunchConfiguration config) {
            try {
                return LaunchMode.from(config.getAttribute(ATTRIBUTE, ""));
            }
            catch (CoreException coreException) {
                return DEFAULT;
            }
        }

        public String toString() {
            return this.fDisplayName;
        }
    }

    protected static class StyledTextContentAdapter
    implements IControlContentAdapter,
    IControlContentAdapter2 {
        protected StyledTextContentAdapter() {
        }

        public String getControlContents(Control control) {
            return ((StyledText)control).getText();
        }

        public void setControlContents(Control control, String text, int cursorPosition) {
            ((StyledText)control).setText(text);
            ((StyledText)control).setSelection(cursorPosition, cursorPosition);
        }

        public void insertControlContents(Control control, String text, int cursorPosition) {
            Point selection = ((StyledText)control).getSelection();
            ((StyledText)control).insert(text);
            if (cursorPosition <= text.length()) {
                ((StyledText)control).setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
            }
        }

        public int getCursorPosition(Control control) {
            return ((StyledText)control).getCaretOffset();
        }

        public Rectangle getInsertionBounds(Control control) {
            StyledText text = (StyledText)control;
            Point caretOrigin = text.getLocationAtOffset(text.getCaretOffset());
            return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
        }

        public void setCursorPosition(Control control, int position) {
            ((StyledText)control).setSelection(new Point(position, position));
        }

        public Point getSelection(Control control) {
            return ((StyledText)control).getSelection();
        }

        public void setSelection(Control control, Point range) {
            ((StyledText)control).setSelection(range);
        }
    }

    protected static class StyledTextVariableStyleListener
    implements LineStyleListener {
        private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^:}]*)(:[^}]*)?\\}");
        private static final Pattern COLON_PATTERN = Pattern.compile(":[^:]*");

        protected StyledTextVariableStyleListener() {
        }

        public void lineGetStyle(LineStyleEvent event) {
            LinkedList<StyleRange> styles = new LinkedList<StyleRange>();
            Matcher matcher = VARIABLE_PATTERN.matcher(event.lineText);
            while (matcher.find()) {
                String match;
                int end;
                int start = matcher.start(1);
                if (start != (end = matcher.end(1))) {
                    styles.add(new StyleRange(event.lineOffset + start, end - start, null, null, 1));
                }
                if ((match = matcher.group(2)) == null || match.length() <= 1) continue;
                start = matcher.start(2);
                end = matcher.end(2);
                Matcher argMatcher = COLON_PATTERN.matcher(match);
                while (argMatcher.find()) {
                    int argStart = argMatcher.start();
                    int argEnd = argMatcher.end();
                    if (argEnd - argStart <= 1) continue;
                    styles.add(new StyleRange(event.lineOffset + start + 1 + argStart, argEnd - argStart - 1, null, null, 2));
                }
            }
            event.styles = styles.toArray(new StyleRange[styles.size()]);
        }
    }

    protected class VariableProposalProvider
    implements IContentProposalProvider {
        private final TreeMap<String, String> fVariables = new TreeMap(String.CASE_INSENSITIVE_ORDER);

        public VariableProposalProvider() {
            IStringVariable[] variables;
            IStringVariable[] iStringVariableArray = variables = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
            int n = variables.length;
            int n2 = 0;
            while (n2 < n) {
                IStringVariable variable = iStringVariableArray[n2];
                this.fVariables.put("${" + variable.getName() + "}", variable.getDescription());
                ++n2;
            }
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ArrayList<Object> priorityList = new ArrayList<Object>();
            ArrayList<ContentProposal> normalList = new ArrayList<ContentProposal>();
            if (position == 0 && "script".equals(DVTLaunchMainTab.this.getAttributeValueFrom(DVTLaunchMainTab.this.fRunAsCombo))) {
                if (ExternalToolsUtil.IS_WINDOWS) {
                    if (ExternalToolsUtil.DISTRO_BUSYBOX != null) {
                        priorityList.add(new ContentProposal("#!/bin/sh", "In Windows the script will run using Busybox sh interpreter included in the distribution."));
                    }
                } else {
                    List<String> shells = ExternalToolsUtil.getSystemShells();
                    for (String shell : shells) {
                        priorityList.add(new ContentProposal("#!" + shell));
                    }
                }
            } else {
                NavigableSet<String> variableSet = this.fVariables.navigableKeySet();
                block1: for (String variable : variableSet) {
                    String prolog = contents.substring(0, position);
                    int cursorPosition = variable.length();
                    int i = 1;
                    while (i < cursorPosition) {
                        String prefix = variable.substring(0, i);
                        if (prolog.endsWith(prefix)) {
                            String newContent;
                            String postfix = variable.substring(cursorPosition);
                            String epilog = contents.substring(position);
                            if (epilog.startsWith(postfix)) {
                                newContent = variable.substring(i, cursorPosition);
                                priorityList.add(new ContentProposal(variable.substring(i, cursorPosition), variable, this.fVariables.get(variable), newContent.length()));
                                continue block1;
                            }
                            newContent = variable.substring(i);
                            priorityList.add(new ContentProposal(variable.substring(i), variable, this.fVariables.get(variable), newContent.length()));
                            continue block1;
                        }
                        ++i;
                    }
                    normalList.add(new ContentProposal(variable, variable, this.fVariables.get(variable), variable.length()));
                }
                priorityList.addAll(normalList);
            }
            return priorityList.toArray(new IContentProposal[priorityList.size()]);
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.validateAndUpdate();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == DVTLaunchMainTab.this.fProjectButton) {
                DVTLaunchMainTab.this.handleProjectButtonSelected();
            } else if (source == DVTLaunchMainTab.this.fWorkspaceWorkDirectoryButton) {
                DVTLaunchMainTab.this.handleWorkspaceWorkingDirectoryButtonSelected();
            } else if (source == DVTLaunchMainTab.this.fRunAsCombo) {
                DVTLaunchMainTab.this.handleRunAsComboSelected();
                this.validateAndUpdate();
            } else if (source == DVTLaunchMainTab.this.fLaunchInSameSessionRadio || source == DVTLaunchMainTab.this.fLaunchInNewSessionRadio || source == DVTLaunchMainTab.this.fLaunchInXtermSessionRadio) {
                DVTLaunchMainTab.this.handleSessionRadioSelected();
                this.validateAndUpdate();
            } else if (source == DVTLaunchMainTab.this.fHoldXtermOpenCheck || source == DVTLaunchMainTab.this.fRedirectOutputToConsoleCheck || source == DVTLaunchMainTab.this.fTerminateOnExitCheck) {
                this.validateAndUpdate();
            } else if (source == DVTLaunchMainTab.this.fCommandVariablesButton) {
                DVTLaunchMainTab.this.handleVariablesButtonSelected(DVTLaunchMainTab.this.fCommandText);
            } else if (source == DVTLaunchMainTab.this.fVariablesWorkDirectoryButton) {
                DVTLaunchMainTab.this.handleVariablesButtonSelected(DVTLaunchMainTab.this.fWorkDirectoryField);
            } else if (source == DVTLaunchMainTab.this.fFileWorkDirectoryButton) {
                DVTLaunchMainTab.this.handleFileWorkingDirectoryButtonSelected();
            } else if (source == DVTLaunchMainTab.this.fLaunchModeRunRadio || source == DVTLaunchMainTab.this.fLaunchModeDebugRadio || source == DVTLaunchMainTab.this.fLaunchModeBothRadio) {
                this.validateAndUpdate();
            }
        }

        private void validateAndUpdate() {
            DVTLaunchMainTab.this.isValid(DVTLaunchMainTab.this.getCurrentLaunchConfiguration());
            DVTLaunchMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

