/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.pattern.PatternMessages;
import ro.amiq.dvt.externaltools.pattern.PatternReaderWriter;
import ro.amiq.dvt.externaltools.ui.EditBuilderPatternDialog;
import ro.amiq.dvt.externaltools.ui.ExternalToolsContentProvider;
import ro.amiq.dvt.externaltools.ui.ExternalToolsLabelProvider;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.launch.ui.DVTBaseLaunchConfigurationTab;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public class DVTLaunchPatternsTab
extends DVTBaseLaunchConfigurationTab {
    public static final String DVT_CONSOLE_TITLE = "DVTConsoleTitle";
    private Button[] fSimulatorSelectButtons;
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fDuplicateButton;
    private ExternalToolsConfiguration fConfiguration;
    private SourceViewer fPatternViewer;
    private Button fWSLinkFilterButton;
    private Text fConsoleTitleText;
    protected WidgetListener fListener = new WidgetListener();
    private PatternReaderWriter fPatternReaderWriter = new PatternReaderWriter();
    private static final Set<String> METH_FILTERS = new HashSet<String>(Arrays.asList("OVM", "UVM", "VMM", "UVVM", "OSVVM"));
    protected SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            List<Object> newInput = new ArrayList();
            TableItem[] items = DVTLaunchPatternsTab.this.fTableViewer.getTable().getItems();
            if (button.getSelection()) {
                newInput = ExternalToolsUtil.getCategoryPatterns(button.getText());
                int i = 0;
                while (i < items.length) {
                    ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
                    newInput.add(data);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < items.length) {
                    ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
                    if (!data.getKind().equals(button.getText())) {
                        newInput.add(data);
                    }
                    ++i;
                }
            }
            DVTLaunchPatternsTab.this.fTableViewer.setInput(newInput);
            DVTLaunchPatternsTab.this.fTableViewer.setAllChecked(false);
            DVTLaunchPatternsTab.this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
            DVTLaunchPatternsTab.this.updateLaunchConfigurationDialog();
        }
    };

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.IMG_TAB_FILTER);
    }

    public String getName() {
        return "Filters";
    }

    public void dispose() {
        if (this.fAddButton != null) {
            this.fAddButton.dispose();
        }
        if (this.fRemoveButton != null) {
            this.fRemoveButton.dispose();
        }
        if (this.fEditButton != null) {
            this.fEditButton.dispose();
        }
        if (this.fDuplicateButton != null) {
            this.fDuplicateButton.dispose();
        }
        if (this.fConsoleTitleText != null) {
            this.fConsoleTitleText.dispose();
        }
        this.fListener = null;
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout allLayout = new GridLayout();
        allLayout.marginHeight = 7;
        allLayout.marginWidth = 7;
        allLayout.numColumns = 5;
        GridData allGridData = new GridData(1808);
        composite.setLayout((Layout)allLayout);
        composite.setLayoutData((Object)allGridData);
        composite.setFont(parent.getFont());
        this.createMainCompositeContents(composite);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
    }

    public void createWSLinkFilterButton(Composite composite) {
        this.fWSLinkFilterButton = this.createCheckButton(composite, "Links jump to resources located in the current working set");
        GridData gridData = new GridData(4, 4, true, false, 5, 1);
        this.fWSLinkFilterButton.setLayoutData((Object)gridData);
        this.fWSLinkFilterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTLaunchPatternsTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String filterKinds = "";
            String patternsXML = "";
            String consoleTitlePattern = "";
            filterKinds = config.getAttribute("ro.amiq.dvt.launch.FILTERS_KIND", "");
            patternsXML = config.getAttribute("ro.amiq.dvt.launch.LAUNCH_PATTERNS", "");
            consoleTitlePattern = config.getAttribute("ro.amiq.dvt.launch.CONSOLE_TITLE_PATTERN", "");
            ArrayList<String> kinds = new ArrayList<String>();
            kinds.addAll(Arrays.asList(filterKinds.split(",")));
            ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
            int i = 0;
            while (i < this.fSimulatorSelectButtons.length) {
                if (kinds.contains(this.fSimulatorSelectButtons[i].getText())) {
                    this.fSimulatorSelectButtons[i].setSelection(true);
                    newInput.addAll(ExternalToolsUtil.getCategoryPatterns(this.fSimulatorSelectButtons[i].getText()));
                } else {
                    this.fSimulatorSelectButtons[i].setSelection(false);
                }
                ++i;
            }
            this.fConsoleTitleText.setText(consoleTitlePattern);
            try {
                if (patternsXML.length() != 0) {
                    StringReader reader = new StringReader(patternsXML);
                    ExternalToolsPattern[] patterns = this.fPatternReaderWriter.read(reader);
                    reader.close();
                    ExternalToolsPattern[] externalToolsPatternArray = patterns;
                    int n = patterns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ExternalToolsPattern pattern = externalToolsPatternArray[n2];
                        if (!pattern.getKind().equals(DVT_CONSOLE_TITLE)) {
                            newInput.add(pattern);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            this.fTableViewer.setInput(newInput);
            this.fTableViewer.setAllChecked(false);
            this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
            this.fConfiguration = new ExternalToolsConfiguration();
            this.fConfiguration.setPatterns(newInput.toArray(new ExternalToolsPattern[newInput.size()]));
            this.fWSLinkFilterButton.setSelection(config.getAttribute("ro.amiq.dvt.launch.WORKING_SET_LINK_FILTER", true));
            this.setCurrentLaunchConfiguration(config);
            this.updateLaunchConfigurationDialog();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        try {
            String filterKinds = "";
            String patternsXML = "";
            String consoleTitlePattern = "";
            int i = 0;
            while (i < this.fSimulatorSelectButtons.length) {
                if (this.fSimulatorSelectButtons[i].getSelection()) {
                    filterKinds = String.valueOf(filterKinds) + this.fSimulatorSelectButtons[i].getText() + ",";
                }
                ++i;
            }
            config.setAttribute("ro.amiq.dvt.launch.FILTERS_KIND", filterKinds);
            consoleTitlePattern = this.fConsoleTitleText.getText();
            config.setAttribute("ro.amiq.dvt.launch.CONSOLE_TITLE_PATTERN", consoleTitlePattern);
            ArrayList<ExternalToolsPattern> patterns = new ArrayList<ExternalToolsPattern>();
            TableItem[] items = this.fTableViewer.getTable().getItems();
            int i2 = 0;
            while (i2 < items.length) {
                ExternalToolsPattern data = (ExternalToolsPattern)items[i2].getData();
                if (ExternalToolsUtil.isUserDefined(data)) {
                    patterns.add(data);
                }
                ++i2;
            }
            if (consoleTitlePattern != null && !consoleTitlePattern.isEmpty()) {
                try {
                    Pattern compiledPattern = Pattern.compile(consoleTitlePattern);
                    ExternalToolsPattern externalToolsPattern = new ExternalToolsPattern(DVT_CONSOLE_TITLE, "DVT Console Title Filter", "TITLE", "This filter matches a given title in order to change it for the Console", consoleTitlePattern, compiledPattern, null, null, true);
                    patterns.add(externalToolsPattern);
                }
                catch (Exception exception) {}
            }
            StringWriter writer = new StringWriter();
            this.fPatternReaderWriter.save(patterns.toArray(new ExternalToolsPattern[patterns.size()]), writer);
            patternsXML = writer.toString();
            writer.close();
            config.setAttribute("ro.amiq.dvt.launch.LAUNCH_PATTERNS", patternsXML);
            config.setAttribute("ro.amiq.dvt.launch.WORKING_SET_LINK_FILTER", this.fWSLinkFilterButton.getSelection());
            this.fConfiguration.setWSLink(this.fWSLinkFilterButton.getSelection());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.FILTERS_KIND", null);
        config.setAttribute("ro.amiq.dvt.launch.LAUNCH_PATTERNS", null);
        config.setAttribute("ro.amiq.dvt.launch.CONSOLE_TITLE_PATTERN", null);
    }

    private void createMainCompositeContents(Composite allComposite) {
        this.createMatchingOptionsComposite(allComposite);
        this.createFilterCategoriesComposite(allComposite);
        this.createFiltersComposite(allComposite);
        this.createConsoleTitleComposite(allComposite);
        this.createWSLinkFilterButton(allComposite);
    }

    private void createMatchingOptionsComposite(Composite allComposite) {
        Group group = new Group(allComposite, 0);
        group.setText("Matching options:");
        group.setLayout((Layout)new GridLayout(4, false));
        group.setLayoutData((Object)new GridData(4, 4, true, false, 5, 1));
        Label maxCharsLine = new Label((Composite)group, 0);
        maxCharsLine.setText("Max. characters per line (1-999):");
        maxCharsLine.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text maxCharsPerLineText = new Text((Composite)group, 2048);
        GridData layoutData = new GridData(4, 4, false, false);
        maxCharsPerLineText.setLayoutData((Object)layoutData);
        maxCharsPerLineText.setTextLimit(3);
        String string = DVTPlugin.getDefault().getPreferenceStore().getString("max_characters_per_line");
        if (string.isEmpty()) {
            string = "512";
        }
        maxCharsPerLineText.setText(string);
        maxCharsPerLineText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = maxCharsPerLineText.getText();
                int maxChars = -1;
                try {
                    maxChars = Integer.parseInt(text);
                }
                catch (Exception exception) {}
                if (maxChars > 0 && maxChars <= 9999) {
                    DVTPlugin.getDefault().getPreferenceStore().setValue("max_characters_per_line", text);
                } else {
                    DVTPlugin.getDefault().getPreferenceStore().setValue("max_characters_per_line", "512");
                }
            }
        });
        Label maxLinesLabel = new Label((Composite)group, 0);
        maxLinesLabel.setText("Max. consecutive lines (1-99):");
        maxLinesLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        final Text maxLinesText = new Text((Composite)group, 2048);
        layoutData.widthHint = 30;
        maxLinesText.setLayoutData((Object)layoutData);
        maxLinesText.setTextLimit(2);
        string = DVTPlugin.getDefault().getPreferenceStore().getString("max_consecutive_lines");
        if (string.isEmpty()) {
            string = "8";
        }
        maxLinesText.setText(string);
        maxLinesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = maxLinesText.getText();
                int maxLines = -1;
                try {
                    maxLines = Integer.parseInt(text);
                }
                catch (Exception exception) {}
                if (maxLines > 0 && maxLines <= 99) {
                    DVTPlugin.getDefault().getPreferenceStore().setValue("max_consecutive_lines", text);
                } else {
                    DVTPlugin.getDefault().getPreferenceStore().setValue("max_consecutive_lines", "8");
                }
            }
        });
    }

    private void createFilterCategoriesComposite(Composite allComposite) {
        Group group = new Group(allComposite, 0);
        String groupName = ExternalToolsMessages.ExternalToolsFiterTabCategoryGroupName;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(1, 4, false, true, 1, 1);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        String[] filterCategories = ExternalToolsUtil.getFilterCategories();
        ArrayList<String> methFilters = new ArrayList<String>();
        ArrayList<String> simFilters = new ArrayList<String>();
        String[] stringArray = filterCategories;
        int n = filterCategories.length;
        int n2 = 0;
        while (n2 < n) {
            String filterCat = stringArray[n2];
            if (METH_FILTERS.contains(filterCat)) {
                methFilters.add(filterCat);
            } else {
                simFilters.add(filterCat);
            }
            ++n2;
        }
        Collections.sort(methFilters);
        Collections.sort(simFilters);
        this.fSimulatorSelectButtons = new Button[filterCategories.length];
        int i = 0;
        while (i < simFilters.size()) {
            this.fSimulatorSelectButtons[i] = this.createCheckButton((Composite)group, (String)simFilters.get(i));
            this.fSimulatorSelectButtons[i].setSelection(false);
            this.fSimulatorSelectButtons[i].addSelectionListener(this.fSelectionListener);
            ++i;
        }
        new Label((Composite)group, 258).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        i = 0;
        while (i < methFilters.size()) {
            this.fSimulatorSelectButtons[i + simFilters.size()] = this.createCheckButton((Composite)group, (String)methFilters.get(i));
            this.fSimulatorSelectButtons[i + simFilters.size()].setSelection(false);
            this.fSimulatorSelectButtons[i + simFilters.size()].addSelectionListener(this.fSelectionListener);
            ++i;
        }
    }

    private Control createFiltersComposite(Composite allComposite) {
        Composite parent = new Composite(allComposite, 0);
        GridData gridData = new GridData(4, 4, true, true, 4, 1);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        innerParent.setLayoutData((Object)gd);
        Table table = new Table(innerParent, 67618);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(ExternalToolsMessages.RulePropertyPage_column_name);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(ExternalToolsMessages.RulePropertyPage_column_context);
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(ExternalToolsMessages.RulePropertyPage_column_type);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ExternalToolsLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ExternalToolsContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof ExternalToolsPattern && object2 instanceof ExternalToolsPattern) {
                    ExternalToolsPattern left = (ExternalToolsPattern)object1;
                    ExternalToolsPattern right = (ExternalToolsPattern)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                DVTLaunchPatternsTab.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                DVTLaunchPatternsTab.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExternalToolsPattern d = (ExternalToolsPattern)event.getElement();
                if (ExternalToolsUtil.isUserDefined(d)) {
                    d.setEnabled(event.getChecked());
                    DVTLaunchPatternsTab.this.updateLaunchConfigurationDialog();
                } else {
                    DVTLaunchPatternsTab.this.fTableViewer.setChecked(event.getElement(), true);
                    DVTLaunchPatternsTab.this.fTableViewer.refresh();
                    DVTLaunchPatternsTab.this.openReadOnlyPatternDisableErrorDialog();
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = DVTLaunchPatternsTab.createPushButton(buttons, "ListEditor.add");
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DVTLaunchPatternsTab.this.add();
            }
        });
        this.fEditButton = DVTLaunchPatternsTab.createPushButton(buttons, "&Edit...");
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DVTLaunchPatternsTab.this.edit();
            }
        });
        this.fRemoveButton = DVTLaunchPatternsTab.createPushButton(buttons, "ListEditor.remove");
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DVTLaunchPatternsTab.this.remove();
            }
        });
        this.fDuplicateButton = DVTLaunchPatternsTab.createPushButton(buttons, "Duplicate...");
        this.fDuplicateButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DVTLaunchPatternsTab.this.duplicate();
            }
        });
        this.createSeparator(buttons);
        this.fPatternViewer = this.doCreateViewer(parent);
        this.updateButtons();
        DVTLaunchPatternsTab.configureTableResizing(table);
        Dialog.applyDialogFont((Control)parent);
        table.getHorizontalBar().setVisible(true);
        return parent;
    }

    private Control createConsoleTitleComposite(Composite allComposite) {
        Composite parent = new Composite(allComposite, 0);
        GridData gridData = new GridData(4, 4, true, false, 5, 1);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Group group = new Group(parent, 0);
        String groupName = "Console title pattern:";
        group.setText(groupName);
        GridLayout groupLayout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)groupLayout);
        group.setLayoutData((Object)new GridData(768));
        this.fConsoleTitleText = new Text((Composite)group, 2048);
        this.fConsoleTitleText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fConsoleTitleText.addModifyListener((ModifyListener)this.fListener);
        return parent;
    }

    private SourceViewer doCreateViewer(Composite parent) {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(parent, 0);
        label.setText(ExternalToolsMessages.RulePropertyPage_preview);
        label.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(3, (Control)parent);
        data.minimumHeight = this.convertHeightInCharsToPixels(3, (Control)parent);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        control.setLayoutData((Object)data);
        return viewer;
    }

    private int convertHeightInCharsToPixels(int chars, Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private void selectionChanged1() {
        this.updateViewerInput();
        this.updateButtons();
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            ExternalToolsPattern convention = (ExternalToolsPattern)selection.getFirstElement();
            this.fPatternViewer.getDocument().set(convention.getPatternString());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection == null) {
            return;
        }
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        boolean canRemove = true;
        boolean canEdit = true;
        for (ExternalToolsPattern data : selection) {
            if (data == null || ExternalToolsUtil.isUserDefined(data)) continue;
            canEdit = false;
            canRemove = false;
            break;
        }
        this.fEditButton.setEnabled(selectionCount == 1 && canEdit);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount && canRemove);
    }

    private void add() {
        ExternalToolsPattern convention = new ExternalToolsPattern("User defined", "", "", "", "", null, null, null, true);
        ExternalToolsPattern newConvention = this.editPattern(convention, false, true);
        if (newConvention != null) {
            this.addElementTableViewer(newConvention);
            this.updateFilterComposite();
            this.fTableViewer.setChecked((Object)newConvention, newConvention.getEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newConvention));
        }
        this.updateConfig();
    }

    private void addElementTableViewer(ExternalToolsPattern newPattern) {
        ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            newInput.add(data);
            ++i;
        }
        newInput.add(newPattern);
        this.fTableViewer.setInput(newInput);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
    }

    private void deleteElementTableViewer(ExternalToolsPattern pattern) {
        ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            newInput.add(data);
            ++i;
        }
        newInput.remove(pattern);
        this.fTableViewer.setInput(newInput);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
    }

    private void editElementTableViewer(ExternalToolsPattern newPattern, ExternalToolsPattern oldPattern) {
        ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            if (!data.equals(oldPattern)) {
                newInput.add(data);
            }
            ++i;
        }
        newInput.add(newPattern);
        this.fTableViewer.setInput(newInput);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
    }

    protected ExternalToolsPattern editPattern(ExternalToolsPattern pattern, boolean edit, boolean isNameModifiable) {
        EditBuilderPatternDialog dialog = new EditBuilderPatternDialog(this.getShell(), pattern, edit, isNameModifiable, ExternalToolsModelManager.getInstance().getContextTypeRegistry(), this.fConfiguration);
        if (dialog.open() == 0) {
            return dialog.getBuilderFilterPattern();
        }
        return null;
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        ExternalToolsPattern data = (ExternalToolsPattern)selection.getFirstElement();
        if (ExternalToolsUtil.isUserDefined(data)) {
            this.edit(data);
        } else {
            this.openReadOnlyPatternEditErrorDialog();
        }
        this.updateConfig();
    }

    private void edit(ExternalToolsPattern oldConvention) {
        ExternalToolsPattern newConvention = this.editPattern(oldConvention, true, true);
        if (newConvention != null) {
            if (!newConvention.getName().equals(oldConvention.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)ExternalToolsMessages.RulePropertyPage_question_create_new_title, (String)ExternalToolsMessages.RulePropertyPage_question_create_new_message)) {
                this.addElementTableViewer(newConvention);
            } else {
                oldConvention.setName(newConvention.getName());
                oldConvention.setKind(newConvention.getKind());
                oldConvention.setDescription(newConvention.getDescription());
                oldConvention.setPatternString(newConvention.getPatternString());
                oldConvention.setPattern(newConvention.getPattern());
                oldConvention.setVariablesMap(newConvention.getVariablesMap());
                oldConvention.setHyperlinkCommandsMap(newConvention.getHyperlinkCommandsMap());
                oldConvention.setType(newConvention.getType());
                oldConvention.setEnabled(newConvention.getEnabled());
                this.editElementTableViewer(newConvention, oldConvention);
            }
            this.updateFilterComposite();
            this.selectionChanged1();
        }
    }

    public static String messageFormat(String message, Object argument) {
        return MessageFormat.format(message, argument);
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (ExternalToolsPattern data : selection) {
            this.deleteElementTableViewer(data);
        }
        this.updateFilterComposite();
        this.updateConfig();
    }

    private void duplicate() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        ExternalToolsPattern data = (ExternalToolsPattern)selection.getFirstElement();
        ExternalToolsPattern convention = new ExternalToolsPattern(data);
        convention.setKind("User defined");
        convention.setName("Copy of " + convention.getName());
        ExternalToolsPattern newConvention = this.editPattern(convention, false, true);
        if (newConvention != null) {
            this.addElementTableViewer(newConvention);
            this.updateFilterComposite();
            this.fTableViewer.setChecked((Object)newConvention, newConvention.getEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newConvention));
        }
        this.updateConfig();
    }

    private void updateConfig() {
        ArrayList<ExternalToolsPattern> patterns = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            if (ExternalToolsUtil.isUserDefined(data)) {
                patterns.add(data);
            }
            ++i;
        }
        this.fConfiguration.setPatterns(patterns.toArray(new ExternalToolsPattern[patterns.size()]));
        this.fConfiguration.setWSLink(this.fWSLinkFilterButton.getSelection());
    }

    private void openReadOnlyPatternEditErrorDialog() {
        String title = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Edit_Error_Title;
        String message = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Edit_Error_Message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openReadOnlyPatternDisableErrorDialog() {
        String title = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Disable_Error_Title;
        String message = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Disable_Error_Message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void updateFilterComposite() {
        this.fTableViewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    private static void configureTableResizing(final Table table) {
        ControlAdapter resizer = new ControlAdapter(){
            private boolean fIsResizing = false;
            private final int[] fWidths = new int[]{340, 160, 160};
            private int fSum = 740;

            public void controlResized(ControlEvent e) {
                if (this.fIsResizing) {
                    return;
                }
                try {
                    this.fIsResizing = true;
                    int clientAreaWidth = table.getClientArea().width;
                    TableColumn[] columns = table.getColumns();
                    int tableWidth = 0;
                    if (e.widget == table) {
                        int toDistribute;
                        int[] initial = new int[]{200, 120, 120};
                        int[] minimums = new int[columns.length];
                        int minSum = 0;
                        int i = 0;
                        while (i < columns.length) {
                            minimums[i] = Math.min(this.fWidths[i], initial[i]);
                            minSum += minimums[i];
                            ++i;
                        }
                        int newWidth = this.fSum < clientAreaWidth ? clientAreaWidth : Math.max(clientAreaWidth, minSum);
                        int lastPart = toDistribute = newWidth - this.fSum;
                        if (toDistribute != 0) {
                            int[] nArray = new int[3];
                            nArray[0] = 2;
                            nArray[1] = 1;
                            int[] iteration = nArray;
                            int i2 = 0;
                            while (i2 < iteration.length) {
                                int width;
                                int c = iteration[i2];
                                if (this.fSum > 0) {
                                    int part = i2 == iteration.length - 1 ? lastPart : toDistribute * this.fWidths[c] / this.fSum;
                                    lastPart -= part;
                                    width = Math.max(minimums[c], this.fWidths[c] + part);
                                } else {
                                    width = toDistribute * initial[c] / 280;
                                }
                                columns[c].setWidth(width);
                                this.fWidths[c] = width;
                                tableWidth += width;
                                ++i2;
                            }
                            this.fSum = tableWidth;
                        }
                    } else {
                        if (e.widget == columns[2]) {
                            return;
                        }
                        int i = 0;
                        while (i < columns.length) {
                            this.fWidths[i] = columns[i].getWidth();
                            tableWidth += this.fWidths[i];
                            ++i;
                        }
                        this.fSum = tableWidth;
                    }
                    table.getHorizontalBar().setVisible(tableWidth > clientAreaWidth);
                }
                finally {
                    this.fIsResizing = false;
                    table.redraw();
                }
            }
        };
        table.addControlListener((ControlListener)resizer);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addControlListener((ControlListener)resizer);
            ++i;
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        try {
            this.setErrorMessage(null);
            this.setMessage(null);
            String consolePattern = this.fConsoleTitleText.getText();
            try {
                Pattern.compile(consolePattern);
            }
            catch (Exception exception) {
                this.setErrorMessage(PatternMessages.PatternCompile_error_message);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    protected class WidgetListener
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            this.validateAndUpdate();
        }

        private void validateAndUpdate() {
            DVTLaunchPatternsTab.this.isValid(DVTLaunchPatternsTab.this.getCurrentLaunchConfiguration());
            DVTLaunchPatternsTab.this.updateLaunchConfigurationDialog();
        }
    }
}

