/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import java.io.File;
import java.util.List;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigToolbar;
import ro.amiq.dvt.dynamicactions.launchconfigs.DynamicLaunchConfigUtils;
import ro.amiq.dvt.dynamicactions.launchconfigs.IconGenerator;
import ro.amiq.dvt.launch.ui.DVTBaseLaunchConfigurationTab;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTShortcutsTab
extends DVTBaseLaunchConfigurationTab {
    private static final String[] FILTER_EXTS = new String[]{"*.png", "*.jpg", "*.gif", "*.bmp", "*.ico", "*.*"};
    private Button fBrowseForIconLocationButton;
    private Button fAddShortcutOnToolbar;
    private Text fShortcutBinding;
    private Text fIconPathText;
    private Button fCreateAccelerator;
    private String fIconPath = "";
    private String fIconLetter = "1";
    private String fIconBgColor = "ffffff";
    private Button[] fRadioButtons;
    private Text fIconLetterText;
    private Canvas fCanvas;
    private Image fPreviewImage;
    private Text fBackColorText;
    private Group fGenerateIconGroup;
    private Label fIconLetterLb;
    private Button fColorPickButton;
    private Label fToolbarOrderLb;
    private Text fToolbarOrder;
    private String fToolbarOrderStr;

    public void dispose() {
        if (this.fShortcutBinding != null) {
            this.fShortcutBinding.dispose();
        }
        if (this.fIconPathText != null) {
            this.fIconPathText.dispose();
        }
        super.dispose();
        DynamicLaunchConfigToolbar.INSTANCE.refresh();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isValid((ILaunchConfiguration)configuration) && !configuration.isReadOnly()) {
            try {
                ILaunchConfiguration currentConfig = this.getCurrentLaunchConfiguration();
                if (this.fAddShortcutOnToolbar.getSelection() && this.fRadioButtons[0].getSelection() && !currentConfig.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_PATH", "").equals(this.fIconPathText.getText().trim()) || this.fAddShortcutOnToolbar.getSelection() && this.fRadioButtons[1].getSelection() && !configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_BGCOLOR", "ffffff").equals(this.fBackColorText.getText().trim()) || this.fAddShortcutOnToolbar.getSelection() && this.fRadioButtons[1].getSelection() && !configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_LETTER", "1").equals(this.fIconLetterText.getText().trim()) || this.fAddShortcutOnToolbar.getSelection() && this.fRadioButtons[1].getSelection() && !configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_TOOLBAR_ORDER", "0").equals(this.fToolbarOrder.getText()) || this.fCreateAccelerator.getSelection() && !currentConfig.getAttribute("ro.amiq.dvt.launch.SHORTCUT_BINDING", "").equals(this.fShortcutBinding.getText().trim()) || currentConfig.getAttribute("ro.amiq.dvt.launch.CREATE_SHORTCUT", false) != this.fAddShortcutOnToolbar.getSelection() || currentConfig.getAttribute("ro.amiq.dvt.launch.CREATE_ACCELERATOR", false) != this.fCreateAccelerator.getSelection()) {
                    configuration.setAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_PATH", this.fRadioButtons[0].getSelection() ? this.fIconPathText.getText().trim() : "");
                    configuration.setAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_BGCOLOR", this.fRadioButtons[1].getSelection() ? this.fIconBgColor : "ffffff");
                    configuration.setAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_LETTER", this.fRadioButtons[1].getSelection() ? this.fIconLetter : "1");
                    configuration.setAttribute("ro.amiq.dvt.launch.SHORTCUT_TOOLBAR_ORDER", this.fToolbarOrder.getText());
                    configuration.setAttribute("ro.amiq.dvt.launch.SHORTCUT_BINDING", this.fShortcutBinding.getText().trim());
                    configuration.setAttribute("ro.amiq.dvt.launch.CREATE_SHORTCUT", this.fAddShortcutOnToolbar.getSelection());
                    configuration.setAttribute("ro.amiq.dvt.launch.CREATE_ACCELERATOR", this.fCreateAccelerator.getSelection());
                }
            }
            catch (Exception exception) {}
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.fShortcutBinding == null || this.fIconPathText == null) {
            return;
        }
        this.fAddShortcutOnToolbar.setEnabled(!configuration.isReadOnly());
        this.fRadioButtons[0].setEnabled(!configuration.isReadOnly());
        this.fIconPathText.setEnabled(!configuration.isReadOnly());
        this.fBrowseForIconLocationButton.setEnabled(!configuration.isReadOnly());
        this.fRadioButtons[1].setEnabled(!configuration.isReadOnly());
        this.fIconLetterLb.setEnabled(!configuration.isReadOnly());
        this.fIconLetterText.setEnabled(!configuration.isReadOnly());
        this.fCanvas.setEnabled(!configuration.isReadOnly());
        this.fToolbarOrderLb.setEnabled(!configuration.isReadOnly());
        this.fToolbarOrder.setEnabled(!configuration.isReadOnly());
        this.fColorPickButton.setEnabled(!configuration.isReadOnly());
        this.fBackColorText.setEnabled(!configuration.isReadOnly());
        this.fCreateAccelerator.setEnabled(!configuration.isReadOnly());
        this.fShortcutBinding.setEnabled(!configuration.isReadOnly());
        DynamicLaunchConfigToolbar.INSTANCE.refresh();
        this.setCurrentLaunchConfiguration(configuration);
        try {
            this.fIconPath = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_PATH", "");
            this.fIconLetter = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_LETTER", "1");
            this.fIconBgColor = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_ICON_BGCOLOR", "ffffff");
            this.fToolbarOrderStr = configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_TOOLBAR_ORDER", "0");
            int order = 0;
            try {
                order = Integer.parseInt(this.fToolbarOrderStr);
            }
            catch (Exception exception) {
                order = 0;
            }
            this.fIconPathText.setText(this.fIconPath);
            this.fIconLetterText.setText(this.fIconLetter);
            this.fBackColorText.setText(this.fIconBgColor);
            this.fToolbarOrder.setText(String.valueOf(order));
            if (configuration.isReadOnly()) {
                return;
            }
            if (configuration.getAttribute("ro.amiq.dvt.launch.CREATE_SHORTCUT", false)) {
                this.fAddShortcutOnToolbar.setSelection(true);
                this.fRadioButtons[0].setEnabled(true);
                this.fRadioButtons[1].setEnabled(true);
                this.fRadioButtons[0].setSelection(false);
                this.fRadioButtons[1].setSelection(false);
                if (!this.fIconPath.isEmpty()) {
                    this.fRadioButtons[0].setSelection(true);
                    this.fIconPathText.setEnabled(true);
                    this.fBrowseForIconLocationButton.setEnabled(true);
                    this.fIconLetterLb.setEnabled(false);
                    this.fIconLetterText.setEnabled(false);
                    this.fColorPickButton.setEnabled(false);
                    this.fBackColorText.setEnabled(false);
                    this.fToolbarOrderLb.setEnabled(false);
                    this.fToolbarOrder.setEnabled(false);
                } else {
                    this.fRadioButtons[1].setSelection(true);
                    this.fIconPathText.setEnabled(false);
                    this.fBrowseForIconLocationButton.setEnabled(false);
                    this.fIconLetterLb.setEnabled(true);
                    this.fIconLetterText.setEnabled(true);
                    this.fColorPickButton.setEnabled(true);
                    this.fBackColorText.setEnabled(true);
                    this.fToolbarOrderLb.setEnabled(true);
                    this.fToolbarOrder.setEnabled(true);
                }
            } else {
                this.fAddShortcutOnToolbar.setSelection(false);
                this.fIconPathText.setEnabled(false);
                this.fBrowseForIconLocationButton.setEnabled(false);
                this.fIconLetterLb.setEnabled(false);
                this.fIconLetterText.setEnabled(false);
                this.fColorPickButton.setEnabled(false);
                this.fBackColorText.setEnabled(false);
                this.fToolbarOrderLb.setEnabled(false);
                this.fToolbarOrder.setEnabled(false);
                this.fRadioButtons[0].setEnabled(false);
                this.fRadioButtons[1].setEnabled(false);
                this.fIconPathText.setText(this.fIconPath);
            }
            if (configuration.getAttribute("ro.amiq.dvt.launch.CREATE_ACCELERATOR", false)) {
                this.fCreateAccelerator.setSelection(true);
                this.fShortcutBinding.setEnabled(true);
                this.fShortcutBinding.setText(configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_BINDING", ""));
            } else {
                this.fCreateAccelerator.setSelection(false);
                this.fShortcutBinding.setEnabled(false);
                this.fShortcutBinding.setText(configuration.getAttribute("ro.amiq.dvt.launch.SHORTCUT_BINDING", ""));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Dialog.applyDialogFont((Control)composite);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        this.createMainCompositeContents(composite);
        this.setControl((Control)composite);
    }

    private void createMainCompositeContents(Composite parent) {
        this.fAddShortcutOnToolbar = new Button(parent, 32);
        this.fAddShortcutOnToolbar.setText("Add toolbar button");
        this.fAddShortcutOnToolbar.setSelection(false);
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).applyTo((Control)this.fAddShortcutOnToolbar);
        this.fAddShortcutOnToolbar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected;
                boolean bl = selected = DVTShortcutsTab.this.fAddShortcutOnToolbar.getSelection() && !DVTShortcutsTab.this.getCurrentLaunchConfiguration().isReadOnly();
                if (!selected) {
                    DVTShortcutsTab.this.fRadioButtons[0].setEnabled(selected);
                    DVTShortcutsTab.this.fIconPathText.setEnabled(selected);
                    DVTShortcutsTab.this.fBrowseForIconLocationButton.setEnabled(selected);
                    DVTShortcutsTab.this.fRadioButtons[1].setEnabled(selected);
                    DVTShortcutsTab.this.fIconLetterLb.setEnabled(selected);
                    DVTShortcutsTab.this.fIconLetterText.setEnabled(selected);
                    DVTShortcutsTab.this.fCanvas.setEnabled(selected);
                    DVTShortcutsTab.this.fColorPickButton.setEnabled(selected);
                    DVTShortcutsTab.this.fBackColorText.setEnabled(selected);
                    DVTShortcutsTab.this.fToolbarOrderLb.setEnabled(selected);
                    DVTShortcutsTab.this.fToolbarOrder.setEnabled(selected);
                } else {
                    DVTShortcutsTab.this.fRadioButtons[0].setEnabled(true);
                    DVTShortcutsTab.this.fRadioButtons[1].setEnabled(true);
                    boolean b1 = DVTShortcutsTab.this.fRadioButtons[0].getSelection();
                    DVTShortcutsTab.this.fIconPathText.setEnabled(b1);
                    DVTShortcutsTab.this.fBrowseForIconLocationButton.setEnabled(b1);
                    DVTShortcutsTab.this.fIconLetterLb.setEnabled(!b1);
                    DVTShortcutsTab.this.fIconLetterText.setEnabled(!b1);
                    DVTShortcutsTab.this.fCanvas.setEnabled(!b1);
                    DVTShortcutsTab.this.fColorPickButton.setEnabled(!b1);
                    DVTShortcutsTab.this.fBackColorText.setEnabled(!b1);
                    DVTShortcutsTab.this.fToolbarOrderLb.setEnabled(!b1);
                    DVTShortcutsTab.this.fToolbarOrder.setEnabled(!b1);
                }
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fRadioButtons = new Button[2];
        this.fRadioButtons[0] = new Button(parent, 16);
        this.fRadioButtons[0].setSelection(true);
        this.fRadioButtons[0].setText("Select icon:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fRadioButtons[0]);
        this.fRadioButtons[0].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTShortcutsTab.this.fIconPathText.setEnabled(true);
                DVTShortcutsTab.this.fBrowseForIconLocationButton.setEnabled(true);
                DVTShortcutsTab.this.fIconLetterLb.setEnabled(false);
                DVTShortcutsTab.this.fIconLetterText.setEnabled(false);
                DVTShortcutsTab.this.fColorPickButton.setEnabled(false);
                DVTShortcutsTab.this.fBackColorText.setEnabled(false);
                DVTShortcutsTab.this.fToolbarOrderLb.setEnabled(false);
                DVTShortcutsTab.this.fToolbarOrder.setEnabled(false);
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fIconPathText = new Text(parent, 2048);
        this.fIconPathText.setEnabled(false);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.fIconPathText);
        this.fIconPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTShortcutsTab.this.fIconPath = DVTShortcutsTab.this.fIconPathText.getText();
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fBrowseForIconLocationButton = new Button(parent, 8);
        this.fBrowseForIconLocationButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)this.fBrowseForIconLocationButton);
        this.fBrowseForIconLocationButton.setEnabled(false);
        this.fBrowseForIconLocationButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String filterPath = DVTFileUtils.getInstance().getLastDirectory();
                FileDialog fileDialog = new FileDialog(DVTShortcutsTab.this.getShell());
                fileDialog.setFilterPath(filterPath);
                fileDialog.setFilterExtensions(FILTER_EXTS);
                String selectedFile = fileDialog.open();
                fileDialog.setText(filterPath);
                if (selectedFile != null) {
                    DVTShortcutsTab.this.fIconPathText.setText(selectedFile);
                    DVTShortcutsTab.this.fIconPath = DVTShortcutsTab.this.fIconPathText.getText();
                    DVTFileUtils.getInstance().setLastDirectory(selectedFile);
                    DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                    DVTShortcutsTab.this.updateLaunchConfigurationDialog();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fRadioButtons[1] = new Button(parent, 16);
        this.fRadioButtons[1].setText("Generate icon:");
        GridDataFactory.fillDefaults().align(1, 1).applyTo((Control)this.fRadioButtons[1]);
        this.fRadioButtons[1].addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTShortcutsTab.this.fIconPathText.setEnabled(false);
                DVTShortcutsTab.this.fBrowseForIconLocationButton.setEnabled(false);
                DVTShortcutsTab.this.fIconLetterLb.setEnabled(true);
                DVTShortcutsTab.this.fIconLetterText.setEnabled(true);
                DVTShortcutsTab.this.fColorPickButton.setEnabled(true);
                DVTShortcutsTab.this.fBackColorText.setEnabled(true);
                DVTShortcutsTab.this.fToolbarOrderLb.setEnabled(true);
                DVTShortcutsTab.this.fToolbarOrder.setEnabled(true);
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fGenerateIconGroup = new Group(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)this.fGenerateIconGroup);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.fGenerateIconGroup);
        this.fIconLetterLb = new Label((Composite)this.fGenerateIconGroup, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fIconLetterLb);
        this.fIconLetterLb.setText("Label:");
        this.fIconLetterText = new Text((Composite)this.fGenerateIconGroup, 2048);
        this.fIconLetterText.setText(this.fIconLetter);
        this.fIconLetterText.setTextLimit(1);
        GridDataFactory.fillDefaults().align(1, 0x1000000).hint(50, -1).applyTo((Control)this.fIconLetterText);
        this.fIconLetterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTShortcutsTab.this.fIconLetter = DVTShortcutsTab.this.fIconLetterText.getText();
                if (DVTShortcutsTab.this.fIconLetter.isEmpty()) {
                    DVTShortcutsTab.this.fIconLetter = "1";
                }
                DVTShortcutsTab.this.fCanvas.redraw();
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fCanvas = new Canvas((Composite)this.fGenerateIconGroup, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).span(1, 3).indent(16, 0).minSize(64, 64).applyTo((Control)this.fCanvas);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                try {
                    String character = "1";
                    if (DVTShortcutsTab.this.fIconLetter.length() >= 1) {
                        character = Character.toString(DVTShortcutsTab.this.fIconLetter.charAt(0));
                    }
                    if (DVTShortcutsTab.this.fPreviewImage != null) {
                        DVTShortcutsTab.this.fPreviewImage.dispose();
                    }
                    DVTShortcutsTab.this.fPreviewImage = IconGenerator.generatePreview(character, DVTShortcutsTab.this.fIconBgColor);
                    e.gc.drawImage(DVTShortcutsTab.this.fPreviewImage, 0, 0);
                }
                catch (Exception exception) {}
            }
        });
        this.fColorPickButton = new Button((Composite)this.fGenerateIconGroup, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fColorPickButton);
        this.fColorPickButton.setText("Color...");
        this.fColorPickButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(DVTShortcutsTab.this.getShell());
                RGB colorRGB = cd.open();
                if (colorRGB == null) {
                    return;
                }
                DVTShortcutsTab.this.fBackColorText.setText(IconGenerator.rgbToString(colorRGB));
                DVTShortcutsTab.this.fCanvas.redraw();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fBackColorText = new Text((Composite)this.fGenerateIconGroup, 2048);
        GridDataFactory.fillDefaults().align(1, 0x1000000).hint(50, -1).applyTo((Control)this.fBackColorText);
        this.fBackColorText.setText(this.fIconBgColor);
        this.fBackColorText.setTextLimit(6);
        this.fBackColorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTShortcutsTab.this.fIconBgColor = DVTShortcutsTab.this.fBackColorText.getText();
                DVTShortcutsTab.this.fCanvas.redraw();
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fToolbarOrderLb = new Label((Composite)this.fGenerateIconGroup, 0);
        GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)this.fToolbarOrderLb);
        this.fToolbarOrderLb.setText("Position #:");
        this.fToolbarOrder = new Text((Composite)this.fGenerateIconGroup, 2048);
        GridDataFactory.fillDefaults().align(1, 0x1000000).hint(50, -1).applyTo((Control)this.fToolbarOrder);
        this.fToolbarOrder.setText("0");
        this.fToolbarOrder.setTextLimit(3);
        this.fToolbarOrder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String tmp = DVTShortcutsTab.this.fToolbarOrder.getText();
                try {
                    Integer.parseInt(tmp);
                }
                catch (Exception exception) {
                    tmp = "0";
                }
                DVTShortcutsTab.this.fToolbarOrderStr = tmp;
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fCreateAccelerator = new Button(parent, 32);
        this.fCreateAccelerator.setText("Add shortcut:");
        this.fCreateAccelerator.setSelection(false);
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(1, 1).applyTo((Control)this.fCreateAccelerator);
        this.fCreateAccelerator.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DVTShortcutsTab.this.fShortcutBinding.setEnabled(!DVTShortcutsTab.this.fShortcutBinding.isEnabled());
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fShortcutBinding = new Text(parent, 2048);
        this.fShortcutBinding.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.fShortcutBinding);
        this.fShortcutBinding.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTShortcutsTab.this.isValid(DVTShortcutsTab.this.getCurrentLaunchConfiguration());
                DVTShortcutsTab.this.updateLaunchConfigurationDialog();
            }
        });
        KeySequenceText keySequenceText = new KeySequenceText(this.fShortcutBinding);
        keySequenceText.setKeyStrokeLimit(4);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fShortcutBinding == null || this.fIconPathText == null) {
            return;
        }
        this.fShortcutBinding.setText("");
        this.fIconPathText.setText(DynamicLaunchConfigUtils.getProjectLocation((ILaunchConfiguration)configuration));
        this.fAddShortcutOnToolbar.setSelection(false);
        this.fCreateAccelerator.setSelection(false);
    }

    public String getName() {
        return "Shortcuts";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.fAddShortcutOnToolbar.getSelection() && !this.fCreateAccelerator.getSelection()) {
            return true;
        }
        if (this.fShortcutBinding == null || this.fIconPathText == null) {
            return false;
        }
        if (this.fCreateAccelerator.getSelection() && this.fShortcutBinding.getText().isEmpty()) {
            this.setErrorMessage("Key binding must not be empty!");
            return false;
        }
        if (this.fCreateAccelerator.getSelection()) {
            String bindingText = this.fShortcutBinding.getText();
            if (!DynamicLaunchConfigUtils.validateAccelerator(bindingText)) {
                this.setErrorMessage("Invalid key binding!");
                return false;
            }
            List<Binding> currentBindings = DynamicLaunchConfigUtils.getBindingsForAccelerator(bindingText);
            if (currentBindings != null && !currentBindings.isEmpty()) {
                for (Binding currentBinding : currentBindings) {
                    String commandId;
                    ParameterizedCommand command = currentBinding.getParameterizedCommand();
                    if (command == null || (commandId = DynamicLaunchConfigUtils.getLaunchConfigurationNameFromCommandId(command.getId())).equals(this.getCurrentLaunchConfiguration().getName().replaceAll("_", " "))) continue;
                    String errorMessage = "Go to Preferences > General > Keys to unbind.";
                    String schemeName = DynamicLaunchConfigUtils.getSchemeForBinding(currentBinding);
                    if (schemeName == null) {
                        errorMessage = "This key binding is already in use!" + System.lineSeparator() + errorMessage;
                    } else {
                        try {
                            errorMessage = "This key binding is already in use for the '" + command.getName() + "' command in " + schemeName + " scheme!" + System.lineSeparator() + errorMessage;
                        }
                        catch (NotDefinedException e) {
                            errorMessage = "This key binding is already in use in " + schemeName + " scheme!" + System.lineSeparator() + errorMessage;
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    this.setErrorMessage(errorMessage);
                    return false;
                }
            }
        }
        if (this.fAddShortcutOnToolbar.getSelection() && this.fRadioButtons[0].getSelection() && this.fRadioButtons[0].isEnabled()) {
            if (this.fIconPath.isEmpty()) {
                this.setErrorMessage("Icon path must not be empty!");
                return false;
            }
            String absoluteIconPath = DVTShortcutsTab.getFullPathOfIcon(this.fIconPath, launchConfig);
            if (absoluteIconPath == null) {
                this.setErrorMessage("Icon path can't be resolved!");
                return false;
            }
            File iconFile = new File(absoluteIconPath);
            if (!iconFile.canRead()) {
                this.setErrorMessage("Icon file can't be read!");
                return false;
            }
            if (iconFile.isDirectory()) {
                this.setErrorMessage("Icon path points to a directory!");
                return false;
            }
        }
        return true;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.KEYBOARD_SHORTCUTS);
    }

    public static String getFullPathOfIcon(String iconName, ILaunchConfiguration launchConfiguration) {
        String translatedIconPath = ResourceFilterUtils.expandDvtEnvVars(ResourceFilterUtils.toDvtEnvVars(iconName));
        if (new File(translatedIconPath).isAbsolute()) {
            return translatedIconPath;
        }
        if (launchConfiguration == null) {
            return null;
        }
        IFile launchFile = launchConfiguration.getFile();
        if (launchFile == null) {
            return null;
        }
        IContainer parentDirectory = launchFile.getParent();
        if (parentDirectory == null) {
            return null;
        }
        IPath parentDirectroyPath = parentDirectory.getLocation();
        if (parentDirectroyPath == null) {
            return null;
        }
        return parentDirectroyPath.append(translatedIconPath).toOSString();
    }
}

