/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.launch.ui.DVTLaunchMainTab;
import ro.amiq.dvt.launch.ui.DVTSimLaunchConfigTabGroup;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.StyledTextUndoRedo;

public class DVTSimLaunchConfigTab
extends DVTLaunchMainTab {
    private StyledText fArgumentsText;
    protected BuildPhaseWidgetListener fBuildPhaseListener = new BuildPhaseWidgetListener();

    private void handleVariablesButtonSelectedArguments(StyledText textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", this.getAttributeValueFrom(this.fProjectField));
        config.setAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", this.getAttributeValueFrom(this.fWorkDirectoryField));
        config.setAttribute("ro.amiq.dvt.launch.ARGUMENTS_BUILD_PHASE_ATTR", this.getAttributeValueFrom(this.fArgumentsText));
        DVTSimLaunchConfigTabGroup.setBuildPhaseConfigVersion(config);
        config.removeAttribute("ro.amiq.dvt.launch.GENERIC_COMMAND_ATTR");
        String projectName = this.getAttributeValueFrom(this.fProjectField);
        IProject project = null;
        try {
            if (projectName != null && !projectName.isEmpty()) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            }
        }
        catch (Exception exception) {}
        if (project != null && project.exists()) {
            config.setAttribute(ATTR_MAPPED_RESOURCE_PATHS, Arrays.asList(project.getName()));
            config.setAttribute(ATTR_MAPPED_RESOURCE_TYPES, Arrays.asList("4"));
        }
    }

    @Override
    public void initializeFrom(ILaunchConfiguration config) {
        try {
            String command = config.getAttribute("ro.amiq.dvt.launch.ARGUMENTS_BUILD_PHASE_ATTR", this.getAttributeValueFrom(this.fArgumentsText));
            if (command != null && !command.isEmpty()) {
                this.fArgumentsText.setText(command);
            }
            this.fProjectField.setText(config.getAttribute("ro.amiq.dvt.launch.PROJECT_ATTR", ""));
            this.fWorkDirectoryField.setText(config.getAttribute("ro.amiq.dvt.launch.WORKING_DIRECTORY", ""));
            if ("".equals(this.fArgumentsText.getText())) {
                this.fArgumentsText.setText("${dvt_dialog_prompt:RunAllDefaultCustomDialog.swtxml}");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        this.createProjectComponent(composite);
        this.createWorkDirectoryComponent(composite);
        this.createArgumentComponent(composite);
        this.createVerticalSpacer(composite, 1);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private void createArgumentComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        Label runWithCustomArguments = new Label((Composite)group, 0);
        runWithCustomArguments.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        runWithCustomArguments.setText("Runtime arguments:");
        Composite buttonComposite = new Composite((Composite)group, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        buttonComposite.setLayout((Layout)gl);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        this.fCommandVariablesButton = DVTSimLaunchConfigTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_31);
        this.fCommandVariablesButton.addSelectionListener((SelectionListener)this.fBuildPhaseListener);
        this.addControlAccessibleListener((Control)this.fCommandVariablesButton, String.valueOf(group.getText()) + " " + this.fCommandVariablesButton.getText());
        this.fArgumentsText = new StyledText((Composite)group, 2626);
        GridData gd = new GridData(4, 4, true, true, 6, 1);
        gd.heightHint = 150;
        gd.widthHint = 200;
        this.fArgumentsText.setLayoutData((Object)gd);
        this.addControlAccessibleListener((Control)this.fArgumentsText, group.getText());
        this.fArgumentsText.addModifyListener((ModifyListener)this.fBuildPhaseListener);
        this.fArgumentsText.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fArgumentsText.addLineStyleListener((LineStyleListener)new DVTLaunchMainTab.StyledTextVariableStyleListener());
        StyledTextUndoRedo.install(this.fArgumentsText);
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)this.fArgumentsText, (IControlContentAdapter)new DVTLaunchMainTab.StyledTextContentAdapter(), (IContentProposalProvider)new DVTLaunchMainTab.VariableProposalProvider(), "org.eclipse.ui.edit.text.contentAssist.proposals", null, true);
        adapter.setPopupSize(new Point(300, 300));
    }

    @Override
    public boolean isValid(ILaunchConfiguration config) {
        block5: {
            String projectName;
            block6: {
                try {
                    this.setErrorMessage(null);
                    this.setMessage(null);
                    projectName = this.fProjectField.getText().trim();
                    if (projectName.length() == 0) break block5;
                    Path projectPath = new Path(null, projectName);
                    if (projectPath.isValidSegment(projectName)) break block6;
                    this.setErrorMessage("Project name '" + projectName + "' not valid.");
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (project != null && project.exists()) break block5;
            this.setErrorMessage("Project '" + projectName + "' does not exist.");
            return false;
        }
        String argumentsSpecified = this.fArgumentsText.getText();
        if (argumentsSpecified != null && argumentsSpecified.length() == 0) {
            this.setErrorMessage("Runtime arguments not specified.");
            return false;
        }
        return true;
    }

    private class BuildPhaseWidgetListener
    extends DVTLaunchMainTab.WidgetListener {
        private BuildPhaseWidgetListener() {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == DVTSimLaunchConfigTab.this.fCommandVariablesButton) {
                DVTSimLaunchConfigTab.this.handleVariablesButtonSelectedArguments(DVTSimLaunchConfigTab.this.fArgumentsText);
                return;
            }
            super.widgetSelected(e);
        }
    }
}

