/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.launch.ui;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class DVTSyncBreakpointsPolicyGroup {
    private Button fTarget;
    private Button fEclipse;
    private Button fMerge;
    private boolean fShowSkipAllBreakpointsWarning;
    private CLabel fWarningLabel;

    public DVTSyncBreakpointsPolicyGroup(boolean showSkipAllBreakpointsWarning) {
        this.fShowSkipAllBreakpointsWarning = showSkipAllBreakpointsWarning;
    }

    public Group createGroup(Composite parent, int syncBreakpointsPolicy) {
        Group group = new Group(parent, 0);
        group.setText("Breakpoints Synchronization Policy: ");
        GridData groupData = new GridData(4, 0x1000000, true, false, 2, 1);
        groupData.widthHint = 400;
        group.setLayoutData((Object)groupData);
        group.setLayout((Layout)new GridLayout());
        this.fTarget = new Button((Composite)group, 16);
        this.fTarget.setText("Use breakpoints from Debug Target (simulator)");
        this.fEclipse = new Button((Composite)group, 16);
        this.fEclipse.setText("Use breakpoints from Eclipse");
        this.fMerge = new Button((Composite)group, 16);
        this.fMerge.setText("Merge breakpoints");
        if (this.fShowSkipAllBreakpointsWarning && !DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
            this.fWarningLabel = new CLabel((Composite)group, 0);
            this.fWarningLabel.setText("Skip all breakpoints option is enabled.\nAll breakpoints will be skipped.");
            Shell shell = DVTUiUtils.getActiveWorkbenchShell();
            if (shell != null) {
                this.fWarningLabel.setImage(shell.getDisplay().getSystemImage(8));
            }
            this.fWarningLabel.setVisible(false);
            this.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DVTSyncBreakpointsPolicyGroup.this.updateWarningLabel();
                }
            });
        }
        this.setSyncBreakpointsPolicy(syncBreakpointsPolicy);
        return group;
    }

    private void updateWarningLabel() {
        if (this.fWarningLabel == null) {
            return;
        }
        if (this.fEclipse.getSelection()) {
            this.fWarningLabel.setVisible(true);
        } else {
            this.fWarningLabel.setVisible(false);
        }
    }

    public int getSyncBreakpointsPolicy() {
        if (this.fTarget.getSelection()) {
            return 0;
        }
        if (this.fEclipse.getSelection()) {
            return 1;
        }
        if (this.fMerge.getSelection()) {
            return 2;
        }
        return 1;
    }

    public void setSyncBreakpointsPolicy(int syncBreakpointsPolicy) {
        this.fTarget.setSelection(syncBreakpointsPolicy == 0);
        this.fEclipse.setSelection(syncBreakpointsPolicy == 1);
        this.fMerge.setSelection(syncBreakpointsPolicy == 2);
        this.updateWarningLabel();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.fTarget.addSelectionListener(selectionListener);
        this.fEclipse.addSelectionListener(selectionListener);
        this.fMerge.addSelectionListener(selectionListener);
    }
}

